




setwd()    #set your work directory

library(TwoSampleMR) #library R package



#########warning: please load these data below, one by one###########

load() #load RData
#save() #save RData 




################################################################



#methods
method_list=c(
  'mr_egger_regression',
  'mr_weighted_median',
  'mr_ivw',
  #'mr_ivw_mre',
  'mr_simple_mode',
  'mr_weighted_mode')


#output results
res <- mr(dat,method_list=method_list)  
res


#sensitive analysis
het<-mr_heterogeneity(dat)  
het


pleio<- mr_pleiotropy_test(dat)
pleio


single <- mr_leaveoneout(dat)
single


direction <- directionality_test(dat) 
direction 


#MR-PRESSO
mr_presso_result=mr_presso(BetaOutcome ='beta.outcome',     
                               BetaExposure = 'beta.exposure', 
                               SdOutcome ='se.outcome',         
                               SdExposure = 'se.exposure',      
                               data = dat,                     
                               OUTLIERtest = TRUE,             
                               DISTORTIONtest = TRUE,           
                               NbDistribution = 10000,          
                               SignifThreshold = 0.05)


mr_presso_result




#calculate F statistic

    N=dat$samplesize.exposure[1]
    k=res$nsnp[1]
    R2=TwoSampleMR::get_r_from_bsen(b=dat$beta.exposure,
                                    se=dat$se.exposure,
                                    n=dat$samplesize.exposure[1]) 
    
    
    F.value=((N-k-1)/(k)) * (R2/(1-R2))
