
import matplotlib.pyplot as plt
import numpy as np
def percent_formatter(x, pos):
    return f"{x*100:.0f}%"

from matplotlib.ticker import FuncFormatter
from matplotlib.ticker import MultipleLocator

# 示例数据
categories = ['Ontonote', 'MSRA',"Weibo", 'Resume']
values11= [0.2057, 0.1818, 0.1903, 0.0936]
values12 = [0.0280, 0.0189, 0.0188, 0.0301]

values21 = [0.1849, 0.1831, 0.1889, 0.0911]
values22 = [0.0183, 0.02, 0.0192, 0.0315]
# #
values31 = [0.1944, 0.1669, 0.1883, 0.0883]
values32 = [0.0186, 0.0206, 0.0164, 0.0305]
formatter = FuncFormatter(percent_formatter)

# 创建画布和轴
fig, axs = plt.subplots(1, 3, figsize=(15, 5))  # 1行3列


# 绘制第一个柱状图
bar_width = 0.15  # 柱子的宽度
index = np.arange(len(categories))  # 确定每个柱子的位置
text=['(a)Train Dataset','(b)Dev Dataset','(c)Test Dataset']

for i in range(3):

    #第一个图
    bars1 = axs[i].bar(index, values11, bar_width, label='LEBERT')
    # 绘制第二个柱状图，通过平移位置避免重叠
    bars2 = axs[i].bar(index + bar_width, values12, bar_width, label='SLEBERT')
    # 添加轴标题和图表标题
    axs[i].set_xlabel(text[i])
    axs[i].set_ylabel('lexical conflict percentage')
    axs[i].set_ylim(0, 0.219)
    # 设置Y轴的刻度间隔为5
    axs[i].yaxis.set_major_locator(MultipleLocator(0.02))
    # 创建FuncFormatter对象

    axs[i].yaxis.set_major_formatter(formatter)

    # 显示x轴的标签
    axs[i].set_xticks(index + bar_width / 2)
    axs[i].set_xticklabels(categories)

    #第一个图结束

   # 添加图例
axs[i].legend(loc='upper right',bbox_to_anchor=(1.5, 1))
fig.subplots_adjust(wspace=0.5)
# 显示图表
plt.show()