import matplotlib.pyplot as plt
import numpy as np

# 示例数据
categories = ['Category A', 'Category B', 'Category C', 'Category D']
values1 = [5, 20, 14, 30]
values2 = [10, 15, 20, 25]
values3 = [15, 25, 10, 20]

# 创建一个画布，并设置一行三列的子图布局
fig, axs = plt.subplots(1, 3, figsize=(15, 5))  # 1行3列

# 在第一个子图位置上绘制第一个条形图
axs[0].bar(categories, values1, color='skyblue', label='Dataset 1')
axs[0].set_title('Bar Chart 1')
axs[0].set_xlabel('Categories')
axs[0].set_ylabel('Values')
axs[0].legend()

# 在第二个子图位置上绘制第二个条形图
axs[1].bar(categories, values2, color='lightgreen', label='Dataset 2')
axs[1].set_title('Bar Chart 2')
axs[1].set_xlabel('Categories')
axs[1].set_ylabel('Values')
axs[1].legend()

# 在第三个子图位置上绘制第三个条形图
axs[2].bar(categories, values3, color='orange', label='Dataset 3')
axs[2].set_title('Bar Chart 3')
axs[2].set_xlabel('Categories')
axs[2].set_ylabel('Values')
axs[2].legend()

# 调整子图间的间距
plt.tight_layout()

# 显示图表
plt.show()