from sklearn.metrics import accuracy_score, f1_score, precision_score, recall_score, balanced_accuracy_score, matthews_corrcoef, roc_auc_score, average_precision_score
from sklearn.metrics import roc_auc_score, average_precision_score
from torch.autograd import Variable
import torch
import numpy as np

def evaluate(target, preds, probs):
    roc_auc = roc_auc_score(target, probs, average='weighted', multi_class='ovr')
    pr_auc = average_precision_score(target, probs, average='weighted')
    accuracy = accuracy_score(target, preds)
    precision = precision_score(target, preds, average='weighted')
    recall = recall_score(target, preds, average='weighted')
    f1 = f1_score(target, preds, average='weighted') 
    balanced_ACC = balanced_accuracy_score(target, preds)
    mcc = matthews_corrcoef(target, preds)
    return  roc_auc, pr_auc, accuracy, precision, recall, f1, balanced_ACC, mcc
