library(DESeq2)
countsdata <- read.table("GSE294595_raw_counts.txt",row.names = 1, header = T, sep="\t")[,2:13]
countdata<- countsdata[rowSums(countsdata)>60,]
countdata <-countdata[,c(1:3,4:6)]
coldata<-data.frame(genome=factor(c(rep('WT',3),rep('MT',3)), 
                                    levels = c('WT','MT')),  
                    row.names = colnames(countdata)) 
dds<-DESeqDataSetFromMatrix(countData = countdata, colData = coldata,  design = ~genome)
dds<-DESeq(dds)
res<-results(dds) 

resdata<-merge(as.data.frame(res),    
               as.data.frame(counts(dds,normalized=F)),    
               by='row.names',sort=F)                      

resdata$significant <- 'unchanged' 
resdata$significant[resdata$log2FoldChange > 1 & resdata$padj < 0.05] <- 'up'      #上调
resdata$significant[resdata$log2FoldChange < -1 & resdata$padj < 0.05] <- 'down'
table(resdata$significant)
write.csv(resdata, file = "MT_vs_WT_DEG.csv")
