rm(list=ls())
options(stringsAsFactors = F)

library(clusterProfiler)

go <- read.delim("go.tb", stringsAsFactors=FALSE)
gene <- read.csv("MT_vs_WT_up_genelist.csv", header = F)[,1]

go_term2gene <- data.frame(go$V1,go$V4)
go_term2name <- data.frame(go$V1,go$V2)
names(go_term2gene) <- c("go_term","gene")
names(go_term2name) <- c("go_term","name")

gene <- as.vector(gene$V1)
head(gene)

go_enrich <- enricher(gene=gene,pvalueCutoff = 0.05,pAdjustMethod = "BH",TERM2GENE = go_term2gene,TERM2NAME = go_term2name)
head(as.data.frame(go_enrich))

write.csv(as.data.frame(go_result),"GO.csv",row.names = F)



