WGCNA
#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install(c("GO.db", "preprocessCore", "impute","limma"))

#install.packages(c("matrixStats", "Hmisc", "foreach", "doParallel", "fastcluster", "dynamicTreeCut", "survival")) 
#install.packages("WGCNA")

#???ð?
library(limma)
library(WGCNA)
expFile="43458-68465-50081-tumour.txt"      
immFile="CIBERSORTx_Job1_Results.txt"     

#??ȡ?????ļ????????????ļ?????????
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
dim(rt)
#[1] 12477   651
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
dim(exp)
#[1] 12477   650
data=matrix(as.numeric(as.matrix(exp)), nrow=nrow(exp), dimnames=dimnames)
data=avereps(data)

#ɾ????????Ʒ
data=log2(data+1)
data<-data[complete.cases(data),]
data=data[rowMeans(data)>0.2,]
data=data[apply(data,1,sd)>0.2,] 
dim(data)
#[1] 2022  650
datExpr0=t(data)
dim(datExpr0)
#[1]  650 2022

###????ȱʧֵ
gsg = goodSamplesGenes(datExpr0, verbose = 3)
if (!gsg$allOK){
  # Optionally, print the gene and sample names that were removed:
  if (sum(!gsg$goodGenes)>0)
    printFlush(paste("Removing genes:", paste(names(datExpr0)[!gsg$goodGenes], collapse = ", ")))
  if (sum(!gsg$goodSamples)>0)
    printFlush(paste("Removing samples:", paste(rownames(datExpr0)[!gsg$goodSamples], collapse = ", ")))
  # Remove the offending genes and samples from the data:
  datExpr0 = datExpr0[gsg$goodSamples, gsg$goodGenes]
}

###??Ʒ????,????????????Ʒ
sampleTree = hclust(dist(datExpr0), method = "average")
pdf(file = "1_sample_cluster.pdf", width = 12, height = 9)
par(cex = 0.6)
par(mar = c(0,4,2,0))
plot(sampleTree, main = "Sample clustering to detect outliers", sub="", xlab="", cex.lab = 1.5, cex.axis = 1.5, cex.main = 2)
abline(h = 100000, col = "red")
dev.off()

###ɾ???????????µ???Ʒ
clust = cutreeStatic(sampleTree, cutHeight = 100000, minSize = 10)
table(clust)
keepSamples = (clust==1)
datExpr0 = datExpr0[keepSamples, ]

###powerֵɢ??ͼ
enableWGCNAThreads()  
powers = c(1:20)      
sft = pickSoftThreshold(datExpr0, powerVector = powers, verbose = 5)
pdf(file="2_scale_independence.pdf",width=9,height=5)
par(mfrow = c(1,2))
cex1 = 0.9

###????ָ????powerֵɢ??ͼ
plot(sft$fitIndices[,1], -sign(sft$fitIndices[,3])*sft$fitIndices[,2],
     xlab="Soft Threshold (power)",ylab="Scale Free Topology Model Fit,signed R^2",type="n",
     main = paste("Scale independence"));
text(sft$fitIndices[,1], -sign(sft$fitIndices[,3])*sft$fitIndices[,2],
     labels=powers,cex=cex1,col="red");
abline(h=0.90,col="red")

###ƽ??��ͨ????powerֵɢ??ͼ
plot(sft$fitIndices[,1], sft$fitIndices[,5],
     xlab="Soft Threshold (power)",ylab="Mean Connectivity", type="n",
     main = paste("Mean connectivity"))
text(sft$fitIndices[,1], sft$fitIndices[,5], labels=powers, cex=cex1,col="red")
dev.off()


###?ڽӾ???ת??
sft 
softPower =sft$powerEstimate 
adjacency = adjacency(datExpr0, power = softPower)
softPower

###TOM????
TOM = TOMsimilarity(adjacency)
dissTOM = 1-TOM

###????????
geneTree = hclust(as.dist(dissTOM), method = "average");
pdf(file="3_gene_clustering.pdf",width=12,height=9)
plot(geneTree, xlab="", sub="", main = "Gene clustering on TOM-based dissimilarity",
     labels = FALSE, hang = 0.04)
dev.off()


###??̬????ģ??ʶ??
minModuleSize=60    
dynamicMods = cutreeDynamic(dendro = geneTree, distM = dissTOM,
                            deepSplit = 2, pamRespectsDendro = FALSE,
                            minClusterSize = minModuleSize);
table(dynamicMods)
dynamicColors = labels2colors(dynamicMods)
table(dynamicColors)

#???ƻ???ģ????ͼ??
pdf(file="4_Dynamic_Tree.pdf",width=8,height=6)
plotDendroAndColors(geneTree, dynamicColors, "Dynamic Tree Cut",
                    dendroLabels = FALSE, hang = 0.03,
                    addGuide = TRUE, guideHang = 0.05,
                    main = "Gene dendrogram and module colors")
dev.off()

###????????ģ??????
MEList = moduleEigengenes(datExpr0, colors = dynamicColors)
MEs = MEList$eigengenes
MEDiss = 1-cor(MEs);
METree = hclust(as.dist(MEDiss), method = "average")
pdf(file="5_Clustering_module.pdf",width=7,height=7)
plot(METree, main = "Clustering of module eigengenes",
     xlab = "", sub = "")
MEDissThres = 0.25    
abline(h=MEDissThres, col = "red")
dev.off()

###????ģ???ϲ?
merge = mergeCloseModules(datExpr0, dynamicColors, cutHeight = MEDissThres, verbose = 3)
mergedColors = merge$colors
mergedMEs = merge$newMEs
#?ϲ?ģ????ͼ??
pdf(file="6_merged_dynamic.pdf", width = 9, height = 6)
plotDendroAndColors(geneTree, mergedColors,"Dynamic Tree Cut",
                    dendroLabels = FALSE, hang = 0.03,
                    addGuide = TRUE, guideHang = 0.05,
                    main = "Gene dendrogram and module colors")
dev.off()
moduleColors = mergedColors
table(moduleColors)
colorOrder = c("grey", standardColors(50))
moduleLabels = match(moduleColors, colorOrder)-1
MEs = mergedMEs

###????ģ????????ϸ??֮????????????ͼ
immune=read.table(immFile, header=T, sep="\t", check.names=F, row.names=1)
immune=immune[immune[,"P-value"]<0.05,]
cli=as.matrix(immune[,1:(ncol(immune)-3)])
sameSample=intersect(row.names(cli), row.names(MEs))
MEs=MEs[sameSample,,drop=F]
datTraits=cli[sameSample,,drop=F]
nGenes = ncol(datExpr0)
nSamples = nrow(datExpr0)
#?õ?????ϵ?????????Լ?????pvalue
moduleTraitCor = cor(MEs, datTraits, use = "p")
moduleTraitPvalue = corPvalueStudent(moduleTraitCor, nSamples)
?????????Ե???ͼ
pdf(file="7_Module_trait.pdf", width=10, height=8)
textMatrix = paste(signif(moduleTraitCor, 2), "\n(",
                   signif(moduleTraitPvalue, 1), ")", sep = "")
dim(textMatrix) = dim(moduleTraitCor)
par(mar = c(9, 9, 3, 3))
labeledHeatmap(Matrix = moduleTraitCor,
               xLabels = colnames(datTraits),
               yLabels = names(MEs),
               ySymbols = names(MEs),
               colorLabels = FALSE,
               colors = blueWhiteRed(50),
               textMatrix = textMatrix,
               setStdMargins = FALSE,
               cex.text = 0.5,
               zlim = c(-1,1),
               main = paste("Module-trait relationships"))
dev.off()

###???????ڵ?ģ??
probes = colnames(datExpr0)
geneInfo0 = data.frame(probes= probes,
                       moduleColor = moduleColors)
geneOrder =order(geneInfo0$moduleColor)
geneInfo = geneInfo0[geneOrder, ]
write.table(geneInfo, file = "module_all.txt",sep="\t",row.names=F,quote=F)


###????ÿ??ģ???Ļ???
for (mod in 1:nrow(table(moduleColors))){  
  modules = names(table(moduleColors))[mod]
  probes = colnames(datExpr0)
  inModule = (moduleColors == modules)
  modGenes = probes[inModule]
  write.table(modGenes, file =paste0("module_",modules,".txt"),sep="\t",row.names=F,col.names=F,quote=F)
}

save.image(file = "wgcna.RData")

######??????ѧ??: https://www.biowolf.cn/
######?γ?��??1: https://shop119322454.taobao.com
######?γ?��??2: https://ke.biowolf.cn
######?γ?��??3: https://ke.biowolf.cn/mobile
######?⿡??ʦ????: seqbio@foxmail.com
######?⿡??ʦ΢??: eduBio




UNICOX
###
library(survival)
library(survminer)
library(readxl)
###
data <- read_excel("GEO-brown-cib-treg-tn-hl.xlsx")
data <- data[-1,]
a<-data$ID
data[]<-sapply(data,as.numeric)

###
data <- as.matrix(data)
rownames(data)<-a
data <- subset(data, select = -ID)

###
data=t(data)
colnames(data)<-a

###
rownames(data)=substr(rownames(data),1,12)

###
cli <- read_excel("survival.xlsx")

###
b<-cli$ID
c<-rownames(data)
sameSample=intersect(c, b)

###
data=data[sameSample,]
rownames(cli)<-b
cli=cli[sameSample,]
e<-cli$ID
rownames(cli)<-e
cli <- subset(cli, select = -ID)

###
rt=cbind(cli, data)

#0.05,0.01,0.001
p.value = 0.05
####
outTab=data.frame()
for(i in colnames(rt[,3:ncol(rt)])){
  #cox
  cox <- coxph(Surv(time, status) ~ rt[,i], data = rt)
  coxSummary = summary(cox)
  coxP=coxSummary$coefficients[,"Pr(>|z|)"]
  if(coxP < p.value){
    outTab=rbind(outTab,
                 cbind(id=i,
                       HR=coxSummary$conf.int[,"exp(coef)"],
                       HR.95L=coxSummary$conf.int[,"lower .95"],
                       HR.95H=coxSummary$conf.int[,"upper .95"],
                       pvalue=coxSummary$coefficients[,"Pr(>|z|)"])
    )
  }
}

####
write.table(outTab, file="uniCox.txt", sep="\t", row.names=F, quote=F)


####
####
rt <- read.table("uniCox.txt",header=T,sep="\t",check.names=F,row.names=1)
gene <- rownames(rt)
hr <- sprintf("%.3f",rt$"HR")
hrLow  <- sprintf("%.3f",rt$"HR.95L")
hrHigh <- sprintf("%.3f",rt$"HR.95H")
Hazard.ratio <- paste0(hr,"(",hrLow,"-",hrHigh,")")
pVal <- ifelse(rt$pvalue<0.001, "<0.001", sprintf("%.3f", rt$pvalue))

pdf(file="uniCoxforest-all.pdf", width =15,height =40)
n <- nrow(rt)
nRow <- n+1
ylim <- c(1,nRow)
layout(matrix(c(1,2),nc=2),width=c(3,2.5))

xlim = c(0,3)
par(mar=c(4,2.5,2,1))
plot(1,xlim=xlim,ylim=ylim,type="n",axes=F,xlab="",ylab="")
text.cex=0.8
text(0,n:1,gene,adj=0,cex=text.cex)
text(1.5-0.5*0.2,n:1,pVal,adj=1,cex=text.cex);text(1.5-0.5*0.2,n+1,'pvalue',cex=text.cex,font=2,adj=1)
text(3,n:1,Hazard.ratio,adj=1,cex=text.cex);text(3,n+1,'Hazard ratio',cex=text.cex,font=2,adj=1,)

par(mar=c(4,1,2,1),mgp=c(2,0.5,0))
xlim = c(0,max(as.numeric(hrLow),as.numeric(hrHigh)))
plot(1,xlim=xlim,ylim=ylim,type="n",axes=F,ylab="",xaxs="i",xlab="Hazard ratio")
arrows(as.numeric(hrLow),n:1,as.numeric(hrHigh),n:1,angle=90,code=3,length=0.05,col="darkblue",lwd=2.5)
abline(v=1,col="black",lty=2,lwd=2)
boxcolor = ifelse(as.numeric(hr) > 1, "red", "blue")
points(as.numeric(hr), n:1, pch = 15, col = boxcolor, cex=1.6)
axis(1)
dev.off()

####
####
rt <- read.table("uniCox.txt",header=T,sep="\t",check.names=F,row.names=1)
####
rt = rt[1:20,]
gene <- rownames(rt)
hr <- sprintf("%.3f",rt$"HR")
hrLow  <- sprintf("%.3f",rt$"HR.95L")
hrHigh <- sprintf("%.3f",rt$"HR.95H")
Hazard.ratio <- paste0(hr,"(",hrLow,"-",hrHigh,")")
pVal <- ifelse(rt$pvalue<0.001, "<0.001", sprintf("%.3f", rt$pvalue))

####
pdf(file="uniCoxforest-前20.pdf", width =10,height =10)
n <- nrow(rt)
nRow <- n+1
ylim <- c(1,nRow)
layout(matrix(c(1,2),nc=2),width=c(3,2.5))

xlim = c(0,3)
par(mar=c(4,2.5,2,1))
plot(1,xlim=xlim,ylim=ylim,type="n",axes=F,xlab="",ylab="")
text.cex=0.8
text(0,n:1,gene,adj=0,cex=text.cex)
text(1.5-0.5*0.2,n:1,pVal,adj=1,cex=text.cex);text(1.5-0.5*0.2,n+1,'pvalue',cex=text.cex,font=2,adj=1)
text(3,n:1,Hazard.ratio,adj=1,cex=text.cex);text(3,n+1,'Hazard ratio',cex=text.cex,font=2,adj=1,)

par(mar=c(4,1,2,1),mgp=c(2,0.5,0))
xlim = c(0,max(as.numeric(hrLow),as.numeric(hrHigh)))
plot(1,xlim=xlim,ylim=ylim,type="n",axes=F,ylab="",xaxs="i",xlab="Hazard ratio")
arrows(as.numeric(hrLow),n:1,as.numeric(hrHigh),n:1,angle=90,code=3,length=0.05,col="darkblue",lwd=2.5)
abline(v=1,col="black",lty=2,lwd=2)
boxcolor = ifelse(as.numeric(hr) > 1, "red", "blue")
points(as.numeric(hr), n:1, pch = 15, col = boxcolor, cex=1.6)
axis(1)
dev.off()

save.image(file = "cox.RData")





LASSO
library("glmnet")
library("survival")
library(readxl)

####
data <- read_excel("GEO-unicox.xlsx")
a<-data$ID
####
dimnames=list(rownames(data), colnames(data))
data=matrix(as.numeric(as.matrix(data)), nrow=nrow(data), dimnames=dimnames)
rownames(data)<-a
data <- subset(data, select = -ID)

####
data=t(data)

####
cli <- read_excel("survival.xlsx")
b<-cli$ID
c<-rownames(data)

####
sameSample=intersect(b, c)
####
data=data[sameSample,]
rownames(cli)<-b
cli=cli[sameSample,]

####
rt=cbind(cli, data)
write.table(rt,file = "rt.txt",sep = "\t")

rt1 <- read_excel("rt.xlsx")
d<-rt1$ID
dimnames=list(rownames(rt1), colnames(rt1))
rt1=matrix(as.numeric(as.matrix(rt1)), nrow=nrow(rt1), dimnames=dimnames)
rownames(rt1)<-d
rt1 <- subset(rt1, select = -ID)
rt1<-as.data.frame(rt1)
rt1<-rt1[complete.cases(rt1),]

####
set.seed(123456)

####
x=as.matrix(rt1[,c(3:ncol(rt1))])
y=data.matrix(Surv(rt1$time, rt1$status))
fit=glmnet(x, y, family="cox", nfolds = 10)

#family="gaussian" （univariate）
#family="mgaussian" （multivariate）
#family="poisson" （count）
#family="binomial" （binary）
#family="multinomial" （category）

#c-index
cvfit <- cv.glmnet(x, y, family = "cox", type.measure = "C", nfolds = 10)
pdf("lasso.c-index.pdf")
plot(cvfit)
abline(v=log(c(cvfit$lambda.min,cvfit$lambda.1se)), lty="dashed")
dev.off()

####
cvfit=cv.glmnet(x, y, family="cox", type.measure = "deviance", nfolds = 10)
pdf("lasso.cvfit.pdf")
plot(cvfit)
abline(v=log(c(cvfit$lambda.min,cvfit$lambda.1se)), lty="dashed")
dev.off()

#Coefficients
pdf("lasso.lambda.pdf")
plot(fit, xvar="lambda", label=T)
abline(v=log(cvfit$lambda.min), lty="dashed")
dev.off()

####
coef=coef(fit, s=cvfit$lambda.min)
index=which(coef != 0)
actCoef=coef[index]
lassoGene=row.names(coef)[index]
row.names(coef)[index]
#[1] [1] "DDIT4"   "MELTF"   "PERP"    "PLEK2"   "PPP1R3G" "S100A16"
actCoef
#[1] 4.094454e-05 1.346095e-03 6.165647e-04 1.981126e-03 1.173768e-01
#[6] 2.770770e-05
index
#[1]  32  74  86  89  91 100

lassoSigExp=rt1[,c("time", "status", lassoGene)]
lassoSigExpOut=cbind(id=row.names(lassoSigExp), lassoSigExp)
write.table(lassoSigExpOut,file="lasso.SigExp.txt",sep="\t",row.names=F,quote=F)

save.image(file = "lasso.RData")





MULTICOX
####
library(survival)

####
rt=read.table("lasso.SigExp.txt",header=T,sep="\t",check.names=F,row.names=1)   

#COX
multiCox=coxph(Surv(time, status) ~ ., data = rt)
####step，"both", "backward", "forward"
####
multiCox=step(multiCox,direction = "both")
multiCoxSum=summary(multiCox)

####
outTab=data.frame()
outTab=cbind(
  coef=multiCoxSum$coefficients[,"coef"],
  HR=multiCoxSum$conf.int[,"exp(coef)"],
  HR.95L=multiCoxSum$conf.int[,"lower .95"],
  HR.95H=multiCoxSum$conf.int[,"upper .95"],
  pvalue=multiCoxSum$coefficients[,"Pr(>|z|)"])
outTab=cbind(id=row.names(outTab),outTab)
outTab=gsub("`","",outTab)
write.table(outTab,file="multiCox.txt",sep="\t",row.names=F,quote=F)

####
riskScore=predict(multiCox,type="risk",newdata=rt)
coxGene=rownames(multiCoxSum$coefficients)
coxGene=gsub("`","",coxGene)
outCol=c("time","status",coxGene)
risk=as.vector(ifelse(riskScore>median(riskScore),"high","low"))
write.table(cbind(id=rownames(cbind(rt[,outCol],riskScore,risk)),cbind(rt[,outCol],riskScore,risk)),
            file="risk.txt",
            sep="\t",
            quote=F,
            row.names=F)

###
####
rt <- read.table("multiCox.txt",header=T,sep="\t",check.names=F,row.names=1)
gene <- rownames(rt)
hr <- sprintf("%.3f",rt$"HR")
hrLow  <- sprintf("%.3f",rt$"HR.95L")
hrHigh <- sprintf("%.3f",rt$"HR.95H")
Hazard.ratio <- paste0(hr,"(",hrLow,"-",hrHigh,")")
pVal <- ifelse(rt$pvalue<0.001, "<0.001", sprintf("%.3f", rt$pvalue))

####
pdf(file="multiCoxforest.pdf", width = 7,height = nrow(rt)/13+5)
n <- nrow(rt)
nRow <- n+1
ylim <- c(1,nRow)
layout(matrix(c(1,2),nc=2),width=c(3,2.5))

xlim = c(0,3)
par(mar=c(4,2.5,2,1))
plot(1,xlim=xlim,ylim=ylim,type="n",axes=F,xlab="",ylab="")
text.cex=0.8
text(0,n:1,gene,adj=0,cex=text.cex)
text(1.5-0.5*0.2,n:1,pVal,adj=1,cex=text.cex);text(1.5-0.5*0.2,n+1,'pvalue',cex=text.cex,font=2,adj=1)
text(3,n:1,Hazard.ratio,adj=1,cex=text.cex);text(3,n+1,'Hazard ratio',cex=text.cex,font=2,adj=1,)

par(mar=c(4,1,2,1),mgp=c(2,0.5,0))
xlim = c(0,max(as.numeric(hrLow),as.numeric(hrHigh)))
plot(1,xlim=xlim,ylim=ylim,type="n",axes=F,ylab="",xaxs="i",xlab="Hazard ratio")
arrows(as.numeric(hrLow),n:1,as.numeric(hrHigh),n:1,angle=90,code=3,length=0.05,col="darkblue",lwd=2.5)
abline(v=1,col="black",lty=2,lwd=2)
boxcolor = ifelse(as.numeric(hr) > 1, "red", "blue")
points(as.numeric(hr), n:1, pch = 15, col = boxcolor, cex=1.6)
axis(1)
dev.off()

save.image(file = "multicox.RData")



PCA
#install.packages("scatterplot3d")

####
library(limma)
library(ggplot2)
library(scatterplot3d)
library(readxl)

expFile="risk1.txt"      
data=read.table(expFile, header=T, sep="\t", check.names=F)
data<-data[complete.cases(data),]
a<-data$ID
rownames(data)<-a

####
risk=as.vector(data$group)

####
data <- subset(data, select = -group)
data <- subset(data, select = -ID)

#PCA
data.pca=prcomp(data, scale. = TRUE)
pcaPredict=predict(data.pca)

####
PCA=data.frame(PC1=pcaPredict[,1], PC2=pcaPredict[,2], risk=risk)
PCA.mean=aggregate(PCA[,1:2], list(risk=PCA$risk), mean)

####
color=ifelse(risk=="high","DarkOrchid","Orange2")
pdf(file="PCA.2d4.pdf", width=5.5, height=4.75)
ggplot(data = PCA, aes(PC1, PC2)) + geom_point(aes(color=color)) +
  scale_colour_manual(name="risk", values =c("DarkOrchid","Orange2"))+
  theme_bw()+
  labs(title ="PCA")+
  theme(plot.margin=unit(rep(1.5,4),'lines'), plot.title = element_text(hjust=0.5))+
  annotate("text",x=PCA.mean$PC1, y=PCA.mean$PC2, label=PCA.mean$risk, cex=7)+theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank())
dev.off()

####
color=ifelse(risk=="high","DarkOrchid","Orange2")
pdf(file="PCA.3d4.pdf", width=7, height=7)
par(oma=c(1,1,2.5,1))
s3d=scatterplot3d(pcaPredict[,1:3], pch = 16, color=color, angle=60)
legend("top", legend = c("High risk","Low risk"),pch = 16, inset = -0.2, box.col="white", xpd = TRUE, horiz = TRUE,col=c("DarkOrchid","Orange2"))
dev.off()

save.image(file = "pca.RData")
write.table(pcaPredict,file = "pcaPredict.txt",sep = "\t")
write.table(PCA.mean,file = "PCA.mean.txt",sep = "\t")
write.table(PCA,file = "PCA.txt",sep = "\t")



Risk triple plot
####
library(pheatmap)
library(readxl)

####
rt <- read_excel("risk all.xlsx")
a<-rt$ID

####
rt=rt[order(rt$risk),]      

####
riskClass=rt[,"group"]
lowLength=length(riskClass[riskClass=="Low"])
#lowLength=121
highLength=length(riskClass[riskClass=="High"])
#highLength=120
lowMax=max(rt$risk[riskClass=="Low"])
#lowMax=1.012525

line=rt[,"risk"]
line[line>10]=10
pdf(file="risk score1.pdf", width=7, height=4)
plot(rt$risk, type="p", pch=20,
     xlab="Patients (increasing risk)",
     ylab="risk score",
     col=c(rep("MediumSeaGreen",lowLength),rep("Firebrick3",highLength)) )
abline(h=lowMax,v=lowLength,lty=2)
legend("topleft", c("High risk","Low risk"),bty="n",pch=19,col=c("Firebrick3","MediumSeaGreen"),cex=1.2)
dev.off()

####
color=as.vector(rt$status)
color[color==1]="Firebrick3"
color[color==0]="MediumSeaGreen"
pdf(file="survStat1.pdf", width=7, height=4)
plot(rt$time, pch=19,
     xlab="Patients (increasing risk)",
     ylab="Survival time (years)",
     col=color)
legend("topleft", c("Dead","Alive"),bty="n",pch=19,col=c("Firebrick3","MediumSeaGreen"),cex=1.2)
abline(v=lowLength,lty=2)
dev.off()

save(data,file = "1.RData")
####
library(pheatmap)
library(readxl)
####
rt <- read_excel("risk3.xlsx")
####
ann_colors=list()
bioCol=c("MediumSeaGreen", "Firebrick3")
names(bioCol)=c("low", "high")
ann_colors[["risk"]]=bioCol
ann_colors

####
a<-rt$ID
risk<-rt$group

rt1<-rt
rt1 <- subset(rt1,select = -ID)
rt1 <- subset(rt1,select = -risk)
rt1 <- subset(rt1,select = -group)
rt1 <- subset(rt1,select = -time)
rt1 <- subset(rt1,select = -status)

rt1=t(rt1)
c<-t(a)
colnames(rt1)<-c

annotation=data.frame(risk)
rownames(annotation)=a

pdf(file="heatmap1.pdf", width=6, height=5)
pheatmap(rt1, 
         annotation=annotation,
         annotation_colors = ann_colors, 
         cluster_cols = FALSE,
         cluster_rows = FALSE,
         show_colnames = F,
         scale="row",
         color = colorRampPalette(c(rep("MediumSeaGreen",3.5), "white", rep("Firebrick3",3.5)))(50),
         fontsize_col=3,
         fontsize=7,
         fontsize_row=8)
dev.off()

save.image(file = "heatmap.RData")####

Numo
#install.packages("survival")
#install.packages("regplot")
#install.packages("rms")

####
library(survival)
library(regplot)
library(rms)
library(readxl)
rt <- read_excel("rt.xlsx")
a<-rt$ID
rt <- subset(rt, select = -ID)
rownames(rt)<-a
rt$time=as.numeric(rt$time)
rt$status=as.numeric(rt$status)

#cox
res.cox=coxph(Surv(time, status) ~ . , data = rt)
####

nom1=regplot(res.cox,
             clickable=F,
             title="",
             points=TRUE,
             droplines=TRUE,
             observation=rt[50,],
             rank="sd",
             failtime = c(1,3,5),
             prfail = F)

####
nomoRisk=predict(res.cox, data=rt, type="risk")
rownames(rt)<-a
rt=cbind(rt, Nomogram=nomoRisk)
outTab=rbind(ID=colnames(rt), rt)
write.table(outTab, file="nomoRisk.txt", sep="\t", col.names=F, quote=F)

####
pdf(file="calibration.pdf", width=6, height=6)
#1 year
f <- cph(Surv(time, status) ~ Nomogram, x=T, y=T, surv=T, data=rt, time.inc=1)
cal <- calibrate(f, cmethod="KM", method="boot", u=1, m=(nrow(rt)/3), B=1000)
plot(cal, xlim=c(0,1), ylim=c(0,1),
     xlab="Nomogram-predicted OS (%)", ylab="Observed OS (%)", lwd=3, col="Firebrick2", sub=F)
#3year
f <- cph(Surv(time, status) ~ Nomogram, x=T, y=T, surv=T, data=rt, time.inc=3)
cal <- calibrate(f, cmethod="KM", method="boot", u=3, m=(nrow(rt)/3), B=1000)
plot(cal, xlim=c(0,1), ylim=c(0,1), xlab="", ylab="", lwd=3, col="MediumSeaGreen", sub=F, add=T)
#5year
f <- cph(Surv(time, status) ~ Nomogram, x=T, y=T, surv=T, data=rt, time.inc=5)
cal <- calibrate(f, cmethod="KM", method="boot", u=5, m=(nrow(rt)/3), B=1000)
plot(cal, xlim=c(0,1), ylim=c(0,1), xlab="", ylab="",  lwd=3, col="NavyBlue", sub=F, add=T)
legend('bottomright', c('1-year', '3-year', '5-year'),
       col=c("Firebrick3","MediumSeaGreen","NavyBlue"), lwd=3, bty = 'n')
dev.off()

save.image(file = "numo.RData")





Drug
#install.packages ("parallel")

install.packages("oncoPredict")
install.packages("oncoPredict", dependencies = TRUE)
if (!require("BiocManager", quietly = TRUE))
  install.packages("BiocManager")
BiocManager::install("GenomicFeatures")
if (!require("BiocManager", quietly = TRUE))
  install.packages("BiocManager")
BiocManager::install("TCGAbiolinks")
if (!require("BiocManager", quietly = TRUE))
  install.packages("BiocManager")
BiocManager::install("TxDb.Hsapiens.UCSC.hg19.knownGene")

####
library(limma)
library(oncoPredict)
library(parallel)
library(limma)
library(ggplot2)
library(ggpubr)
library(limma)
library(reshape2)
library(ggplot2)
library(ggpubr)

####
set.seed(999)

####
data=read.table("GEO1-tumour.txt", header=T, sep="\t", check.names=F,row.names = 1)
####
dimnames=list(rownames(data), colnames(data))
data=matrix(as.numeric(as.matrix(data)), nrow=nrow(data), dimnames=dimnames)
colnames(data)=gsub("(.*?)\\_(.*?)", "\\2", colnames(data))

####
GDSC2_Expr=readRDS(file='GDSC2_Expr.rds')
GDSC2_Res=readRDS(file = 'GDSC2_Res.rds')
GDSC2_Res=exp(GDSC2_Res) 

####
calcPhenotype(trainingExprData = GDSC2_Expr,    
              trainingPtype = GDSC2_Res,        
              testExprData = data,              
              batchCorrect = 'eb',  
              powerTransformPhenotype = TRUE,
              removeLowVaryingGenes = 0.2,    
              minNumSamples = 10,    
              printOutput = TRUE,    
              removeLowVaringGenesFrom = 'rawData')

####
senstivity=read.csv("calcPhenotype_Output/DrugPredictions.csv", header=T, sep=",", check.names=F, row.names=1)
colnames(senstivity)=gsub("(.*)\\_(\\d+)", "\\1", colnames(senstivity))

####
risk=read.table("group2.txt", header=T, sep="\t", check.names=F)
a<-risk$ID
rownames(risk)<-a


####
sameSample=intersect(rownames(risk), row.names(senstivity))
risk=risk[sameSample, "risk",drop=F]
senstivity=senstivity[sameSample,,drop=F]
senstivity[is.na(senstivity)] = 0
senstivity = log2(senstivity+1)
rt=cbind(risk, senstivity)

####
rt$risk=factor(rt$risk, levels=c("low", "high"))
type=levels(factor(rt[,"risk"]))
comp=combn(type, 2)
my_comparisons=list()
for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}

####
sigGene=c()
for(i in colnames(rt)[2:(ncol(rt))]){
  if(sd(rt[,i])<0.05){next}
  wilcoxTest=wilcox.test(rt[,i] ~ rt[,"risk"])
  pvalue=wilcoxTest$p.value
  if(wilcoxTest$p.value<0.001){
    sigGene=c(sigGene, i)
  }
}
sigGene=c(sigGene, "risk")
rt=rt[,sigGene]

####
rt=melt(rt,id.vars=c("risk"))
colnames(rt)=c("risk","Gene","Expression")

####
group=levels(factor(rt$risk))
rt$risk=factor(rt$risk, levels=c("low","high"))
comp=combn(group,2)
my_comparisons=list()
for(j in 1:ncol(comp)){my_comparisons[[j]]<-comp[,j]}

####
boxplot=ggboxplot(rt, x="Gene", y="Expression", fill="risk",
                  xlab="",
                  ylab="Drug Senstivity",
                  legend.title="Risk",
                  width=0.8,
                  palette = c("DodgerBlue1","Firebrick2") )+
  rotate_x_text(50)+
  stat_compare_means(aes(group=risk),
                     method="wilcox.test",
                     symnum.args=list(cutpoints=c(0, 0.001, 0.01, 0.05, 1), 
                                      symbols=c("***", "**", "*", "ns")), label="p.signif")+
  theme(axis.text= element_text(face = "bold.italic",colour = "#441718",size = 16),
        axis.title = element_text(face = "bold.italic",colour = "#441718",size = 16),
        axis.line = element_blank(),
        plot.title = element_text(face = "bold.italic",colour = "#441718",size = 16),
        legend.text = element_text(face ="bold.italic"),
        panel.border = element_rect(fill=NA,color="#35A79D",size=1.5,linetype="solid"),
        panel.background = element_rect(fill = "#F1F6FC"),
        panel.grid.major = element_line(color = "#CFD3D6", size =.5,linetype ="dotdash" ),
        legend.title = element_text(face ="bold.italic",size = 13)
  )

####
pdf(file="drugSenstivity.pdf", width=20, height=8)
print(boxplot)
dev.off()

write.table(rt,file = "sigGene.txt",sep = "\t")

save.image(file = "onepredict.RData")


Iobr
####
# if (!requireNamespace("BiocManager", quietly = TRUE)) install.packages("BiocManager")
# 
# depens<-c('tibble', 'survival', 'survminer', 'limma', "DESeq2","devtools", 'limSolve', 'GSVA', 'e1071', 'preprocessCore', 
#           "devtools", "tidyHeatmap", "caret", "glmnet", "ppcor",  "timeROC", "pracma", "factoextra", 
#           "FactoMineR", "WGCNA", "patchwork", 'ggplot2', "biomaRt", 'ggpubr', 'ComplexHeatmap')
# for(i in 1:length(depens)){
#   depen<-depens[i]
#   if (!requireNamespace(depen, quietly = TRUE))  BiocManager::install(depen,update = FALSE)
# }
# 
# 
# if (!requireNamespace("IOBR", quietly = TRUE))
#   devtools::install_github("IOBR/IOBR")

####
library(IOBR)

####
data=read.table("GEO1-tumour-risk-rhl.txt", header=T, sep="\t", check.names=F,row.names = 1)
group<-data[2,]

#log2
#data = log2(data +1)

####
data=data[rowMeans(data)>0.5,]
a<-rownames(data)

####
# method:'mcpcounter', 'epic', 'xcell', 'cibersort', 'ips', 'quantiseq', 'estimate','timer'
im_mcpcounter <- deconvo_tme(eset = data,method = "mcpcounter")
im_epic <- deconvo_tme(eset = data,method = "epic",arrays = F)
im_xcell <- deconvo_tme(eset = data,method = "xcell",arrays = F)
im_cibersort <- deconvo_tme(eset = data,method = "cibersort",arrays = F,perm = 1000)
im_ips <- deconvo_tme(eset = data,method = "ips",plot = F)
im_quantiseq <- deconvo_tme(eset = data,method = "quantiseq",scale_mrna = T)
im_estimate <- deconvo_tme(eset = data,method = "estimate")
im_timer <- deconvo_tme(eset = data,method = "timer",group_list = rep("coad",dim(data)[2]))

####
im_genesets = signature_collection

#GSVA

im_ssgsea <- calculate_sig_score(eset=data,signature=signature_collection,method= "ssgsea")

####
tme_combine <- im_mcpcounter %>% 
  inner_join(im_epic, by="ID") %>% 
  inner_join(im_xcell, by="ID") %>% 
  inner_join(im_cibersort, by="ID") %>% 
  inner_join(im_ips, by= "ID") %>% 
  inner_join(im_quantiseq, by="ID") %>% 
  inner_join(im_estimate, by= "ID") %>% 
  inner_join(im_timer, by= "ID") %>% 
  inner_join(im_ssgsea, by = "ID")

####
saveRDS(tme_combine,"tme_combine.rds")
# tme_combine = readRDS('tme_combine.rds')

####
####
group=sapply(strsplit(colnames(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)

####
group=gsub("2", "1", group)

group=gsub("0", "low", group)
group=gsub("1", "high", group)
Type = cbind(tme_combine[,1],group)

####
signature_group = sig_group
names(signature_group)[1]
names(signature_group)[1] = "risk_Signature"
names(signature_group)[1]

####
iobr_cor_plot(pdata_group = Type,id1 = "ID",
              feature_data = tme_combine,id2 = "ID",
              group = "group",is_target_continuous  = F,
              category = "signature",character_limit=60,
              #signature_group = sig_group[c(1:10)],
              palette_box = "jco",ProjectID = "geo2")

####
citation123=signature_collection_citation
citation("IOBR")