# Step 0 - Set up and define working directory and file paths.  This is meant 
# simplify the reproducibility of the code. Code was written and performed using 
# RStudio and assumes environment was manually set up via: 
#
# 'RStudio --> Sessions --> Set working directory --> Choose Directory'.

#-------------------------------------------------------------------------------
### Step 1 - Set up working environment 
#-------------------------------------------------------------------------------


# Load libraries:
library(geodata)
library(terra)

# Create directory to store RDS objects for progressive usage: 
dir.create(path = "RDS_objects2")

# Create directory to store spatial data:
dir.create(path = "Geodata") 


#-------------------------------------------------------------------------------
### STEP 2 - Download geospatial data  
#-------------------------------------------------------------------------------


###------------------------------------
### GADM boundaries
###------------------------------------


# Download  GADM United States polygon: 
states <- geodata::gadm( country ="USA" , level = 1 , path = paste0(getwd(),"/Geodata" ))

# Import counties polygon, choose only the counties for WA for model training:
counties <- geodata::gadm( country ="USA" , level = 2 , path = paste0( getwd() , "Geodata" ) )


###------------------------------------
### Land cover data 
###------------------------------------


# List of land cover types:
lc_types <- c("trees", "grassland", "shrubs", "cropland", "built", "bare",
               "snow", "water", "wetland", "mangroves", "moss")

# Loop to easily download all land cover files:
for (i in 1:length(lc_types)){
  geodata::landcover(lc_types[i], path = paste0(getwd(), "/Geodata"))
}


###------------------------------------
### Elevation 
###------------------------------------


# Download Elevation data:
geodata::elevation_global(res = 0.5, path = paste0(getwd(), "/Geodata"))


###------------------------------------
### Bioclimatic data
###------------------------------------


# Download WorldClim data:
geodata::worldclim_global(var = "bio", res = 0.5, path = paste0(getwd(), "/Geodata"))


#-------------------------------------------------------------------------------
### EOC
#-------------------------------------------------------------------------------

