---
description: Explore Ultralytics YOLO metrics tools - from confusion matrix, detection metrics, pose metrics to box IOU. Learn how to compute and plot precision-recall curves.
keywords: Ultralytics, YOLO, YOLOv3, YOLOv4, metrics, confusion matrix, detection metrics, pose metrics, box IOU, mask IOU, plot precision-recall curves, compute average precision
---

# Reference for `ultralytics/utils/metrics.py`

!!! note

    Full source code for this file is available at [https://github.com/ultralytics/ultralytics/blob/main/ultralytics/utils/metrics.py](https://github.com/ultralytics/ultralytics/blob/main/ultralytics/utils/metrics.py). Help us fix any issues you see by submitting a [Pull Request](https://docs.ultralytics.com/help/contributing/) 🛠️. Thank you 🙏!

---
## ::: ultralytics.utils.metrics.ConfusionMatrix
<br><br>

---
## ::: ultralytics.utils.metrics.Metric
<br><br>

---
## ::: ultralytics.utils.metrics.DetMetrics
<br><br>

---
## ::: ultralytics.utils.metrics.SegmentMetrics
<br><br>

---
## ::: ultralytics.utils.metrics.PoseMetrics
<br><br>

---
## ::: ultralytics.utils.metrics.ClassifyMetrics
<br><br>

---
## ::: ultralytics.utils.metrics.bbox_ioa
<br><br>

---
## ::: ultralytics.utils.metrics.box_iou
<br><br>

---
## ::: ultralytics.utils.metrics.bbox_iou
<br><br>

---
## ::: ultralytics.utils.metrics.mask_iou
<br><br>

---
## ::: ultralytics.utils.metrics.kpt_iou
<br><br>

---
## ::: ultralytics.utils.metrics.smooth_BCE
<br><br>

---
## ::: ultralytics.utils.metrics.smooth
<br><br>

---
## ::: ultralytics.utils.metrics.plot_pr_curve
<br><br>

---
## ::: ultralytics.utils.metrics.plot_mc_curve
<br><br>

---
## ::: ultralytics.utils.metrics.compute_ap
<br><br>

---
## ::: ultralytics.utils.metrics.ap_per_class
<br><br>
