/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.CellInfo;
/*     */ import com.dlmu.wisdomST.core.CellInfo1D;
/*     */ import com.dlmu.wisdomST.core.IPoint;
/*     */ import com.dlmu.wisdomST.core.Point;
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import com.dlmu.wisdomST.operation.ShapeIterRecordReader1D;
/*     */ import com.dlmu.wisdomST.operation.SpatialRecordReader1D;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.util.ArrayDeque;
/*     */ import java.util.Arrays;
/*     */ import java.util.Comparator;
/*     */ import java.util.Queue;
/*     */ import java.util.Vector;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.mapred.FileSplit;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class BPTPartitioner
/*     */   extends Partitioner
/*     */ {
/*  43 */   private final Segment seg = new Segment();
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private double[] splits;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void write(DataOutput out) throws IOException {
/*  62 */     this.seg.write(out);
/*  63 */     out.writeInt(this.splits.length);
/*  64 */     ByteBuffer bbuffer = ByteBuffer.allocate(this.splits.length * 8); byte b; int i; double[] arrayOfDouble;
/*  65 */     for (i = (arrayOfDouble = this.splits).length, b = 0; b < i; ) { double split = arrayOfDouble[b];
/*  66 */       bbuffer.putDouble(split); b++; }
/*  67 */      if (bbuffer.hasRemaining())
/*  68 */       throw new RuntimeException("Did not calculate buffer size correctly"); 
/*  69 */     out.write(bbuffer.array(), bbuffer.arrayOffset(), bbuffer.position());
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void readFields(DataInput in) throws IOException {
/*  77 */     this.seg.readFields(in);
/*  78 */     int partitions = in.readInt();
/*  79 */     this.splits = new double[partitions];
/*     */     
/*  81 */     int bufferLength = this.splits.length * 8;
/*  82 */     byte[] buffer = new byte[bufferLength];
/*  83 */     in.readFully(buffer);
/*  84 */     ByteBuffer bbuffer = ByteBuffer.wrap(buffer);
/*  85 */     for (int i = 0; i < this.splits.length; i++)
/*  86 */       this.splits[i] = bbuffer.getDouble(); 
/*  87 */     if (bbuffer.hasRemaining()) {
/*  88 */       throw new RuntimeException("Error reading BPT partitioner");
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void createFromPoints(Segment mbr, IPoint[] points, int capacity) throws IllegalArgumentException {
/* 100 */     int numSplits = (int)Math.ceil(points.length / capacity);
/* 101 */     System.out.println("numSplits：" + numSplits);
/* 102 */     String[] ids = new String[numSplits];
/* 103 */     for (int id = numSplits; id < 2 * numSplits; id++) {
/* 104 */       System.out.println(Integer.toBinaryString(id));
/* 105 */       ids[id - numSplits] = Integer.toBinaryString(id);
/*     */     } 
/*     */ 
/*     */     
/* 109 */     Comparator<IPoint> comparators = 
/* 110 */       new Comparator<IPoint>()
/*     */       {
/*     */         public int compare(IPoint a, IPoint b) {
/* 113 */           return (a.x < b.x) ? -1 : ((a.x > b.x) ? 1 : 0);
/*     */         }
/*     */       };
/*     */     class SplitTask
/*     */     {
/*     */       int fromIndex;
/*     */       
/*     */       int toIndex;
/*     */       
/*     */       int partitionID;
/*     */ 
/*     */       
/*     */       public SplitTask(int fromIndex, int toIndex, int partitionID) {
/* 126 */         this.fromIndex = fromIndex;
/* 127 */         this.toIndex = toIndex;
/*     */         
/* 129 */         this.partitionID = partitionID;
/*     */       }
/*     */     };
/*     */     
/* 133 */     Queue<SplitTask> splitTasks = new ArrayDeque<SplitTask>();
/* 134 */     splitTasks.add(new SplitTask(0, points.length, 1));
/*     */     
/* 136 */     this.seg.set((Shape1D)mbr);
/* 137 */     this.splits = new double[numSplits];
/*     */     
/* 139 */     while (!splitTasks.isEmpty()) {
/* 140 */       SplitTask splitTask = splitTasks.remove();
/*     */       
/* 142 */       if (splitTask.partitionID < numSplits) {
/* 143 */         String child1 = Integer.toBinaryString(splitTask.partitionID * 2);
/*     */         
/* 145 */         String child2 = Integer.toBinaryString(splitTask.partitionID * 2 + 1);
/* 146 */         System.out.println("child1：" + child1 + ",child2：" + child2);
/* 147 */         int size_child1 = 0, size_child2 = 0;
/* 148 */         for (int i = 0; i < ids.length; i++) {
/* 149 */           if (ids[i].startsWith(child1)) {
/* 150 */             size_child1++;
/* 151 */           } else if (ids[i].startsWith(child2)) {
/* 152 */             size_child2++;
/*     */           } 
/*     */         } 
/*     */ 
/*     */         
/* 157 */         int splitIndex = (int)((size_child1 * splitTask.toIndex + size_child2 * splitTask.fromIndex) / (
/* 158 */           size_child1 + size_child2));
/* 159 */         System.out.println(String.valueOf(points.length) + "," + splitTask.fromIndex + "," + splitTask.toIndex + "," + splitIndex);
/*     */         
/* 161 */         partialQuickSort(points, splitTask.fromIndex, splitTask.toIndex, splitIndex, comparators);
/*     */         
/* 163 */         IPoint splitValue = points[splitIndex];
/* 164 */         this.splits[splitTask.partitionID] = splitValue.x;
/* 165 */         System.out.println("splitValue.x:" + splitValue.x);
/* 166 */         splitTasks.add(new SplitTask(this, splitTask.fromIndex, splitIndex, 
/* 167 */               splitTask.partitionID * 2));
/* 168 */         splitTasks.add(new SplitTask(this, splitIndex, splitTask.toIndex, 
/* 169 */               splitTask.partitionID * 2 + 1));
/*     */       } 
/*     */     } 
/*     */   }
/*     */   
/*     */   public static <T> void partialQuickSort(Object[] a, int fromIndex, int toIndex, int desiredIndex, Comparator<T> c) {
/* 175 */     Arrays.sort(a, fromIndex, toIndex, (Comparator)c);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void createFromPoints(Rectangle mbr, Point[] points, int capacity) throws IllegalArgumentException {}
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void overlapPartitions(Shape shape, ResultCollector<Integer> matcher) {}
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void overlapPartitions1D(Shape1D shape, ResultCollector<Integer> matcher) {
/* 201 */     if (shape == null || shape.getSegment() == null)
/*     */       return; 
/* 203 */     Segment shapeMBR = shape.getSegment();
/*     */     class SplitToTest
/*     */     {
/*     */       int splitID;
/*     */ 
/*     */ 
/*     */ 
/*     */       
/*     */       public SplitToTest(int splitID) {
/* 212 */         this.splitID = splitID;
/*     */       }
/*     */     };
/*     */ 
/*     */     
/* 217 */     Queue<SplitToTest> splitsToTest = new ArrayDeque<SplitToTest>();
/*     */     
/* 219 */     splitsToTest.add(new SplitToTest(1));
/*     */     
/* 221 */     while (!splitsToTest.isEmpty()) {
/* 222 */       SplitToTest splitToTest = splitsToTest.remove();
/* 223 */       if (splitToTest.splitID >= this.splits.length) {
/*     */         
/* 225 */         matcher.collect(Integer.valueOf(splitToTest.splitID));
/*     */         
/*     */         continue;
/*     */       } 
/*     */       
/* 230 */       if (shapeMBR.x1 < this.splits[splitToTest.splitID])
/* 231 */         splitsToTest.add(new SplitToTest(this, splitToTest.splitID * 2)); 
/* 232 */       if (shapeMBR.x2 > this.splits[splitToTest.splitID]) {
/* 233 */         splitsToTest.add(new SplitToTest(this, splitToTest.splitID * 2 + 1));
/*     */       }
/*     */     } 
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int overlapPartition(Shape shape) {
/* 247 */     return 0;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int overlapPartition1D(Shape1D shape) {
/* 257 */     if (shape == null || shape.getSegment() == null)
/* 258 */       return -1; 
/* 259 */     IPoint pt = shape.getSegment().getCenterPoint();
/* 260 */     int splitID = 1;
/*     */     
/* 262 */     while (splitID < this.splits.length) {
/*     */ 
/*     */       
/* 265 */       if (pt.x < this.splits[splitID]) {
/* 266 */         splitID *= 2; continue;
/*     */       } 
/* 268 */       splitID = splitID * 2 + 1;
/*     */     } 
/*     */     
/* 271 */     return splitID;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo getPartition(int partitionID) {
/* 281 */     return null;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartition1D(int id) {
/* 290 */     CellInfo1D cellInfo = new CellInfo1D(id, this.seg);
/* 291 */     boolean minXFound = false;
/* 292 */     boolean maxXFound = false;
/*     */ 
/*     */     
/* 295 */     while (id > 1) {
/*     */       
/* 297 */       int minOrMax = id & 0x1;
/* 298 */       id >>>= 1;
/* 299 */       if (minOrMax == 0 && !maxXFound) {
/* 300 */         cellInfo.x2 = this.splits[id]; maxXFound = true; continue;
/* 301 */       }  if (minOrMax == 1 && !minXFound) {
/* 302 */         cellInfo.x1 = this.splits[id]; minXFound = true;
/*     */       } 
/*     */     } 
/*     */     
/* 306 */     return cellInfo;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo getPartitionAt(int index) {
/* 316 */     return null;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartitionAt1D(int index) {
/* 325 */     return getPartition1D(index + this.splits.length);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int getPartitionCount() {
/* 332 */     return this.splits.length;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static int getNumberOfSignificantBits(int x) {
/* 343 */     int numOfSignificantBits = 0;
/* 344 */     if ((x & 0xFFFF0000) != 0) {
/*     */       
/* 346 */       numOfSignificantBits += 16;
/* 347 */       x >>>= 16;
/*     */     } 
/* 349 */     if ((x & 0xFF00) != 0) {
/*     */       
/* 351 */       numOfSignificantBits += 8;
/* 352 */       x >>>= 8;
/*     */     } 
/* 354 */     if ((x & 0xF0) != 0) {
/* 355 */       numOfSignificantBits += 4;
/* 356 */       x >>>= 4;
/*     */     } 
/* 358 */     if ((x & 0xC) != 0) {
/* 359 */       numOfSignificantBits += 2;
/* 360 */       x >>>= 2;
/*     */     } 
/* 362 */     if ((x & 0x2) != 0) {
/* 363 */       numOfSignificantBits++;
/* 364 */       x >>>= 1;
/*     */     } 
/* 366 */     if ((x & 0x1) != 0) {
/* 367 */       numOfSignificantBits++;
/*     */     }
/*     */     
/* 370 */     return numOfSignificantBits;
/*     */   }
/*     */   public static void main(String[] args) throws IOException {
/* 373 */     args = new String[3];
/* 374 */     args[0] = "hdfs://master:9000/test/17.csv";
/* 375 */     args[1] = "shape:com.dlmu.wisdomST.core.TrajBus3";
/* 376 */     args[2] = "segment:90000156,90000168";
/* 377 */     OperationsParams params = new OperationsParams(new GenericOptionsParser(args));
/*     */     
/* 379 */     Path inPath = params.getInputPath();
/* 380 */     long length = inPath.getFileSystem((Configuration)params).getFileStatus(inPath).getLen();
/* 381 */     ShapeIterRecordReader1D reader = new ShapeIterRecordReader1D((Configuration)params, 
/* 382 */         new FileSplit(inPath, 0L, length, new String[0]));
/* 383 */     Segment key = reader.createKey();
/* 384 */     SpatialRecordReader1D.ShapeIterator shapes = reader.createValue();
/* 385 */     Vector<IPoint> points = new Vector<IPoint>();
/* 386 */     while (reader.next(key, shapes)) {
/* 387 */       for (Shape1D s : shapes) {
/* 388 */         points.add(s.getSegment().getCenterPoint());
/*     */       }
/*     */     } 
/* 391 */     Segment inMBR = (Segment)OperationsParams.getShape1D((Configuration)params, "segment");
/*     */     
/* 393 */     BPTPartitioner bpt = new BPTPartitioner();
/* 394 */     bpt.createFromPoints(inMBR, points.<IPoint>toArray(new IPoint[points.size()]), 400);
/* 395 */     System.out.println("x,y,partition");
/* 396 */     int[] sizes = new int[bpt.getPartitionCount() * 2];
/* 397 */     for (IPoint p : points) {
/* 398 */       int partition = bpt.overlapPartition1D((Shape1D)p);
/*     */       
/* 400 */       sizes[partition] = sizes[partition] + 1;
/*     */     } 
/* 402 */     int count = 0;
/* 403 */     for (int i = 0; i < sizes.length; i++) {
/* 404 */       if (sizes[i] != 0) {
/* 405 */         count += sizes[i];
/*     */       }
/*     */     } 
/*     */     
/* 409 */     System.out.println();
/* 410 */     System.out.println(" sizes.length：" + sizes.length);
/* 411 */     System.out.println(" count：" + count);
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\BPTPartitioner.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */