/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.CellInfo;
/*     */ import com.dlmu.wisdomST.core.CellInfo1D;
/*     */ import com.dlmu.wisdomST.core.GridInfo;
/*     */ import com.dlmu.wisdomST.core.IPoint;
/*     */ import com.dlmu.wisdomST.core.Point;
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.util.Arrays;
/*     */ import java.util.Comparator;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class BTRPartitioner
/*     */   extends Partitioner
/*     */ {
/*  38 */   private final Rectangle mbr = new Rectangle();
/*     */ 
/*     */ 
/*     */   
/*     */   private int columns;
/*     */ 
/*     */ 
/*     */   
/*     */   private int rows;
/*     */ 
/*     */   
/*     */   private double[] xSplits;
/*     */ 
/*     */   
/*     */   private double[] ySplits;
/*     */ 
/*     */ 
/*     */   
/*     */   public void createFromPoints(Rectangle mbr, Point[] points, int capacity) {
/*  57 */     Arrays.sort(points, new Comparator<Point>()
/*     */         {
/*     */           public int compare(Point a, Point b) {
/*  60 */             return (a.x < b.x) ? -1 : ((a.x > b.x) ? 1 : 0);
/*     */           }
/*     */         });
/*  63 */     int numSplits = (int)Math.ceil(points.length / capacity);
/*  64 */     GridInfo gridInfo = new GridInfo(mbr.x1, mbr.y1, mbr.x2, mbr.y2);
/*  65 */     gridInfo.calculateCellDimensions(numSplits);
/*  66 */     this.columns = gridInfo.columns;
/*  67 */     this.rows = gridInfo.rows;
/*  68 */     this.xSplits = new double[this.columns];
/*  69 */     this.ySplits = new double[this.rows * this.columns];
/*  70 */     int prev_quantile = 0;
/*  71 */     this.mbr.set((Shape)mbr);
/*  72 */     for (int column = 0; column < this.columns; column++) {
/*  73 */       int col_quantile = (column + 1) * points.length / this.columns;
/*     */       
/*  75 */       this.xSplits[column] = (col_quantile == points.length) ? mbr.x2 : (points[col_quantile - 1]).x;
/*     */       
/*  77 */       Arrays.sort(points, prev_quantile, col_quantile, new Comparator<Point>()
/*     */           {
/*     */             public int compare(Point a, Point b) {
/*  80 */               return (a.y < b.y) ? -1 : ((a.y > b.y) ? 1 : 0);
/*     */             }
/*     */           });
/*     */       
/*  84 */       for (int row = 0; row < this.rows; row++) {
/*  85 */         int row_quantile = (prev_quantile * (this.rows - row + 1) + 
/*  86 */           col_quantile * (row + 1)) / this.rows;
/*     */         
/*  88 */         this.ySplits[column * this.rows + row] = (row_quantile == col_quantile) ? mbr.y2 : (points[row_quantile]).y;
/*     */       } 
/*     */       
/*  91 */       prev_quantile = col_quantile;
/*     */     } 
/*     */   }
/*     */ 
/*     */   
/*     */   public void write(DataOutput out) throws IOException {
/*  97 */     this.mbr.write(out);
/*  98 */     out.writeInt(this.columns);
/*  99 */     out.writeInt(this.rows);
/* 100 */     ByteBuffer bbuffer = ByteBuffer.allocate((this.xSplits.length + this.ySplits.length) * 8); byte b; int i; double[] arrayOfDouble;
/* 101 */     for (i = (arrayOfDouble = this.xSplits).length, b = 0; b < i; ) { double xSplit = arrayOfDouble[b];
/* 102 */       bbuffer.putDouble(xSplit); b++; }
/* 103 */      for (i = (arrayOfDouble = this.ySplits).length, b = 0; b < i; ) { double ySplit = arrayOfDouble[b];
/* 104 */       bbuffer.putDouble(ySplit); b++; }
/* 105 */      if (bbuffer.hasRemaining())
/* 106 */       throw new RuntimeException("Did not calculate buffer size correctly"); 
/* 107 */     out.write(bbuffer.array(), bbuffer.arrayOffset(), bbuffer.position());
/*     */   }
/*     */ 
/*     */   
/*     */   public void readFields(DataInput in) throws IOException {
/* 112 */     this.mbr.readFields(in);
/* 113 */     this.columns = in.readInt();
/* 114 */     this.rows = in.readInt();
/* 115 */     this.xSplits = new double[this.columns];
/* 116 */     this.ySplits = new double[this.columns * this.rows];
/*     */     
/* 118 */     int bufferLength = (this.xSplits.length + this.ySplits.length) * 8;
/* 119 */     byte[] buffer = new byte[bufferLength];
/* 120 */     in.readFully(buffer);
/* 121 */     ByteBuffer bbuffer = ByteBuffer.wrap(buffer); int i;
/* 122 */     for (i = 0; i < this.xSplits.length; i++)
/* 123 */       this.xSplits[i] = bbuffer.getDouble(); 
/* 124 */     for (i = 0; i < this.ySplits.length; i++)
/* 125 */       this.ySplits[i] = bbuffer.getDouble(); 
/* 126 */     if (bbuffer.hasRemaining()) {
/* 127 */       throw new RuntimeException("Error reading STR partitioner");
/*     */     }
/*     */   }
/*     */   
/*     */   public int getPartitionCount() {
/* 132 */     return this.ySplits.length;
/*     */   }
/*     */ 
/*     */   
/*     */   public void overlapPartitions(Shape shape, ResultCollector<Integer> matcher) {
/* 137 */     if (shape == null)
/*     */       return; 
/* 139 */     Rectangle shapeMBR = shape.getMBR();
/* 140 */     if (shapeMBR == null) {
/*     */       return;
/*     */     }
/*     */     
/* 144 */     int col1 = Arrays.binarySearch(this.xSplits, shapeMBR.x1);
/* 145 */     if (col1 < 0)
/* 146 */       col1 = -col1 - 1; 
/* 147 */     int col2 = Arrays.binarySearch(this.xSplits, shapeMBR.x2);
/* 148 */     if (col2 < 0) {
/* 149 */       col2 = -col2 - 1;
/*     */     }
/* 151 */     for (int col = col1; col <= col2; col++) {
/*     */       
/* 153 */       int cell1 = Arrays.binarySearch(this.ySplits, col * this.rows, (col + 1) * this.rows, shapeMBR.y1);
/* 154 */       if (cell1 < 0)
/* 155 */         cell1 = -cell1 - 1; 
/* 156 */       int cell2 = Arrays.binarySearch(this.ySplits, col * this.rows, (col + 1) * this.rows, shapeMBR.y2);
/* 157 */       if (cell2 < 0) {
/* 158 */         cell2 = -cell2 - 1;
/*     */       }
/* 160 */       for (int cell = cell1; cell <= cell2; cell++) {
/* 161 */         matcher.collect(Integer.valueOf(cell));
/*     */       }
/*     */     } 
/*     */   }
/*     */   
/*     */   public int overlapPartition(Shape shape) {
/* 167 */     if (shape == null)
/* 168 */       return -1; 
/* 169 */     Rectangle shapeMBR = shape.getMBR();
/* 170 */     if (shapeMBR == null) {
/* 171 */       return -1;
/*     */     }
/*     */     
/* 174 */     int col = Arrays.binarySearch(this.xSplits, shapeMBR.x1);
/* 175 */     if (col < 0)
/* 176 */       col = -col - 1; 
/* 177 */     int cell = Arrays.binarySearch(this.ySplits, col * this.rows, (col + 1) * this.rows, shapeMBR.y1);
/* 178 */     if (cell < 0)
/* 179 */       cell = -cell - 1; 
/* 180 */     return cell;
/*     */   }
/*     */ 
/*     */   
/*     */   public CellInfo getPartitionAt(int index) {
/* 185 */     return getPartition(index);
/*     */   }
/*     */ 
/*     */   
/*     */   public CellInfo getPartition(int id) {
/* 190 */     int col = id / this.rows;
/* 191 */     int row = id % this.rows;
/* 192 */     double y2 = this.ySplits[id];
/* 193 */     double y1 = (row == 0) ? this.mbr.y1 : this.ySplits[id - 1];
/* 194 */     double x2 = this.xSplits[col];
/* 195 */     double x1 = (col == 0) ? this.mbr.x1 : this.xSplits[col - 1];
/* 196 */     return new CellInfo(id, x1, y1, x2, y2);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void createFromPoints(Segment mbr, IPoint[] points, int capacity) throws IllegalArgumentException {}
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void overlapPartitions1D(Shape1D shape, ResultCollector<Integer> matcher) {}
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int overlapPartition1D(Shape1D shape) {
/* 223 */     return 0;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartition1D(int partitionID) {
/* 232 */     return null;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartitionAt1D(int index) {
/* 241 */     return null;
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\BTRPartitioner.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */