/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.ResultCollector2;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.core.SpatialAlgorithms;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import java.util.Iterator;
/*     */ import java.util.Vector;
/*     */ import org.apache.hadoop.io.Writable;
/*     */ import org.apache.hadoop.util.IndexedSortable;
/*     */ import org.apache.hadoop.util.QuickSort;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class GlobalIndex<S extends Shape>
/*     */   implements Writable, Iterable<S>
/*     */ {
/*     */   protected S stockShape;
/*     */   protected S[] shapes;
/*     */   private boolean compact;
/*     */   private boolean replicated;
/*     */   
/*     */   public void bulkLoad(Shape[] shapes) {
/*  56 */     this.shapes = (S[])shapes.clone();
/*     */     
/*  58 */     for (int i = 0; i < this.shapes.length; i++) {
/*  59 */       this.shapes[i] = (S)this.shapes[i].clone();
/*     */     }
/*     */   }
/*     */ 
/*     */   
/*     */   public void write(DataOutput out) throws IOException {
/*  65 */     out.writeInt(this.shapes.length);
/*  66 */     for (int i = 0; i < this.shapes.length; i++) {
/*  67 */       this.shapes[i].write(out);
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public void readFields(DataInput in) throws IOException {
/*  74 */     int length = in.readInt();
/*  75 */     this.shapes = (S[])new Shape[length];
/*  76 */     for (int i = 0; i < length; i++) {
/*  77 */       this.shapes[i] = (S)this.stockShape.clone();
/*  78 */       this.shapes[i].readFields(in);
/*     */     } 
/*     */   }
/*     */ 
/*     */   
/*     */   public int rangeQuery(Shape queryRange, ResultCollector<S> output) {
/*  84 */     int result_count = 0; byte b; int i; S[] arrayOfS;
/*  85 */     for (i = (arrayOfS = this.shapes).length, b = 0; b < i; ) { S shape = arrayOfS[b];
/*     */       
/*  87 */       System.out.println(shape.getClass());
/*  88 */       if (shape.isIntersected(queryRange)) {
/*     */         
/*  90 */         result_count++;
/*  91 */         if (output != null)
/*  92 */           output.collect(shape); 
/*     */       } 
/*     */       b++; }
/*     */     
/*  96 */     return result_count;
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public static <S1 extends Shape, S2 extends Shape> int spatialJoin(GlobalIndex<S1> s1, GlobalIndex<S2> s2, ResultCollector2<S1, S2> output) {
/* 102 */     return SpatialAlgorithms.SpatialJoin_planeSweep((Shape[])s1.shapes, (Shape[])s2.shapes, output, null);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   class SimpleIterator
/*     */     implements Iterator<S>
/*     */   {
/* 114 */     int i = 0;
/*     */ 
/*     */     
/*     */     public boolean hasNext() {
/* 118 */       return (this.i < GlobalIndex.this.shapes.length);
/*     */     }
/*     */ 
/*     */     
/*     */     public S next() {
/* 123 */       return GlobalIndex.this.shapes[this.i++];
/*     */     }
/*     */ 
/*     */     
/*     */     public void remove() {
/* 128 */       throw new RuntimeException("Not implemented");
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public Iterator<S> iterator() {
/* 135 */     return new SimpleIterator();
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int size() {
/* 143 */     return this.shapes.length;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public Rectangle getMBR() {
/* 152 */     Iterator<S> i = iterator();
/* 153 */     if (!i.hasNext())
/* 154 */       return null; 
/* 155 */     Rectangle globalMBR = new Rectangle(Double.MAX_VALUE, Double.MAX_VALUE, 
/* 156 */         -1.7976931348623157E308D, -1.7976931348623157E308D);
/* 157 */     while (i.hasNext()) {
/* 158 */       globalMBR.expand((Shape)((Shape)i.next()).getMBR());
/*     */     }
/* 160 */     return globalMBR;
/*     */   }
/*     */   
/*     */   public int knn(final double qx, final double qy, int k, ResultCollector2<S, Double> output) {
/*     */     boolean result_correct;
/* 165 */     double query_area = getMBR().getWidth() * getMBR().getHeight() * k / size();
/* 166 */     double query_radius = Math.sqrt(query_area / Math.PI);
/*     */ 
/*     */     
/* 169 */     final Vector<Double> distances = new Vector<Double>();
/* 170 */     final Vector<S> shapes = new Vector<S>();
/*     */ 
/*     */ 
/*     */     
/*     */     do {
/* 175 */       distances.clear(); shapes.clear();
/* 176 */       Rectangle queryRange = new Rectangle();
/* 177 */       queryRange.x1 = qx - query_radius / 2.0D;
/* 178 */       queryRange.y1 = qy - query_radius / 2.0D;
/* 179 */       queryRange.x2 = qx + query_radius / 2.0D;
/* 180 */       queryRange.y2 = qy + query_radius / 2.0D;
/*     */       
/* 182 */       rangeQuery((Shape)queryRange, new ResultCollector<S>()
/*     */           {
/*     */             public void collect(S shape) {
/* 185 */               distances.add(Double.valueOf(shape.distanceTo(qx, qy)));
/* 186 */               shapes.add(shape.clone());
/*     */             }
/*     */           });
/* 189 */       if (shapes.size() <= k) {
/*     */         
/* 191 */         if (shapes.size() == size() || shapes.size() == k) {
/*     */           
/* 193 */           result_correct = true;
/*     */         } else {
/* 195 */           query_radius *= 2.0D;
/* 196 */           result_correct = false;
/*     */         } 
/*     */       } else {
/*     */         
/* 200 */         IndexedSortable s = new IndexedSortable()
/*     */           {
/*     */             public void swap(int i, int j) {
/* 203 */               double temp_distance = ((Double)distances.elementAt(i)).doubleValue();
/* 204 */               distances.set(i, distances.elementAt(j));
/* 205 */               distances.set(j, Double.valueOf(temp_distance));
/*     */               
/* 207 */               Shape shape = shapes.elementAt(i);
/* 208 */               shapes.set(i, shapes.elementAt(j));
/* 209 */               shapes.set(j, shape);
/*     */             }
/*     */ 
/*     */ 
/*     */             
/*     */             public int compare(int i, int j) {
/* 215 */               if (distances.elementAt(i) == distances.elementAt(j))
/* 216 */                 return 0; 
/* 217 */               if (((Double)distances.elementAt(i)).doubleValue() < ((Double)distances.elementAt(j)).doubleValue())
/* 218 */                 return -1; 
/* 219 */               return 1;
/*     */             }
/*     */           };
/* 222 */         QuickSort quickSort = new QuickSort();
/* 223 */         quickSort.sort(s, 0, shapes.size());
/* 224 */         if (((Double)distances.elementAt(k - 1)).doubleValue() > query_radius) {
/* 225 */           result_correct = false;
/* 226 */           query_radius = ((Double)distances.elementAt(k)).doubleValue();
/*     */         } else {
/* 228 */           result_correct = true;
/*     */         } 
/*     */       } 
/* 231 */     } while (!result_correct);
/*     */     
/* 233 */     int result_size = Math.min(k, shapes.size());
/* 234 */     if (output != null) {
/* 235 */       for (int i = 0; i < result_size; i++) {
/* 236 */         output.collect((Shape)shapes.elementAt(i), distances.elementAt(i));
/*     */       }
/*     */     }
/* 239 */     return result_size;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public boolean isCompact() {
/* 249 */     return this.compact;
/*     */   }
/*     */   
/*     */   public void setCompact(boolean compact) {
/* 253 */     this.compact = compact;
/*     */   }
/*     */   
/*     */   public void setReplicated(boolean r) {
/* 257 */     this.replicated = r;
/*     */   }
/*     */   
/*     */   public boolean isReplicated() {
/* 261 */     return this.replicated;
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\GlobalIndex.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */