/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.ResultCollector2;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import com.dlmu.wisdomST.core.SpatialAlgorithms;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import java.util.Iterator;
/*     */ import java.util.Vector;
/*     */ import org.apache.hadoop.io.Writable;
/*     */ import org.apache.hadoop.util.IndexedSortable;
/*     */ import org.apache.hadoop.util.QuickSort;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class GlobalIndex1D<S extends Shape1D>
/*     */   implements Writable, Iterable<S>
/*     */ {
/*     */   protected S stockShape;
/*     */   protected S[] shapes;
/*     */   private boolean compact;
/*     */   private boolean replicated;
/*     */   
/*     */   public void bulkLoad(Shape1D[] shapes) {
/*  56 */     this.shapes = (S[])shapes.clone();
/*     */     
/*  58 */     for (int i = 0; i < this.shapes.length; i++) {
/*  59 */       this.shapes[i] = (S)this.shapes[i].clone();
/*     */     }
/*     */   }
/*     */ 
/*     */   
/*     */   public void write(DataOutput out) throws IOException {
/*  65 */     out.writeInt(this.shapes.length);
/*  66 */     for (int i = 0; i < this.shapes.length; i++) {
/*  67 */       this.shapes[i].write(out);
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public void readFields(DataInput in) throws IOException {
/*  74 */     int length = in.readInt();
/*  75 */     this.shapes = (S[])new Shape1D[length];
/*  76 */     for (int i = 0; i < length; i++) {
/*  77 */       this.shapes[i] = (S)this.stockShape.clone();
/*  78 */       this.shapes[i].readFields(in);
/*     */     } 
/*     */   }
/*     */   
/*     */   public int rangeQuery(Shape1D queryRange, ResultCollector<S> output) {
/*  83 */     int result_count = 0; byte b; int i; S[] arrayOfS;
/*  84 */     for (i = (arrayOfS = this.shapes).length, b = 0; b < i; ) { S shape = arrayOfS[b];
/*  85 */       if (shape.isIntersected(queryRange)) {
/*  86 */         result_count++;
/*  87 */         if (output != null)
/*  88 */           output.collect(shape); 
/*     */       } 
/*     */       b++; }
/*     */     
/*  92 */     return result_count;
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public static <S1 extends Shape1D, S2 extends Shape1D> int spatialJoin(GlobalIndex1D<S1> s1, GlobalIndex1D<S2> s2, ResultCollector2<S1, S2> output) {
/*  98 */     return SpatialAlgorithms.SpatialJoin_planeSweep1D((Shape1D[])s1.shapes, (Shape1D[])s2.shapes, output, null);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   class SimpleIterator
/*     */     implements Iterator<S>
/*     */   {
/* 110 */     int i = 0;
/*     */ 
/*     */     
/*     */     public boolean hasNext() {
/* 114 */       return (this.i < GlobalIndex1D.this.shapes.length);
/*     */     }
/*     */ 
/*     */     
/*     */     public S next() {
/* 119 */       return GlobalIndex1D.this.shapes[this.i++];
/*     */     }
/*     */ 
/*     */     
/*     */     public void remove() {
/* 124 */       throw new RuntimeException("Not implemented");
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public Iterator<S> iterator() {
/* 131 */     return new SimpleIterator();
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int size() {
/* 139 */     return this.shapes.length;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public Segment getSegment() {
/* 148 */     Iterator<S> i = iterator();
/* 149 */     if (!i.hasNext())
/* 150 */       return null; 
/* 151 */     Segment globalMBR = new Segment(Double.MAX_VALUE, 
/* 152 */         -1.7976931348623157E308D);
/* 153 */     while (i.hasNext()) {
/* 154 */       globalMBR.expand((Shape1D)((Shape1D)i.next()).getSegment());
/*     */     }
/* 156 */     return globalMBR;
/*     */   }
/*     */   
/*     */   public int knn(final double qx, double qy, int k, ResultCollector2<S, Double> output) {
/*     */     boolean result_correct;
/* 161 */     double query_area = getSegment().getWidth() * k / size();
/* 162 */     double query_radius = Math.sqrt(query_area / Math.PI);
/*     */ 
/*     */     
/* 165 */     final Vector<Double> distances = new Vector<Double>();
/* 166 */     final Vector<S> shapes = new Vector<S>();
/*     */ 
/*     */ 
/*     */     
/*     */     do {
/* 171 */       distances.clear(); shapes.clear();
/* 172 */       Segment queryRange = new Segment();
/* 173 */       queryRange.x1 = qx - query_radius / 2.0D;
/* 174 */       queryRange.x2 = qx + query_radius / 2.0D;
/*     */ 
/*     */       
/* 177 */       rangeQuery((Shape1D)queryRange, new ResultCollector<S>()
/*     */           {
/*     */             public void collect(S shape) {
/* 180 */               distances.add(Double.valueOf(shape.distanceTo(qx)));
/* 181 */               shapes.add(shape.clone());
/*     */             }
/*     */           });
/* 184 */       if (shapes.size() <= k) {
/*     */         
/* 186 */         if (shapes.size() == size() || shapes.size() == k) {
/*     */           
/* 188 */           result_correct = true;
/*     */         } else {
/* 190 */           query_radius *= 2.0D;
/* 191 */           result_correct = false;
/*     */         } 
/*     */       } else {
/*     */         
/* 195 */         IndexedSortable s = new IndexedSortable()
/*     */           {
/*     */             public void swap(int i, int j) {
/* 198 */               double temp_distance = ((Double)distances.elementAt(i)).doubleValue();
/* 199 */               distances.set(i, distances.elementAt(j));
/* 200 */               distances.set(j, Double.valueOf(temp_distance));
/*     */               
/* 202 */               Shape1D shape1D = shapes.elementAt(i);
/* 203 */               shapes.set(i, shapes.elementAt(j));
/* 204 */               shapes.set(j, shape1D);
/*     */             }
/*     */ 
/*     */ 
/*     */             
/*     */             public int compare(int i, int j) {
/* 210 */               if (distances.elementAt(i) == distances.elementAt(j))
/* 211 */                 return 0; 
/* 212 */               if (((Double)distances.elementAt(i)).doubleValue() < ((Double)distances.elementAt(j)).doubleValue())
/* 213 */                 return -1; 
/* 214 */               return 1;
/*     */             }
/*     */           };
/* 217 */         QuickSort quickSort = new QuickSort();
/* 218 */         quickSort.sort(s, 0, shapes.size());
/* 219 */         if (((Double)distances.elementAt(k - 1)).doubleValue() > query_radius) {
/* 220 */           result_correct = false;
/* 221 */           query_radius = ((Double)distances.elementAt(k)).doubleValue();
/*     */         } else {
/* 223 */           result_correct = true;
/*     */         } 
/*     */       } 
/* 226 */     } while (!result_correct);
/*     */     
/* 228 */     int result_size = Math.min(k, shapes.size());
/* 229 */     if (output != null) {
/* 230 */       for (int i = 0; i < result_size; i++) {
/* 231 */         output.collect((Shape1D)shapes.elementAt(i), distances.elementAt(i));
/*     */       }
/*     */     }
/* 234 */     return result_size;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public boolean isCompact() {
/* 244 */     return this.compact;
/*     */   }
/*     */   
/*     */   public void setCompact(boolean compact) {
/* 248 */     this.compact = compact;
/*     */   }
/*     */   
/*     */   public void setReplicated(boolean r) {
/* 252 */     this.replicated = r;
/*     */   }
/*     */   
/*     */   public boolean isReplicated() {
/* 256 */     return this.replicated;
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\GlobalIndex1D.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */