/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.CellInfo;
/*     */ import com.dlmu.wisdomST.core.CellInfo1D;
/*     */ import com.dlmu.wisdomST.core.GridInfo;
/*     */ import com.dlmu.wisdomST.core.IPoint;
/*     */ import com.dlmu.wisdomST.core.Point;
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class GridPartitioner
/*     */   extends Partitioner
/*     */ {
/*  38 */   private static final Log LOG = LogFactory.getLog(GridPartitioner.class);
/*     */ 
/*     */   
/*     */   protected double x;
/*     */   
/*     */   protected double y;
/*     */   
/*     */   protected int numTiles;
/*     */   
/*     */   protected int numColumns;
/*     */   
/*     */   protected int numRows;
/*     */   
/*     */   protected double tileWidth;
/*     */   
/*     */   protected double tileHeight;
/*     */ 
/*     */   
/*     */   public GridPartitioner() {}
/*     */ 
/*     */   
/*     */   public GridPartitioner(Rectangle mbr, int columns, int rows) {
/*  60 */     this.x = mbr.x1;
/*  61 */     this.y = mbr.y1;
/*  62 */     this.numTiles = rows * columns;
/*  63 */     this.numColumns = columns;
/*  64 */     this.numRows = rows;
/*  65 */     this.tileWidth = mbr.getWidth() / columns;
/*  66 */     this.tileHeight = mbr.getHeight() / rows;
/*     */   }
/*     */   
/*     */   public void createFromPoints(Rectangle mbr, Point[] points, int capacity) throws IllegalArgumentException {
/*     */     int maxCellSize;
/*  71 */     if (points.length == 0) {
/*  72 */       throw new IllegalArgumentException("Amount of points must be > 0");
/*     */     }
/*  74 */     this.x = mbr.x1;
/*  75 */     this.y = mbr.y1;
/*     */ 
/*     */     
/*  78 */     this.numTiles = (int)Math.ceil((points.length / capacity));
/*  79 */     GridInfo gridInfo = new GridInfo(mbr.x1, mbr.y1, mbr.x2, mbr.y2);
/*     */ 
/*     */     
/*  82 */     int maxIterations = 1000;
/*     */     
/*     */     do {
/*  85 */       int cols = (int)Math.round(Math.sqrt(this.numTiles));
/*     */       
/*  87 */       this.numColumns = gridInfo.columns = Math.max(1, cols);
/*  88 */       this.numRows = gridInfo.rows = (int)Math.ceil((this.numTiles / gridInfo.columns));
/*     */       
/*  90 */       maxCellSize = 0;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */     
/*     */     }
/* 102 */     while (maxCellSize > capacity && maxIterations-- > 0);
/* 103 */     LOG.info("Partitioning the space into a " + gridInfo.columns + "x" + gridInfo.rows + " grid");
/* 104 */     this.tileWidth = mbr.getWidth() / gridInfo.columns;
/* 105 */     this.tileHeight = mbr.getHeight() / gridInfo.rows;
/*     */   }
/*     */ 
/*     */   
/*     */   public void write(DataOutput out) throws IOException {
/* 110 */     out.writeDouble(this.x);
/* 111 */     out.writeDouble(this.y);
/* 112 */     out.writeDouble(this.tileWidth);
/* 113 */     out.writeDouble(this.tileHeight);
/* 114 */     out.writeInt(this.numTiles);
/*     */   }
/*     */ 
/*     */   
/*     */   public void readFields(DataInput in) throws IOException {
/* 119 */     this.x = in.readDouble();
/* 120 */     this.y = in.readDouble();
/* 121 */     this.tileWidth = in.readDouble();
/* 122 */     this.tileHeight = in.readDouble();
/* 123 */     this.numTiles = in.readInt();
/* 124 */     this.numColumns = (int)Math.round(Math.sqrt(this.numTiles));
/* 125 */     this.numRows = (int)Math.ceil((this.numTiles / this.numColumns));
/*     */   }
/*     */ 
/*     */   
/*     */   public int getPartitionCount() {
/* 130 */     return this.numTiles;
/*     */   }
/*     */ 
/*     */   
/*     */   public void overlapPartitions(Shape shape, ResultCollector<Integer> matcher) {
/* 135 */     if (shape == null)
/*     */       return; 
/* 137 */     Rectangle shapeMBR = shape.getMBR();
/* 138 */     if (shapeMBR == null) {
/*     */       return;
/*     */     }
/* 141 */     int col1 = (int)Math.floor((shapeMBR.x1 - this.x) / this.tileWidth);
/* 142 */     int col2 = (int)Math.ceil((shapeMBR.x2 - this.x) / this.tileWidth);
/* 143 */     int row1 = (int)Math.floor((shapeMBR.y1 - this.y) / this.tileHeight);
/* 144 */     int row2 = (int)Math.ceil((shapeMBR.y2 - this.y) / this.tileHeight);
/*     */     
/* 146 */     if (col1 < 0) col1 = 0; 
/* 147 */     if (row1 < 0) row1 = 0; 
/* 148 */     for (int col = col1; col < col2; col++) {
/* 149 */       for (int row = row1; row < row2; row++)
/* 150 */         matcher.collect(Integer.valueOf(getCellNumber(col, row))); 
/*     */     } 
/*     */   }
/*     */   private int getCellNumber(int col, int row) {
/* 154 */     return row * this.numColumns + col;
/*     */   }
/*     */ 
/*     */   
/*     */   public int overlapPartition(Shape shape) {
/* 159 */     if (shape == null)
/* 160 */       return -1; 
/* 161 */     Rectangle shapeMBR = shape.getMBR();
/* 162 */     if (shapeMBR == null)
/* 163 */       return -1; 
/* 164 */     Point centerPoint = shapeMBR.getCenterPoint();
/* 165 */     int col = (int)Math.floor((centerPoint.x - this.x) / this.tileWidth);
/* 166 */     int row = (int)Math.floor((centerPoint.y - this.y) / this.tileHeight);
/* 167 */     return getCellNumber(col, row);
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo getPartition(int partitionID) {
/* 173 */     int col = partitionID % this.numColumns;
/* 174 */     int row = partitionID / this.numColumns;
/* 175 */     return new CellInfo(partitionID, this.x + col * this.tileWidth, this.y + row * this.tileHeight, 
/* 176 */         this.x + (col + 1) * this.tileWidth, this.y + (row + 1) * this.tileHeight);
/*     */   }
/*     */ 
/*     */   
/*     */   public CellInfo getPartitionAt(int index) {
/* 181 */     return getPartition(index);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void overlapPartitions1D(Shape1D shape, ResultCollector<Integer> matcher) {}
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int overlapPartition1D(Shape1D shape) {
/* 199 */     return 0;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartition1D(int partitionID) {
/* 213 */     return null;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartitionAt1D(int index) {
/* 222 */     return null;
/*     */   }
/*     */   
/*     */   public void createFromPoints(Segment mbr, IPoint[] points, int capacity) throws IllegalArgumentException {}
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\GridPartitioner.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */