/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.CellInfo;
/*     */ import com.dlmu.wisdomST.core.CellInfo1D;
/*     */ import com.dlmu.wisdomST.core.IPoint;
/*     */ import com.dlmu.wisdomST.core.Point;
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialRecordReader;
/*     */ import com.dlmu.wisdomST.operation.ShapeIterRecordReader;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.util.Arrays;
/*     */ import java.util.Vector;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.mapred.FileSplit;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class HilbertCurvePartitioner
/*     */   extends Partitioner
/*     */ {
/*     */   protected int[] splits;
/*  46 */   protected final Rectangle mbr = new Rectangle();
/*     */ 
/*     */ 
/*     */   
/*     */   protected static final int Resolution = 32767;
/*     */ 
/*     */ 
/*     */   
/*     */   public void createFromPoints(Rectangle mbr, Point[] points, int capacity) {
/*  55 */     this.mbr.set((Shape)mbr);
/*  56 */     int[] hValues = new int[points.length];
/*  57 */     for (int i = 0; i < points.length; i++)
/*  58 */       hValues[i] = computeHValue(mbr, (points[i]).x, (points[i]).y); 
/*  59 */     createFromHValues(hValues, capacity);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected void createFromHValues(int[] hValues, int capacity) {
/*  68 */     Arrays.sort(hValues);
/*  69 */     int numSplits = (int)Math.ceil(hValues.length / capacity);
/*  70 */     this.splits = new int[numSplits];
/*  71 */     int maxH = Integer.MAX_VALUE;
/*  72 */     for (int i = 0; i < this.splits.length; i++) {
/*  73 */       int quantile = (int)((i + 1) * hValues.length / numSplits);
/*  74 */       this.splits[i] = (quantile == hValues.length) ? maxH : hValues[quantile];
/*     */     } 
/*     */   }
/*     */ 
/*     */   
/*     */   public void write(DataOutput out) throws IOException {
/*  80 */     this.mbr.write(out);
/*  81 */     out.writeInt(this.splits.length);
/*  82 */     ByteBuffer bbuffer = ByteBuffer.allocate(this.splits.length * 4); byte b; int i, arrayOfInt[];
/*  83 */     for (i = (arrayOfInt = this.splits).length, b = 0; b < i; ) { int split = arrayOfInt[b];
/*  84 */       bbuffer.putInt(split); b++; }
/*  85 */      out.write(bbuffer.array(), bbuffer.arrayOffset(), bbuffer.position());
/*     */   }
/*     */ 
/*     */   
/*     */   public void readFields(DataInput in) throws IOException {
/*  90 */     this.mbr.readFields(in);
/*  91 */     this.splits = new int[in.readInt()];
/*  92 */     byte[] buffer = new byte[this.splits.length * 4];
/*  93 */     in.readFully(buffer);
/*  94 */     ByteBuffer bbuffer = ByteBuffer.wrap(buffer);
/*  95 */     for (int i = 0; i < this.splits.length; i++) {
/*  96 */       this.splits[i] = bbuffer.getInt();
/*     */     }
/*     */   }
/*     */   
/*     */   public void overlapPartitions(Shape shape, ResultCollector<Integer> matcher) {
/* 101 */     throw new RuntimeException("Non-implemented method");
/*     */   }
/*     */ 
/*     */   
/*     */   public int overlapPartition(Shape shape) {
/* 106 */     if (shape == null)
/* 107 */       return -1; 
/* 108 */     Rectangle shapeMBR = shape.getMBR();
/* 109 */     if (shapeMBR == null) {
/* 110 */       return -1;
/*     */     }
/* 112 */     Point center = shapeMBR.getCenterPoint();
/* 113 */     int hValue = computeHValue(this.mbr, center.x, center.y);
/* 114 */     int partition = Arrays.binarySearch(this.splits, hValue);
/* 115 */     if (partition < 0)
/* 116 */       partition = -partition - 1; 
/* 117 */     return partition;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static int computeHValue(int n, int x, int y) {
/* 129 */     int h = 0;
/* 130 */     for (int s = n / 2; s > 0; s /= 2) {
/* 131 */       int rx = ((x & s) > 0) ? 1 : 0;
/* 132 */       int ry = ((y & s) > 0) ? 1 : 0;
/* 133 */       h += s * s * (3 * rx ^ ry);
/*     */ 
/*     */       
/* 136 */       if (ry == 0) {
/* 137 */         if (rx == 1) {
/* 138 */           x = n - 1 - x;
/* 139 */           y = n - 1 - y;
/*     */         } 
/*     */ 
/*     */         
/* 143 */         int t = x; x = y; y = t;
/*     */       } 
/*     */     } 
/* 146 */     return h;
/*     */   }
/*     */   public static int computeHValue(Rectangle inMBR, double x, double y) {
/* 149 */     int ix = (int)((x - inMBR.x1) * 32767.0D / inMBR.getWidth());
/* 150 */     int iy = (int)((y - inMBR.y1) * 32767.0D / inMBR.getHeight());
/* 151 */     return computeHValue(32768, ix, iy);
/*     */   }
/*     */ 
/*     */   
/*     */   public CellInfo getPartition(int partitionID) {
/* 156 */     throw new RuntimeException("Non-implemented method");
/*     */   }
/*     */ 
/*     */   
/*     */   public CellInfo getPartitionAt(int index) {
/* 161 */     throw new RuntimeException("Non-implemented method");
/*     */   }
/*     */ 
/*     */   
/*     */   public int getPartitionCount() {
/* 166 */     return this.splits.length;
/*     */   }
/*     */   
/*     */   public static void main(String[] args) throws IOException {
/* 170 */     OperationsParams params = new OperationsParams(new GenericOptionsParser(args));
/*     */     
/* 172 */     Path inPath = params.getInputPath();
/* 173 */     long length = inPath.getFileSystem((Configuration)params).getFileStatus(inPath).getLen();
/* 174 */     ShapeIterRecordReader reader = new ShapeIterRecordReader((Configuration)params, 
/* 175 */         new FileSplit(inPath, 0L, length, new String[0]));
/* 176 */     Rectangle key = reader.createKey();
/* 177 */     SpatialRecordReader.ShapeIterator shapes = reader.createValue();
/* 178 */     Vector<Point> points = new Vector<Point>();
/* 179 */     while (reader.next(key, shapes)) {
/* 180 */       for (Shape s : shapes) {
/* 181 */         points.add(s.getMBR().getCenterPoint());
/*     */       }
/*     */     } 
/* 184 */     Rectangle inMBR = (Rectangle)OperationsParams.getShape((Configuration)params, "mbr");
/* 185 */     HilbertCurvePartitioner hcp = new HilbertCurvePartitioner();
/* 186 */     hcp.createFromPoints(inMBR, points.<Point>toArray(new Point[points.size()]), 10);
/*     */     
/* 188 */     System.out.println("x,y,partition");
/* 189 */     for (Point p : points) {
/* 190 */       int partition = hcp.overlapPartition((Shape)p);
/* 191 */       System.out.println(String.valueOf(p.x) + "," + p.y + "," + partition);
/*     */     } 
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void overlapPartitions1D(Shape1D shape, ResultCollector<Integer> matcher) {}
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int overlapPartition1D(Shape1D shape) {
/* 210 */     return 0;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartition1D(int partitionID) {
/* 224 */     return null;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartitionAt1D(int index) {
/* 233 */     return null;
/*     */   }
/*     */   
/*     */   public void createFromPoints(Segment mbr, IPoint[] points, int capacity) throws IllegalArgumentException {}
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\HilbertCurvePartitioner.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */