/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import com.dlmu.wisdomST.io.Text2;
/*     */ import java.io.BufferedOutputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.util.Map;
/*     */ import java.util.Vector;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.FSDataOutputStream;
/*     */ import org.apache.hadoop.fs.FileStatus;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.fs.PathFilter;
/*     */ import org.apache.hadoop.io.IntWritable;
/*     */ import org.apache.hadoop.io.Text;
/*     */ import org.apache.hadoop.mapreduce.JobContext;
/*     */ import org.apache.hadoop.mapreduce.OutputCommitter;
/*     */ import org.apache.hadoop.mapreduce.RecordWriter;
/*     */ import org.apache.hadoop.mapreduce.TaskAttemptContext;
/*     */ import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
/*     */ import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
/*     */ import org.apache.hadoop.util.LineReader;
/*     */ import org.apache.hadoop.util.Progressable;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class IndexOutputFormat1D<S extends Shape1D>
/*     */   extends FileOutputFormat<IntWritable, S>
/*     */ {
/*     */   public static class IndexRecordWriter<S extends Shape1D>
/*     */     extends RecordWriter<IntWritable, S>
/*     */   {
/*     */     private Partitioner partitioner;
/*     */     private FileSystem outFS;
/*     */     private Path outPath;
/*  81 */     private Map<Integer, Partition1D> partitionsInfo = new ConcurrentHashMap<Integer, Partition1D>();
/*     */     
/*  83 */     private Map<Integer, File> tempFiles = new ConcurrentHashMap<Integer, File>();
/*     */ 
/*     */ 
/*     */ 
/*     */     
/*  88 */     private Map<Integer, OutputStream> partitionsOutput = new ConcurrentHashMap<Integer, OutputStream>();
/*     */     
/*  90 */     private Text tempText = (Text)new Text2();
/*     */     
/*  92 */     private Vector<Thread> closingThreads = new Vector<Thread>();
/*     */     
/*     */     private OutputStream masterFile;
/*     */     
/*  96 */     private Vector<Throwable> listOfErrors = new Vector<Throwable>();
/*     */     
/*     */     private boolean replicated;
/*     */     
/*     */     private S shape;
/*     */     
/*     */     private LocalIndexer localIndexer;
/*     */     
/*     */     public IndexRecordWriter(TaskAttemptContext task, Path outPath) throws IOException, InterruptedException {
/* 105 */       this(task, Integer.toString(task.getTaskAttemptID().getTaskID().getId()), outPath, null);
/*     */     }
/*     */ 
/*     */ 
/*     */     
/*     */     public IndexRecordWriter(TaskAttemptContext task, String name, Path outPath, Progressable progress) throws IOException, InterruptedException {
/* 111 */       Configuration conf = task.getConfiguration();
/* 112 */       String sindex = conf.get("sindex");
/* 113 */       this.replicated = conf.getBoolean("replicate", false);
/* 114 */       this.outFS = outPath.getFileSystem(conf);
/* 115 */       this.outPath = outPath;
/* 116 */       this.partitioner = Partitioner.getPartitioner(conf);
/* 117 */       Class<? extends LocalIndexer> localIndexerClass = conf.getClass("LocalIndexer.ClassName", null, LocalIndexer.class);
/* 118 */       if (localIndexerClass != null) {
/*     */         try {
/* 120 */           this.localIndexer = localIndexerClass.newInstance();
/* 121 */           this.localIndexer.setup(conf);
/* 122 */           System.out.println("progress................");
/* 123 */         } catch (InstantiationException e) {
/* 124 */           e.printStackTrace();
/* 125 */         } catch (IllegalAccessException e) {
/* 126 */           e.printStackTrace();
/*     */         } 
/*     */       }
/* 129 */       Path masterFilePath = (name == null) ? 
/* 130 */         new Path(outPath, String.format("_master.%s", new Object[] { sindex
/* 131 */             })) : new Path(outPath, String.format("_master_%s.%s", new Object[] { name, sindex }));
/* 132 */       this.masterFile = (OutputStream)this.outFS.create(masterFilePath);
/*     */     }
/*     */ 
/*     */ 
/*     */     
/*     */     public IndexRecordWriter(Partitioner partitioner, boolean replicate, String sindex, Path outPath, Configuration conf) throws IOException, InterruptedException {
/* 138 */       this.replicated = replicate;
/* 139 */       this.outFS = outPath.getFileSystem(conf);
/* 140 */       this.outPath = outPath;
/* 141 */       this.partitioner = partitioner;
/* 142 */       Class<? extends LocalIndexer> localIndexerClass = conf.getClass(
/* 143 */           "LocalIndexer.ClassName", null, LocalIndexer.class);
/* 144 */       if (localIndexerClass != null) {
/*     */         try {
/* 146 */           this.localIndexer = localIndexerClass.newInstance();
/* 147 */           this.localIndexer.setup(conf);
/* 148 */           System.out.println("conf................");
/* 149 */         } catch (InstantiationException e) {
/* 150 */           e.printStackTrace();
/* 151 */         } catch (IllegalAccessException e) {
/* 152 */           e.printStackTrace();
/*     */         } 
/*     */       }
/* 155 */       Path masterFilePath = new Path(outPath, "_master." + sindex);
/* 156 */       this.masterFile = (OutputStream)this.outFS.create(masterFilePath);
/*     */     }
/*     */ 
/*     */     
/*     */     public void write(IntWritable partitionID, S value) throws IOException {
/* 161 */       int id = partitionID.get();
/* 162 */       if (id < 0) {
/*     */         
/* 164 */         int partitionToClose = -id - 1;
/* 165 */         closePartition(partitionToClose);
/*     */       } else {
/*     */         
/* 168 */         OutputStream output = getOrCreateDataOutput(id);
/* 169 */         this.tempText.clear();
/* 170 */         value.toText(this.tempText);
/* 171 */         byte[] bytes = this.tempText.getBytes();
/* 172 */         output.write(bytes, 0, this.tempText.getLength());
/* 173 */         output.write(IndexOutputFormat1D.NEW_LINE);
/* 174 */         Partition1D partition = this.partitionsInfo.get(Integer.valueOf(id));
/* 175 */         partition.recordCount++;
/* 176 */         partition.size += (this.tempText.getLength() + IndexOutputFormat1D.NEW_LINE.length);
/* 177 */         partition.expand((Shape1D)value);
/* 178 */         if (this.shape == null) {
/* 179 */           this.shape = (S)value.clone();
/*     */         }
/*     */       } 
/*     */     }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */     
/*     */     private void closePartition(final int id) {
/* 191 */       final Partition1D partitionInfo = this.partitionsInfo.get(Integer.valueOf(id));
/* 192 */       final OutputStream outStream = this.partitionsOutput.get(Integer.valueOf(id));
/* 193 */       final File tempFile = this.tempFiles.get(Integer.valueOf(id));
/* 194 */       Thread closeThread = new Thread()
/*     */         {
/*     */           public void run() {
/*     */             try {
/* 198 */               outStream.close();
/*     */               
/* 200 */               if (IndexOutputFormat1D.IndexRecordWriter.this.localIndexer != null) {
/*     */                 
/*     */                 try {
/* 203 */                   Path indexedFilePath = IndexOutputFormat1D.IndexRecordWriter.this.getPartitionFile(id);
/* 204 */                   partitionInfo.filename = indexedFilePath.getName();
/* 205 */                   IndexOutputFormat1D.IndexRecordWriter.this.localIndexer.buildLocalIndex(tempFile, indexedFilePath, (Shape1D)IndexOutputFormat1D.IndexRecordWriter.this.shape);
/*     */                   
/* 207 */                   tempFile.delete();
/* 208 */                 } catch (InterruptedException e) {
/* 209 */                   throw new RuntimeException("Error building local index", e);
/*     */                 } 
/*     */               }
/*     */               
/* 213 */               if (IndexOutputFormat1D.IndexRecordWriter.this.replicated)
/*     */               {
/*     */                 
/* 216 */                 partitionInfo.set((Shape1D)partitionInfo.getIntersection((Shape1D)IndexOutputFormat1D.IndexRecordWriter.this.partitioner.getPartition1D(id)));
/*     */               }
/* 218 */               Text partitionText = partitionInfo.toText(new Text());
/* 219 */               synchronized (IndexOutputFormat1D.IndexRecordWriter.this.masterFile) {
/*     */                 
/* 221 */                 IndexOutputFormat1D.IndexRecordWriter.this.masterFile.write(partitionText.getBytes(), 0, partitionText.getLength());
/* 222 */                 IndexOutputFormat1D.IndexRecordWriter.this.masterFile.write(IndexOutputFormat1D.NEW_LINE);
/*     */               } 
/* 224 */               if (!IndexOutputFormat1D.IndexRecordWriter.this.closingThreads.remove(Thread.currentThread())) {
/* 225 */                 throw new RuntimeException("Could not remove closing thread");
/*     */               }
/*     */               
/* 228 */               int numRunningThreads = 0;
/*     */               try {
/* 230 */                 for (int i_thread = 0; i_thread < IndexOutputFormat1D.IndexRecordWriter.this.closingThreads.size() && 
/* 231 */                   numRunningThreads < IndexOutputFormat1D.MaxClosingThreads; i_thread++) {
/* 232 */                   Thread thread = IndexOutputFormat1D.IndexRecordWriter.this.closingThreads.elementAt(i_thread);
/* 233 */                   synchronized (thread) {
/* 234 */                     switch (thread.getState()) {
/*     */                       
/*     */                       case NEW:
/* 237 */                         thread.start();
/*     */                       
/*     */                       case RUNNABLE:
/*     */                       case null:
/*     */                       case WAITING:
/*     */                       case TIMED_WAITING:
/* 243 */                         numRunningThreads++;
/*     */                         break;
/*     */                     } 
/*     */ 
/*     */ 
/*     */                   
/*     */                   } 
/*     */                 } 
/* 251 */               } catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
/*     */             
/*     */             }
/* 254 */             catch (IOException e) {
/* 255 */               e.printStackTrace();
/* 256 */               throw new RuntimeException("Error closing partition: " + partitionInfo, e);
/*     */             } 
/*     */           }
/*     */         };
/*     */       
/* 261 */       closeThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler()
/*     */           {
/*     */             public void uncaughtException(Thread t, Throwable e) {
/* 264 */               IndexOutputFormat1D.IndexRecordWriter.this.listOfErrors.add(e);
/*     */             }
/*     */           });
/*     */ 
/*     */       
/* 269 */       this.partitionsInfo.remove(Integer.valueOf(id));
/* 270 */       this.partitionsOutput.remove(Integer.valueOf(id));
/* 271 */       this.tempFiles.remove(Integer.valueOf(id));
/*     */       
/* 273 */       if (this.closingThreads.size() < IndexOutputFormat1D.MaxClosingThreads) {
/*     */ 
/*     */ 
/*     */         
/* 277 */         closeThread.start();
/*     */         try {
/* 279 */           while (closeThread.getState() == Thread.State.NEW) {
/* 280 */             Thread.sleep(1000L);
/* 281 */             IndexOutputFormat1D.LOG.info("Waiting for thread #" + closeThread.getId() + " to start");
/*     */           } 
/* 283 */         } catch (InterruptedException interruptedException) {}
/*     */       } 
/* 285 */       this.closingThreads.add(closeThread);
/*     */     }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */     
/*     */     private OutputStream getOrCreateDataOutput(int id) throws IOException {
/* 299 */       OutputStream out = this.partitionsOutput.get(Integer.valueOf(id));
/* 300 */       if (out == null) {
/*     */         
/* 302 */         Partition1D partition = new Partition1D();
/*     */         
/* 304 */         if (this.localIndexer == null) {
/*     */           
/* 306 */           Path path = getPartitionFile(id);
/* 307 */           FSDataOutputStream fSDataOutputStream = this.outFS.create(path);
/* 308 */           partition.filename = path.getName();
/*     */         } else {
/*     */           
/* 311 */           File tempFile = File.createTempFile(String.format("part-%05d", new Object[] { Integer.valueOf(id) }), "lindex");
/* 312 */           out = new BufferedOutputStream(new FileOutputStream(tempFile));
/* 313 */           this.tempFiles.put(Integer.valueOf(id), tempFile);
/*     */         } 
/* 315 */         partition.cellId = id;
/*     */ 
/*     */         
/* 318 */         partition.set(Double.MAX_VALUE, 
/* 319 */             -1.7976931348623157E308D);
/*     */         
/* 321 */         this.partitionsOutput.put(Integer.valueOf(id), out);
/* 322 */         this.partitionsInfo.put(Integer.valueOf(id), partition);
/*     */       } 
/* 324 */       return out;
/*     */     }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */     
/*     */     private Path getPartitionFile(int id) throws IOException {
/* 334 */       String format = "part-%05d";
/* 335 */       if (this.localIndexer != null)
/* 336 */         format = String.valueOf(format) + "." + this.localIndexer.getExtension(); 
/* 337 */       Path partitionPath = new Path(this.outPath, String.format(format, new Object[] { Integer.valueOf(id) }));
/* 338 */       if (this.outFS.exists(partitionPath)) {
/* 339 */         format = "part-%05d-%03d";
/* 340 */         if (this.localIndexer != null)
/* 341 */           format = String.valueOf(format) + "." + this.localIndexer.getExtension(); 
/* 342 */         int i = 0;
/*     */         do {
/* 344 */           partitionPath = new Path(this.outPath, String.format(format, new Object[] { Integer.valueOf(id), Integer.valueOf(++i) }));
/* 345 */         } while (this.outFS.exists(partitionPath));
/*     */       } 
/* 347 */       return partitionPath;
/*     */     }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */     
/*     */     public void close(TaskAttemptContext task) throws IOException {
/*     */       // Byte code:
/*     */       //   0: aload_0
/*     */       //   1: getfield partitionsInfo : Ljava/util/Map;
/*     */       //   4: invokeinterface keySet : ()Ljava/util/Set;
/*     */       //   9: invokeinterface iterator : ()Ljava/util/Iterator;
/*     */       //   14: astore_3
/*     */       //   15: goto -> 46
/*     */       //   18: aload_3
/*     */       //   19: invokeinterface next : ()Ljava/lang/Object;
/*     */       //   24: checkcast java/lang/Integer
/*     */       //   27: astore_2
/*     */       //   28: aload_0
/*     */       //   29: aload_2
/*     */       //   30: invokevirtual intValue : ()I
/*     */       //   33: invokespecial closePartition : (I)V
/*     */       //   36: aload_1
/*     */       //   37: ifnull -> 46
/*     */       //   40: aload_1
/*     */       //   41: invokeinterface progress : ()V
/*     */       //   46: aload_3
/*     */       //   47: invokeinterface hasNext : ()Z
/*     */       //   52: ifne -> 18
/*     */       //   55: aload_1
/*     */       //   56: ifnull -> 182
/*     */       //   59: aload_1
/*     */       //   60: new java/lang/StringBuilder
/*     */       //   63: dup
/*     */       //   64: ldc_w 'Closing! '
/*     */       //   67: invokespecial <init> : (Ljava/lang/String;)V
/*     */       //   70: aload_0
/*     */       //   71: getfield closingThreads : Ljava/util/Vector;
/*     */       //   74: invokevirtual size : ()I
/*     */       //   77: invokevirtual append : (I)Ljava/lang/StringBuilder;
/*     */       //   80: ldc_w ' remaining'
/*     */       //   83: invokevirtual append : (Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */       //   86: invokevirtual toString : ()Ljava/lang/String;
/*     */       //   89: invokeinterface setStatus : (Ljava/lang/String;)V
/*     */       //   94: goto -> 182
/*     */       //   97: aload_0
/*     */       //   98: getfield closingThreads : Ljava/util/Vector;
/*     */       //   101: invokevirtual firstElement : ()Ljava/lang/Object;
/*     */       //   104: checkcast java/lang/Thread
/*     */       //   107: astore_2
/*     */       //   108: goto -> 136
/*     */       //   111: aload_2
/*     */       //   112: ldc2_w 10000
/*     */       //   115: invokevirtual join : (J)V
/*     */       //   118: aload_1
/*     */       //   119: ifnull -> 136
/*     */       //   122: aload_1
/*     */       //   123: invokeinterface progress : ()V
/*     */       //   128: goto -> 136
/*     */       //   131: astore_3
/*     */       //   132: aload_3
/*     */       //   133: invokevirtual printStackTrace : ()V
/*     */       //   136: aload_2
/*     */       //   137: invokevirtual isAlive : ()Z
/*     */       //   140: ifne -> 111
/*     */       //   143: aload_1
/*     */       //   144: ifnull -> 182
/*     */       //   147: aload_1
/*     */       //   148: new java/lang/StringBuilder
/*     */       //   151: dup
/*     */       //   152: ldc_w 'Closing! '
/*     */       //   155: invokespecial <init> : (Ljava/lang/String;)V
/*     */       //   158: aload_0
/*     */       //   159: getfield closingThreads : Ljava/util/Vector;
/*     */       //   162: invokevirtual size : ()I
/*     */       //   165: invokevirtual append : (I)Ljava/lang/StringBuilder;
/*     */       //   168: ldc_w ' remaining'
/*     */       //   171: invokevirtual append : (Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */       //   174: invokevirtual toString : ()Ljava/lang/String;
/*     */       //   177: invokeinterface setStatus : (Ljava/lang/String;)V
/*     */       //   182: aload_0
/*     */       //   183: getfield closingThreads : Ljava/util/Vector;
/*     */       //   186: invokevirtual isEmpty : ()Z
/*     */       //   189: ifeq -> 97
/*     */       //   192: goto -> 196
/*     */       //   195: astore_2
/*     */       //   196: aload_1
/*     */       //   197: ifnull -> 209
/*     */       //   200: aload_1
/*     */       //   201: ldc_w 'All closed'
/*     */       //   204: invokeinterface setStatus : (Ljava/lang/String;)V
/*     */       //   209: aload_0
/*     */       //   210: getfield listOfErrors : Ljava/util/Vector;
/*     */       //   213: invokevirtual isEmpty : ()Z
/*     */       //   216: ifne -> 310
/*     */       //   219: aload_0
/*     */       //   220: getfield listOfErrors : Ljava/util/Vector;
/*     */       //   223: invokevirtual iterator : ()Ljava/util/Iterator;
/*     */       //   226: astore_3
/*     */       //   227: goto -> 252
/*     */       //   230: aload_3
/*     */       //   231: invokeinterface next : ()Ljava/lang/Object;
/*     */       //   236: checkcast java/lang/Throwable
/*     */       //   239: astore_2
/*     */       //   240: invokestatic access$1 : ()Lorg/apache/commons/logging/Log;
/*     */       //   243: ldc_w 'Error in thread'
/*     */       //   246: aload_2
/*     */       //   247: invokeinterface error : (Ljava/lang/Object;Ljava/lang/Throwable;)V
/*     */       //   252: aload_3
/*     */       //   253: invokeinterface hasNext : ()Z
/*     */       //   258: ifne -> 230
/*     */       //   261: new java/lang/RuntimeException
/*     */       //   264: dup
/*     */       //   265: new java/lang/StringBuilder
/*     */       //   268: dup
/*     */       //   269: ldc_w 'Encountered '
/*     */       //   272: invokespecial <init> : (Ljava/lang/String;)V
/*     */       //   275: aload_0
/*     */       //   276: getfield listOfErrors : Ljava/util/Vector;
/*     */       //   279: invokevirtual size : ()I
/*     */       //   282: invokevirtual append : (I)Ljava/lang/StringBuilder;
/*     */       //   285: ldc_w ' errors in background thread'
/*     */       //   288: invokevirtual append : (Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */       //   291: invokevirtual toString : ()Ljava/lang/String;
/*     */       //   294: invokespecial <init> : (Ljava/lang/String;)V
/*     */       //   297: athrow
/*     */       //   298: astore #4
/*     */       //   300: aload_0
/*     */       //   301: getfield masterFile : Ljava/io/OutputStream;
/*     */       //   304: invokevirtual close : ()V
/*     */       //   307: aload #4
/*     */       //   309: athrow
/*     */       //   310: aload_0
/*     */       //   311: getfield masterFile : Ljava/io/OutputStream;
/*     */       //   314: invokevirtual close : ()V
/*     */       //   317: return
/*     */       // Line number table:
/*     */       //   Java source line number -> byte code offset
/*     */       //   #354	-> 0
/*     */       //   #355	-> 28
/*     */       //   #356	-> 36
/*     */       //   #357	-> 40
/*     */       //   #354	-> 46
/*     */       //   #359	-> 55
/*     */       //   #360	-> 59
/*     */       //   #363	-> 94
/*     */       //   #364	-> 97
/*     */       //   #365	-> 108
/*     */       //   #367	-> 111
/*     */       //   #368	-> 118
/*     */       //   #369	-> 122
/*     */       //   #370	-> 128
/*     */       //   #371	-> 132
/*     */       //   #365	-> 136
/*     */       //   #374	-> 143
/*     */       //   #375	-> 147
/*     */       //   #363	-> 182
/*     */       //   #377	-> 192
/*     */       //   #380	-> 196
/*     */       //   #381	-> 200
/*     */       //   #383	-> 209
/*     */       //   #384	-> 219
/*     */       //   #385	-> 240
/*     */       //   #384	-> 252
/*     */       //   #386	-> 261
/*     */       //   #388	-> 298
/*     */       //   #390	-> 300
/*     */       //   #391	-> 307
/*     */       //   #390	-> 310
/*     */       //   #392	-> 317
/*     */       // Local variable table:
/*     */       //   start	length	slot	name	descriptor
/*     */       //   0	318	0	this	Lcom/dlmu/wisdomST/indexing/IndexOutputFormat1D$IndexRecordWriter;
/*     */       //   0	318	1	task	Lorg/apache/hadoop/mapreduce/TaskAttemptContext;
/*     */       //   28	18	2	id	Ljava/lang/Integer;
/*     */       //   108	74	2	thread	Ljava/lang/Thread;
/*     */       //   132	4	3	e	Ljava/lang/InterruptedException;
/*     */       //   240	12	2	t	Ljava/lang/Throwable;
/*     */       // Local variable type table:
/*     */       //   start	length	slot	name	signature
/*     */       //   0	318	0	this	Lcom/dlmu/wisdomST/indexing/IndexOutputFormat1D$IndexRecordWriter<TS;>;
/*     */       // Exception table:
/*     */       //   from	to	target	type
/*     */       //   0	298	298	finally
/*     */       //   94	192	195	java/lang/ArrayIndexOutOfBoundsException
/*     */       //   111	128	131	java/lang/InterruptedException
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static class IndexerOutputCommitter
/*     */     extends FileOutputCommitter
/*     */   {
/*     */     private Path outPath;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */     
/*     */     public IndexerOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
/* 408 */       super(outputPath, context);
/* 409 */       this.outPath = outputPath;
/*     */     }
/*     */     
/*     */     public void commitJob(JobContext context) throws IOException
/*     */     {
/* 414 */       super.commitJob(context);
/*     */       
/* 416 */       Configuration conf = context.getConfiguration();
/*     */       
/* 418 */       FileSystem outFs = this.outPath.getFileSystem(conf);
/*     */ 
/*     */       
/* 421 */       FileStatus[] resultFiles = outFs.listStatus(this.outPath, new PathFilter()
/*     */           {
/*     */             public boolean accept(Path path) {
/* 424 */               return path.getName().contains("_master");
/*     */             }
/*     */           });
/*     */       
/* 428 */       if (resultFiles.length == 0) {
/* 429 */         IndexOutputFormat1D.LOG.warn("No _master files were written by reducers");
/*     */       } else {
/* 431 */         String sindex = conf.get("sindex");
/* 432 */         Path masterPath = new Path(this.outPath, "_master." + sindex);
/* 433 */         FSDataOutputStream fSDataOutputStream = outFs.create(masterPath);
/* 434 */         Path wktPath = new Path(this.outPath, "_" + sindex + ".wkt");
/* 435 */         PrintStream wktOut = new PrintStream((OutputStream)outFs.create(wktPath));
/* 436 */         wktOut.println("ID\tBoundaries\tRecord Count\tSize\tFile name");
/* 437 */         Text2 text2 = new Text2();
/* 438 */         Partition1D tempPartition = new Partition1D();
/* 439 */         byte[] NewLine = { 10 }; byte b; int i; FileStatus[] arrayOfFileStatus;
/* 440 */         for (i = (arrayOfFileStatus = resultFiles).length, b = 0; b < i; ) { FileStatus f = arrayOfFileStatus[b];
/* 441 */           LineReader in = new LineReader((InputStream)outFs.open(f.getPath()));
/* 442 */           while (in.readLine((Text)text2) > 0) {
/* 443 */             fSDataOutputStream.write(text2.getBytes(), 0, text2.getLength());
/* 444 */             fSDataOutputStream.write(NewLine);
/* 445 */             tempPartition.fromText((Text)text2);
/* 446 */             wktOut.println(tempPartition.toWKT());
/*     */           } 
/* 448 */           in.close();
/* 449 */           outFs.delete(f.getPath(), false); b++; }
/*     */         
/* 451 */         wktOut.close();
/* 452 */         fSDataOutputStream.close();
/*     */       } 
/*     */     }
/*     */   }
/*     */   private static final Log LOG = LogFactory.getLog(IndexOutputFormat1D.class);
/*     */   private static final int MaxClosingThreads = Runtime.getRuntime().availableProcessors() * 2;
/*     */   
/*     */   public RecordWriter<IntWritable, S> getRecordWriter(TaskAttemptContext task) throws IOException, InterruptedException
/*     */   {
/* 461 */     Path file = getDefaultWorkFile(task, "").getParent();
/* 462 */     return new IndexRecordWriter<S>(task, file);
/*     */   }
/*     */   
/*     */   protected static byte[] NEW_LINE;
/*     */   
/*     */   public synchronized OutputCommitter getOutputCommitter(TaskAttemptContext task) throws IOException {
/* 468 */     Path jobOutputPath = getOutputPath((JobContext)task);
/* 469 */     return (OutputCommitter)new IndexerOutputCommitter(jobOutputPath, task);
/*     */   }
/*     */   
/*     */   static {
/*     */     try {
/*     */       NEW_LINE = System.getProperty("line.separator", "\n").getBytes("utf-8");
/*     */     } catch (UnsupportedEncodingException e) {
/*     */       e.printStackTrace();
/*     */       throw new RuntimeException("Cannot retrieve system line separator", e);
/*     */     } 
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\IndexOutputFormat1D.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */