/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.Point;
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.io.Text2;
/*     */ import com.dlmu.wisdomST.mapreduce.RTreeRecordReader3;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialInputFormat3;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialRecordReader3;
/*     */ import com.dlmu.wisdomST.operation.FileMBR;
/*     */ import com.dlmu.wisdomST.operation.Sampler;
/*     */ import com.dlmu.wisdomST.util.FileUtil;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.sql.Date;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.FileStatus;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.io.IntWritable;
/*     */ import org.apache.hadoop.io.Text;
/*     */ import org.apache.hadoop.mapred.ClusterStatus;
/*     */ import org.apache.hadoop.mapred.JobClient;
/*     */ import org.apache.hadoop.mapred.JobConf;
/*     */ import org.apache.hadoop.mapreduce.InputSplit;
/*     */ import org.apache.hadoop.mapreduce.Job;
/*     */ import org.apache.hadoop.mapreduce.JobContext;
/*     */ import org.apache.hadoop.mapreduce.Mapper;
/*     */ import org.apache.hadoop.mapreduce.RecordReader;
/*     */ import org.apache.hadoop.mapreduce.Reducer;
/*     */ import org.apache.hadoop.mapreduce.lib.input.FileSplit;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ import org.apache.hadoop.util.LineReader;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class Indexer
/*     */ {
/*     */   public static class PartitionerMap
/*     */     extends Mapper<Rectangle, Iterable<? extends Shape>, IntWritable, Shape>
/*     */   {
/*     */     private Partitioner partitioner;
/*     */     private boolean replicate;
/*     */     
/*     */     protected void setup(Mapper<Rectangle, Iterable<? extends Shape>, IntWritable, Shape>.Context context) throws IOException, InterruptedException {
/* 129 */       super.setup(context);
/* 130 */       this.partitioner = Partitioner.getPartitioner(context.getConfiguration());
/* 131 */       this.replicate = context.getConfiguration().getBoolean("replicate", false);
/*     */     }
/*     */ 
/*     */ 
/*     */ 
/*     */     
/*     */     protected void map(Rectangle key, Iterable<? extends Shape> shapes, final Mapper<Rectangle, Iterable<? extends Shape>, IntWritable, Shape>.Context context) throws IOException, InterruptedException {
/* 138 */       final IntWritable partitionID = new IntWritable();
/* 139 */       for (Shape shape : shapes) {
/* 140 */         if (this.replicate) {
/* 141 */           this.partitioner.overlapPartitions(shape, new ResultCollector<Integer>()
/*     */               {
/*     */                 public void collect(Integer r) {
/* 144 */                   partitionID.set(r.intValue());
/*     */                   try {
/* 146 */                     context.write(partitionID, shape);
/* 147 */                   } catch (IOException e) {
/* 148 */                     Indexer.LOG.warn("Error checking overlapping partitions", e);
/* 149 */                   } catch (InterruptedException e) {
/* 150 */                     Indexer.LOG.warn("Error checking overlapping partitions", e);
/*     */                   } 
/*     */                 }
/*     */               });
/*     */         } else {
/* 155 */           partitionID.set(this.partitioner.overlapPartition(shape));
/*     */           
/* 157 */           if (partitionID.get() >= 0)
/* 158 */             context.write(partitionID, shape); 
/*     */         } 
/* 160 */         context.progress();
/*     */       } 
/*     */     }
/*     */   } private static final Log LOG = LogFactory.getLog(Indexer.class); private static final Map<String, Class<? extends Partitioner>> PartitionerClasses = new HashMap<String, Class<? extends Partitioner>>(); private static final Map<String, Class<? extends LocalIndexer>> LocalIndexes; static { PartitionerClasses.put("grid", GridPartitioner.class); PartitionerClasses.put("str", STRPartitioner.class); PartitionerClasses.put("str+", STRPartitioner.class); PartitionerClasses.put("rtree", STRPartitioner.class); PartitionerClasses.put("r+tree", STRPartitioner.class); PartitionerClasses.put("quadtree", QuadTreePartitioner.class); PartitionerClasses.put("zcurve", ZCurvePartitioner.class); PartitionerClasses.put("hilbert", HilbertCurvePartitioner.class); PartitionerClasses.put("kdtree", KdTreePartitioner.class); PartitionerClasses.put("btr", BTRPartitioner.class); } private static final Map<String, Boolean> PartitionerReplicate = new HashMap<String, Boolean>(); static { PartitionerReplicate.put("grid", Boolean.valueOf(true)); PartitionerReplicate.put("str", Boolean.valueOf(false)); PartitionerReplicate.put("btr", Boolean.valueOf(false)); PartitionerReplicate.put("str+", Boolean.valueOf(true));
/*     */     PartitionerReplicate.put("rtree", Boolean.valueOf(false));
/*     */     PartitionerReplicate.put("r+tree", Boolean.valueOf(true));
/*     */     PartitionerReplicate.put("quadtree", Boolean.valueOf(true));
/*     */     PartitionerReplicate.put("zcurve", Boolean.valueOf(false));
/*     */     PartitionerReplicate.put("hilbert", Boolean.valueOf(false));
/*     */     PartitionerReplicate.put("kdtree", Boolean.valueOf(true));
/*     */     LocalIndexes = new HashMap<String, Class<? extends LocalIndexer>>();
/*     */     LocalIndexes.put("rtree", RTreeLocalIndexer.class);
/* 172 */     LocalIndexes.put("r+tree", RTreeLocalIndexer.class); } public static class PartitionerReduce<S extends Shape> extends Reducer<IntWritable, Shape, IntWritable, Shape> { protected void reduce(IntWritable partitionID, Iterable<Shape> shapes, Reducer<IntWritable, Shape, IntWritable, Shape>.Context context) throws IOException, InterruptedException { Indexer.LOG.info("Working on partition #" + partitionID);
/* 173 */       for (Shape shape : shapes) {
/* 174 */         context.write(partitionID, shape);
/* 175 */         context.progress();
/*     */       } 
/*     */       
/* 178 */       context.write(new IntWritable(-partitionID.get() - 1), null);
/* 179 */       Indexer.LOG.info("Done with partition #" + partitionID); }
/*     */      }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static Job indexMapReduce(Path inPath, Path outPath, OperationsParams paramss) throws IOException, InterruptedException, ClassNotFoundException {
/* 186 */     Job job = new Job((Configuration)paramss, "Indexer");
/* 187 */     Configuration conf = job.getConfiguration();
/* 188 */     job.setJarByClass(Indexer.class);
/*     */ 
/*     */     
/* 191 */     Rectangle inputMBR = (Rectangle)OperationsParams.getShape(conf, "mbr");
/* 192 */     if (inputMBR == null) {
/* 193 */       Partition partition = FileMBR.fileMBR(inPath, new OperationsParams(conf, new String[0]));
/* 194 */       OperationsParams.setShape(conf, "mbr", (Shape)partition);
/*     */     } 
/*     */ 
/*     */     
/* 198 */     String index = conf.get("sindex");
/* 199 */     if (index == null)
/* 200 */       throw new RuntimeException("Index type is not set"); 
/* 201 */     long t1 = System.currentTimeMillis();
/* 202 */     setLocalIndexer(conf, index);
/* 203 */     Partitioner partitioner = createPartitioner(inPath, outPath, conf, index);
/* 204 */     Partitioner.setPartitioner(conf, partitioner);
/*     */     
/* 206 */     long t2 = System.currentTimeMillis();
/* 207 */     System.out.println("Total time for space subdivision in millis: " + (t2 - t1));
/*     */ 
/*     */     
/* 210 */     Shape shape = OperationsParams.getShape(conf, "shape");
/* 211 */     job.setMapperClass(PartitionerMap.class);
/* 212 */     job.setMapOutputKeyClass(IntWritable.class);
/* 213 */     job.setMapOutputValueClass(shape.getClass());
/* 214 */     job.setReducerClass(PartitionerReduce.class);
/*     */     
/* 216 */     job.setInputFormatClass(SpatialInputFormat3.class);
/* 217 */     SpatialInputFormat3.setInputPaths(job, new Path[] { inPath });
/* 218 */     job.setOutputFormatClass(IndexOutputFormat.class);
/* 219 */     IndexOutputFormat.setOutputPath(job, outPath);
/*     */     
/* 221 */     ClusterStatus clusterStatus = (new JobClient(new JobConf())).getClusterStatus();
/* 222 */     job.setNumReduceTasks(Math.max(1, Math.min(partitioner.getPartitionCount(), 
/* 223 */             clusterStatus.getMaxReduceTasks() * 9 / 10)));
/*     */ 
/*     */     
/* 226 */     conf.setInt("mapreduce.local.map.tasks.maximum", Runtime.getRuntime().availableProcessors());
/*     */ 
/*     */     
/* 229 */     if (conf.getBoolean("background", false)) {
/*     */       
/* 231 */       job.submit();
/*     */     } else {
/* 233 */       job.waitForCompletion(conf.getBoolean("verbose", false));
/*     */     } 
/* 235 */     return job;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static void setLocalIndexer(Configuration conf, String sindex) {
/* 244 */     Class<? extends LocalIndexer> localIndexerClass = LocalIndexes.get(sindex);
/* 245 */     if (localIndexerClass != null) {
/* 246 */       conf.setClass("LocalIndexer.ClassName", localIndexerClass, LocalIndexer.class);
/*     */     }
/*     */   }
/*     */   
/*     */   public static Partitioner createPartitioner(Path in, Path out, Configuration job, String partitionerName) throws IOException {
/* 251 */     return createPartitioner(new Path[] { in }, out, job, partitionerName);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static Partitioner createPartitioner(Path[] ins, Path out, Configuration job, String partitionerName) throws IOException {
/*     */     try {
/* 267 */       Class<? extends Partitioner> partitionerClass = 
/* 268 */         PartitionerClasses.get(partitionerName.toLowerCase());
/* 269 */       if (partitionerClass == null) {
/*     */         
/*     */         try {
/* 272 */           partitionerClass = Class.forName(partitionerName).asSubclass(Partitioner.class);
/* 273 */         } catch (ClassNotFoundException e) {
/* 274 */           throw new RuntimeException("Unknown index type '" + partitionerName + "'");
/*     */         } 
/*     */       }
/*     */       
/* 278 */       if (PartitionerReplicate.containsKey(partitionerName.toLowerCase())) {
/* 279 */         boolean replicate = ((Boolean)PartitionerReplicate.get(partitionerName.toLowerCase())).booleanValue();
/* 280 */         job.setBoolean("replicate", replicate);
/*     */       } 
/* 282 */       Partitioner partitioner = partitionerClass.newInstance();
/*     */       
/* 284 */       long t1 = System.currentTimeMillis();
/* 285 */       Rectangle inMBR = (Rectangle)OperationsParams.getShape(job, "mbr");
/*     */       
/* 287 */       long inSize = 0L; byte b; int i; Path[] arrayOfPath;
/* 288 */       for (i = (arrayOfPath = ins).length, b = 0; b < i; ) { Path in = arrayOfPath[b];
/* 289 */         inSize += FileUtil.getPathSize(in.getFileSystem(job), in); b++; }
/*     */       
/* 291 */       long estimatedOutSize = (long)(inSize * (1.0D + job.getFloat("spatialHadoop.storage.IndexingOverhead", 0.1F)));
/* 292 */       FileSystem outFS = out.getFileSystem(job);
/* 293 */       long outBlockSize = outFS.getDefaultBlockSize(out);
/*     */       
/* 295 */       final List<Point> sample = new ArrayList<Point>();
/* 296 */       float sample_ratio = job.getFloat("spatialHadoop.storage.SampleRatio", 0.01F);
/* 297 */       long sample_size = job.getLong("spatialHadoop.storage.SampleSize", 104857600L);
/*     */       
/* 299 */       LOG.info("Reading a sample of " + Math.round(sample_ratio * 100.0F) + "%");
/* 300 */       ResultCollector<Point> resultCollector = new ResultCollector<Point>()
/*     */         {
/*     */           public void collect(Point p) {
/* 303 */             sample.add(p.clone());
/*     */           }
/*     */         };
/*     */       
/* 307 */       OperationsParams params2 = new OperationsParams(job, new String[0]);
/* 308 */       params2.setFloat("ratio", sample_ratio);
/* 309 */       params2.setLong("size", sample_size);
/* 310 */       if (job.get("shape") != null)
/* 311 */         params2.set("shape", job.get("shape")); 
/* 312 */       if (job.get("local") != null)
/* 313 */         params2.set("local", job.get("local")); 
/* 314 */       params2.setClass("outshape", Point.class, Shape.class);
/* 315 */       Sampler.sample(ins, resultCollector, params2);
/* 316 */       long t2 = System.currentTimeMillis();
/* 317 */       System.out.println("Total time for sampling in millis: " + (t2 - t1));
/* 318 */       LOG.info("Finished reading a sample of " + sample.size() + " records");
/*     */       
/* 320 */       int partitionCapacity = (int)Math.max(1.0D, Math.floor(sample.size() * outBlockSize / estimatedOutSize));
/* 321 */       int numPartitions = Math.max(1, (int)Math.ceil(((float)estimatedOutSize / (float)outBlockSize)));
/* 322 */       LOG.info("Partitioning the space into " + numPartitions + " partitions with capacity of " + partitionCapacity);
/*     */       
/* 324 */       partitioner.createFromPoints(inMBR, sample.<Point>toArray(new Point[sample.size()]), partitionCapacity);
/* 325 */       return partitioner;
/* 326 */     } catch (InstantiationException e) {
/* 327 */       e.printStackTrace();
/* 328 */       return null;
/* 329 */     } catch (IllegalAccessException e) {
/* 330 */       e.printStackTrace();
/* 331 */       return null;
/*     */     } 
/*     */   }
/*     */ 
/*     */   
/*     */   private static void indexLocal(Path inPath, Path outPath, OperationsParams params) throws IOException, InterruptedException {
/* 337 */     Job job = Job.getInstance((Configuration)params);
/* 338 */     Configuration conf = job.getConfiguration();
/*     */     
/* 340 */     String sindex = conf.get("sindex");
/*     */ 
/*     */     
/* 343 */     List<InputSplit> splits = new ArrayList<InputSplit>();
/* 344 */     SpatialInputFormat3<Rectangle, Shape> inputFormat = new SpatialInputFormat3();
/* 345 */     FileSystem inFs = inPath.getFileSystem(conf);
/* 346 */     FileStatus inFStatus = inFs.getFileStatus(inPath);
/* 347 */     if (inFStatus != null && !inFStatus.isDir()) {
/*     */ 
/*     */ 
/*     */ 
/*     */       
/* 352 */       splits.add(new FileSplit(inPath, 0L, inFStatus.getLen(), new String[0]));
/*     */     } else {
/* 354 */       SpatialInputFormat3.setInputPaths(job, new Path[] { inPath });
/* 355 */       for (InputSplit s : inputFormat.getSplits((JobContext)job)) {
/* 356 */         splits.add(s);
/*     */       }
/*     */     } 
/*     */     
/* 360 */     FileSplit[] fsplits = splits.<FileSplit>toArray(new FileSplit[splits.size()]);
/* 361 */     boolean replicate = ((Boolean)PartitionerReplicate.get(sindex)).booleanValue();
/*     */ 
/*     */     
/* 364 */     Rectangle inputMBR = (Rectangle)OperationsParams.getShape(conf, "mbr");
/* 365 */     if (inputMBR == null) {
/* 366 */       Partition partition = FileMBR.fileMBR(inPath, new OperationsParams(conf, new String[0]));
/* 367 */       OperationsParams.setShape(conf, "mbr", (Shape)partition);
/*     */     } 
/*     */     
/* 370 */     setLocalIndexer(conf, sindex);
/* 371 */     Partitioner partitioner = createPartitioner(inPath, outPath, conf, sindex);
/*     */     
/* 373 */     final IndexOutputFormat.IndexRecordWriter<Shape> recordWriter = new IndexOutputFormat.IndexRecordWriter<Shape>(
/* 374 */         partitioner, replicate, sindex, outPath, conf); byte b; int i; FileSplit[] arrayOfFileSplit1;
/* 375 */     for (i = (arrayOfFileSplit1 = fsplits).length, b = 0; b < i; ) { FileSplit fsplit = arrayOfFileSplit1[b];
/* 376 */       RecordReader<Rectangle, Iterable<Shape>> reader = inputFormat.createRecordReader((InputSplit)fsplit, null);
/* 377 */       if (reader instanceof SpatialRecordReader3) {
/* 378 */         ((SpatialRecordReader3)reader).initialize((InputSplit)fsplit, conf);
/* 379 */       } else if (reader instanceof RTreeRecordReader3) {
/* 380 */         ((RTreeRecordReader3)reader).initialize((InputSplit)fsplit, conf);
/*     */       } else {
/* 382 */         throw new RuntimeException("Unknown record reader");
/*     */       } 
/*     */       
/* 385 */       final IntWritable partitionID = new IntWritable();
/*     */       
/* 387 */       while (reader.nextKeyValue()) {
/* 388 */         Iterable<Shape> shapes = (Iterable<Shape>)reader.getCurrentValue();
/* 389 */         if (replicate) {
/* 390 */           for (Shape s : shapes) {
/* 391 */             partitioner.overlapPartitions(s, new ResultCollector<Integer>()
/*     */                 {
/*     */                   public void collect(Integer id) {
/* 394 */                     partitionID.set(id.intValue());
/*     */                     try {
/* 396 */                       recordWriter.write(partitionID, s);
/* 397 */                     } catch (IOException e) {
/* 398 */                       throw new RuntimeException(e);
/*     */                     }  }
/*     */                 });
/*     */           } 
/*     */           continue;
/*     */         } 
/* 404 */         for (Shape s : shapes) {
/* 405 */           int pid = partitioner.overlapPartition(s);
/* 406 */           if (pid != -1) {
/* 407 */             partitionID.set(pid);
/* 408 */             recordWriter.write(partitionID, s);
/*     */           } 
/*     */         } 
/*     */       } 
/*     */       
/* 413 */       reader.close(); b++; }
/*     */     
/* 415 */     recordWriter.close(null);
/*     */ 
/*     */     
/* 418 */     Path masterPath = new Path(outPath, "_master." + sindex);
/* 419 */     FileSystem outFs = outPath.getFileSystem((Configuration)params);
/* 420 */     Path wktPath = new Path(outPath, "_" + sindex + ".wkt");
/* 421 */     PrintStream wktOut = new PrintStream((OutputStream)outFs.create(wktPath));
/* 422 */     wktOut.println("ID\tBoundaries\tRecord Count\tSize\tFile name\tStartDay\tEndDay");
/* 423 */     Text2 text2 = new Text2();
/* 424 */     Partition tempPartition = new Partition();
/* 425 */     LineReader in = new LineReader((InputStream)outFs.open(masterPath));
/* 426 */     while (in.readLine((Text)text2) > 0) {
/* 427 */       tempPartition.fromText((Text)text2);
/* 428 */       Date starttime = new Date((long)tempPartition.x1);
/* 429 */       Date endtime = new Date((long)tempPartition.x2);
/* 430 */       wktOut.println(String.valueOf(tempPartition.toWKT()) + "\t" + starttime.toString() + "\t" + endtime.toString());
/*     */     } 
/* 432 */     in.close();
/* 433 */     wktOut.close();
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public static Job index(Path inPath, Path outPath, OperationsParams params) throws IOException, InterruptedException, ClassNotFoundException {
/* 439 */     String string = params.get("lindex");
/* 440 */     if (string != null) {
/* 441 */       LocalIndexes.put(params.get("sindex"), RTreeLocalIndexer.class);
/*     */     }
/* 443 */     if (OperationsParams.isLocal((Configuration)new JobConf((Configuration)params), new Path[] { inPath })) {
/* 444 */       indexLocal(inPath, outPath, params);
/* 445 */       return null;
/*     */     } 
/* 447 */     return indexMapReduce(inPath, outPath, params);
/*     */   }
/*     */ 
/*     */   
/*     */   protected static void printUsage() {
/* 452 */     System.out.println("Builds a spatial index on an input file");
/* 453 */     System.out.println("Parameters (* marks required parameters):");
/* 454 */     System.out.println("<input file> - (*) Path to input file");
/* 455 */     System.out.println("<output file> - (*) Path to output file");
/* 456 */     System.out.println("shape:<point|rectangle|polygon> - (*) Type of shapes stored in input file");
/* 457 */     System.out.println("sindex:<index> - (*) Type of spatial index (grid|str|str+|quadtree|zcurve|kdtree)");
/* 458 */     System.out.println("-overwrite - Overwrite output file without noitce");
/* 459 */     GenericOptionsParser.printGenericCommandUsage(System.out);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static void main(String[] args) throws Exception {
/* 476 */     OperationsParams params = new OperationsParams(new GenericOptionsParser(args));
/*     */     
/* 478 */     if (!params.checkInputOutput(true)) {
/* 479 */       printUsage();
/*     */       return;
/*     */     } 
/* 482 */     if (params.get("sindex") == null) {
/* 483 */       System.err.println("Please specify type of index to build (grid, rtree, r+tree, str, str+)");
/* 484 */       printUsage();
/*     */       return;
/*     */     } 
/* 487 */     Path inputPath = params.getInputPath();
/* 488 */     Path outputPath = params.getOutputPath();
/*     */ 
/*     */     
/* 491 */     long t1 = System.currentTimeMillis();
/* 492 */     index(inputPath, outputPath, params);
/* 493 */     long t2 = System.currentTimeMillis();
/* 494 */     System.out.println("Total indexing time in millis " + (t2 - t1));
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\Indexer.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */