/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.Point;
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.io.Text2;
/*     */ import com.dlmu.wisdomST.mapreduce.RTreeRecordReader3;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialInputFormat3;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialRecordReader3;
/*     */ import com.dlmu.wisdomST.operation.FileMBR;
/*     */ import com.dlmu.wisdomST.operation.Sampler;
/*     */ import com.dlmu.wisdomST.util.FileUtil;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.FileStatus;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.io.IntWritable;
/*     */ import org.apache.hadoop.io.Text;
/*     */ import org.apache.hadoop.mapred.ClusterStatus;
/*     */ import org.apache.hadoop.mapred.JobClient;
/*     */ import org.apache.hadoop.mapred.JobConf;
/*     */ import org.apache.hadoop.mapreduce.InputSplit;
/*     */ import org.apache.hadoop.mapreduce.Job;
/*     */ import org.apache.hadoop.mapreduce.JobContext;
/*     */ import org.apache.hadoop.mapreduce.Mapper;
/*     */ import org.apache.hadoop.mapreduce.RecordReader;
/*     */ import org.apache.hadoop.mapreduce.Reducer;
/*     */ import org.apache.hadoop.mapreduce.lib.input.FileSplit;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ import org.apache.hadoop.util.LineReader;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class Indexer2
/*     */ {
/*     */   public static class PartitionerMap
/*     */     extends Mapper<Rectangle, Iterable<? extends Shape>, IntWritable, Shape>
/*     */   {
/*     */     private Partitioner partitioner;
/*     */     private boolean replicate;
/*     */     
/*     */     protected void setup(Mapper<Rectangle, Iterable<? extends Shape>, IntWritable, Shape>.Context context) throws IOException, InterruptedException {
/* 124 */       super.setup(context);
/* 125 */       this.partitioner = Partitioner.getPartitioner(context.getConfiguration());
/* 126 */       this.replicate = context.getConfiguration().getBoolean("replicate", false);
/*     */     }
/*     */ 
/*     */ 
/*     */ 
/*     */     
/*     */     protected void map(Rectangle key, Iterable<? extends Shape> shapes, final Mapper<Rectangle, Iterable<? extends Shape>, IntWritable, Shape>.Context context) throws IOException, InterruptedException {
/* 133 */       final IntWritable partitionID = new IntWritable();
/* 134 */       for (Shape shape : shapes) {
/* 135 */         if (this.replicate) {
/* 136 */           this.partitioner.overlapPartitions(shape, new ResultCollector<Integer>()
/*     */               {
/*     */                 public void collect(Integer r) {
/* 139 */                   partitionID.set(r.intValue());
/*     */                   try {
/* 141 */                     context.write(partitionID, shape);
/* 142 */                   } catch (IOException e) {
/* 143 */                     Indexer2.LOG.warn("Error checking overlapping partitions", e);
/* 144 */                   } catch (InterruptedException e) {
/* 145 */                     Indexer2.LOG.warn("Error checking overlapping partitions", e);
/*     */                   } 
/*     */                 }
/*     */               });
/*     */         } else {
/* 150 */           partitionID.set(this.partitioner.overlapPartition(shape));
/*     */           
/* 152 */           if (partitionID.get() >= 0)
/* 153 */             context.write(partitionID, shape); 
/*     */         } 
/* 155 */         context.progress();
/*     */       } 
/*     */     }
/*     */   } private static final Log LOG = LogFactory.getLog(Indexer2.class); private static final Map<String, Class<? extends Partitioner>> PartitionerClasses = new HashMap<String, Class<? extends Partitioner>>(); private static final Map<String, Class<? extends LocalIndexer>> LocalIndexes; static { PartitionerClasses.put("grid", GridPartitioner.class); PartitionerClasses.put("str", STRPartitioner.class); PartitionerClasses.put("str+", STRPartitioner.class); PartitionerClasses.put("rtree", STRPartitioner.class); PartitionerClasses.put("r+tree", STRPartitioner.class); PartitionerClasses.put("quadtree", QuadTreePartitioner.class); PartitionerClasses.put("zcurve", ZCurvePartitioner.class); PartitionerClasses.put("hilbert", HilbertCurvePartitioner.class); PartitionerClasses.put("kdtree", KdTreePartitioner.class); PartitionerClasses.put("btr", BTRPartitioner.class); } private static final Map<String, Boolean> PartitionerReplicate = new HashMap<String, Boolean>(); static { PartitionerReplicate.put("grid", Boolean.valueOf(true)); PartitionerReplicate.put("str", Boolean.valueOf(false)); PartitionerReplicate.put("btr", Boolean.valueOf(false)); PartitionerReplicate.put("str+", Boolean.valueOf(true));
/*     */     PartitionerReplicate.put("rtree", Boolean.valueOf(false));
/*     */     PartitionerReplicate.put("r+tree", Boolean.valueOf(true));
/*     */     PartitionerReplicate.put("quadtree", Boolean.valueOf(true));
/*     */     PartitionerReplicate.put("zcurve", Boolean.valueOf(false));
/*     */     PartitionerReplicate.put("hilbert", Boolean.valueOf(false));
/*     */     PartitionerReplicate.put("kdtree", Boolean.valueOf(true));
/*     */     LocalIndexes = new HashMap<String, Class<? extends LocalIndexer>>();
/*     */     LocalIndexes.put("rtree", RTreeLocalIndexer.class);
/* 167 */     LocalIndexes.put("r+tree", RTreeLocalIndexer.class); } public static class PartitionerReduce<S extends Shape> extends Reducer<IntWritable, Shape, IntWritable, Shape> { protected void reduce(IntWritable partitionID, Iterable<Shape> shapes, Reducer<IntWritable, Shape, IntWritable, Shape>.Context context) throws IOException, InterruptedException { Indexer2.LOG.info("Working on partition #" + partitionID);
/* 168 */       for (Shape shape : shapes) {
/* 169 */         context.write(partitionID, shape);
/* 170 */         context.progress();
/*     */       } 
/*     */       
/* 173 */       context.write(new IntWritable(-partitionID.get() - 1), null);
/* 174 */       Indexer2.LOG.info("Done with partition #" + partitionID); }
/*     */      }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static Job indexMapReduce(Path inPath, Path outPath, OperationsParams paramss) throws IOException, InterruptedException, ClassNotFoundException {
/* 181 */     Job job = new Job((Configuration)paramss, "Indexer");
/* 182 */     Configuration conf = job.getConfiguration();
/* 183 */     job.setJarByClass(Indexer2.class);
/*     */ 
/*     */     
/* 186 */     Rectangle inputMBR = (Rectangle)OperationsParams.getShape(conf, "rect");
/* 187 */     if (inputMBR == null) {
/* 188 */       Partition partition = FileMBR.fileMBR(inPath, new OperationsParams(conf, new String[0]));
/* 189 */       OperationsParams.setShape(conf, "mbr", (Shape)partition);
/*     */     } 
/*     */ 
/*     */     
/* 193 */     String index = conf.get("sindex");
/* 194 */     if (index == null)
/* 195 */       throw new RuntimeException("Index type is not set"); 
/* 196 */     long t1 = System.currentTimeMillis();
/* 197 */     setLocalIndexer(conf, index);
/* 198 */     Partitioner partitioner = createPartitioner(inPath, outPath, conf, index);
/* 199 */     Partitioner.setPartitioner(conf, partitioner);
/*     */     
/* 201 */     long t2 = System.currentTimeMillis();
/* 202 */     System.out.println("Total time for space subdivision in millis: " + (t2 - t1));
/*     */ 
/*     */     
/* 205 */     Shape shape = OperationsParams.getShape(conf, "shape");
/* 206 */     job.setMapperClass(PartitionerMap.class);
/* 207 */     job.setMapOutputKeyClass(IntWritable.class);
/* 208 */     job.setMapOutputValueClass(shape.getClass());
/* 209 */     job.setReducerClass(PartitionerReduce.class);
/*     */     
/* 211 */     job.setInputFormatClass(SpatialInputFormat3.class);
/* 212 */     SpatialInputFormat3.setInputPaths(job, new Path[] { inPath });
/* 213 */     job.setOutputFormatClass(IndexOutputFormat.class);
/* 214 */     IndexOutputFormat.setOutputPath(job, outPath);
/*     */     
/* 216 */     ClusterStatus clusterStatus = (new JobClient(new JobConf())).getClusterStatus();
/* 217 */     job.setNumReduceTasks(Math.max(1, Math.min(partitioner.getPartitionCount(), 
/* 218 */             clusterStatus.getMaxReduceTasks() * 9 / 10)));
/*     */ 
/*     */     
/* 221 */     conf.setInt("mapreduce.local.map.tasks.maximum", Runtime.getRuntime().availableProcessors());
/*     */ 
/*     */     
/* 224 */     if (conf.getBoolean("background", false)) {
/*     */       
/* 226 */       job.submit();
/*     */     } else {
/* 228 */       job.waitForCompletion(conf.getBoolean("verbose", false));
/*     */     } 
/* 230 */     return job;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static void setLocalIndexer(Configuration conf, String sindex) {
/* 239 */     Class<? extends LocalIndexer> localIndexerClass = LocalIndexes.get(sindex);
/* 240 */     if (localIndexerClass != null) {
/* 241 */       conf.setClass("LocalIndexer.ClassName", localIndexerClass, LocalIndexer.class);
/*     */     }
/*     */   }
/*     */   
/*     */   public static Partitioner createPartitioner(Path in, Path out, Configuration job, String partitionerName) throws IOException {
/* 246 */     return createPartitioner(new Path[] { in }, out, job, partitionerName);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static Partitioner createPartitioner(Path[] ins, Path out, Configuration job, String partitionerName) throws IOException {
/*     */     try {
/* 262 */       Class<? extends Partitioner> partitionerClass = 
/* 263 */         PartitionerClasses.get(partitionerName.toLowerCase());
/* 264 */       if (partitionerClass == null) {
/*     */         
/*     */         try {
/* 267 */           partitionerClass = Class.forName(partitionerName).asSubclass(Partitioner.class);
/* 268 */         } catch (ClassNotFoundException e) {
/* 269 */           throw new RuntimeException("Unknown index type '" + partitionerName + "'");
/*     */         } 
/*     */       }
/*     */       
/* 273 */       if (PartitionerReplicate.containsKey(partitionerName.toLowerCase())) {
/* 274 */         boolean replicate = ((Boolean)PartitionerReplicate.get(partitionerName.toLowerCase())).booleanValue();
/* 275 */         job.setBoolean("replicate", replicate);
/*     */       } 
/* 277 */       Partitioner partitioner = partitionerClass.newInstance();
/*     */       
/* 279 */       long t1 = System.currentTimeMillis();
/* 280 */       Rectangle inMBR = (Rectangle)OperationsParams.getShape(job, "mbr");
/*     */       
/* 282 */       long inSize = 0L; byte b; int i; Path[] arrayOfPath;
/* 283 */       for (i = (arrayOfPath = ins).length, b = 0; b < i; ) { Path in = arrayOfPath[b];
/* 284 */         inSize += FileUtil.getPathSize(in.getFileSystem(job), in); b++; }
/*     */       
/* 286 */       long estimatedOutSize = (long)(inSize * (1.0D + job.getFloat("spatialHadoop.storage.IndexingOverhead", 0.1F)));
/* 287 */       FileSystem outFS = out.getFileSystem(job);
/* 288 */       long outBlockSize = outFS.getDefaultBlockSize(out);
/*     */       
/* 290 */       final List<Point> sample = new ArrayList<Point>();
/* 291 */       float sample_ratio = job.getFloat("spatialHadoop.storage.SampleRatio", 0.01F);
/* 292 */       long sample_size = job.getLong("spatialHadoop.storage.SampleSize", 104857600L);
/*     */       
/* 294 */       LOG.info("Reading a sample of " + Math.round(sample_ratio * 100.0F) + "%");
/* 295 */       ResultCollector<Point> resultCollector = new ResultCollector<Point>()
/*     */         {
/*     */           public void collect(Point p) {
/* 298 */             sample.add(p.clone());
/*     */           }
/*     */         };
/*     */       
/* 302 */       OperationsParams params2 = new OperationsParams(job, new String[0]);
/* 303 */       params2.setFloat("ratio", sample_ratio);
/* 304 */       params2.setLong("size", sample_size);
/* 305 */       if (job.get("shape") != null)
/* 306 */         params2.set("shape", job.get("shape")); 
/* 307 */       if (job.get("local") != null)
/* 308 */         params2.set("local", job.get("local")); 
/* 309 */       params2.setClass("outshape", Point.class, Shape.class);
/* 310 */       Sampler.sample(ins, resultCollector, params2);
/* 311 */       long t2 = System.currentTimeMillis();
/* 312 */       System.out.println("Total time for sampling in millis: " + (t2 - t1));
/* 313 */       LOG.info("Finished reading a sample of " + sample.size() + " records");
/*     */       
/* 315 */       int partitionCapacity = (int)Math.max(1.0D, Math.floor(sample.size() * outBlockSize / estimatedOutSize));
/* 316 */       int numPartitions = Math.max(1, (int)Math.ceil(((float)estimatedOutSize / (float)outBlockSize)));
/* 317 */       LOG.info("Partitioning the space into " + numPartitions + " partitions with capacity of " + partitionCapacity);
/*     */       
/* 319 */       partitioner.createFromPoints(inMBR, sample.<Point>toArray(new Point[sample.size()]), partitionCapacity);
/* 320 */       return partitioner;
/* 321 */     } catch (InstantiationException e) {
/* 322 */       e.printStackTrace();
/* 323 */       return null;
/* 324 */     } catch (IllegalAccessException e) {
/* 325 */       e.printStackTrace();
/* 326 */       return null;
/*     */     } 
/*     */   }
/*     */ 
/*     */   
/*     */   private static void indexLocal(Path inPath, Path outPath, OperationsParams params) throws IOException, InterruptedException {
/* 332 */     Job job = Job.getInstance((Configuration)params);
/* 333 */     Configuration conf = job.getConfiguration();
/*     */     
/* 335 */     String sindex = conf.get("sindex");
/*     */ 
/*     */     
/* 338 */     List<InputSplit> splits = new ArrayList<InputSplit>();
/* 339 */     SpatialInputFormat3<Rectangle, Shape> inputFormat = new SpatialInputFormat3();
/* 340 */     FileSystem inFs = inPath.getFileSystem(conf);
/* 341 */     FileStatus inFStatus = inFs.getFileStatus(inPath);
/* 342 */     if (inFStatus != null && !inFStatus.isDir()) {
/*     */ 
/*     */ 
/*     */ 
/*     */       
/* 347 */       splits.add(new FileSplit(inPath, 0L, inFStatus.getLen(), new String[0]));
/*     */     } else {
/* 349 */       SpatialInputFormat3.setInputPaths(job, new Path[] { inPath });
/* 350 */       for (InputSplit s : inputFormat.getSplits((JobContext)job)) {
/* 351 */         splits.add(s);
/*     */       }
/*     */     } 
/*     */     
/* 355 */     FileSplit[] fsplits = splits.<FileSplit>toArray(new FileSplit[splits.size()]);
/* 356 */     boolean replicate = ((Boolean)PartitionerReplicate.get(sindex)).booleanValue();
/*     */ 
/*     */     
/* 359 */     Rectangle inputMBR = (Rectangle)OperationsParams.getShape(conf, "mbr");
/* 360 */     if (inputMBR == null) {
/* 361 */       Partition partition = FileMBR.fileMBR(inPath, new OperationsParams(conf, new String[0]));
/* 362 */       OperationsParams.setShape(conf, "mbr", (Shape)partition);
/*     */     } 
/*     */     
/* 365 */     setLocalIndexer(conf, sindex);
/* 366 */     Partitioner partitioner = createPartitioner(inPath, outPath, conf, sindex);
/*     */     
/* 368 */     final IndexOutputFormat.IndexRecordWriter<Shape> recordWriter = new IndexOutputFormat.IndexRecordWriter<Shape>(
/* 369 */         partitioner, replicate, sindex, outPath, conf); byte b; int i; FileSplit[] arrayOfFileSplit1;
/* 370 */     for (i = (arrayOfFileSplit1 = fsplits).length, b = 0; b < i; ) { FileSplit fsplit = arrayOfFileSplit1[b];
/* 371 */       RecordReader<Rectangle, Iterable<Shape>> reader = inputFormat.createRecordReader((InputSplit)fsplit, null);
/* 372 */       if (reader instanceof SpatialRecordReader3) {
/* 373 */         ((SpatialRecordReader3)reader).initialize((InputSplit)fsplit, conf);
/* 374 */       } else if (reader instanceof RTreeRecordReader3) {
/* 375 */         ((RTreeRecordReader3)reader).initialize((InputSplit)fsplit, conf);
/*     */       } else {
/* 377 */         throw new RuntimeException("Unknown record reader");
/*     */       } 
/*     */       
/* 380 */       final IntWritable partitionID = new IntWritable();
/*     */       
/* 382 */       while (reader.nextKeyValue()) {
/* 383 */         Iterable<Shape> shapes = (Iterable<Shape>)reader.getCurrentValue();
/* 384 */         if (replicate) {
/* 385 */           for (Shape s : shapes) {
/* 386 */             partitioner.overlapPartitions(s, new ResultCollector<Integer>()
/*     */                 {
/*     */                   public void collect(Integer id) {
/* 389 */                     partitionID.set(id.intValue());
/*     */                     try {
/* 391 */                       recordWriter.write(partitionID, s);
/* 392 */                     } catch (IOException e) {
/* 393 */                       throw new RuntimeException(e);
/*     */                     }  }
/*     */                 });
/*     */           } 
/*     */           continue;
/*     */         } 
/* 399 */         for (Shape s : shapes) {
/* 400 */           int pid = partitioner.overlapPartition(s);
/* 401 */           if (pid != -1) {
/* 402 */             partitionID.set(pid);
/* 403 */             recordWriter.write(partitionID, s);
/*     */           } 
/*     */         } 
/*     */       } 
/*     */       
/* 408 */       reader.close(); b++; }
/*     */     
/* 410 */     recordWriter.close(null);
/*     */ 
/*     */     
/* 413 */     Path masterPath = new Path(outPath, "_master." + sindex);
/* 414 */     FileSystem outFs = outPath.getFileSystem((Configuration)params);
/* 415 */     Path wktPath = new Path(outPath, "_" + sindex + ".wkt");
/* 416 */     PrintStream wktOut = new PrintStream((OutputStream)outFs.create(wktPath));
/* 417 */     wktOut.println("ID\tBoundaries\tRecord Count\tSize\tFile name");
/* 418 */     Text2 text2 = new Text2();
/* 419 */     Partition tempPartition = new Partition();
/* 420 */     LineReader in = new LineReader((InputStream)outFs.open(masterPath));
/* 421 */     while (in.readLine((Text)text2) > 0) {
/*     */       
/* 423 */       tempPartition.fromText((Text)text2);
/*     */ 
/*     */       
/* 426 */       wktOut.println(tempPartition.toWKT());
/*     */     } 
/* 428 */     in.close();
/* 429 */     wktOut.close();
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static Job index(Path inPath, Path outPath, OperationsParams params) throws IOException, InterruptedException, ClassNotFoundException {
/* 436 */     if (OperationsParams.isLocal((Configuration)new JobConf((Configuration)params), new Path[] { inPath })) {
/* 437 */       indexLocal(inPath, outPath, params);
/* 438 */       return null;
/*     */     } 
/* 440 */     return indexMapReduce(inPath, outPath, params);
/*     */   }
/*     */ 
/*     */   
/*     */   protected static void printUsage() {
/* 445 */     System.out.println("Builds a spatial index on an input file");
/* 446 */     System.out.println("Parameters (* marks required parameters):");
/* 447 */     System.out.println("<input file> - (*) Path to input file");
/* 448 */     System.out.println("<output file> - (*) Path to output file");
/* 449 */     System.out.println("shape:<point|rectangle|polygon> - (*) Type of shapes stored in input file");
/* 450 */     System.out.println("sindex:<index> - (*) Type of spatial index (grid|str|str+|quadtree|zcurve|kdtree)");
/* 451 */     System.out.println("-overwrite - Overwrite output file without noitce");
/* 452 */     GenericOptionsParser.printGenericCommandUsage(System.out);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static void main(String[] args) throws Exception {
/* 469 */     OperationsParams params = new OperationsParams(new GenericOptionsParser(args));
/*     */     
/* 471 */     if (!params.checkInputOutput(true)) {
/* 472 */       printUsage();
/*     */       return;
/*     */     } 
/* 475 */     if (params.get("sindex") == null) {
/* 476 */       System.err.println("Please specify type of index to build (grid, rtree, r+tree, str, str+)");
/* 477 */       printUsage();
/*     */       return;
/*     */     } 
/* 480 */     Path inputPath = params.getInputPath();
/* 481 */     Path outputPath = params.getOutputPath();
/*     */ 
/*     */     
/* 484 */     long t1 = System.currentTimeMillis();
/* 485 */     index(inputPath, outputPath, params);
/* 486 */     long t2 = System.currentTimeMillis();
/* 487 */     System.out.println("Total indexing time in millis " + (t2 - t1));
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\Indexer2.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */