/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.IPoint;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import com.dlmu.wisdomST.io.Text2;
/*     */ import com.dlmu.wisdomST.mapreduce.RTreeRecordReader3;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialInputFormat31D;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialRecordReader31D;
/*     */ import com.dlmu.wisdomST.operation.FileMBR1D;
/*     */ import com.dlmu.wisdomST.operation.Sampler1D;
/*     */ import com.dlmu.wisdomST.util.FileUtil;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.FileStatus;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.io.IntWritable;
/*     */ import org.apache.hadoop.io.Text;
/*     */ import org.apache.hadoop.mapred.ClusterStatus;
/*     */ import org.apache.hadoop.mapred.JobClient;
/*     */ import org.apache.hadoop.mapred.JobConf;
/*     */ import org.apache.hadoop.mapreduce.InputSplit;
/*     */ import org.apache.hadoop.mapreduce.Job;
/*     */ import org.apache.hadoop.mapreduce.JobContext;
/*     */ import org.apache.hadoop.mapreduce.Mapper;
/*     */ import org.apache.hadoop.mapreduce.RecordReader;
/*     */ import org.apache.hadoop.mapreduce.Reducer;
/*     */ import org.apache.hadoop.mapreduce.lib.input.FileSplit;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ import org.apache.hadoop.util.LineReader;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class Indexer3
/*     */ {
/*     */   public static class PartitionerMap
/*     */     extends Mapper<Segment, Iterable<? extends Shape1D>, IntWritable, Shape1D>
/*     */   {
/*     */     private Partitioner partitioner;
/*     */     private boolean replicate;
/*     */     
/*     */     protected void setup(Mapper<Segment, Iterable<? extends Shape1D>, IntWritable, Shape1D>.Context context) throws IOException, InterruptedException {
/* 136 */       super.setup(context);
/* 137 */       this.partitioner = Partitioner.getPartitioner(context.getConfiguration());
/* 138 */       this.replicate = context.getConfiguration().getBoolean("replicate", false);
/*     */     }
/*     */ 
/*     */ 
/*     */ 
/*     */     
/*     */     protected void map(Segment key, Iterable<? extends Shape1D> shapes, final Mapper<Segment, Iterable<? extends Shape1D>, IntWritable, Shape1D>.Context context) throws IOException, InterruptedException {
/* 145 */       final IntWritable partitionID = new IntWritable();
/* 146 */       for (Shape1D shape : shapes) {
/* 147 */         if (this.replicate) {
/* 148 */           this.partitioner.overlapPartitions1D(shape, new ResultCollector<Integer>()
/*     */               {
/*     */                 public void collect(Integer r) {
/* 151 */                   partitionID.set(r.intValue());
/*     */                   try {
/* 153 */                     context.write(partitionID, shape);
/* 154 */                   } catch (IOException e) {
/* 155 */                     Indexer3.LOG.warn("Error checking overlapping partitions", e);
/* 156 */                   } catch (InterruptedException e) {
/* 157 */                     Indexer3.LOG.warn("Error checking overlapping partitions", e);
/*     */                   } 
/*     */                 }
/*     */               });
/*     */         } else {
/* 162 */           partitionID.set(this.partitioner.overlapPartition1D(shape));
/*     */           
/* 164 */           if (partitionID.get() >= 0)
/* 165 */             context.write(partitionID, shape); 
/*     */         } 
/* 167 */         context.progress();
/*     */       } 
/*     */     }
/*     */   } private static final Log LOG = LogFactory.getLog(Indexer3.class); private static final Map<String, Class<? extends Partitioner>> PartitionerClasses = new HashMap<String, Class<? extends Partitioner>>(); private static final Map<String, Class<? extends LocalIndexer>> LocalIndexes; static { PartitionerClasses.put("grid", GridPartitioner.class); PartitionerClasses.put("str", STRPartitioner.class); PartitionerClasses.put("str+", STRPartitioner.class); PartitionerClasses.put("rtree", STRPartitioner.class); PartitionerClasses.put("r+tree", STRPartitioner.class); PartitionerClasses.put("quadtree", QuadTreePartitioner.class); PartitionerClasses.put("zcurve", ZCurvePartitioner.class); PartitionerClasses.put("hilbert", HilbertCurvePartitioner.class); PartitionerClasses.put("kdtree", KdTreePartitioner.class); PartitionerClasses.put("btr", BTRPartitioner.class); PartitionerClasses.put("bpt", BPTPartitioner.class); } private static final Map<String, Boolean> PartitionerReplicate = new HashMap<String, Boolean>(); static { PartitionerReplicate.put("grid", Boolean.valueOf(true)); PartitionerReplicate.put("str", Boolean.valueOf(false)); PartitionerReplicate.put("btr", Boolean.valueOf(false)); PartitionerReplicate.put("str+", Boolean.valueOf(true)); PartitionerReplicate.put("rtree", Boolean.valueOf(false));
/*     */     PartitionerReplicate.put("r+tree", Boolean.valueOf(true));
/*     */     PartitionerReplicate.put("quadtree", Boolean.valueOf(true));
/*     */     PartitionerReplicate.put("zcurve", Boolean.valueOf(false));
/*     */     PartitionerReplicate.put("hilbert", Boolean.valueOf(false));
/*     */     PartitionerReplicate.put("kdtree", Boolean.valueOf(true));
/*     */     PartitionerReplicate.put("bpt", Boolean.valueOf(false));
/*     */     LocalIndexes = new HashMap<String, Class<? extends LocalIndexer>>();
/*     */     LocalIndexes.put("rtree", RTreeLocalIndexer.class);
/* 179 */     LocalIndexes.put("r+tree", RTreeLocalIndexer.class); } public static class PartitionerReduce<S extends Shape1D> extends Reducer<IntWritable, Shape1D, IntWritable, Shape1D> { protected void reduce(IntWritable partitionID, Iterable<Shape1D> shapes, Reducer<IntWritable, Shape1D, IntWritable, Shape1D>.Context context) throws IOException, InterruptedException { Indexer3.LOG.info("Working on partition #" + partitionID);
/* 180 */       for (Shape1D shape : shapes) {
/* 181 */         context.write(partitionID, shape);
/* 182 */         context.progress();
/*     */       } 
/*     */       
/* 185 */       context.write(new IntWritable(-partitionID.get() - 1), null);
/* 186 */       Indexer3.LOG.info("Done with partition #" + partitionID); }
/*     */      }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static Job indexMapReduce(Path inPath, Path outPath, OperationsParams paramss) throws IOException, InterruptedException, ClassNotFoundException {
/* 193 */     System.out.println("indexMapReduce");
/* 194 */     Job job = new Job((Configuration)paramss, "Indexer3");
/* 195 */     Configuration conf = job.getConfiguration();
/* 196 */     job.setJarByClass(Indexer3.class);
/*     */ 
/*     */     
/* 199 */     Segment inputMBR = (Segment)OperationsParams.getShape1D(conf, "segment");
/* 200 */     if (inputMBR == null) {
/* 201 */       Partition1D partition1D = FileMBR1D.fileMBR(inPath, new OperationsParams(conf, new String[0]));
/* 202 */       OperationsParams.setShape(conf, "mbr", (Shape1D)partition1D);
/*     */     } 
/*     */ 
/*     */     
/* 206 */     String index = conf.get("sindex");
/* 207 */     System.out.println("index：" + index);
/* 208 */     if (index == null)
/* 209 */       throw new RuntimeException("Index type is not set"); 
/* 210 */     long t1 = System.currentTimeMillis();
/* 211 */     setLocalIndexer(conf, index);
/* 212 */     Partitioner partitioner = createPartitioner(inPath, outPath, conf, index);
/* 213 */     Partitioner.setPartitioner(conf, partitioner);
/*     */     
/* 215 */     long t2 = System.currentTimeMillis();
/* 216 */     System.out.println("Total time for space subdivision in millis: " + (t2 - t1));
/*     */ 
/*     */     
/* 219 */     Shape1D shape = OperationsParams.getShape1D(conf, "shape");
/* 220 */     job.setMapperClass(PartitionerMap.class);
/* 221 */     job.setMapOutputKeyClass(IntWritable.class);
/* 222 */     job.setMapOutputValueClass(shape.getClass());
/* 223 */     job.setReducerClass(PartitionerReduce.class);
/*     */     
/* 225 */     job.setInputFormatClass(SpatialInputFormat31D.class);
/* 226 */     SpatialInputFormat31D.setInputPaths(job, new Path[] { inPath });
/* 227 */     job.setOutputFormatClass(IndexOutputFormat1D.class);
/* 228 */     IndexOutputFormat.setOutputPath(job, outPath);
/*     */     
/* 230 */     ClusterStatus clusterStatus = (new JobClient(new JobConf())).getClusterStatus();
/* 231 */     job.setNumReduceTasks(Math.max(1, Math.min(partitioner.getPartitionCount(), 
/* 232 */             clusterStatus.getMaxReduceTasks() * 9 / 10)));
/*     */ 
/*     */     
/* 235 */     conf.setInt("mapreduce.local.map.tasks.maximum", Runtime.getRuntime().availableProcessors());
/*     */ 
/*     */     
/* 238 */     if (conf.getBoolean("background", false)) {
/*     */       
/* 240 */       job.submit();
/*     */     } else {
/* 242 */       job.waitForCompletion(conf.getBoolean("verbose", false));
/*     */     } 
/* 244 */     return job;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static void setLocalIndexer(Configuration conf, String sindex) {
/* 253 */     Class<? extends LocalIndexer> localIndexerClass = LocalIndexes.get(sindex);
/* 254 */     if (localIndexerClass != null) {
/* 255 */       conf.setClass("LocalIndexer.ClassName", localIndexerClass, LocalIndexer.class);
/*     */     }
/*     */   }
/*     */   
/*     */   public static Partitioner createPartitioner(Path in, Path out, Configuration job, String partitionerName) throws IOException {
/* 260 */     return createPartitioner(new Path[] { in }, out, job, partitionerName);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static Partitioner createPartitioner(Path[] ins, Path out, Configuration job, String partitionerName) throws IOException {
/*     */     try {
/* 276 */       Class<? extends Partitioner> partitionerClass = 
/* 277 */         PartitionerClasses.get(partitionerName.toLowerCase());
/* 278 */       if (partitionerClass == null) {
/*     */         
/*     */         try {
/* 281 */           partitionerClass = Class.forName(partitionerName).asSubclass(Partitioner.class);
/* 282 */         } catch (ClassNotFoundException e) {
/* 283 */           throw new RuntimeException("Unknown index type '" + partitionerName + "'");
/*     */         } 
/*     */       }
/*     */       
/* 287 */       if (PartitionerReplicate.containsKey(partitionerName.toLowerCase())) {
/* 288 */         boolean replicate = ((Boolean)PartitionerReplicate.get(partitionerName.toLowerCase())).booleanValue();
/* 289 */         job.setBoolean("replicate", replicate);
/*     */       } 
/* 291 */       Partitioner partitioner = partitionerClass.newInstance();
/*     */       
/* 293 */       long t1 = System.currentTimeMillis();
/* 294 */       Segment inMBR = (Segment)OperationsParams.getShape1D(job, "mbr");
/*     */       
/* 296 */       long inSize = 0L; byte b; int i; Path[] arrayOfPath;
/* 297 */       for (i = (arrayOfPath = ins).length, b = 0; b < i; ) { Path in = arrayOfPath[b];
/* 298 */         inSize += FileUtil.getPathSize(in.getFileSystem(job), in); b++; }
/*     */       
/* 300 */       long estimatedOutSize = (long)(inSize * (1.0D + job.getFloat("spatialHadoop.storage.IndexingOverhead", 0.1F)));
/* 301 */       FileSystem outFS = out.getFileSystem(job);
/* 302 */       long outBlockSize = outFS.getDefaultBlockSize(out);
/*     */       
/* 304 */       final List<IPoint> sample = new ArrayList<IPoint>();
/* 305 */       float sample_ratio = job.getFloat("spatialHadoop.storage.SampleRatio", 0.01F);
/* 306 */       long sample_size = job.getLong("spatialHadoop.storage.SampleSize", 104857600L);
/*     */       
/* 308 */       LOG.info("Reading a sample of " + Math.round(sample_ratio * 100.0F) + "%");
/* 309 */       ResultCollector<IPoint> resultCollector = new ResultCollector<IPoint>()
/*     */         {
/*     */           public void collect(IPoint p) {
/* 312 */             sample.add(p.clone());
/*     */           }
/*     */         };
/*     */       
/* 316 */       OperationsParams params2 = new OperationsParams(job, new String[0]);
/* 317 */       params2.setFloat("ratio", sample_ratio);
/* 318 */       params2.setLong("size", sample_size);
/* 319 */       if (job.get("shape") != null)
/* 320 */         params2.set("shape", job.get("shape")); 
/* 321 */       if (job.get("local") != null)
/* 322 */         params2.set("local", job.get("local")); 
/* 323 */       params2.setClass("outshape", IPoint.class, Shape1D.class);
/*     */       
/* 325 */       Sampler1D.sample(ins, resultCollector, params2);
/* 326 */       long t2 = System.currentTimeMillis();
/* 327 */       System.out.println("Total time for sampling in millis: " + (t2 - t1));
/* 328 */       LOG.info("Finished reading a sample of " + sample.size() + " records");
/*     */       
/* 330 */       int partitionCapacity = (int)Math.max(1.0D, Math.floor(sample.size() * outBlockSize / estimatedOutSize));
/* 331 */       int numPartitions = Math.max(1, (int)Math.ceil(((float)estimatedOutSize / (float)outBlockSize)));
/* 332 */       LOG.info("Partitioning the space into " + numPartitions + " partitions with capacity of " + partitionCapacity);
/*     */       
/* 334 */       partitioner.createFromPoints(inMBR, sample.<IPoint>toArray(new IPoint[sample.size()]), partitionCapacity);
/* 335 */       return partitioner;
/* 336 */     } catch (InstantiationException e) {
/* 337 */       e.printStackTrace();
/* 338 */       return null;
/* 339 */     } catch (IllegalAccessException e) {
/* 340 */       e.printStackTrace();
/* 341 */       return null;
/*     */     } 
/*     */   }
/*     */ 
/*     */   
/*     */   private static void indexLocal(Path inPath, Path outPath, OperationsParams params) throws IOException, InterruptedException {
/* 347 */     System.out.println("indexLocal");
/* 348 */     Job job = Job.getInstance((Configuration)params);
/* 349 */     Configuration conf = job.getConfiguration();
/*     */     
/* 351 */     String sindex = conf.get("sindex");
/* 352 */     System.out.println("sindex：" + sindex);
/*     */     
/* 354 */     List<InputSplit> splits = new ArrayList<InputSplit>();
/* 355 */     SpatialInputFormat31D<Segment, Shape1D> inputFormat = new SpatialInputFormat31D();
/* 356 */     FileSystem inFs = inPath.getFileSystem(conf);
/* 357 */     FileStatus inFStatus = inFs.getFileStatus(inPath);
/* 358 */     if (inFStatus != null && !inFStatus.isDir()) {
/*     */ 
/*     */ 
/*     */ 
/*     */       
/* 363 */       splits.add(new FileSplit(inPath, 0L, inFStatus.getLen(), new String[0]));
/*     */     } else {
/* 365 */       SpatialInputFormat31D.setInputPaths(job, new Path[] { inPath });
/* 366 */       for (InputSplit s : inputFormat.getSplits((JobContext)job)) {
/* 367 */         splits.add(s);
/*     */       }
/*     */     } 
/*     */     
/* 371 */     FileSplit[] fsplits = splits.<FileSplit>toArray(new FileSplit[splits.size()]);
/* 372 */     boolean replicate = ((Boolean)PartitionerReplicate.get(sindex)).booleanValue();
/*     */ 
/*     */     
/* 375 */     Segment inputMBR = (Segment)OperationsParams.getShape1D(conf, "mbr");
/* 376 */     if (inputMBR == null) {
/* 377 */       Partition1D partition1D = FileMBR1D.fileMBR(inPath, new OperationsParams(conf, new String[0]));
/* 378 */       OperationsParams.setShape(conf, "mbr", (Shape1D)partition1D);
/*     */     } 
/*     */     
/* 381 */     setLocalIndexer(conf, sindex);
/* 382 */     Partitioner partitioner = createPartitioner(inPath, outPath, conf, sindex);
/*     */     
/* 384 */     final IndexOutputFormat1D.IndexRecordWriter<Shape1D> recordWriter = new IndexOutputFormat1D.IndexRecordWriter<Shape1D>(
/* 385 */         partitioner, replicate, sindex, outPath, conf); byte b; int i; FileSplit[] arrayOfFileSplit1;
/* 386 */     for (i = (arrayOfFileSplit1 = fsplits).length, b = 0; b < i; ) { FileSplit fsplit = arrayOfFileSplit1[b];
/* 387 */       RecordReader<Segment, Iterable<Shape1D>> reader = inputFormat.createRecordReader((InputSplit)fsplit, null);
/* 388 */       if (reader instanceof SpatialRecordReader31D) {
/* 389 */         ((SpatialRecordReader31D)reader).initialize((InputSplit)fsplit, conf);
/* 390 */       } else if (reader instanceof RTreeRecordReader3) {
/* 391 */         ((RTreeRecordReader3)reader).initialize((InputSplit)fsplit, conf);
/*     */       } else {
/* 393 */         throw new RuntimeException("Unknown record reader");
/*     */       } 
/*     */       
/* 396 */       final IntWritable partitionID = new IntWritable();
/*     */       
/* 398 */       while (reader.nextKeyValue()) {
/* 399 */         Iterable<Shape1D> shapes = (Iterable<Shape1D>)reader.getCurrentValue();
/* 400 */         if (replicate) {
/* 401 */           for (Shape1D s : shapes) {
/* 402 */             partitioner.overlapPartitions1D(s, new ResultCollector<Integer>()
/*     */                 {
/*     */                   public void collect(Integer id) {
/* 405 */                     partitionID.set(id.intValue());
/*     */                     try {
/* 407 */                       recordWriter.write(partitionID, s);
/* 408 */                     } catch (IOException e) {
/* 409 */                       throw new RuntimeException(e);
/*     */                     }  }
/*     */                 });
/*     */           } 
/*     */           continue;
/*     */         } 
/* 415 */         for (Shape1D s : shapes) {
/* 416 */           int pid = partitioner.overlapPartition1D(s);
/* 417 */           System.out.println(String.valueOf(pid) + "--------");
/* 418 */           if (pid != -1)
/*     */           {
/* 420 */             recordWriter.write(partitionID, s);
/*     */           }
/*     */         } 
/*     */       } 
/*     */       
/* 425 */       reader.close(); b++; }
/*     */     
/* 427 */     recordWriter.close(null);
/*     */ 
/*     */     
/* 430 */     Path masterPath = new Path(outPath, "_master." + sindex);
/* 431 */     FileSystem outFs = outPath.getFileSystem((Configuration)params);
/* 432 */     Path wktPath = new Path(outPath, "_" + sindex + ".wkt");
/* 433 */     PrintStream wktOut = new PrintStream((OutputStream)outFs.create(wktPath));
/* 434 */     wktOut.println("ID\tSegments\tRecord Count\tSize\tFile name");
/* 435 */     Text2 text2 = new Text2();
/* 436 */     Partition1D tempPartition = new Partition1D();
/* 437 */     LineReader in = new LineReader((InputStream)outFs.open(masterPath));
/* 438 */     while (in.readLine((Text)text2) > 0) {
/* 439 */       tempPartition.fromText((Text)text2);
/* 440 */       wktOut.println(tempPartition.toWKT());
/*     */     } 
/* 442 */     in.close();
/* 443 */     wktOut.close();
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static Job index(Path inPath, Path outPath, OperationsParams params) throws IOException, InterruptedException, ClassNotFoundException {
/* 450 */     if (OperationsParams.isLocal((Configuration)new JobConf((Configuration)params), new Path[] { inPath })) {
/* 451 */       indexLocal(inPath, outPath, params);
/* 452 */       return null;
/*     */     } 
/* 454 */     return indexMapReduce(inPath, outPath, params);
/*     */   }
/*     */ 
/*     */   
/*     */   protected static void printUsage() {
/* 459 */     System.out.println("Builds a spatial index on an input file");
/* 460 */     System.out.println("Parameters (* marks required parameters):");
/* 461 */     System.out.println("<input file> - (*) Path to input file");
/* 462 */     System.out.println("<output file> - (*) Path to output file");
/* 463 */     System.out.println("shape:<point|rectangle|polygon> - (*) Type of shapes stored in input file");
/* 464 */     System.out.println("sindex:<index> - (*) Type of spatial index (grid|str|str+|quadtree|zcurve|kdtree)");
/* 465 */     System.out.println("-overwrite - Overwrite output file without noitce");
/* 466 */     GenericOptionsParser.printGenericCommandUsage(System.out);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static void main(String[] args) throws Exception {
/* 475 */     args = new String[6];
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */     
/* 482 */     args[0] = "hdfs://master:9000/test";
/* 483 */     args[1] = "hdfs://master:9000/output";
/* 484 */     args[2] = "sindex:bpt";
/* 485 */     args[3] = "shape:com.dlmu.wisdomST.core.TrajBus3";
/* 486 */     args[4] = "-overwrite";
/* 487 */     args[5] = "-local";
/*     */     
/* 489 */     OperationsParams params = new OperationsParams(new GenericOptionsParser(args));
/*     */     
/* 491 */     if (!params.checkInputOutput(true)) {
/* 492 */       printUsage();
/*     */       return;
/*     */     } 
/* 495 */     if (params.get("sindex") == null) {
/* 496 */       System.err.println("Please specify type of index to build (grid, rtree, r+tree, str, str+)");
/* 497 */       printUsage();
/*     */       return;
/*     */     } 
/* 500 */     Path inputPath = params.getInputPath();
/* 501 */     Path outputPath = params.getOutputPath();
/*     */ 
/*     */     
/* 504 */     long t1 = System.currentTimeMillis();
/* 505 */     index(inputPath, outputPath, params);
/* 506 */     long t2 = System.currentTimeMillis();
/* 507 */     System.out.println("Total indexing time in millis " + (t2 - t1));
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\Indexer3.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */