/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.CellInfo;
/*     */ import com.dlmu.wisdomST.core.CellInfo1D;
/*     */ import com.dlmu.wisdomST.core.IPoint;
/*     */ import com.dlmu.wisdomST.core.Point;
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialRecordReader;
/*     */ import com.dlmu.wisdomST.operation.ShapeIterRecordReader;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.util.ArrayDeque;
/*     */ import java.util.Arrays;
/*     */ import java.util.Comparator;
/*     */ import java.util.Queue;
/*     */ import java.util.Vector;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.mapred.FileSplit;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class KdTreePartitioner
/*     */   extends Partitioner
/*     */ {
/*  47 */   private final Rectangle mbr = new Rectangle();
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private double[] splits;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void createFromPoints(Rectangle mbr, Point[] points, int capacity) {
/*  67 */     int numSplits = (int)Math.ceil(points.length / capacity);
/*  68 */     String[] ids = new String[numSplits];
/*  69 */     for (int id = numSplits; id < 2 * numSplits; id++) {
/*  70 */       ids[id - numSplits] = Integer.toBinaryString(id);
/*     */     }
/*     */ 
/*     */ 
/*     */     
/*  75 */     Comparator[] comparators = {
/*  76 */         new Comparator<Point>()
/*     */         {
/*     */           public int compare(Point a, Point b) {
/*  79 */             return (a.x < b.x) ? -1 : ((a.x > b.x) ? 1 : 0);
/*     */           }
/*  81 */         }, new Comparator<Point>()
/*     */         {
/*     */           public int compare(Point a, Point b) {
/*  84 */             return (a.y < b.y) ? -1 : ((a.y > b.y) ? 1 : 0);
/*     */           }
/*     */         }
/*     */       };
/*     */     class SplitTask
/*     */     {
/*     */       int fromIndex;
/*     */       
/*     */       int toIndex;
/*     */       int direction;
/*     */       int partitionID;
/*     */       
/*     */       public SplitTask(int fromIndex, int toIndex, int direction, int partitionID) {
/*  97 */         this.fromIndex = fromIndex;
/*  98 */         this.toIndex = toIndex;
/*  99 */         this.direction = direction;
/* 100 */         this.partitionID = partitionID;
/*     */       }
/*     */     };
/*     */     
/* 104 */     Queue<SplitTask> splitTasks = new ArrayDeque<SplitTask>();
/* 105 */     splitTasks.add(new SplitTask(0, points.length, 0, 1));
/*     */     
/* 107 */     this.mbr.set((Shape)mbr);
/* 108 */     this.splits = new double[numSplits];
/*     */     
/* 110 */     while (!splitTasks.isEmpty()) {
/* 111 */       SplitTask splitTask = splitTasks.remove();
/* 112 */       if (splitTask.partitionID < numSplits) {
/* 113 */         String child1 = Integer.toBinaryString(splitTask.partitionID * 2);
/* 114 */         String child2 = Integer.toBinaryString(splitTask.partitionID * 2 + 1);
/* 115 */         int size_child1 = 0, size_child2 = 0;
/* 116 */         for (int i = 0; i < ids.length; i++) {
/* 117 */           if (ids[i].startsWith(child1)) {
/* 118 */             size_child1++;
/* 119 */           } else if (ids[i].startsWith(child2)) {
/* 120 */             size_child2++;
/*     */           } 
/*     */         } 
/*     */ 
/*     */         
/* 125 */         int splitIndex = (int)((size_child1 * splitTask.toIndex + size_child2 * splitTask.fromIndex) / (
/* 126 */           size_child1 + size_child2));
/* 127 */         partialQuickSort(points, splitTask.fromIndex, splitTask.toIndex, 
/* 128 */             splitIndex, comparators[splitTask.direction]);
/* 129 */         Point splitValue = points[splitIndex];
/* 130 */         this.splits[splitTask.partitionID] = (splitTask.direction == 0) ? 
/* 131 */           splitValue.x : splitValue.y;
/* 132 */         splitTasks.add(new SplitTask(this, splitTask.fromIndex, splitIndex, 
/* 133 */               1 - splitTask.direction, splitTask.partitionID * 2));
/* 134 */         splitTasks.add(new SplitTask(this, splitIndex, splitTask.toIndex, 
/* 135 */               1 - splitTask.direction, splitTask.partitionID * 2 + 1));
/*     */       } 
/*     */     } 
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static <T> void partialQuickSort(Object[] a, int fromIndex, int toIndex, int desiredIndex, Comparator<T> c) {
/* 154 */     Arrays.sort(a, fromIndex, toIndex, (Comparator)c);
/*     */   }
/*     */ 
/*     */   
/*     */   public void write(DataOutput out) throws IOException {
/* 159 */     this.mbr.write(out);
/* 160 */     out.writeInt(this.splits.length);
/* 161 */     ByteBuffer bbuffer = ByteBuffer.allocate(this.splits.length * 8); byte b; int i; double[] arrayOfDouble;
/* 162 */     for (i = (arrayOfDouble = this.splits).length, b = 0; b < i; ) { double split = arrayOfDouble[b];
/* 163 */       bbuffer.putDouble(split); b++; }
/* 164 */      if (bbuffer.hasRemaining())
/* 165 */       throw new RuntimeException("Did not calculate buffer size correctly"); 
/* 166 */     out.write(bbuffer.array(), bbuffer.arrayOffset(), bbuffer.position());
/*     */   }
/*     */ 
/*     */   
/*     */   public void readFields(DataInput in) throws IOException {
/* 171 */     this.mbr.readFields(in);
/* 172 */     int partitions = in.readInt();
/* 173 */     this.splits = new double[partitions];
/*     */     
/* 175 */     int bufferLength = this.splits.length * 8;
/* 176 */     byte[] buffer = new byte[bufferLength];
/* 177 */     in.readFully(buffer);
/* 178 */     ByteBuffer bbuffer = ByteBuffer.wrap(buffer);
/* 179 */     for (int i = 0; i < this.splits.length; i++)
/* 180 */       this.splits[i] = bbuffer.getDouble(); 
/* 181 */     if (bbuffer.hasRemaining()) {
/* 182 */       throw new RuntimeException("Error reading STR partitioner");
/*     */     }
/*     */   }
/*     */   
/*     */   public int getPartitionCount() {
/* 187 */     return this.splits.length;
/*     */   }
/*     */ 
/*     */   
/*     */   public void overlapPartitions(Shape shape, ResultCollector<Integer> matcher) {
/* 192 */     if (shape == null || shape.getMBR() == null)
/*     */       return; 
/* 194 */     Rectangle shapeMBR = shape.getMBR();
/*     */     class SplitToTest
/*     */     {
/*     */       int splitID;
/*     */       
/*     */       int direction;
/*     */ 
/*     */       
/*     */       public SplitToTest(int splitID, int direction) {
/* 203 */         this.splitID = splitID;
/* 204 */         this.direction = direction;
/*     */       }
/*     */     };
/*     */     
/* 208 */     Queue<SplitToTest> splitsToTest = new ArrayDeque<SplitToTest>();
/*     */     
/* 210 */     splitsToTest.add(new SplitToTest(1, 0));
/*     */     
/* 212 */     while (!splitsToTest.isEmpty()) {
/* 213 */       SplitToTest splitToTest = splitsToTest.remove();
/* 214 */       if (splitToTest.splitID >= this.splits.length) {
/*     */         
/* 216 */         matcher.collect(Integer.valueOf(splitToTest.splitID));
/*     */         continue;
/*     */       } 
/* 219 */       if (splitToTest.direction == 0) {
/*     */         
/* 221 */         if (shapeMBR.x1 < this.splits[splitToTest.splitID])
/* 222 */           splitsToTest.add(new SplitToTest(this, splitToTest.splitID * 2, 0x1 ^ splitToTest.direction)); 
/* 223 */         if (shapeMBR.x2 > this.splits[splitToTest.splitID])
/* 224 */           splitsToTest.add(new SplitToTest(this, splitToTest.splitID * 2 + 1, 0x1 ^ splitToTest.direction)); 
/*     */         continue;
/*     */       } 
/* 227 */       if (shapeMBR.y1 < this.splits[splitToTest.splitID])
/* 228 */         splitsToTest.add(new SplitToTest(this, splitToTest.splitID * 2, 0x1 ^ splitToTest.direction)); 
/* 229 */       if (shapeMBR.y2 > this.splits[splitToTest.splitID]) {
/* 230 */         splitsToTest.add(new SplitToTest(this, splitToTest.splitID * 2 + 1, 0x1 ^ splitToTest.direction));
/*     */       }
/*     */     } 
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int overlapPartition(Shape shape) {
/* 241 */     if (shape == null || shape.getMBR() == null)
/* 242 */       return -1; 
/* 243 */     Point pt = shape.getMBR().getCenterPoint();
/* 244 */     int splitID = 1;
/* 245 */     int direction = 0;
/* 246 */     while (splitID < this.splits.length) {
/* 247 */       if (direction == 0) {
/*     */         
/* 249 */         if (pt.x < this.splits[splitID]) {
/* 250 */           splitID *= 2;
/*     */         } else {
/* 252 */           splitID = splitID * 2 + 1;
/*     */         }
/*     */       
/* 255 */       } else if (pt.y < this.splits[splitID]) {
/* 256 */         splitID *= 2;
/*     */       } else {
/* 258 */         splitID = splitID * 2 + 1;
/*     */       } 
/* 260 */       direction ^= 0x1;
/*     */     } 
/* 262 */     return splitID;
/*     */   }
/*     */ 
/*     */   
/*     */   public CellInfo getPartitionAt(int index) {
/* 267 */     return getPartition(index + this.splits.length);
/*     */   }
/*     */ 
/*     */   
/*     */   public CellInfo getPartition(int id) {
/* 272 */     CellInfo cellInfo = new CellInfo(id, this.mbr);
/* 273 */     boolean minXFound = false, minYFound = false;
/* 274 */     boolean maxXFound = false, maxYFound = false;
/*     */     
/* 276 */     int direction = getNumberOfSignificantBits(id) & 0x1;
/* 277 */     while (id > 1) {
/*     */       
/* 279 */       int minOrMax = id & 0x1;
/* 280 */       id >>>= 1;
/* 281 */       if (minOrMax == 0 && direction == 0 && !maxXFound) {
/* 282 */         cellInfo.x2 = this.splits[id]; maxXFound = true;
/* 283 */       } else if (minOrMax == 0 && direction == 1 && !maxYFound) {
/* 284 */         cellInfo.y2 = this.splits[id]; maxYFound = true;
/* 285 */       } else if (minOrMax == 1 && direction == 0 && !minXFound) {
/* 286 */         cellInfo.x1 = this.splits[id]; minXFound = true;
/* 287 */       } else if (minOrMax == 1 && direction == 1 && !minYFound) {
/* 288 */         cellInfo.y1 = this.splits[id]; minYFound = true;
/*     */       } 
/* 290 */       direction ^= 0x1;
/*     */     } 
/* 292 */     return cellInfo;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static int getNumberOfSignificantBits(int x) {
/* 304 */     int numOfSignificantBits = 0;
/* 305 */     if ((x & 0xFFFF0000) != 0) {
/*     */       
/* 307 */       numOfSignificantBits += 16;
/* 308 */       x >>>= 16;
/*     */     } 
/* 310 */     if ((x & 0xFF00) != 0) {
/*     */       
/* 312 */       numOfSignificantBits += 8;
/* 313 */       x >>>= 8;
/*     */     } 
/* 315 */     if ((x & 0xF0) != 0) {
/* 316 */       numOfSignificantBits += 4;
/* 317 */       x >>>= 4;
/*     */     } 
/* 319 */     if ((x & 0xC) != 0) {
/* 320 */       numOfSignificantBits += 2;
/* 321 */       x >>>= 2;
/*     */     } 
/* 323 */     if ((x & 0x2) != 0) {
/* 324 */       numOfSignificantBits++;
/* 325 */       x >>>= 1;
/*     */     } 
/* 327 */     if ((x & 0x1) != 0) {
/* 328 */       numOfSignificantBits++;
/*     */     }
/*     */     
/* 331 */     return numOfSignificantBits;
/*     */   }
/*     */   
/*     */   public static void main(String[] args) throws IOException {
/* 335 */     OperationsParams params = new OperationsParams(new GenericOptionsParser(args));
/*     */     
/* 337 */     Path inPath = params.getInputPath();
/* 338 */     long length = inPath.getFileSystem((Configuration)params).getFileStatus(inPath).getLen();
/* 339 */     ShapeIterRecordReader reader = new ShapeIterRecordReader((Configuration)params, 
/* 340 */         new FileSplit(inPath, 0L, length, new String[0]));
/* 341 */     Rectangle key = reader.createKey();
/* 342 */     SpatialRecordReader.ShapeIterator shapes = reader.createValue();
/* 343 */     Vector<Point> points = new Vector<Point>();
/* 344 */     while (reader.next(key, shapes)) {
/* 345 */       for (Shape s : shapes) {
/* 346 */         points.add(s.getMBR().getCenterPoint());
/*     */       }
/*     */     } 
/* 349 */     Rectangle inMBR = (Rectangle)OperationsParams.getShape((Configuration)params, "mbr");
/*     */     
/* 351 */     KdTreePartitioner kdp = new KdTreePartitioner();
/* 352 */     kdp.createFromPoints(inMBR, points.<Point>toArray(new Point[points.size()]), 7);
/* 353 */     System.out.println("x,y,partition");
/* 354 */     int[] sizes = new int[kdp.getPartitionCount() * 2];
/* 355 */     for (Point p : points) {
/* 356 */       int partition = kdp.overlapPartition((Shape)p);
/*     */       
/* 358 */       sizes[partition] = sizes[partition] + 1;
/*     */     } 
/* 360 */     for (int i = 0; i < sizes.length; i++) {
/* 361 */       System.out.print(String.valueOf(sizes[i]) + ",");
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void overlapPartitions1D(Shape1D shape, ResultCollector<Integer> matcher) {}
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int overlapPartition1D(Shape1D shape) {
/* 379 */     return 0;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartition1D(int partitionID) {
/* 393 */     return null;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartitionAt1D(int index) {
/* 402 */     return null;
/*     */   }
/*     */   
/*     */   public void createFromPoints(Segment mbr, IPoint[] points, int capacity) throws IllegalArgumentException {}
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\KdTreePartitioner.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */