/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.CellInfo;
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.io.TextSerializerHelper;
/*     */ import java.awt.Graphics;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import org.apache.hadoop.io.Text;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class Partition
/*     */   extends CellInfo
/*     */ {
/*     */   public String filename;
/*     */   public long recordCount;
/*     */   public long size;
/*     */   
/*     */   public Partition() {}
/*     */   
/*     */   public Partition(String filename, CellInfo cell) {
/*  38 */     this.filename = filename;
/*  39 */     set(cell);
/*     */   }
/*     */   
/*     */   public Partition(Partition other) {
/*  43 */     this.filename = other.filename;
/*  44 */     this.recordCount = other.recordCount;
/*  45 */     this.size = other.size;
/*  46 */     set(other);
/*     */   }
/*     */ 
/*     */   
/*     */   public void write(DataOutput out) throws IOException {
/*  51 */     super.write(out);
/*  52 */     out.writeUTF(this.filename);
/*  53 */     out.writeLong(this.recordCount);
/*  54 */     out.writeLong(this.size);
/*     */   }
/*     */ 
/*     */   
/*     */   public void readFields(DataInput in) throws IOException {
/*  59 */     super.readFields(in);
/*  60 */     this.filename = in.readUTF();
/*  61 */     this.recordCount = in.readLong();
/*  62 */     this.size = in.readLong();
/*     */   }
/*     */ 
/*     */   
/*     */   public Text toText(Text text) {
/*  67 */     super.toText(text);
/*  68 */     text.append(new byte[] { 44 }, 0, 1);
/*  69 */     TextSerializerHelper.serializeLong(this.recordCount, text, ',');
/*  70 */     TextSerializerHelper.serializeLong(this.size, text, ',');
/*  71 */     byte[] temp = ((this.filename == null) ? "" : this.filename).getBytes();
/*  72 */     text.append(temp, 0, temp.length);
/*  73 */     return text;
/*     */   }
/*     */ 
/*     */   
/*     */   public void fromText(Text text) {
/*  78 */     super.fromText(text);
/*  79 */     text.set(text.getBytes(), 1, text.getLength() - 1);
/*  80 */     this.recordCount = TextSerializerHelper.consumeLong(text, ',');
/*  81 */     this.size = TextSerializerHelper.consumeLong(text, ',');
/*  82 */     this.filename = text.toString();
/*     */   }
/*     */ 
/*     */   
/*     */   public Partition clone() {
/*  87 */     return new Partition(this);
/*     */   }
/*     */ 
/*     */   
/*     */   public int hashCode() {
/*  92 */     return this.filename.hashCode();
/*     */   }
/*     */ 
/*     */   
/*     */   public boolean equals(Object obj) {
/*  97 */     if (obj == null)
/*  98 */       return false; 
/*  99 */     return this.filename.equals(((Partition)obj).filename);
/*     */   }
/*     */   
/*     */   public void expand(Partition p) {
/* 103 */     expand((Shape)p);
/*     */     
/* 105 */     this.size += p.size;
/* 106 */     this.recordCount += p.recordCount;
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public void draw(Graphics g, Rectangle fileMBR, int imageWidth, int imageHeight, double scale) {
/* 112 */     int s_x1 = (int)Math.round((this.x1 - fileMBR.x1) * imageWidth / fileMBR.getWidth());
/* 113 */     int s_y1 = (int)Math.round((this.y1 - fileMBR.y1) * imageHeight / fileMBR.getHeight());
/* 114 */     int s_x2 = (int)Math.round((this.x2 - fileMBR.x1) * imageWidth / fileMBR.getWidth());
/* 115 */     int s_y2 = (int)Math.round((this.y2 - fileMBR.y1) * imageHeight / fileMBR.getHeight());
/* 116 */     g.drawRect(s_x1, s_y1, s_x2 - s_x1 + 1, s_y2 - s_y1 + 1);
/*     */   }
/*     */ 
/*     */   
/*     */   public void draw(Graphics g, double xscale, double yscale) {
/* 121 */     int imgx1 = (int)Math.round(this.x1 * xscale);
/* 122 */     int imgy1 = (int)Math.round(this.y1 * yscale);
/* 123 */     int imgx2 = (int)Math.round(this.x2 * xscale);
/* 124 */     int imgy2 = (int)Math.round(this.y2 * yscale);
/* 125 */     g.drawRect(imgx1, imgy1, imgx2 - imgx1 + 1, imgy2 - imgy1 + 1);
/*     */   }
/*     */ 
/*     */   
/*     */   public String toWKT() {
/* 130 */     return String.valueOf(super.toWKT()) + "\t" + this.recordCount + "\t" + this.size + "\t" + this.filename;
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\Partition.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */