/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.CellInfo1D;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import com.dlmu.wisdomST.io.TextSerializerHelper;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import org.apache.hadoop.io.Text;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class Partition1D
/*     */   extends CellInfo1D
/*     */ {
/*     */   public String filename;
/*     */   public long recordCount;
/*     */   public long size;
/*     */   
/*     */   public Partition1D() {}
/*     */   
/*     */   public Partition1D(String filename, CellInfo1D cell) {
/*  39 */     this.filename = filename;
/*  40 */     set(cell);
/*     */   }
/*     */   
/*     */   public Partition1D(Partition1D other) {
/*  44 */     this.filename = other.filename;
/*  45 */     this.recordCount = other.recordCount;
/*  46 */     this.size = other.size;
/*  47 */     set(other);
/*     */   }
/*     */ 
/*     */   
/*     */   public void write(DataOutput out) throws IOException {
/*  52 */     super.write(out);
/*  53 */     out.writeUTF(this.filename);
/*  54 */     out.writeLong(this.recordCount);
/*  55 */     out.writeLong(this.size);
/*     */   }
/*     */ 
/*     */   
/*     */   public void readFields(DataInput in) throws IOException {
/*  60 */     super.readFields(in);
/*  61 */     this.filename = in.readUTF();
/*  62 */     this.recordCount = in.readLong();
/*  63 */     this.size = in.readLong();
/*     */   }
/*     */ 
/*     */   
/*     */   public Text toText(Text text) {
/*  68 */     super.toText(text);
/*  69 */     text.append(new byte[] { 44 }, 0, 1);
/*  70 */     TextSerializerHelper.serializeLong(this.recordCount, text, ',');
/*  71 */     TextSerializerHelper.serializeLong(this.size, text, ',');
/*  72 */     byte[] temp = ((this.filename == null) ? "" : this.filename).getBytes();
/*  73 */     text.append(temp, 0, temp.length);
/*  74 */     return text;
/*     */   }
/*     */ 
/*     */   
/*     */   public void fromText(Text text) {
/*  79 */     super.fromText(text);
/*  80 */     text.set(text.getBytes(), 1, text.getLength() - 1);
/*  81 */     this.recordCount = TextSerializerHelper.consumeLong(text, ',');
/*  82 */     this.size = TextSerializerHelper.consumeLong(text, ',');
/*  83 */     this.filename = text.toString();
/*     */   }
/*     */ 
/*     */   
/*     */   public Partition1D clone() {
/*  88 */     return new Partition1D(this);
/*     */   }
/*     */ 
/*     */   
/*     */   public int hashCode() {
/*  93 */     return this.filename.hashCode();
/*     */   }
/*     */ 
/*     */   
/*     */   public boolean equals(Object obj) {
/*  98 */     if (obj == null)
/*  99 */       return false; 
/* 100 */     return this.filename.equals(((Partition1D)obj).filename);
/*     */   }
/*     */   
/*     */   public void expand(Partition1D p) {
/* 104 */     expand((Shape1D)p);
/*     */     
/* 106 */     this.size += p.size;
/* 107 */     this.recordCount += p.recordCount;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public String toWKT() {
/* 114 */     return String.valueOf(super.toWKT()) + "\t" + this.recordCount + "\t" + this.size + "\t" + this.filename;
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\Partition1D.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */