/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.CellInfo;
/*     */ import com.dlmu.wisdomST.core.CellInfo1D;
/*     */ import com.dlmu.wisdomST.core.IPoint;
/*     */ import com.dlmu.wisdomST.core.Point;
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.filecache.DistributedCache;
/*     */ import org.apache.hadoop.fs.FSDataInputStream;
/*     */ import org.apache.hadoop.fs.FSDataOutputStream;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.io.Writable;
/*     */ import org.mortbay.log.Log;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public abstract class Partitioner
/*     */   implements Writable
/*     */ {
/*     */   private static final String PartitionerClass = "Partitioner.Class";
/*     */   private static final String PartitionerValue = "Partitioner.Value";
/*     */   
/*     */   public abstract void createFromPoints(Segment paramSegment, IPoint[] paramArrayOfIPoint, int paramInt) throws IllegalArgumentException;
/*     */   
/*     */   public abstract void createFromPoints(Rectangle paramRectangle, Point[] paramArrayOfPoint, int paramInt) throws IllegalArgumentException;
/*     */   
/*     */   public abstract void overlapPartitions(Shape paramShape, ResultCollector<Integer> paramResultCollector);
/*     */   
/*     */   public abstract void overlapPartitions1D(Shape1D paramShape1D, ResultCollector<Integer> paramResultCollector);
/*     */   
/*     */   public abstract int overlapPartition(Shape paramShape);
/*     */   
/*     */   public abstract int overlapPartition1D(Shape1D paramShape1D);
/*     */   
/*     */   public abstract CellInfo getPartition(int paramInt);
/*     */   
/*     */   public abstract CellInfo1D getPartition1D(int paramInt);
/*     */   
/*     */   public abstract CellInfo getPartitionAt(int paramInt);
/*     */   
/*     */   public abstract CellInfo1D getPartitionAt1D(int paramInt);
/*     */   
/*     */   public abstract int getPartitionCount();
/*     */   
/*     */   public static void setPartitioner(Configuration conf, Partitioner partitioner) throws IOException {
/* 107 */     conf.setClass("Partitioner.Class", partitioner.getClass(), Partitioner.class);
/*     */     
/* 109 */     FileSystem fs = FileSystem.get(conf);
/*     */     while (true) {
/* 111 */       Path tempFile = new Path("cells_" + (int)(Math.random() * 1000000.0D) + ".partitions");
/* 112 */       if (!fs.exists(tempFile)) {
/* 113 */         FSDataOutputStream out = fs.create(tempFile);
/* 114 */         partitioner.write((DataOutput)out);
/* 115 */         out.close();
/*     */         
/* 117 */         fs.deleteOnExit(tempFile);
/*     */         
/* 119 */         DistributedCache.addCacheFile(tempFile.toUri(), conf);
/* 120 */         conf.set("Partitioner.Value", tempFile.getName());
/*     */         return;
/*     */       } 
/*     */     } 
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public static Partitioner getPartitioner(Configuration conf) {
/* 129 */     Class<? extends Partitioner> klass = conf.getClass("Partitioner.Class", Partitioner.class).asSubclass(Partitioner.class);
/* 130 */     if (klass == null)
/* 131 */       return null; 
/*     */     try {
/* 133 */       Partitioner partitioner = klass.newInstance();
/*     */       
/* 135 */       String partitionerFile = conf.get("Partitioner.Value");
/* 136 */       if (partitionerFile != null) {
/* 137 */         Path[] cacheFiles = DistributedCache.getLocalCacheFiles(conf); byte b; int i; Path[] arrayOfPath1;
/* 138 */         for (i = (arrayOfPath1 = cacheFiles).length, b = 0; b < i; ) { Path cacheFile = arrayOfPath1[b];
/* 139 */           if (cacheFile.getName().contains(partitionerFile)) {
/* 140 */             FSDataInputStream in = FileSystem.getLocal(conf).open(cacheFile);
/* 141 */             partitioner.readFields((DataInput)in);
/* 142 */             in.close();
/*     */           }  b++; }
/*     */       
/*     */       } 
/* 146 */       return partitioner;
/* 147 */     } catch (InstantiationException e) {
/* 148 */       Log.warn("Error instantiating partitioner", e);
/* 149 */       return null;
/* 150 */     } catch (IllegalAccessException e) {
/* 151 */       Log.warn("Error instantiating partitioner", e);
/* 152 */       return null;
/* 153 */     } catch (IOException e) {
/* 154 */       Log.warn("Error retrieving partitioner value", e);
/* 155 */       return null;
/*     */     } 
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\Partitioner.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */