/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.CellInfo;
/*     */ import com.dlmu.wisdomST.core.CellInfo1D;
/*     */ import com.dlmu.wisdomST.core.IPoint;
/*     */ import com.dlmu.wisdomST.core.Point;
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialRecordReader;
/*     */ import com.dlmu.wisdomST.operation.ShapeIterRecordReader;
/*     */ import com.dlmu.wisdomST.util.BitArray;
/*     */ import com.dlmu.wisdomST.util.IntArray;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import java.util.ArrayDeque;
/*     */ import java.util.Arrays;
/*     */ import java.util.Queue;
/*     */ import java.util.Vector;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.mapred.FileSplit;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class QuadTreePartitioner
/*     */   extends Partitioner
/*     */ {
/*  48 */   protected final Rectangle mbr = new Rectangle();
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected BitArray leafNodes;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected int[] leafNodeIDs;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void createFromPoints(Rectangle mbr, Point[] points, int capacity) {
/*  69 */     this.mbr.set((Shape)mbr);
/*  70 */     long[] zValues = new long[points.length];
/*  71 */     for (int i = 0; i < points.length; i++)
/*  72 */       zValues[i] = ZCurvePartitioner.computeZ(mbr, (points[i]).x, (points[i]).y); 
/*  73 */     createFromZValues(zValues, capacity);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected void createFromZValues(long[] zValues, int capacity) {
/*  82 */     Arrays.sort(zValues);
/*     */     class QuadTreeNode {
/*     */       int fromIndex;
/*     */       int toIndex;
/*     */       long minZ;
/*     */       int nodeID;
/*     */       int depth;
/*     */       
/*     */       public QuadTreeNode(int fromIndex, int toIndex, long minZ, long maxZ, int nodeID, int depth) {
/*  91 */         this.fromIndex = fromIndex;
/*  92 */         this.toIndex = toIndex;
/*  93 */         this.minZ = minZ;
/*     */         
/*  95 */         this.nodeID = nodeID;
/*  96 */         this.depth = depth;
/*     */       }
/*     */     };
/*     */     
/* 100 */     long minZ = ZCurvePartitioner.computeZ(this.mbr, this.mbr.x1, this.mbr.y1);
/* 101 */     long maxZ = ZCurvePartitioner.computeZ(this.mbr, this.mbr.x2, this.mbr.y2);
/* 102 */     QuadTreeNode root = new QuadTreeNode(0, zValues.length, minZ, maxZ, 1, 1);
/* 103 */     Queue<QuadTreeNode> nodesToSplit = new ArrayDeque<QuadTreeNode>();
/* 104 */     nodesToSplit.add(root);
/*     */     
/* 106 */     Vector<Integer> leafNodeIDs = new Vector<Integer>();
/* 107 */     int maxNodeID = 0;
/*     */     
/* 109 */     while (!nodesToSplit.isEmpty()) {
/* 110 */       QuadTreeNode nodeToSplit = nodesToSplit.remove();
/* 111 */       if (nodeToSplit.nodeID < 0) {
/* 112 */         nodesToSplit.remove();
/*     */         continue;
/*     */       } 
/* 115 */       if (nodeToSplit.toIndex - nodeToSplit.fromIndex <= capacity) {
/*     */         
/* 117 */         leafNodeIDs.add(Integer.valueOf(nodeToSplit.nodeID));
/* 118 */         if (nodeToSplit.nodeID > maxNodeID) {
/* 119 */           maxNodeID = nodeToSplit.nodeID;
/*     */         }
/*     */         
/*     */         continue;
/*     */       } 
/* 124 */       int changedBits = 
/* 125 */         KdTreePartitioner.getNumberOfSignificantBits(2147483647) * 2 - 
/* 126 */         nodeToSplit.depth * 2;
/*     */       
/* 128 */       long childMinZ = nodeToSplit.minZ;
/* 129 */       int childFromIndex = nodeToSplit.fromIndex;
/* 130 */       for (int iChild = 0; iChild < 4; iChild++) {
/* 131 */         long childMaxZ = nodeToSplit.minZ + (iChild + 1L << changedBits);
/* 132 */         int childToIndex = Arrays.binarySearch(zValues, 
/* 133 */             nodeToSplit.fromIndex, nodeToSplit.toIndex, childMaxZ);
/* 134 */         if (childToIndex < 0)
/* 135 */           childToIndex = -(childToIndex + 1); 
/* 136 */         QuadTreeNode childNode = new QuadTreeNode(this, childFromIndex, 
/* 137 */             childToIndex, childMinZ, childMaxZ, 
/* 138 */             nodeToSplit.nodeID * 4 + iChild, nodeToSplit.depth + 1);
/* 139 */         if (childNode.nodeID > 0) {
/* 140 */           nodesToSplit.add(childNode);
/* 141 */           childMinZ = childMaxZ;
/* 142 */           childFromIndex = childToIndex;
/*     */         } 
/*     */       } 
/*     */     } 
/*     */ 
/*     */     
/* 148 */     this.leafNodes = new BitArray((maxNodeID + 1));
/* 149 */     this.leafNodeIDs = new int[leafNodeIDs.size()];
/* 150 */     for (int i = 0; i < leafNodeIDs.size(); i++) {
/*     */       try {
/* 152 */         this.leafNodes.set(((Integer)leafNodeIDs.get(i)).intValue(), true);
/* 153 */         this.leafNodeIDs[i] = ((Integer)leafNodeIDs.get(i)).intValue();
/* 154 */       } catch (ArrayIndexOutOfBoundsException e) {
/* 155 */         System.out
/* 156 */           .println("catch java.lang.ArrayIndexOutOfBoundsException");
/*     */       } 
/*     */     } 
/* 159 */     Arrays.sort(this.leafNodeIDs);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void write(DataOutput out) throws IOException {
/* 166 */     IntArray.writeIntArray(this.leafNodeIDs, out);
/* 167 */     this.mbr.write(out);
/* 168 */     this.leafNodes.write(out);
/*     */   }
/*     */ 
/*     */   
/*     */   public void readFields(DataInput in) throws IOException {
/* 173 */     this.leafNodeIDs = IntArray.readIntArray(this.leafNodeIDs, in);
/* 174 */     this.mbr.readFields(in);
/* 175 */     this.leafNodes = new BitArray();
/* 176 */     this.leafNodes.readFields(in);
/*     */   }
/*     */ 
/*     */   
/*     */   public int overlapPartition(Shape shape) {
/* 181 */     if (shape == null || shape.getMBR() == null) {
/* 182 */       return -1;
/*     */     }
/* 184 */     Point queryPoint = shape.getMBR().getCenterPoint();
/* 185 */     int nodeToSearch = 1;
/* 186 */     Rectangle nodeMBR = this.mbr.clone();
/*     */     
/* 188 */     while (nodeToSearch < this.leafNodes.size() && !this.leafNodes.get(nodeToSearch)) {
/* 189 */       Point nodeCenter = nodeMBR.getCenterPoint();
/* 190 */       if (queryPoint.x < nodeCenter.x && queryPoint.y < nodeCenter.y) {
/* 191 */         nodeToSearch *= 4;
/* 192 */         nodeMBR.x2 = nodeCenter.x;
/* 193 */         nodeMBR.y2 = nodeCenter.y; continue;
/* 194 */       }  if (queryPoint.x < nodeCenter.x && queryPoint.y >= nodeCenter.y) {
/* 195 */         nodeToSearch = nodeToSearch * 4 + 1;
/* 196 */         nodeMBR.x2 = nodeCenter.x;
/* 197 */         nodeMBR.y1 = nodeCenter.y; continue;
/* 198 */       }  if (queryPoint.x >= nodeCenter.x && queryPoint.y < nodeCenter.y) {
/* 199 */         nodeToSearch = nodeToSearch * 4 + 2;
/* 200 */         nodeMBR.x1 = nodeCenter.x;
/* 201 */         nodeMBR.y2 = nodeCenter.y; continue;
/*     */       } 
/* 203 */       nodeToSearch = nodeToSearch * 4 + 3;
/* 204 */       nodeMBR.x1 = nodeCenter.x;
/* 205 */       nodeMBR.y1 = nodeCenter.y;
/*     */     } 
/*     */ 
/*     */     
/* 209 */     if (nodeToSearch >= this.leafNodes.size())
/* 210 */       return -1; 
/* 211 */     return nodeToSearch;
/*     */   }
/*     */ 
/*     */   
/*     */   public void overlapPartitions(Shape shape, ResultCollector<Integer> matcher) {
/* 216 */     if (shape == null || shape.getMBR() == null)
/*     */       return; 
/* 218 */     Rectangle shapeMBR = shape.getMBR();
/* 219 */     Queue<CellInfo> nodesToSearch = new ArrayDeque<CellInfo>();
/* 220 */     nodesToSearch.add(new CellInfo(1, this.mbr));
/*     */     
/* 222 */     while (!nodesToSearch.isEmpty()) {
/*     */       
/* 224 */       CellInfo nodeToSearch = nodesToSearch.remove();
/* 225 */       if (!shapeMBR.isIntersected((Shape)nodeToSearch) || 
/* 226 */         nodeToSearch.cellId < 0) {
/*     */         continue;
/*     */       }
/* 229 */       if (this.leafNodes.get(nodeToSearch.cellId)) {
/*     */         
/* 231 */         matcher.collect(Integer.valueOf(nodeToSearch.cellId));
/*     */         continue;
/*     */       } 
/* 234 */       Point centerPoint = nodeToSearch.getCenterPoint();
/* 235 */       nodesToSearch.add(new CellInfo(nodeToSearch.cellId * 4, 
/* 236 */             nodeToSearch.x1, nodeToSearch.y1, centerPoint.x, centerPoint.y));
/* 237 */       nodesToSearch.add(new CellInfo(nodeToSearch.cellId * 4 + 1, 
/* 238 */             nodeToSearch.x1, centerPoint.y, centerPoint.x, nodeToSearch.y2));
/* 239 */       nodesToSearch.add(new CellInfo(nodeToSearch.cellId * 4 + 2, 
/* 240 */             centerPoint.x, nodeToSearch.y1, nodeToSearch.x2, centerPoint.y));
/* 241 */       nodesToSearch.add(new CellInfo(nodeToSearch.cellId * 4 + 3, 
/* 242 */             centerPoint.x, centerPoint.y, nodeToSearch.x2, nodeToSearch.y2));
/*     */     } 
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int getPartitionCount() {
/* 250 */     return this.leafNodeIDs.length;
/*     */   }
/*     */ 
/*     */   
/*     */   public CellInfo getPartitionAt(int index) {
/* 255 */     return getPartition(this.leafNodeIDs[index]);
/*     */   }
/*     */ 
/*     */   
/*     */   public CellInfo getPartition(int partitionID) {
/* 260 */     CellInfo cellInfo = new CellInfo(partitionID, this.mbr);
/*     */     
/* 262 */     int partitionDepth = (
/* 263 */       KdTreePartitioner.getNumberOfSignificantBits(partitionID) + 1) / 2;
/*     */     
/* 265 */     for (int depth = 1; depth < partitionDepth; depth++) {
/* 266 */       int childNumber = partitionID >> 2 * (partitionDepth - depth - 1) & 0x3;
/* 267 */       Point center = cellInfo.getCenterPoint();
/* 268 */       switch (childNumber) { case 0:
/* 269 */           cellInfo.x2 = center.x; cellInfo.y2 = center.y; break;
/* 270 */         case 1: cellInfo.x2 = center.x; cellInfo.y1 = center.y; break;
/* 271 */         case 2: cellInfo.x1 = center.x; cellInfo.y2 = center.y; break;
/* 272 */         case 3: cellInfo.x1 = center.x; cellInfo.y1 = center.y;
/*     */           break; }
/*     */     
/*     */     } 
/* 276 */     return cellInfo;
/*     */   }
/*     */   
/*     */   public static void main(String[] args) throws IOException {
/* 280 */     OperationsParams params = new OperationsParams(new GenericOptionsParser(args));
/*     */     
/* 282 */     Path inPath = params.getInputPath();
/* 283 */     long length = inPath.getFileSystem((Configuration)params).getFileStatus(inPath).getLen();
/* 284 */     ShapeIterRecordReader reader = new ShapeIterRecordReader((Configuration)params, 
/* 285 */         new FileSplit(inPath, 0L, length, new String[0]));
/* 286 */     Rectangle key = reader.createKey();
/* 287 */     SpatialRecordReader.ShapeIterator shapes = reader.createValue();
/* 288 */     Vector<Point> points = new Vector<Point>();
/* 289 */     while (reader.next(key, shapes)) {
/* 290 */       for (Shape s : shapes) {
/* 291 */         points.add(s.getMBR().getCenterPoint());
/*     */       }
/*     */     } 
/* 294 */     Rectangle inMBR = (Rectangle)OperationsParams.getShape((Configuration)params, "mbr");
/*     */     
/* 296 */     QuadTreePartitioner qtp = new QuadTreePartitioner();
/* 297 */     qtp.createFromPoints(inMBR, points.<Point>toArray(new Point[points.size()]), 8);
/* 298 */     System.out.println("x,y,partition");
/* 299 */     for (Point p : points) {
/* 300 */       int partition = qtp.overlapPartition((Shape)p);
/* 301 */       System.out.println(String.valueOf(p.x) + "," + p.y + "," + partition);
/*     */     } 
/*     */     
/* 304 */     System.out.println("Partition count " + qtp.getPartitionCount());
/* 305 */     for (int i = 0; i < qtp.getPartitionCount(); i++) {
/* 306 */       System.out.println(qtp.getPartitionAt(i).toWKT());
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void overlapPartitions1D(Shape1D shape, ResultCollector<Integer> matcher) {}
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int overlapPartition1D(Shape1D shape) {
/* 325 */     return 0;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartition1D(int partitionID) {
/* 339 */     return null;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartitionAt1D(int index) {
/* 348 */     return null;
/*     */   }
/*     */   
/*     */   public void createFromPoints(Segment mbr, IPoint[] points, int capacity) throws IllegalArgumentException {}
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\QuadTreePartitioner.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */