/*    */ package com.dlmu.wisdomST.indexing;
/*    */ 
/*    */ import com.dlmu.wisdomST.core.Shape;
/*    */ import com.dlmu.wisdomST.core.Shape1D;
/*    */ import java.io.BufferedInputStream;
/*    */ import java.io.DataOutput;
/*    */ import java.io.File;
/*    */ import java.io.FileInputStream;
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import org.apache.commons.logging.Log;
/*    */ import org.apache.commons.logging.LogFactory;
/*    */ import org.apache.hadoop.conf.Configuration;
/*    */ import org.apache.hadoop.fs.FSDataOutputStream;
/*    */ import org.apache.hadoop.fs.FileSystem;
/*    */ import org.apache.hadoop.fs.Path;
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ public class RTreeLocalIndexer
/*    */   implements LocalIndexer
/*    */ {
/* 35 */   private static final Log LOG = LogFactory.getLog(RTreeLocalIndexer.class);
/*    */ 
/*    */   
/*    */   protected Configuration conf;
/*    */ 
/*    */ 
/*    */   
/*    */   public void setup(Configuration conf) throws IOException, InterruptedException {
/* 43 */     this.conf = conf;
/*    */   }
/*    */ 
/*    */   
/*    */   public String getExtension() {
/* 48 */     return "rtree";
/*    */   }
/*    */ 
/*    */ 
/*    */ 
/*    */   
/*    */   public void buildLocalIndex(File nonIndexedFile, Path outputIndexedFile, Shape shape) throws IOException, InterruptedException {
/* 55 */     byte[] cellData = new byte[(int)nonIndexedFile.length()];
/* 56 */     InputStream cellIn = new BufferedInputStream(new FileInputStream(nonIndexedFile));
/* 57 */     cellIn.read(cellData);
/* 58 */     cellIn.close();
/*    */ 
/*    */ 
/*    */     
/* 62 */     FileSystem outFS = outputIndexedFile.getFileSystem(this.conf);
/* 63 */     FSDataOutputStream fSDataOutputStream = outFS.create(outputIndexedFile);
/* 64 */     fSDataOutputStream.writeLong(-1250999896336L);
/* 65 */     int degree = 113;
/* 66 */     boolean fastAlgorithm = this.conf.get("spatialHadoop.storage.RTreeBuildMode", "fast").equals("fast");
/* 67 */     RTree.bulkLoadWrite(cellData, 0, cellData.length, degree, (DataOutput)fSDataOutputStream, 
/* 68 */         shape.clone(), fastAlgorithm);
/* 69 */     fSDataOutputStream.close();
/*    */   }
/*    */   
/*    */   public void buildLocalIndex(File nonIndexedFile, Path outputIndexedFile, Shape1D shape) throws IOException, InterruptedException {}
/*    */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\RTreeLocalIndexer.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */