/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.CellInfo;
/*     */ import com.dlmu.wisdomST.core.CellInfo1D;
/*     */ import com.dlmu.wisdomST.core.GridInfo;
/*     */ import com.dlmu.wisdomST.core.IPoint;
/*     */ import com.dlmu.wisdomST.core.Point;
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.SegmentInfo;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.util.Arrays;
/*     */ import java.util.Comparator;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class STRPartitioner
/*     */   extends Partitioner
/*     */ {
/*  39 */   private final Rectangle mbr = new Rectangle();
/*     */   
/*  41 */   private final Segment seg = new Segment();
/*     */ 
/*     */ 
/*     */   
/*     */   private int columns;
/*     */ 
/*     */ 
/*     */   
/*     */   private int rows;
/*     */ 
/*     */   
/*     */   private double[] xSplits;
/*     */ 
/*     */   
/*     */   private double[] ySplits;
/*     */ 
/*     */ 
/*     */   
/*     */   public void createFromPoints(Rectangle mbr, Point[] points, int capacity) {
/*  60 */     Arrays.sort(points, new Comparator<Point>()
/*     */         {
/*     */           public int compare(Point a, Point b) {
/*  63 */             return (a.x < b.x) ? -1 : ((a.x > b.x) ? 1 : 0);
/*     */           }
/*     */         });
/*  66 */     int numSplits = (int)Math.ceil(points.length / capacity);
/*  67 */     GridInfo gridInfo = new GridInfo(mbr.x1, mbr.y1, mbr.x2, mbr.y2);
/*  68 */     gridInfo.calculateCellDimensions(numSplits);
/*  69 */     this.columns = gridInfo.columns;
/*  70 */     this.rows = gridInfo.rows;
/*  71 */     this.xSplits = new double[this.columns];
/*  72 */     this.ySplits = new double[this.rows * this.columns];
/*  73 */     int prev_quantile = 0;
/*  74 */     this.mbr.set((Shape)mbr);
/*  75 */     for (int column = 0; column < this.columns; column++) {
/*  76 */       int col_quantile = (column + 1) * points.length / this.columns;
/*     */       
/*  78 */       this.xSplits[column] = (col_quantile == points.length) ? mbr.x2 : (points[col_quantile - 1]).x;
/*     */       
/*  80 */       Arrays.sort(points, prev_quantile, col_quantile, new Comparator<Point>()
/*     */           {
/*     */             public int compare(Point a, Point b) {
/*  83 */               return (a.y < b.y) ? -1 : ((a.y > b.y) ? 1 : 0);
/*     */             }
/*     */           });
/*     */       
/*  87 */       for (int row = 0; row < this.rows; row++) {
/*  88 */         int row_quantile = (prev_quantile * (this.rows - row + 1) + 
/*  89 */           col_quantile * (row + 1)) / this.rows;
/*     */         
/*  91 */         this.ySplits[column * this.rows + row] = (row_quantile == col_quantile) ? mbr.y2 : (points[row_quantile]).y;
/*     */       } 
/*     */       
/*  94 */       prev_quantile = col_quantile;
/*     */     } 
/*     */   }
/*     */ 
/*     */   
/*     */   public void write(DataOutput out) throws IOException {
/* 100 */     this.mbr.write(out);
/* 101 */     out.writeInt(this.columns);
/* 102 */     out.writeInt(this.rows);
/* 103 */     ByteBuffer bbuffer = ByteBuffer.allocate((this.xSplits.length + this.ySplits.length) * 8); byte b; int i; double[] arrayOfDouble;
/* 104 */     for (i = (arrayOfDouble = this.xSplits).length, b = 0; b < i; ) { double xSplit = arrayOfDouble[b];
/* 105 */       bbuffer.putDouble(xSplit); b++; }
/* 106 */      for (i = (arrayOfDouble = this.ySplits).length, b = 0; b < i; ) { double ySplit = arrayOfDouble[b];
/* 107 */       bbuffer.putDouble(ySplit); b++; }
/* 108 */      if (bbuffer.hasRemaining())
/* 109 */       throw new RuntimeException("Did not calculate buffer size correctly"); 
/* 110 */     out.write(bbuffer.array(), bbuffer.arrayOffset(), bbuffer.position());
/*     */   }
/*     */ 
/*     */   
/*     */   public void readFields(DataInput in) throws IOException {
/* 115 */     this.mbr.readFields(in);
/* 116 */     this.columns = in.readInt();
/* 117 */     this.rows = in.readInt();
/* 118 */     this.xSplits = new double[this.columns];
/* 119 */     this.ySplits = new double[this.columns * this.rows];
/*     */     
/* 121 */     int bufferLength = (this.xSplits.length + this.ySplits.length) * 8;
/* 122 */     byte[] buffer = new byte[bufferLength];
/* 123 */     in.readFully(buffer);
/* 124 */     ByteBuffer bbuffer = ByteBuffer.wrap(buffer); int i;
/* 125 */     for (i = 0; i < this.xSplits.length; i++)
/* 126 */       this.xSplits[i] = bbuffer.getDouble(); 
/* 127 */     for (i = 0; i < this.ySplits.length; i++)
/* 128 */       this.ySplits[i] = bbuffer.getDouble(); 
/* 129 */     if (bbuffer.hasRemaining()) {
/* 130 */       throw new RuntimeException("Error reading STR partitioner");
/*     */     }
/*     */   }
/*     */   
/*     */   public int getPartitionCount() {
/* 135 */     return this.ySplits.length;
/*     */   }
/*     */ 
/*     */   
/*     */   public void overlapPartitions(Shape shape, ResultCollector<Integer> matcher) {
/* 140 */     if (shape == null)
/*     */       return; 
/* 142 */     Rectangle shapeMBR = shape.getMBR();
/* 143 */     if (shapeMBR == null) {
/*     */       return;
/*     */     }
/*     */     
/* 147 */     int col1 = Arrays.binarySearch(this.xSplits, shapeMBR.x1);
/* 148 */     if (col1 < 0)
/* 149 */       col1 = -col1 - 1; 
/* 150 */     int col2 = Arrays.binarySearch(this.xSplits, shapeMBR.x2);
/* 151 */     if (col2 < 0) {
/* 152 */       col2 = -col2 - 1;
/*     */     }
/* 154 */     for (int col = col1; col <= col2; col++) {
/*     */       
/* 156 */       int cell1 = Arrays.binarySearch(this.ySplits, col * this.rows, (col + 1) * this.rows, shapeMBR.y1);
/* 157 */       if (cell1 < 0)
/* 158 */         cell1 = -cell1 - 1; 
/* 159 */       int cell2 = Arrays.binarySearch(this.ySplits, col * this.rows, (col + 1) * this.rows, shapeMBR.y2);
/* 160 */       if (cell2 < 0) {
/* 161 */         cell2 = -cell2 - 1;
/*     */       }
/* 163 */       for (int cell = cell1; cell <= cell2; cell++) {
/* 164 */         matcher.collect(Integer.valueOf(cell));
/*     */       }
/*     */     } 
/*     */   }
/*     */   
/*     */   public int overlapPartition(Shape shape) {
/* 170 */     if (shape == null)
/* 171 */       return -1; 
/* 172 */     Rectangle shapeMBR = shape.getMBR();
/* 173 */     if (shapeMBR == null) {
/* 174 */       return -1;
/*     */     }
/* 176 */     Point center = shapeMBR.getCenterPoint();
/* 177 */     int col = Arrays.binarySearch(this.xSplits, center.x);
/* 178 */     if (col < 0)
/* 179 */       col = -col - 1; 
/* 180 */     int cell = Arrays.binarySearch(this.ySplits, col * this.rows, (col + 1) * this.rows, center.y);
/* 181 */     if (cell < 0)
/* 182 */       cell = -cell - 1; 
/* 183 */     return cell;
/*     */   }
/*     */ 
/*     */   
/*     */   public CellInfo getPartitionAt(int index) {
/* 188 */     return getPartition(index);
/*     */   }
/*     */ 
/*     */   
/*     */   public CellInfo getPartition(int id) {
/* 193 */     int col = id / this.rows;
/* 194 */     int row = id % this.rows;
/* 195 */     double y2 = this.ySplits[id];
/* 196 */     double y1 = (row == 0) ? this.mbr.y1 : this.ySplits[id - 1];
/* 197 */     double x2 = this.xSplits[col];
/* 198 */     double x1 = (col == 0) ? this.mbr.x1 : this.xSplits[col - 1];
/* 199 */     return new CellInfo(id, x1, y1, x2, y2);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void overlapPartitions1D(Shape1D shape, ResultCollector<Integer> matcher) {}
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int overlapPartition1D(Shape1D shape) {
/* 217 */     return 0;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartition1D(int partitionID) {
/* 224 */     return null;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartitionAt1D(int index) {
/* 233 */     return null;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void createFromPoints(Segment mbr, IPoint[] points, int capacity) throws IllegalArgumentException {
/* 242 */     Arrays.sort(points, new Comparator<IPoint>()
/*     */         {
/*     */           public int compare(IPoint a, IPoint b) {
/* 245 */             return (a.x < b.x) ? -1 : ((a.x > b.x) ? 1 : 0);
/*     */           }
/*     */         });
/* 248 */     int numSplits = (int)Math.ceil(points.length / capacity);
/* 249 */     SegmentInfo gridInfo = new SegmentInfo(mbr.x1, mbr.x2);
/* 250 */     gridInfo.calculateCellDimensions(numSplits);
/* 251 */     this.columns = gridInfo.columns;
/* 252 */     this.xSplits = new double[this.columns];
/* 253 */     this.ySplits = new double[1 * this.columns];
/* 254 */     int prev_quantile = 0;
/* 255 */     this.seg.set((Shape1D)mbr);
/* 256 */     for (int column = 0; column < this.columns; column++) {
/* 257 */       int col_quantile = (column + 1) * points.length / this.columns;
/*     */       
/* 259 */       this.xSplits[column] = (col_quantile == points.length) ? mbr.x2 : (points[col_quantile - 1]).x;
/*     */ 
/*     */ 
/*     */       
/* 263 */       for (int row = 0; row < 1; row++) {
/* 264 */         int row_quantile = (prev_quantile * (1 - row + 1) + 
/* 265 */           col_quantile * (row + 1)) / 1;
/*     */         
/* 267 */         this.ySplits[column * 1 + row] = row_quantile;
/*     */       } 
/*     */       
/* 270 */       prev_quantile = col_quantile;
/*     */     } 
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\STRPartitioner.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */