/*     */ package com.dlmu.wisdomST.indexing;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.CellInfo;
/*     */ import com.dlmu.wisdomST.core.CellInfo1D;
/*     */ import com.dlmu.wisdomST.core.IPoint;
/*     */ import com.dlmu.wisdomST.core.Point;
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import java.awt.Point;
/*     */ import java.awt.Rectangle;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataOutput;
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.util.Arrays;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class ZCurvePartitioner
/*     */   extends Partitioner
/*     */ {
/*  38 */   private static final Log LOG = LogFactory.getLog(ZCurvePartitioner.class);
/*     */ 
/*     */   
/*  41 */   protected final Rectangle mbr = new Rectangle();
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected long[] zSplits;
/*     */ 
/*     */ 
/*     */   
/*     */   protected static final int Resolution = 2147483647;
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void createFromPoints(Rectangle mbr, Point[] points, int capacity) {
/*  56 */     this.mbr.set((Shape)mbr);
/*  57 */     long[] zValues = new long[points.length];
/*  58 */     for (int i = 0; i < points.length; i++)
/*  59 */       zValues[i] = computeZ(mbr, (points[i]).x, (points[i]).y); 
/*  60 */     createFromZValues(zValues, capacity);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected void createFromZValues(long[] zValues, int capacity) {
/*  69 */     Arrays.sort(zValues);
/*  70 */     int numSplits = (int)Math.ceil(zValues.length / capacity);
/*  71 */     this.zSplits = new long[numSplits];
/*  72 */     long maxZ = computeZ(this.mbr, this.mbr.x2, this.mbr.y2);
/*  73 */     for (int i = 0; i < numSplits; i++) {
/*  74 */       int quantile = (int)((i + 1) * zValues.length / numSplits);
/*  75 */       this.zSplits[i] = (quantile == zValues.length) ? maxZ : zValues[quantile];
/*     */     } 
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static long computeZ(Rectangle mbr, double x, double y) {
/*  87 */     int ix = (int)((x - mbr.x1) * 2.147483647E9D / mbr.getWidth());
/*  88 */     int iy = (int)((y - mbr.y1) * 2.147483647E9D / mbr.getHeight());
/*  89 */     return computeZOrder(ix, iy);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static void uncomputeZ(Rectangle mbr, long z, Point outPoint) {
/*  99 */     long ixy = unComputeZOrder(z);
/* 100 */     int ix = (int)(ixy >> 32L);
/* 101 */     int iy = (int)(ixy & 0xFFFFFFFFL);
/* 102 */     outPoint.x = ix * mbr.getWidth() / 2.147483647E9D + mbr.x1;
/* 103 */     outPoint.y = iy * mbr.getHeight() / 2.147483647E9D + mbr.y1;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static long computeZOrder(long x, long y) {
/* 113 */     long morton = 0L;
/*     */     
/* 115 */     for (long bitPosition = 0L; bitPosition < 32L; bitPosition++) {
/* 116 */       long mask = 1L << (int)bitPosition;
/* 117 */       morton |= (x & mask) << (int)(bitPosition + 1L);
/* 118 */       morton |= (y & mask) << (int)bitPosition;
/*     */     } 
/* 120 */     return morton;
/*     */   }
/*     */   
/*     */   public static Point unComputeZOrder(long morton, Point point) {
/* 124 */     long ixy = unComputeZOrder(morton);
/* 125 */     point.x = (int)(ixy >>> 32L);
/* 126 */     point.y = (int)(ixy & 0xFFFFFFFFFFFFFFFFL);
/* 127 */     return point;
/*     */   }
/*     */   
/*     */   public static long unComputeZOrder(long morton) {
/* 131 */     long x = 0L, y = 0L;
/* 132 */     for (long bitPosition = 0L; bitPosition < 32L; bitPosition++) {
/* 133 */       long mask = 1L << (int)(bitPosition << 1L);
/* 134 */       y |= (morton & mask) >> (int)bitPosition;
/* 135 */       x |= (morton & mask << 1L) >> (int)(bitPosition + 1L);
/*     */     } 
/* 137 */     return x << 32L | y;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static Rectangle getMBRInteger(long zMin, long zMax) {
/*     */     long oldMask;
/* 149 */     zMax--;
/* 150 */     long changedBits = zMin ^ zMax;
/*     */ 
/*     */     
/* 153 */     long mask = changedBits;
/*     */     
/*     */     do {
/* 156 */       oldMask = mask;
/* 157 */       mask |= mask >> 1L;
/* 158 */     } while (mask != oldMask);
/*     */ 
/*     */     
/* 161 */     Point minXY = unComputeZOrder(zMin & (mask ^ 0xFFFFFFFFFFFFFFFFL), new Point());
/* 162 */     Point maxXY = unComputeZOrder(zMin | mask, new Point());
/* 163 */     Rectangle mbr = new Rectangle(minXY.x, minXY.y, maxXY.x - minXY.x, maxXY.y - minXY.y);
/* 164 */     return mbr;
/*     */   }
/*     */   
/*     */   public static Rectangle getMBR(Rectangle mbr, long zMin, long zMax) {
/* 168 */     Rectangle mbrInteger = getMBRInteger(zMin, zMax);
/* 169 */     Rectangle trueMBR = new Rectangle();
/* 170 */     trueMBR.x1 = mbrInteger.x * mbr.getWidth() / 2.147483647E9D + mbr.x1;
/* 171 */     trueMBR.y1 = mbrInteger.y * mbr.getHeight() / 2.147483647E9D + mbr.y1;
/* 172 */     trueMBR.x2 = mbrInteger.getMaxX() * mbr.getWidth() / 2.147483647E9D + mbr.x1;
/* 173 */     trueMBR.y2 = mbrInteger.getMaxY() * mbr.getHeight() / 2.147483647E9D + mbr.y1;
/* 174 */     return trueMBR;
/*     */   }
/*     */ 
/*     */   
/*     */   public void write(DataOutput out) throws IOException {
/* 179 */     this.mbr.write(out);
/* 180 */     out.writeInt(this.zSplits.length);
/* 181 */     ByteBuffer bbuffer = ByteBuffer.allocate(this.zSplits.length * 8); byte b; int i; long[] arrayOfLong;
/* 182 */     for (i = (arrayOfLong = this.zSplits).length, b = 0; b < i; ) { long zSplit = arrayOfLong[b];
/* 183 */       bbuffer.putLong(zSplit); b++; }
/* 184 */      if (bbuffer.hasRemaining())
/* 185 */       throw new RuntimeException("Did not calculate buffer size correctly"); 
/* 186 */     out.write(bbuffer.array(), bbuffer.arrayOffset(), bbuffer.position());
/*     */   }
/*     */ 
/*     */   
/*     */   public void readFields(DataInput in) throws IOException {
/* 191 */     this.mbr.readFields(in);
/* 192 */     int partitionCount = in.readInt();
/* 193 */     this.zSplits = new long[partitionCount];
/* 194 */     int bufferLength = 8 * partitionCount;
/* 195 */     byte[] buffer = new byte[bufferLength];
/* 196 */     in.readFully(buffer);
/* 197 */     ByteBuffer bbuffer = ByteBuffer.wrap(buffer);
/* 198 */     for (int i = 0; i < partitionCount; i++) {
/* 199 */       this.zSplits[i] = bbuffer.getLong();
/*     */     }
/* 201 */     if (bbuffer.hasRemaining()) {
/* 202 */       throw new RuntimeException("Error reading STR partitioner");
/*     */     }
/*     */   }
/*     */   
/*     */   public int getPartitionCount() {
/* 207 */     return this.zSplits.length;
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public void overlapPartitions(Shape shape, ResultCollector<Integer> matcher) {
/* 213 */     int partition = overlapPartition(shape);
/* 214 */     if (partition >= 0) {
/* 215 */       matcher.collect(Integer.valueOf(partition));
/*     */     }
/*     */   }
/*     */   
/*     */   public int overlapPartition(Shape shape) {
/* 220 */     if (shape == null)
/* 221 */       return -1; 
/* 222 */     Rectangle shapeMBR = shape.getMBR();
/* 223 */     if (shapeMBR == null) {
/* 224 */       return -1;
/*     */     }
/* 226 */     Point center = shapeMBR.getCenterPoint();
/* 227 */     long zValue = computeZ(this.mbr, center.x, center.y);
/* 228 */     int partition = Arrays.binarySearch(this.zSplits, zValue);
/* 229 */     if (partition < 0)
/* 230 */       partition = -partition - 1; 
/* 231 */     return partition;
/*     */   }
/*     */ 
/*     */   
/*     */   public CellInfo getPartitionAt(int index) {
/* 236 */     return getPartition(index);
/*     */   }
/*     */ 
/*     */   
/*     */   public CellInfo getPartition(int id) {
/* 241 */     CellInfo cell = new CellInfo();
/* 242 */     cell.cellId = id;
/* 243 */     long zMax = this.zSplits[id];
/* 244 */     long zMin = (id == 0) ? 0L : this.zSplits[id - 1];
/*     */     
/* 246 */     Rectangle cellMBR = getMBR(this.mbr, zMin, zMax);
/* 247 */     cell.set((Shape)cellMBR);
/* 248 */     return cell;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void overlapPartitions1D(Shape1D shape, ResultCollector<Integer> matcher) {}
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public int overlapPartition1D(Shape1D shape) {
/* 266 */     return 0;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartition1D(int partitionID) {
/* 279 */     return null;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public CellInfo1D getPartitionAt1D(int index) {
/* 288 */     return null;
/*     */   }
/*     */   
/*     */   public void createFromPoints(Segment mbr, IPoint[] points, int capacity) throws IllegalArgumentException {}
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\indexing\ZCurvePartitioner.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */