/*    */ package com.dlmu.wisdomST.operation;
/*    */ 
/*    */ import com.dlmu.wisdomST.core.ResultCollector;
/*    */ import com.dlmu.wisdomST.core.Shape;
/*    */ import com.dlmu.wisdomST.indexing.GlobalIndex;
/*    */ import com.dlmu.wisdomST.indexing.Partition;
/*    */ import com.dlmu.wisdomST.mapreduce.BlockFilter;
/*    */ import java.util.Vector;
/*    */ import org.apache.hadoop.conf.Configuration;
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ public class CombineBlockFilter
/*    */   extends DefaultBlockFilter
/*    */ {
/*    */   private BlockFilter[] blockFilters;
/*    */   
/*    */   public CombineBlockFilter(BlockFilter bf1, BlockFilter bf2) {
/* 34 */     this.blockFilters = new BlockFilter[] { bf1, bf2 };
/*    */   } public void configure(Configuration conf) {
/*    */     byte b;
/*    */     int i;
/*    */     BlockFilter[] arrayOfBlockFilter;
/* 39 */     for (i = (arrayOfBlockFilter = this.blockFilters).length, b = 0; b < i; ) { BlockFilter bf = arrayOfBlockFilter[b];
/* 40 */       bf.configure(conf);
/*    */       b++; }
/*    */   
/*    */   }
/*    */   
/*    */   public void selectCells(GlobalIndex<Partition> gIndex, ResultCollector<Partition> output) {
/* 46 */     final Vector<Partition> selectedSoFar = new Vector<Partition>();
/*    */     
/* 48 */     this.blockFilters[0].selectCells(gIndex, new ResultCollector<Partition>()
/*    */         {
/*    */           public void collect(Partition p) {
/* 51 */             selectedSoFar.add(p);
/*    */           }
/*    */         });
/*    */     
/* 55 */     for (int i = 1; !selectedSoFar.isEmpty() && i < this.blockFilters.length; i++) {
/* 56 */       BlockFilter bf = this.blockFilters[i];
/* 57 */       gIndex = new GlobalIndex();
/* 58 */       gIndex.bulkLoad((Shape[])selectedSoFar.<Partition>toArray(new Partition[selectedSoFar.size()]));
/* 59 */       bf.selectCells(gIndex, new ResultCollector<Partition>()
/*    */           {
/*    */             public void collect(Partition p) {
/* 62 */               selectedSoFar.add(p);
/*    */             }
/*    */           });
/*    */     } 
/*    */     
/* 67 */     for (Partition p : selectedSoFar)
/* 68 */       output.collect(p); 
/*    */   }
/*    */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\CombineBlockFilter.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */