/*     */ package com.dlmu.wisdomST.operation;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.core.SpatialSite;
/*     */ import com.dlmu.wisdomST.indexing.GlobalIndex;
/*     */ import com.dlmu.wisdomST.indexing.Partition;
/*     */ import com.dlmu.wisdomST.io.Text2;
/*     */ import com.dlmu.wisdomST.mapreduce.RTreeRecordReader3;
/*     */ import com.dlmu.wisdomST.mapreduce.ShapeInputFormat;
/*     */ import com.dlmu.wisdomST.mapreduce.ShapeLineInputFormat;
/*     */ import com.dlmu.wisdomST.mapreduce.ShapeRecordReader;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialInputFormat;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialInputFormat3;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialRecordReader3;
/*     */ import com.dlmu.wisdomST.mapreduce.TextOutputFormat;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import com.dlmu.wisdomST.util.Parallel;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.FileStatus;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.io.NullWritable;
/*     */ import org.apache.hadoop.io.Text;
/*     */ import org.apache.hadoop.mapred.ClusterStatus;
/*     */ import org.apache.hadoop.mapred.Counters;
/*     */ import org.apache.hadoop.mapred.FileOutputCommitter;
/*     */ import org.apache.hadoop.mapred.FileSplit;
/*     */ import org.apache.hadoop.mapred.InputSplit;
/*     */ import org.apache.hadoop.mapred.JobClient;
/*     */ import org.apache.hadoop.mapred.JobConf;
/*     */ import org.apache.hadoop.mapred.JobContext;
/*     */ import org.apache.hadoop.mapred.MapReduceBase;
/*     */ import org.apache.hadoop.mapred.Mapper;
/*     */ import org.apache.hadoop.mapred.OutputCollector;
/*     */ import org.apache.hadoop.mapred.Reducer;
/*     */ import org.apache.hadoop.mapred.Reporter;
/*     */ import org.apache.hadoop.mapred.RunningJob;
/*     */ import org.apache.hadoop.mapred.Task;
/*     */ import org.apache.hadoop.mapreduce.InputSplit;
/*     */ import org.apache.hadoop.mapreduce.Job;
/*     */ import org.apache.hadoop.mapreduce.JobContext;
/*     */ import org.apache.hadoop.mapreduce.RecordReader;
/*     */ import org.apache.hadoop.mapreduce.lib.input.FileSplit;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ import org.apache.hadoop.util.LineReader;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class FileMBR
/*     */ {
/*  73 */   private static final Log LOG = LogFactory.getLog(FileMBR.class);
/*     */   
/*     */   public static long sizeOfLastProcessedFile;
/*     */   
/*     */   public static RunningJob lastSubmittedJob;
/*     */   
/*     */   public static class FileMBRMapper
/*     */     extends MapReduceBase
/*     */     implements Mapper<Rectangle, Text, Text, Partition>
/*     */   {
/*     */     private InputSplit lastSplit;
/*     */     private Text fileName;
/*     */     private Partition value;
/*     */     private Shape shape;
/*     */     
/*     */     public FileMBRMapper() {
/*  89 */       this.lastSplit = null;
/*     */     }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */     
/*     */     public void configure(JobConf job) {
/* 102 */       super.configure(job);
/* 103 */       this.value = new Partition();
/* 104 */       this.value.recordCount = 1L;
/* 105 */       this.shape = OperationsParams.getShape((Configuration)job, "shape");
/*     */     }
/*     */ 
/*     */ 
/*     */     
/*     */     public void map(Rectangle dummy, Text text, OutputCollector<Text, Partition> output, Reporter reporter) throws IOException {
/* 111 */       if (this.lastSplit != reporter.getInputSplit()) {
/* 112 */         this.lastSplit = reporter.getInputSplit();
/* 113 */         this.value.filename = ((FileSplit)this.lastSplit).getPath().getName();
/* 114 */         this.fileName = new Text(this.value.filename);
/*     */       } 
/*     */       
/* 117 */       this.value.size = (text.getLength() + 1);
/*     */       
/* 119 */       this.shape.fromText(text);
/* 120 */       Rectangle mbr = this.shape.getMBR();
/*     */       
/* 122 */       if (mbr != null) {
/*     */         
/* 124 */         this.value.set((Shape)mbr);
/* 125 */         output.collect(this.fileName, this.value);
/*     */       } 
/*     */     }
/*     */   }
/*     */ 
/*     */   
/*     */   public static class Combine
/*     */     extends MapReduceBase
/*     */     implements Reducer<Text, Partition, Text, Partition>
/*     */   {
/*     */     public void reduce(Text filename, Iterator<Partition> values, OutputCollector<Text, Partition> output, Reporter reporter) throws IOException {
/* 136 */       if (values.hasNext()) {
/* 137 */         Partition partition = ((Partition)values.next()).clone();
/* 138 */         while (values.hasNext()) {
/* 139 */           partition.expand(values.next());
/*     */         }
/* 141 */         output.collect(filename, partition);
/*     */       } 
/*     */     }
/*     */   }
/*     */ 
/*     */   
/*     */   public static class Reduce
/*     */     extends MapReduceBase
/*     */     implements Reducer<Text, Partition, NullWritable, Partition>
/*     */   {
/*     */     public void reduce(Text filename, Iterator<Partition> values, OutputCollector<NullWritable, Partition> output, Reporter reporter) throws IOException {
/* 152 */       if (values.hasNext()) {
/* 153 */         Partition partition = ((Partition)values.next()).clone();
/* 154 */         while (values.hasNext()) {
/* 155 */           partition.expand(values.next());
/*     */         }
/* 157 */         partition.cellId = Math.abs(filename.hashCode());
/* 158 */         output.collect(NullWritable.get(), partition);
/*     */       } 
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static class MBROutputCommitter
/*     */     extends FileOutputCommitter
/*     */   {
/*     */     public void commitJob(JobContext context) throws IOException {
/*     */       try {
/* 176 */         super.commitJob(context);
/*     */         
/* 178 */         JobConf job = context.getJobConf();
/*     */         
/* 180 */         Path[] inPaths = SpatialInputFormat.getInputPaths(job);
/* 181 */         Path inPath = inPaths[0];
/* 182 */         FileSystem inFs = inPath.getFileSystem((Configuration)job);
/* 183 */         if (!inFs.getFileStatus(inPath).isDir())
/*     */           return; 
/* 185 */         Path gindex_path = new Path(inPath, "_master.heap");
/*     */         
/* 187 */         if (inFs.exists(gindex_path))
/*     */           return; 
/* 189 */         PrintStream gout = new PrintStream((OutputStream)inFs.create(gindex_path, false));
/*     */ 
/*     */         
/* 192 */         Path outPath = TextOutputFormat.getOutputPath(job);
/* 193 */         FileSystem outFs = outPath.getFileSystem((Configuration)job);
/* 194 */         FileStatus[] results = outFs.listStatus(outPath); byte b; int i; FileStatus[] arrayOfFileStatus1;
/* 195 */         for (i = (arrayOfFileStatus1 = results).length, b = 0; b < i; ) { FileStatus fileStatus = arrayOfFileStatus1[b];
/* 196 */           if (fileStatus.getLen() > 0L && fileStatus.getPath().getName().startsWith("part-")) {
/* 197 */             LineReader lineReader = new LineReader((InputStream)outFs.open(fileStatus.getPath()));
/* 198 */             Text text = new Text();
/* 199 */             while (lineReader.readLine(text) > 0) {
/* 200 */               gout.println(text);
/*     */             }
/* 202 */             lineReader.close();
/*     */           }  b++; }
/*     */         
/* 205 */         gout.close();
/* 206 */       } catch (RuntimeException e) {
/*     */         
/* 208 */         LOG.info("Error caching the output of FileMBR");
/*     */       } 
/*     */     }
/*     */   }
/*     */ 
/*     */   
/*     */   public static Partition fileMBRLocal(Path[] inFiles, final OperationsParams params) throws IOException, InterruptedException {
/* 215 */     System.out.println("FileMBR---fileMBRLocal");
/*     */     
/* 217 */     final SpatialInputFormat3<Rectangle, Shape> inputFormat = 
/* 218 */       new SpatialInputFormat3();
/* 219 */     Job job = Job.getInstance((Configuration)params);
/* 220 */     SpatialInputFormat3.setInputPaths(job, inFiles);
/* 221 */     final List<InputSplit> splits = inputFormat.getSplits((JobContext)job);
/* 222 */     int parallelism = params.getInt("parallel", Runtime.getRuntime().availableProcessors());
/*     */ 
/*     */     
/* 225 */     List<Map<String, Partition>> allMbrs = Parallel.forEach(splits.size(), new Parallel.RunnableRange<Map<String, Partition>>()
/*     */         {
/*     */           public Map<String, Partition> run(int i1, int i2)
/*     */           {
/* 229 */             Map<String, Partition> mbrs = new HashMap<String, Partition>();
/* 230 */             for (int i = i1; i < i2; i++) {
/*     */               try {
/* 232 */                 FileSplit fsplit = splits.get(i);
/*     */                 
/* 234 */                 RecordReader<Rectangle, Iterable<Shape>> reader = 
/* 235 */                   inputFormat.createRecordReader((InputSplit)fsplit, null);
/* 236 */                 if (reader instanceof SpatialRecordReader3) {
/* 237 */                   ((SpatialRecordReader3)reader).initialize((InputSplit)fsplit, (Configuration)params);
/* 238 */                 } else if (reader instanceof RTreeRecordReader3) {
/* 239 */                   ((RTreeRecordReader3)reader).initialize((InputSplit)fsplit, (Configuration)params);
/*     */                 } else {
/* 241 */                   throw new RuntimeException("Unknown record reader");
/*     */                 } 
/* 243 */                 Partition p = mbrs.get(fsplit.getPath().getName());
/* 244 */                 if (p == null) {
/* 245 */                   p = new Partition();
/* 246 */                   p.filename = fsplit.getPath().getName();
/* 247 */                   p.cellId = p.filename.hashCode();
/* 248 */                   p.size = 0L;
/* 249 */                   p.recordCount = 0L;
/* 250 */                   p.set(Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308D, -1.7976931348623157E308D);
/* 251 */                   mbrs.put(p.filename, p);
/*     */                 } 
/* 253 */                 Text2 text2 = new Text2();
/* 254 */                 while (reader.nextKeyValue()) {
/* 255 */                   Iterable<Shape> shapes = (Iterable<Shape>)reader.getCurrentValue();
/*     */                   
/* 257 */                   int count = 0;
/* 258 */                   for (Shape s : shapes) {
/* 259 */                     count++;
/* 260 */                     Rectangle mbr = s.getMBR();
/*     */                     
/* 262 */                     if (mbr != null)
/* 263 */                       p.expand((Shape)mbr); 
/* 264 */                     p.recordCount++;
/* 265 */                     text2.clear();
/* 266 */                     s.toText((Text)text2);
/* 267 */                     p.size += (text2.getLength() + 1);
/*     */                   }
/*     */                 
/*     */                 } 
/* 271 */               } catch (IOException e) {
/* 272 */                 throw new RuntimeException(e);
/* 273 */               } catch (InterruptedException e) {
/* 274 */                 throw new RuntimeException(e);
/*     */               } 
/*     */             } 
/* 277 */             return mbrs;
/*     */           }
/* 279 */         }parallelism);
/* 280 */     Map<String, Partition> mbrs = allMbrs.remove(allMbrs.size() - 1);
/* 281 */     for (Map<String, Partition> list : allMbrs) {
/* 282 */       for (Partition p1 : list.values()) {
/* 283 */         Partition p2 = mbrs.get(p1.filename);
/* 284 */         if (p2 != null) {
/* 285 */           p2.expand(p1); continue;
/*     */         } 
/* 287 */         mbrs.put(p1.filename, p1);
/*     */       } 
/*     */     } 
/*     */     byte b;
/*     */     int i;
/*     */     Path[] arrayOfPath;
/* 293 */     for (i = (arrayOfPath = inFiles).length, b = 0; b < i; ) { Path inFile = arrayOfPath[b];
/* 294 */       FileSystem inFs = inFile.getFileSystem((Configuration)params);
/* 295 */       if (inFs.getFileStatus(inFile).isDir()) {
/*     */         
/* 297 */         Path gindex_path = new Path(inFile, "_master.heap");
/*     */         
/* 299 */         if (!inFs.exists(gindex_path)) {
/*     */           
/* 301 */           FileStatus[] files = inFs.listStatus(inFile, SpatialSite.NonHiddenFileFilter);
/* 302 */           PrintStream wktout = new PrintStream((OutputStream)inFs.create(new Path(inFile, "_heap.wkt"), false));
/* 303 */           PrintStream gout = new PrintStream((OutputStream)inFs.create(gindex_path, false));
/*     */           
/* 305 */           Text2 text2 = new Text2(); byte b1; int j; FileStatus[] arrayOfFileStatus1;
/* 306 */           for (j = (arrayOfFileStatus1 = files).length, b1 = 0; b1 < j; ) { FileStatus file = arrayOfFileStatus1[b1];
/* 307 */             text2.clear();
/* 308 */             Partition p = mbrs.get(file.getPath().getName());
/* 309 */             gout.println(p.toText((Text)text2).toString());
/* 310 */             wktout.println(p.toWKT());
/*     */             b1++; }
/*     */           
/* 313 */           wktout.close();
/* 314 */           gout.close();
/*     */         } 
/*     */       }  b++; }
/*     */     
/* 318 */     Partition finalResult = new Partition();
/* 319 */     finalResult.size = finalResult.recordCount = 0L;
/* 320 */     finalResult.x1 = finalResult.y1 = Double.MAX_VALUE;
/* 321 */     finalResult.x2 = finalResult.y2 = -1.7976931348623157E308D;
/* 322 */     Iterator iterator = mbrs.values().iterator();
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static <S extends Shape> Partition fileMBRMapReduce(Path[] inFiles, OperationsParams params) throws IOException, InterruptedException {
/*     */     Path outputPath;
/* 338 */     System.out.println("FileMBR---fileMBRMapReduce");
/* 339 */     JobConf job = new JobConf((Configuration)params, FileMBR.class);
/*     */ 
/*     */     
/* 342 */     FileSystem outFs = FileSystem.get((Configuration)job);
/*     */     do {
/* 344 */       outputPath = new Path(String.valueOf(inFiles[0].getName()) + ".mbr_" + (int)(Math.random() * 1000000.0D));
/* 345 */     } while (outFs.exists(outputPath));
/*     */     
/* 347 */     job.setJobName("FileMBR");
/* 348 */     job.setMapOutputKeyClass(Text.class);
/* 349 */     job.setMapOutputValueClass(Partition.class);
/*     */     
/* 351 */     job.setMapperClass(FileMBRMapper.class);
/* 352 */     job.setReducerClass(Reduce.class);
/* 353 */     job.setCombinerClass(Combine.class);
/* 354 */     ClusterStatus clusterStatus = (new JobClient(job)).getClusterStatus();
/* 355 */     job.setNumMapTasks(clusterStatus.getMaxMapTasks() * 5);
/*     */     
/* 357 */     job.setInputFormat(ShapeLineInputFormat.class);
/* 358 */     job.setOutputFormat(TextOutputFormat.class);
/*     */     
/* 360 */     ShapeInputFormat.setInputPaths(job, inFiles);
/* 361 */     TextOutputFormat.setOutputPath(job, outputPath);
/* 362 */     job.setOutputCommitter(MBROutputCommitter.class);
/*     */ 
/*     */     
/* 365 */     if (OperationsParams.isLocal((Configuration)job, inFiles)) {
/*     */       
/* 367 */       job.set("mapred.job.tracker", "local");
/*     */       
/* 369 */       job.setInt("mapreduce.local.map.tasks.maximum", Runtime.getRuntime().availableProcessors());
/*     */     } 
/*     */     
/* 372 */     if (params.getBoolean("background", false)) {
/* 373 */       JobClient jc = new JobClient(job);
/* 374 */       lastSubmittedJob = jc.submitJob(job);
/* 375 */       return null;
/*     */     } 
/* 377 */     lastSubmittedJob = JobClient.runJob(job);
/* 378 */     Counters counters = lastSubmittedJob.getCounters();
/* 379 */     Counters.Counter outputSizeCounter = (Counters.Counter)counters.findCounter((Enum)Task.Counter.MAP_INPUT_BYTES);
/* 380 */     sizeOfLastProcessedFile = outputSizeCounter.getCounter();
/*     */     
/* 382 */     FileStatus[] outFiles = outFs.listStatus(outputPath, 
/* 383 */         SpatialSite.NonHiddenFileFilter);
/* 384 */     Partition mbr = new Partition();
/* 385 */     mbr.set(Double.MAX_VALUE, Double.MAX_VALUE, 
/* 386 */         -1.7976931348623157E308D, -1.7976931348623157E308D);
/* 387 */     OperationsParams localMBRParams = new OperationsParams(params);
/* 388 */     localMBRParams.setBoolean("local", true);
/* 389 */     localMBRParams.setClass("shape", Partition.class, Shape.class); byte b; int i; FileStatus[] arrayOfFileStatus1;
/* 390 */     for (i = (arrayOfFileStatus1 = outFiles).length, b = 0; b < i; ) { FileStatus outFile = arrayOfFileStatus1[b];
/* 391 */       if (!outFile.isDir()) {
/*     */         
/* 393 */         ShapeRecordReader<Partition> reader = new ShapeRecordReader(
/* 394 */             (Configuration)localMBRParams, new FileSplit(outFile.getPath(), 0L, outFile.getLen(), new String[0]));
/* 395 */         Rectangle key = reader.createKey();
/* 396 */         Partition p = (Partition)reader.createValue();
/* 397 */         while (reader.next(key, (Shape)p)) {
/* 398 */           mbr.expand(p);
/*     */         }
/* 400 */         reader.close();
/*     */       }  b++; }
/*     */     
/* 403 */     outFs.delete(outputPath, true);
/* 404 */     return mbr;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static Partition fileMBRCached(Path[] files, OperationsParams params) throws IOException {
/* 415 */     Partition p = new Partition(); byte b; int i; Path[] arrayOfPath;
/* 416 */     for (i = (arrayOfPath = files).length, b = 0; b < i; ) { Path file = arrayOfPath[b];
/* 417 */       FileSystem inFs = file.getFileSystem((Configuration)params);
/*     */       
/* 419 */       GlobalIndex<Partition> globalIndex = SpatialSite.getGlobalIndex(inFs, file);
/* 420 */       if (globalIndex == null)
/* 421 */         return null; 
/* 422 */       p.set(Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308D, -1.7976931348623157E308D);
/* 423 */       for (Partition part : globalIndex) {
/* 424 */         p.expand(part);
/*     */       }
/* 426 */       sizeOfLastProcessedFile = p.size; b++; }
/*     */     
/* 428 */     return p;
/*     */   }
/*     */   
/*     */   public static Partition fileMBR(Path file, OperationsParams params) throws IOException, InterruptedException {
/* 432 */     return fileMBR(new Path[] { file }, params);
/*     */   }
/*     */   
/*     */   public static Partition fileMBR(Path[] files, OperationsParams params) throws IOException, InterruptedException {
/* 436 */     Partition cachedMBR = fileMBRCached(files, params);
/* 437 */     if (cachedMBR != null)
/* 438 */       return cachedMBR; 
/* 439 */     if (!params.autoDetectShape()) {
/* 440 */       LOG.error("shape of input files is not set and cannot be auto detected");
/* 441 */       return null;
/*     */     } 
/*     */ 
/*     */     
/* 445 */     if (OperationsParams.isLocal((Configuration)params, files)) {
/* 446 */       return fileMBRLocal(files, params);
/*     */     }
/* 448 */     return fileMBRMapReduce(files, params);
/*     */   }
/*     */ 
/*     */   
/*     */   private static void printUsage() {
/* 453 */     System.out.println("Finds the MBR of an input file");
/* 454 */     System.out.println("Parameters: (* marks required parameters)");
/* 455 */     System.out.println("<input file>: (*) Path to input file");
/* 456 */     System.out.println("shape:<input shape>: (*) Input file format");
/* 457 */     GenericOptionsParser.printGenericCommandUsage(System.out);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static void main(String[] args) throws IOException, InterruptedException {
/* 466 */     OperationsParams params = new OperationsParams(new GenericOptionsParser(args));
/* 467 */     if (!params.checkInput()) {
/* 468 */       printUsage();
/* 469 */       System.exit(1);
/*     */     } 
/* 471 */     Path[] inputFiles = params.getInputPaths();
/*     */     
/* 473 */     if (params.getShape("shape") == null) {
/* 474 */       LOG.error("Input file format not specified");
/* 475 */       printUsage();
/*     */       return;
/*     */     } 
/* 478 */     long t1 = System.currentTimeMillis();
/* 479 */     Partition partition = fileMBR(inputFiles, params);
/* 480 */     long t2 = System.currentTimeMillis();
/* 481 */     if (partition == null) {
/* 482 */       LOG.error("Error computing the MBR");
/* 483 */       System.exit(1);
/*     */     } 
/*     */     
/* 486 */     System.out.println("Total processing time: " + (t2 - t1) + " millis");
/* 487 */     System.out.println("MBR of records in file '" + inputFiles + "' is " + partition);
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\FileMBR.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */