/*     */ package com.dlmu.wisdomST.operation;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import com.dlmu.wisdomST.core.SpatialSite;
/*     */ import com.dlmu.wisdomST.indexing.GlobalIndex1D;
/*     */ import com.dlmu.wisdomST.indexing.Partition1D;
/*     */ import com.dlmu.wisdomST.io.Text2;
/*     */ import com.dlmu.wisdomST.mapreduce.ShapeInputFormat;
/*     */ import com.dlmu.wisdomST.mapreduce.ShapeLineInputFormat1D;
/*     */ import com.dlmu.wisdomST.mapreduce.ShapeRecordReader1D;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialInputFormat1D;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialInputFormat31D;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialRecordReader31D;
/*     */ import com.dlmu.wisdomST.mapreduce.TextOutputFormat;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import com.dlmu.wisdomST.util.Parallel;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.FileStatus;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.io.NullWritable;
/*     */ import org.apache.hadoop.io.Text;
/*     */ import org.apache.hadoop.mapred.ClusterStatus;
/*     */ import org.apache.hadoop.mapred.Counters;
/*     */ import org.apache.hadoop.mapred.FileOutputCommitter;
/*     */ import org.apache.hadoop.mapred.FileSplit;
/*     */ import org.apache.hadoop.mapred.InputSplit;
/*     */ import org.apache.hadoop.mapred.JobClient;
/*     */ import org.apache.hadoop.mapred.JobConf;
/*     */ import org.apache.hadoop.mapred.JobContext;
/*     */ import org.apache.hadoop.mapred.MapReduceBase;
/*     */ import org.apache.hadoop.mapred.Mapper;
/*     */ import org.apache.hadoop.mapred.OutputCollector;
/*     */ import org.apache.hadoop.mapred.Reducer;
/*     */ import org.apache.hadoop.mapred.Reporter;
/*     */ import org.apache.hadoop.mapred.RunningJob;
/*     */ import org.apache.hadoop.mapred.Task;
/*     */ import org.apache.hadoop.mapreduce.InputSplit;
/*     */ import org.apache.hadoop.mapreduce.Job;
/*     */ import org.apache.hadoop.mapreduce.JobContext;
/*     */ import org.apache.hadoop.mapreduce.RecordReader;
/*     */ import org.apache.hadoop.mapreduce.lib.input.FileSplit;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ import org.apache.hadoop.util.LineReader;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class FileMBR1D
/*     */ {
/*  76 */   private static final Log LOG = LogFactory.getLog(FileMBR1D.class);
/*     */   
/*     */   public static long sizeOfLastProcessedFile;
/*     */   
/*     */   public static RunningJob lastSubmittedJob;
/*     */   
/*     */   public static class FileMBRMapper
/*     */     extends MapReduceBase
/*     */     implements Mapper<Segment, Text, Text, Partition1D>
/*     */   {
/*     */     private InputSplit lastSplit;
/*     */     private Text fileName;
/*     */     private Partition1D value;
/*     */     private Shape1D shape;
/*     */     
/*     */     public FileMBRMapper() {
/*  92 */       this.lastSplit = null;
/*     */     }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */     
/*     */     public void configure(JobConf job) {
/* 105 */       super.configure(job);
/* 106 */       this.value = new Partition1D();
/* 107 */       this.value.recordCount = 1L;
/* 108 */       this.shape = OperationsParams.getShape1D((Configuration)job, "shape");
/*     */     }
/*     */ 
/*     */ 
/*     */     
/*     */     public void map(Segment dummy, Text text, OutputCollector<Text, Partition1D> output, Reporter reporter) throws IOException {
/* 114 */       if (this.lastSplit != reporter.getInputSplit()) {
/* 115 */         this.lastSplit = reporter.getInputSplit();
/* 116 */         this.value.filename = ((FileSplit)this.lastSplit).getPath().getName();
/* 117 */         this.fileName = new Text(this.value.filename);
/*     */       } 
/*     */       
/* 120 */       this.value.size = (text.getLength() + 1);
/*     */       
/* 122 */       this.shape.fromText(text);
/* 123 */       Segment mbr = this.shape.getSegment();
/*     */       
/* 125 */       if (mbr != null) {
/*     */         
/* 127 */         this.value.set((Shape1D)mbr);
/* 128 */         output.collect(this.fileName, this.value);
/*     */       } 
/*     */     }
/*     */   }
/*     */ 
/*     */   
/*     */   public static class Combine
/*     */     extends MapReduceBase
/*     */     implements Reducer<Text, Partition1D, Text, Partition1D>
/*     */   {
/*     */     public void reduce(Text filename, Iterator<Partition1D> values, OutputCollector<Text, Partition1D> output, Reporter reporter) throws IOException {
/* 139 */       if (values.hasNext()) {
/* 140 */         Partition1D partition = ((Partition1D)values.next()).clone();
/* 141 */         while (values.hasNext()) {
/* 142 */           partition.expand(values.next());
/*     */         }
/* 144 */         output.collect(filename, partition);
/*     */       } 
/*     */     }
/*     */   }
/*     */ 
/*     */   
/*     */   public static class Reduce
/*     */     extends MapReduceBase
/*     */     implements Reducer<Text, Partition1D, NullWritable, Partition1D>
/*     */   {
/*     */     public void reduce(Text filename, Iterator<Partition1D> values, OutputCollector<NullWritable, Partition1D> output, Reporter reporter) throws IOException {
/* 155 */       if (values.hasNext()) {
/* 156 */         Partition1D partition = ((Partition1D)values.next()).clone();
/* 157 */         while (values.hasNext()) {
/* 158 */           partition.expand(values.next());
/*     */         }
/* 160 */         partition.cellId = Math.abs(filename.hashCode());
/* 161 */         output.collect(NullWritable.get(), partition);
/*     */       } 
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static class MBROutputCommitter
/*     */     extends FileOutputCommitter
/*     */   {
/*     */     public void commitJob(JobContext context) throws IOException {
/*     */       try {
/* 179 */         super.commitJob(context);
/*     */         
/* 181 */         JobConf job = context.getJobConf();
/*     */         
/* 183 */         Path[] inPaths = SpatialInputFormat1D.getInputPaths(job);
/* 184 */         Path inPath = inPaths[0];
/* 185 */         FileSystem inFs = inPath.getFileSystem((Configuration)job);
/* 186 */         if (!inFs.getFileStatus(inPath).isDir())
/*     */           return; 
/* 188 */         Path gindex_path = new Path(inPath, "_master.heap");
/*     */         
/* 190 */         if (inFs.exists(gindex_path))
/*     */           return; 
/* 192 */         PrintStream gout = new PrintStream((OutputStream)inFs.create(gindex_path, false));
/*     */ 
/*     */         
/* 195 */         Path outPath = TextOutputFormat.getOutputPath(job);
/* 196 */         FileSystem outFs = outPath.getFileSystem((Configuration)job);
/* 197 */         FileStatus[] results = outFs.listStatus(outPath); byte b; int i; FileStatus[] arrayOfFileStatus1;
/* 198 */         for (i = (arrayOfFileStatus1 = results).length, b = 0; b < i; ) { FileStatus fileStatus = arrayOfFileStatus1[b];
/* 199 */           if (fileStatus.getLen() > 0L && fileStatus.getPath().getName().startsWith("part-")) {
/* 200 */             LineReader lineReader = new LineReader((InputStream)outFs.open(fileStatus.getPath()));
/* 201 */             Text text = new Text();
/* 202 */             while (lineReader.readLine(text) > 0) {
/* 203 */               gout.println(text);
/*     */             }
/* 205 */             lineReader.close();
/*     */           }  b++; }
/*     */         
/* 208 */         gout.close();
/* 209 */       } catch (RuntimeException e) {
/*     */         
/* 211 */         LOG.info("Error caching the output of FileMBR");
/*     */       } 
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static Partition1D fileMBRLocal(Path[] inFiles, final OperationsParams params) throws IOException, InterruptedException {
/* 220 */     final SpatialInputFormat31D<Segment, Shape1D> inputFormat = 
/* 221 */       new SpatialInputFormat31D();
/* 222 */     Job job = Job.getInstance((Configuration)params);
/* 223 */     SpatialInputFormat31D.setInputPaths(job, inFiles);
/* 224 */     final List<InputSplit> splits = inputFormat.getSplits((JobContext)job);
/* 225 */     int parallelism = params.getInt("parallel", Runtime.getRuntime().availableProcessors());
/*     */ 
/*     */     
/* 228 */     List<Map<String, Partition1D>> allMbrs = Parallel.forEach(splits.size(), new Parallel.RunnableRange<Map<String, Partition1D>>()
/*     */         {
/*     */           public Map<String, Partition1D> run(int i1, int i2)
/*     */           {
/* 232 */             Map<String, Partition1D> mbrs = new HashMap<String, Partition1D>();
/* 233 */             for (int i = i1; i < i2; i++) {
/*     */               try {
/* 235 */                 FileSplit fsplit = splits.get(i);
/*     */                 
/* 237 */                 RecordReader<Segment, Iterable<Shape1D>> reader = 
/* 238 */                   inputFormat.createRecordReader((InputSplit)fsplit, null);
/* 239 */                 if (reader instanceof SpatialRecordReader31D) {
/* 240 */                   ((SpatialRecordReader31D)reader).initialize((InputSplit)fsplit, (Configuration)params);
/*     */                 } else {
/* 242 */                   throw new RuntimeException("Unknown record reader");
/*     */                 } 
/* 244 */                 Partition1D p = mbrs.get(fsplit.getPath().getName());
/* 245 */                 if (p == null) {
/* 246 */                   p = new Partition1D();
/* 247 */                   p.filename = fsplit.getPath().getName();
/* 248 */                   p.cellId = p.filename.hashCode();
/* 249 */                   p.size = 0L;
/* 250 */                   p.recordCount = 0L;
/* 251 */                   p.set(Double.MAX_VALUE, -1.7976931348623157E308D);
/* 252 */                   mbrs.put(p.filename, p);
/*     */                 } 
/* 254 */                 Text2 text2 = new Text2();
/* 255 */                 while (reader.nextKeyValue()) {
/* 256 */                   Iterable<Shape1D> shapes = (Iterable<Shape1D>)reader.getCurrentValue();
/*     */                   
/* 258 */                   int count = 0;
/* 259 */                   for (Shape1D s : shapes) {
/* 260 */                     count++;
/* 261 */                     Segment mbr = s.getSegment();
/*     */                     
/* 263 */                     if (mbr != null)
/* 264 */                       p.expand((Shape1D)mbr); 
/* 265 */                     p.recordCount++;
/* 266 */                     text2.clear();
/* 267 */                     s.toText((Text)text2);
/* 268 */                     p.size += (text2.getLength() + 1);
/*     */                   }
/*     */                 
/*     */                 } 
/* 272 */               } catch (IOException e) {
/* 273 */                 throw new RuntimeException(e);
/* 274 */               } catch (InterruptedException e) {
/* 275 */                 throw new RuntimeException(e);
/*     */               } 
/*     */             } 
/* 278 */             return mbrs;
/*     */           }
/* 280 */         }parallelism);
/* 281 */     Map<String, Partition1D> mbrs = allMbrs.remove(allMbrs.size() - 1);
/* 282 */     for (Map<String, Partition1D> list : allMbrs) {
/* 283 */       for (Partition1D p1 : list.values()) {
/* 284 */         Partition1D p2 = mbrs.get(p1.filename);
/* 285 */         if (p2 != null) {
/* 286 */           p2.expand(p1); continue;
/*     */         } 
/* 288 */         mbrs.put(p1.filename, p1);
/*     */       } 
/*     */     } 
/*     */     byte b;
/*     */     int i;
/*     */     Path[] arrayOfPath;
/* 294 */     for (i = (arrayOfPath = inFiles).length, b = 0; b < i; ) { Path inFile = arrayOfPath[b];
/* 295 */       FileSystem inFs = inFile.getFileSystem((Configuration)params);
/* 296 */       if (inFs.getFileStatus(inFile).isDir()) {
/*     */         
/* 298 */         Path gindex_path = new Path(inFile, "_master.heap");
/*     */         
/* 300 */         if (!inFs.exists(gindex_path)) {
/*     */           
/* 302 */           FileStatus[] files = inFs.listStatus(inFile, SpatialSite.NonHiddenFileFilter);
/* 303 */           PrintStream wktout = new PrintStream((OutputStream)inFs.create(new Path(inFile, "_heap.wkt"), false));
/* 304 */           PrintStream gout = new PrintStream((OutputStream)inFs.create(gindex_path, false));
/*     */           
/* 306 */           Text2 text2 = new Text2(); byte b1; int j; FileStatus[] arrayOfFileStatus1;
/* 307 */           for (j = (arrayOfFileStatus1 = files).length, b1 = 0; b1 < j; ) { FileStatus file = arrayOfFileStatus1[b1];
/* 308 */             text2.clear();
/* 309 */             Partition1D p = mbrs.get(file.getPath().getName());
/* 310 */             gout.println(p.toText((Text)text2).toString());
/* 311 */             wktout.println(p.toWKT());
/*     */             b1++; }
/*     */           
/* 314 */           wktout.close();
/* 315 */           gout.close();
/*     */         } 
/*     */       }  b++; }
/*     */     
/* 319 */     Partition1D finalResult = new Partition1D();
/* 320 */     finalResult.size = finalResult.recordCount = 0L;
/* 321 */     finalResult.x1 = Double.MAX_VALUE;
/* 322 */     finalResult.x2 = -1.7976931348623157E308D;
/* 323 */     Iterator iterator = mbrs.values().iterator();
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static <S extends Shape1D> Partition1D fileMBRMapReduce(Path[] inFiles, OperationsParams params) throws IOException, InterruptedException {
/*     */     Path outputPath;
/* 339 */     System.out.println("FileMBR---fileMBRMapReduce");
/* 340 */     JobConf job = new JobConf((Configuration)params, FileMBR1D.class);
/*     */ 
/*     */     
/* 343 */     FileSystem outFs = FileSystem.get((Configuration)job);
/*     */     do {
/* 345 */       outputPath = new Path(String.valueOf(inFiles[0].getName()) + ".mbr_" + (int)(Math.random() * 1000000.0D));
/* 346 */     } while (outFs.exists(outputPath));
/*     */     
/* 348 */     job.setJobName("FileMBR1D");
/* 349 */     job.setMapOutputKeyClass(Text.class);
/* 350 */     job.setMapOutputValueClass(Partition1D.class);
/*     */     
/* 352 */     job.setMapperClass(FileMBRMapper.class);
/* 353 */     job.setReducerClass(Reduce.class);
/* 354 */     job.setCombinerClass(Combine.class);
/* 355 */     ClusterStatus clusterStatus = (new JobClient(job)).getClusterStatus();
/* 356 */     job.setNumMapTasks(clusterStatus.getMaxMapTasks() * 5);
/*     */     
/* 358 */     job.setInputFormat(ShapeLineInputFormat1D.class);
/* 359 */     job.setOutputFormat(TextOutputFormat.class);
/*     */     
/* 361 */     ShapeInputFormat.setInputPaths(job, inFiles);
/* 362 */     TextOutputFormat.setOutputPath(job, outputPath);
/* 363 */     job.setOutputCommitter(MBROutputCommitter.class);
/*     */ 
/*     */     
/* 366 */     if (OperationsParams.isLocal((Configuration)job, inFiles)) {
/*     */       
/* 368 */       job.set("mapred.job.tracker", "local");
/*     */       
/* 370 */       job.setInt("mapreduce.local.map.tasks.maximum", Runtime.getRuntime().availableProcessors());
/*     */     } 
/*     */     
/* 373 */     if (params.getBoolean("background", false)) {
/* 374 */       JobClient jc = new JobClient(job);
/* 375 */       lastSubmittedJob = jc.submitJob(job);
/* 376 */       return null;
/*     */     } 
/* 378 */     lastSubmittedJob = JobClient.runJob(job);
/* 379 */     Counters counters = lastSubmittedJob.getCounters();
/* 380 */     Counters.Counter outputSizeCounter = (Counters.Counter)counters.findCounter((Enum)Task.Counter.MAP_INPUT_BYTES);
/* 381 */     sizeOfLastProcessedFile = outputSizeCounter.getCounter();
/*     */     
/* 383 */     FileStatus[] outFiles = outFs.listStatus(outputPath, 
/* 384 */         SpatialSite.NonHiddenFileFilter);
/* 385 */     Partition1D mbr = new Partition1D();
/* 386 */     mbr.set(Double.MAX_VALUE, -1.7976931348623157E308D);
/* 387 */     OperationsParams localMBRParams = new OperationsParams(params);
/* 388 */     localMBRParams.setBoolean("local", true);
/* 389 */     localMBRParams.setClass("shape", Partition1D.class, Shape1D.class); byte b; int i; FileStatus[] arrayOfFileStatus1;
/* 390 */     for (i = (arrayOfFileStatus1 = outFiles).length, b = 0; b < i; ) { FileStatus outFile = arrayOfFileStatus1[b];
/* 391 */       if (!outFile.isDir()) {
/*     */         
/* 393 */         ShapeRecordReader1D<Partition1D> reader = new ShapeRecordReader1D((Configuration)localMBRParams, new FileSplit(outFile.getPath(), 0L, outFile.getLen(), new String[0]));
/* 394 */         Segment key = reader.createKey();
/* 395 */         Partition1D p = (Partition1D)reader.createValue();
/* 396 */         while (reader.next(key, (Shape1D)p)) {
/* 397 */           mbr.expand(p);
/*     */         }
/* 399 */         reader.close();
/*     */       }  b++; }
/*     */     
/* 402 */     outFs.delete(outputPath, true);
/* 403 */     return mbr;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static Partition1D fileMBRCached(Path[] files, OperationsParams params) throws IOException {
/* 414 */     Partition1D p = new Partition1D(); byte b; int i; Path[] arrayOfPath;
/* 415 */     for (i = (arrayOfPath = files).length, b = 0; b < i; ) { Path file = arrayOfPath[b];
/* 416 */       FileSystem inFs = file.getFileSystem((Configuration)params);
/*     */       
/* 418 */       GlobalIndex1D<Partition1D> globalIndex = SpatialSite.getGlobalIndex1D(inFs, file);
/* 419 */       if (globalIndex == null)
/* 420 */         return null; 
/* 421 */       p.set(Double.MAX_VALUE, -1.7976931348623157E308D);
/* 422 */       for (Partition1D part : globalIndex) {
/* 423 */         p.expand(part);
/*     */       }
/* 425 */       sizeOfLastProcessedFile = p.size; b++; }
/*     */     
/* 427 */     return p;
/*     */   }
/*     */   
/*     */   public static Partition1D fileMBR(Path file, OperationsParams params) throws IOException, InterruptedException {
/* 431 */     return fileMBR(new Path[] { file }, params);
/*     */   }
/*     */   
/*     */   public static Partition1D fileMBR(Path[] files, OperationsParams params) throws IOException, InterruptedException {
/* 435 */     Partition1D cachedMBR = fileMBRCached(files, params);
/* 436 */     if (cachedMBR != null)
/* 437 */       return cachedMBR; 
/* 438 */     if (!params.autoDetectShape()) {
/* 439 */       LOG.error("shape of input files is not set and cannot be auto detected");
/* 440 */       return null;
/*     */     } 
/*     */ 
/*     */     
/* 444 */     if (OperationsParams.isLocal((Configuration)params, files)) {
/* 445 */       return fileMBRLocal(files, params);
/*     */     }
/* 447 */     return fileMBRMapReduce(files, params);
/*     */   }
/*     */ 
/*     */   
/*     */   private static void printUsage() {
/* 452 */     System.out.println("Finds the MBR of an input file");
/* 453 */     System.out.println("Parameters: (* marks required parameters)");
/* 454 */     System.out.println("<input file>: (*) Path to input file");
/* 455 */     System.out.println("shape:<input shape>: (*) Input file format");
/* 456 */     GenericOptionsParser.printGenericCommandUsage(System.out);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static void main(String[] args) throws IOException, InterruptedException {
/* 465 */     OperationsParams params = new OperationsParams(new GenericOptionsParser(args));
/* 466 */     if (!params.checkInput()) {
/* 467 */       printUsage();
/* 468 */       System.exit(1);
/*     */     } 
/* 470 */     Path[] inputFiles = params.getInputPaths();
/*     */     
/* 472 */     if (params.getShape("shape") == null) {
/* 473 */       LOG.error("Input file format not specified");
/* 474 */       printUsage();
/*     */       return;
/*     */     } 
/* 477 */     long t1 = System.currentTimeMillis();
/* 478 */     Partition1D partition1D = fileMBR(inputFiles, params);
/* 479 */     long t2 = System.currentTimeMillis();
/* 480 */     if (partition1D == null) {
/* 481 */       LOG.error("Error computing the MBR");
/* 482 */       System.exit(1);
/*     */     } 
/*     */     
/* 485 */     System.out.println("Total processing time: " + (t2 - t1) + " millis");
/* 486 */     System.out.println("MBR of records in file '" + inputFiles + "' is " + partition1D);
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\FileMBR1D.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */