/*     */ package com.dlmu.wisdomST.operation;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Vector;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.BlockLocation;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.mapred.FileSplit;
/*     */ import org.apache.hadoop.mapred.InputSplit;
/*     */ import org.apache.hadoop.mapred.JobConf;
/*     */ import org.apache.hadoop.mapred.lib.CombineFileSplit;
/*     */ import org.apache.hadoop.mapreduce.InputSplit;
/*     */ import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
/*     */ import org.apache.hadoop.mapreduce.lib.input.FileSplit;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class FileSplitUtil
/*     */ {
/*  36 */   static final Log LOG = LogFactory.getLog(FileSplitUtil.class);
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static InputSplit combineFileSplits(JobConf conf, List<FileSplit> splits, int startIndex, int count) throws IOException {
/*  53 */     if (count == 1) {
/*  54 */       return (InputSplit)splits.get(startIndex);
/*     */     }
/*  56 */     Path[] paths = new Path[count];
/*  57 */     long[] starts = new long[count];
/*  58 */     long[] lengths = new long[count];
/*  59 */     Vector<String> vlocations = new Vector<String>();
/*  60 */     while (count > 0) {
/*  61 */       paths[count - 1] = ((FileSplit)splits.get(startIndex)).getPath();
/*  62 */       starts[count - 1] = ((FileSplit)splits.get(startIndex)).getStart();
/*  63 */       lengths[count - 1] = ((FileSplit)splits.get(startIndex)).getLength();
/*  64 */       vlocations.addAll(Arrays.asList(((FileSplit)splits.get(startIndex)).getLocations()));
/*  65 */       count--;
/*  66 */       startIndex++;
/*     */     } 
/*  68 */     String[] locations = prioritizeLocations(vlocations);
/*  69 */     if (locations.length > 3) {
/*  70 */       String[] topLocations = new String[3];
/*  71 */       System.arraycopy(locations, 0, topLocations, 0, topLocations.length);
/*  72 */       locations = topLocations;
/*     */     } 
/*  74 */     return (InputSplit)new CombineFileSplit(conf, paths, starts, lengths, locations);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static InputSplit combineFileSplits(List<FileSplit> splits, int startIndex, int count) throws IOException {
/*  91 */     if (count == 1) {
/*  92 */       return (InputSplit)splits.get(startIndex);
/*     */     }
/*  94 */     Path[] paths = new Path[count];
/*  95 */     long[] starts = new long[count];
/*  96 */     long[] lengths = new long[count];
/*  97 */     Vector<String> vlocations = new Vector<String>();
/*  98 */     while (count > 0) {
/*  99 */       paths[count - 1] = ((FileSplit)splits.get(startIndex)).getPath();
/* 100 */       starts[count - 1] = ((FileSplit)splits.get(startIndex)).getStart();
/* 101 */       lengths[count - 1] = ((FileSplit)splits.get(startIndex)).getLength();
/* 102 */       vlocations.addAll(Arrays.asList(((FileSplit)splits.get(startIndex)).getLocations()));
/* 103 */       count--;
/* 104 */       startIndex++;
/*     */     } 
/* 106 */     String[] locations = prioritizeLocations(vlocations);
/* 107 */     if (locations.length > 3) {
/* 108 */       String[] topLocations = new String[3];
/* 109 */       System.arraycopy(locations, 0, topLocations, 0, topLocations.length);
/* 110 */       locations = topLocations;
/*     */     } 
/* 112 */     return (InputSplit)new CombineFileSplit(paths, starts, lengths, locations);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static InputSplit combineFileSplits(JobConf conf, FileSplit split1, FileSplit split2) throws IOException {
/* 126 */     Path[] paths = new Path[2];
/* 127 */     long[] starts = new long[2];
/* 128 */     long[] lengths = new long[2];
/* 129 */     Vector<String> vlocations = new Vector<String>();
/* 130 */     paths[0] = split1.getPath();
/* 131 */     starts[0] = split1.getStart();
/* 132 */     lengths[0] = split1.getLength();
/* 133 */     vlocations.addAll(Arrays.asList(split1.getLocations()));
/* 134 */     paths[1] = split2.getPath();
/* 135 */     starts[1] = split2.getStart();
/* 136 */     lengths[1] = split2.getLength();
/* 137 */     vlocations.addAll(Arrays.asList(split2.getLocations()));
/* 138 */     String[] locations = prioritizeLocations(vlocations);
/* 139 */     return (InputSplit)new CombineFileSplit(conf, paths, starts, lengths, locations);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static String[] prioritizeLocations(Vector<String> vlocations) {
/* 151 */     Collections.sort(vlocations);
/*     */     
/* 153 */     Vector[] locations_by_count = new Vector[vlocations.size() + 1];
/*     */     
/* 155 */     int unique_location_count = 0;
/* 156 */     int first_in_run = 0;
/* 157 */     int i = 1;
/* 158 */     while (i < vlocations.size()) {
/* 159 */       if (((String)vlocations.get(first_in_run)).equals(vlocations.get(i))) {
/* 160 */         i++;
/*     */         continue;
/*     */       } 
/* 163 */       unique_location_count++;
/* 164 */       int k = i - first_in_run;
/* 165 */       if (locations_by_count[k] == null) {
/* 166 */         locations_by_count[k] = new Vector();
/*     */       }
/* 168 */       locations_by_count[k].add(vlocations.get(first_in_run));
/* 169 */       first_in_run = i;
/*     */     } 
/*     */ 
/*     */     
/* 173 */     unique_location_count++;
/* 174 */     int count = i - first_in_run;
/* 175 */     if (locations_by_count[count] == null) {
/* 176 */       locations_by_count[count] = new Vector();
/*     */     }
/* 178 */     locations_by_count[count].add(vlocations.get(first_in_run));
/*     */     
/* 180 */     String[] unique_locations = new String[unique_location_count]; byte b; int j; Vector[] arrayOfVector1;
/* 181 */     for (j = (arrayOfVector1 = locations_by_count).length, b = 0; b < j; ) { Vector<String> locations_with_same_count = arrayOfVector1[b];
/* 182 */       if (locations_with_same_count != null)
/*     */       {
/* 184 */         for (String loc : locations_with_same_count)
/* 185 */           unique_locations[--unique_location_count] = loc;  } 
/*     */       b++; }
/*     */     
/* 188 */     if (unique_location_count != 0)
/* 189 */       throw new RuntimeException(); 
/* 190 */     return unique_locations;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static InputSplit[] autoCombineSplits(JobConf conf, Vector<FileSplit> inputSplits, int numSplits) throws IOException {
/* 203 */     LOG.info("Combining " + inputSplits.size() + " splits into " + numSplits);
/* 204 */     Map<String, Vector<FileSplit>> blocksPerHost = 
/* 205 */       new HashMap<String, Vector<FileSplit>>();
/* 206 */     for (FileSplit fsplit : inputSplits) {
/*     */       
/* 208 */       Path path = fsplit.getPath();
/* 209 */       FileSystem fs = path.getFileSystem((Configuration)conf);
/* 210 */       BlockLocation[] blockLocations = fs.getFileBlockLocations(
/* 211 */           fs.getFileStatus(path), fsplit.getStart(), fsplit.getLength()); byte b; int j; BlockLocation[] arrayOfBlockLocation1;
/* 212 */       for (j = (arrayOfBlockLocation1 = blockLocations).length, b = 0; b < j; ) { BlockLocation blockLocation = arrayOfBlockLocation1[b]; byte b1; int k; String[] arrayOfString;
/* 213 */         for (k = (arrayOfString = blockLocation.getHosts()).length, b1 = 0; b1 < k; ) { String hostName = arrayOfString[b1];
/* 214 */           if (!blocksPerHost.containsKey(hostName))
/* 215 */             blocksPerHost.put(hostName, new Vector<FileSplit>()); 
/* 216 */           ((Vector<FileSplit>)blocksPerHost.get(hostName)).add(fsplit);
/*     */           b1++; }
/*     */         
/*     */         b++; }
/*     */     
/*     */     } 
/* 222 */     InputSplit[] combined_splits = new InputSplit[numSplits];
/* 223 */     int splitsAvailable = inputSplits.size();
/*     */     
/* 225 */     for (int i = 0; i < numSplits; i++) {
/*     */       
/* 227 */       int numSplitsToCombine = splitsAvailable / (numSplits - i);
/* 228 */       Vector<FileSplit> splitsToCombine = new Vector<FileSplit>();
/* 229 */       while (numSplitsToCombine > 0) {
/*     */         
/* 231 */         Map.Entry<String, Vector<FileSplit>> minEntry = null;
/* 232 */         for (Map.Entry<String, Vector<FileSplit>> entry : blocksPerHost.entrySet()) {
/* 233 */           if (minEntry == null || ((Vector)entry.getValue()).size() < ((Vector)minEntry.getValue()).size()) {
/* 234 */             minEntry = entry;
/*     */           }
/*     */         } 
/*     */         
/* 238 */         for (FileSplit fsplit : minEntry.getValue()) {
/* 239 */           if (!splitsToCombine.contains(fsplit)) {
/* 240 */             splitsToCombine.add(fsplit);
/* 241 */             if (--numSplitsToCombine == 0)
/*     */               break; 
/*     */           } 
/*     */         } 
/* 245 */         if (numSplitsToCombine != 0)
/*     */         {
/* 247 */           blocksPerHost.remove(minEntry.getKey());
/*     */         }
/*     */       } 
/*     */       
/* 251 */       combined_splits[i] = combineFileSplits(conf, splitsToCombine, 0, 
/* 252 */           splitsToCombine.size());
/*     */       
/* 254 */       for (Map.Entry<String, Vector<FileSplit>> entry : blocksPerHost.entrySet()) {
/* 255 */         ((Vector)entry.getValue()).removeAll(splitsToCombine);
/*     */       }
/* 257 */       splitsAvailable -= splitsToCombine.size();
/*     */     } 
/*     */     
/* 260 */     LOG.info("Combined splits " + combined_splits.length);
/* 261 */     return combined_splits;
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\FileSplitUtil.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */