/*    */ package com.dlmu.wisdomST.operation;
/*    */ 
/*    */ import com.dlmu.wisdomST.indexing.RTree;
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import org.apache.hadoop.conf.Configuration;
/*    */ import org.apache.hadoop.fs.FSDataInputStream;
/*    */ import org.apache.hadoop.fs.FileStatus;
/*    */ import org.apache.hadoop.fs.FileSystem;
/*    */ import org.apache.hadoop.fs.Path;
/*    */ import org.apache.hadoop.mapreduce.InputSplit;
/*    */ import org.apache.hadoop.mapreduce.TaskAttemptContext;
/*    */ import org.apache.hadoop.mapreduce.TaskAttemptID;
/*    */ import org.apache.hadoop.mapreduce.lib.input.FileSplit;
/*    */ import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
/*    */ import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ public class Head
/*    */ {
/*    */   public static String[] head(FileSystem fs, Path p, int n) throws IOException {
/*    */     FileSplit split;
/* 44 */     String[] lines = new String[n];
/* 45 */     FileStatus fstatus = fs.getFileStatus(p);
/*    */     
/* 47 */     TaskAttemptContext context = createDummyContext();
/* 48 */     LineRecordReader lineReader = new LineRecordReader();
/*    */     
/* 50 */     if (p.getName().endsWith(".rtree")) {
/*    */       
/* 52 */       FSDataInputStream in = fs.open(p);
/* 53 */       in.skip(8L);
/* 54 */       int treeHeaderSize = RTree.skipHeader((InputStream)in);
/* 55 */       in.close();
/* 56 */       split = new FileSplit(p, (treeHeaderSize + 8), fstatus.getLen() - treeHeaderSize - 8L, new String[0]);
/*    */     } else {
/* 58 */       split = new FileSplit(p, 0L, fstatus.getLen(), new String[0]);
/*    */     } 
/* 60 */     lineReader.initialize((InputSplit)split, context);
/* 61 */     int numOfLines = 0;
/* 62 */     for (numOfLines = 0; numOfLines < lines.length && lineReader.nextKeyValue(); numOfLines++) {
/* 63 */       lines[numOfLines] = lineReader.getCurrentValue().toString();
/*    */     }
/* 65 */     lineReader.close();
/*    */     
/* 67 */     return lines;
/*    */   }
/*    */   
/*    */   private static TaskAttemptContext createDummyContext() {
/* 71 */     TaskAttemptID taskId = new TaskAttemptID();
/* 72 */     return (TaskAttemptContext)new TaskAttemptContextImpl(new Configuration(), taskId);
/*    */   }
/*    */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\Head.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */