/*     */ package com.dlmu.wisdomST.operation;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import com.dlmu.wisdomST.indexing.GlobalIndex;
/*     */ import com.dlmu.wisdomST.indexing.GlobalIndex1D;
/*     */ import com.dlmu.wisdomST.indexing.Partition;
/*     */ import com.dlmu.wisdomST.indexing.Partition1D;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class RangeFilter
/*     */   extends DefaultBlockFilter
/*     */ {
/*     */   public static final String QueryRange = "RangeFilter.QueryRange";
/*     */   private Shape queryRange;
/*     */   private Shape1D queryRange1D;
/*     */   
/*     */   public RangeFilter() {}
/*     */   
/*     */   public RangeFilter(Shape shape) {
/*  41 */     this.queryRange = shape.clone();
/*     */   }
/*     */   public RangeFilter(Shape1D shape) {
/*  44 */     this.queryRange1D = shape.clone();
/*     */   }
/*     */ 
/*     */   
/*     */   public void configure(Configuration job) {
/*  49 */     if (this.queryRange == null)
/*  50 */       this.queryRange = OperationsParams.getShape(job, "RangeFilter.QueryRange"); 
/*  51 */     if (this.queryRange1D == null) {
/*  52 */       this.queryRange1D = OperationsParams.getShape1D(job, "RangeFilter.QueryRange");
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public void selectCells(GlobalIndex<Partition> gIndex, ResultCollector<Partition> output) {
/*  59 */     if (gIndex.isReplicated()) {
/*     */       
/*  61 */       System.out.println("需要执行重复过滤了");
/*  62 */       int numPartitions = gIndex.rangeQuery(this.queryRange, output);
/*     */       
/*  64 */       RangeQuery.LOG.info("Selected " + numPartitions + " partitions overlapping " + this.queryRange);
/*     */     
/*     */     }
/*     */     else {
/*     */       
/*  69 */       Rectangle queryMBR = this.queryRange.getMBR();
/*     */ 
/*     */ 
/*     */ 
/*     */       
/*  74 */       int numPartitions = 0;
/*  75 */       for (Partition p : gIndex) {
/*     */         
/*  77 */         if (queryMBR.contains((Rectangle)p)) {
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */           
/*  84 */           if (p.isIntersected(this.queryRange)) {
/*  85 */             output.collect(p);
/*  86 */             numPartitions++;
/*     */           }  continue;
/*  88 */         }  if (p.isIntersected((Shape)queryMBR) && p.isIntersected(this.queryRange)) {
/*     */           
/*  90 */           output.collect(p);
/*  91 */           numPartitions++;
/*     */         } 
/*     */       } 
/*  94 */       RangeQuery.LOG.info("Selected " + numPartitions + " partitions overlapping " + this.queryRange);
/*     */     } 
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public void selectCells(GlobalIndex1D<Partition1D> gIndex, ResultCollector<Partition1D> output) {
/* 101 */     if (gIndex.isReplicated()) {
/*     */       
/* 103 */       int numPartitions = gIndex.rangeQuery(this.queryRange1D, output);
/* 104 */       RangeQuery1D.LOG.info("Selected " + numPartitions + " partitions overlapping " + this.queryRange);
/*     */     
/*     */     }
/*     */     else {
/*     */       
/* 109 */       Segment queryMBR = this.queryRange1D.getSegment();
/*     */ 
/*     */ 
/*     */ 
/*     */       
/* 114 */       int numPartitions = 0;
/* 115 */       for (Partition1D p : gIndex) {
/*     */         
/* 117 */         if (queryMBR.contains((Segment)p)) {
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */           
/* 124 */           if (p.isIntersected(this.queryRange1D)) {
/* 125 */             output.collect(p);
/* 126 */             numPartitions++;
/*     */           }  continue;
/* 128 */         }  if (p.isIntersected((Shape1D)queryMBR) && p.isIntersected(this.queryRange1D)) {
/*     */           
/* 130 */           output.collect(p);
/* 131 */           numPartitions++;
/*     */         } 
/*     */       } 
/*     */     } 
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\RangeFilter.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */