/*     */ package com.dlmu.wisdomST.operation;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.io.Text2;
/*     */ import com.dlmu.wisdomST.mapreduce.RTreeRecordReader3;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialInputFormat3;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialRecordReader3;
/*     */ import com.dlmu.wisdomST.mapreduce.TextOutputFormat3;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import com.dlmu.wisdomST.util.Parallel;
/*     */ import java.io.IOException;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Vector;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.FSDataOutputStream;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.io.NullWritable;
/*     */ import org.apache.hadoop.io.Text;
/*     */ import org.apache.hadoop.mapred.JobConf;
/*     */ import org.apache.hadoop.mapred.Task;
/*     */ import org.apache.hadoop.mapreduce.Counter;
/*     */ import org.apache.hadoop.mapreduce.Counters;
/*     */ import org.apache.hadoop.mapreduce.InputSplit;
/*     */ import org.apache.hadoop.mapreduce.Job;
/*     */ import org.apache.hadoop.mapreduce.JobContext;
/*     */ import org.apache.hadoop.mapreduce.Mapper;
/*     */ import org.apache.hadoop.mapreduce.RecordReader;
/*     */ import org.apache.hadoop.mapreduce.lib.input.FileSplit;
/*     */ import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class RangeQuery
/*     */ {
/*  55 */   static final Log LOG = LogFactory.getLog(RangeQuery.class);
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static class RangeQueryMap
/*     */     extends Mapper<Rectangle, Iterable<Shape>, NullWritable, Shape>
/*     */   {
/*     */     protected void map(Rectangle cellMBR, Iterable<Shape> value, Mapper<Rectangle, Iterable<Shape>, NullWritable, Shape>.Context context) throws IOException, InterruptedException {
/*  67 */       NullWritable dummyKey = NullWritable.get();
/*  68 */       for (Shape s : value)
/*     */       {
/*  70 */         context.write(dummyKey, s);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public static Job rangeQueryMapReduce(Path inFile, Path outFile, OperationsParams params) throws IOException, ClassNotFoundException, InterruptedException {
/*  78 */     params.set("rect", params.get("rect"));
/*     */     
/*  80 */     params.setInt("mapreduce.local.map.tasks.maximum", Runtime.getRuntime().availableProcessors());
/*     */     
/*  82 */     Job job = new Job((Configuration)params, "RangeQuery");
/*  83 */     job.setJarByClass(RangeQuery.class);
/*  84 */     job.setNumReduceTasks(0);
/*     */     
/*  86 */     job.setInputFormatClass(SpatialInputFormat3.class);
/*  87 */     SpatialInputFormat3.setInputPaths(job, new Path[] { inFile });
/*     */     
/*  89 */     job.setMapperClass(RangeQueryMap.class);
/*     */     
/*  91 */     if (params.getBoolean("output", true) && outFile != null) {
/*  92 */       job.setOutputFormatClass(TextOutputFormat3.class);
/*  93 */       TextOutputFormat3.setOutputPath(job, outFile);
/*     */     } else {
/*     */       
/*  96 */       job.setOutputFormatClass(NullOutputFormat.class);
/*     */     } 
/*     */     
/*  99 */     if (!params.getBoolean("background", false)) {
/* 100 */       job.waitForCompletion(false);
/*     */     } else {
/* 102 */       job.submit();
/*     */     } 
/* 104 */     return job;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static <S extends Shape> long rangeQueryLocal(Path inPath, Shape queryRange, S shape, final OperationsParams params, final ResultCollector<S> output) throws IOException, InterruptedException {
/* 127 */     OperationsParams.setShape((Configuration)params, "rect", (Shape)queryRange.getMBR());
/*     */     
/* 129 */     final SpatialInputFormat3<Rectangle, S> inputFormat = 
/* 130 */       new SpatialInputFormat3();
/* 131 */     Job job = Job.getInstance((Configuration)params);
/* 132 */     SpatialInputFormat3.setInputPaths(job, new Path[] { inPath });
/* 133 */     final List<InputSplit> splits = inputFormat.getSplits((JobContext)job);
/*     */ 
/*     */     
/* 136 */     List<Long> results = Parallel.forEach(splits.size(), new Parallel.RunnableRange<Long>()
/*     */         {
/*     */           public Long run(int i1, int i2) {
/* 139 */             long results = 0L;
/* 140 */             for (int i = i1; i < i2; i++) {
/*     */               try {
/* 142 */                 FileSplit fsplit = splits.get(i);
/* 143 */                 RecordReader<Rectangle, Iterable<S>> reader = 
/* 144 */                   inputFormat.createRecordReader((InputSplit)fsplit, null);
/* 145 */                 if (reader instanceof SpatialRecordReader3) {
/* 146 */                   ((SpatialRecordReader3)reader).initialize((InputSplit)fsplit, (Configuration)params);
/* 147 */                 } else if (reader instanceof RTreeRecordReader3) {
/* 148 */                   ((RTreeRecordReader3)reader).initialize((InputSplit)fsplit, (Configuration)params);
/*     */                 } else {
/* 150 */                   throw new RuntimeException("Unknown record reader");
/*     */                 } 
/* 152 */                 while (reader.nextKeyValue()) {
/* 153 */                   Iterable<S> shapes = (Iterable<S>)reader.getCurrentValue();
/* 154 */                   for (Shape s : shapes) {
/* 155 */                     results++;
/* 156 */                     if (output != null)
/* 157 */                       output.collect(s); 
/*     */                   } 
/*     */                 } 
/* 160 */                 reader.close();
/* 161 */               } catch (IOException e) {
/* 162 */                 RangeQuery.LOG.error("Error processing split " + splits.get(i), e);
/* 163 */               } catch (InterruptedException e) {
/* 164 */                 RangeQuery.LOG.error("Error processing split " + splits.get(i), e);
/*     */               } 
/*     */             } 
/* 167 */             return Long.valueOf(results);
/*     */           }
/*     */         });
/* 170 */     long totalResultSize = 0L;
/* 171 */     for (Iterator<Long> iterator = results.iterator(); iterator.hasNext(); ) { long result = ((Long)iterator.next()).longValue();
/* 172 */       totalResultSize += result; }
/* 173 */      return totalResultSize;
/*     */   }
/*     */   
/*     */   private static void printUsage() {
/* 177 */     System.out.println("Performs a range query on an input file");
/* 178 */     System.out.println("Parameters: (* marks required parameters)");
/* 179 */     System.out.println("<input file> - (*) Path to input file");
/* 180 */     System.out.println("<output file> - Path to output file");
/* 181 */     System.out.println("shape:<point|rectangle|polygon> - (*) Type of shapes stored in input file");
/* 182 */     System.out.println("rect:<x1,y1,x2,y2> - (*) Query rectangle");
/* 183 */     System.out.println("-overwrite - Overwrite output file without notice");
/* 184 */     GenericOptionsParser.printGenericCommandUsage(System.out);
/*     */   }
/*     */   
/*     */   public static void main(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
/* 188 */     OperationsParams params = new OperationsParams(new GenericOptionsParser(args));
/*     */     
/* 190 */     Path[] paths = params.getPaths();
/* 191 */     if (paths.length <= 1 && !params.checkInput()) {
/* 192 */       printUsage();
/* 193 */       System.exit(1);
/*     */     } 
/* 195 */     if (paths.length >= 2 && !params.checkInputOutput()) {
/* 196 */       printUsage();
/* 197 */       System.exit(1);
/*     */     } 
/* 199 */     if (params.get("rect") == null) {
/* 200 */       System.err.println("You must provide a query range");
/* 201 */       printUsage();
/* 202 */       System.exit(1);
/*     */     } 
/* 204 */     final Path inPath = params.getInputPath();
/* 205 */     Path outPath = params.getOutputPath();
/* 206 */     Rectangle[] queryRanges = (Rectangle[])params.getShapes("rect", (Shape)new Rectangle());
/*     */ 
/*     */     
/* 209 */     final Vector<Long> resultsCounts = new Vector<Long>();
/* 210 */     Vector<Job> jobs = new Vector<Job>();
/* 211 */     Vector<Thread> threads = new Vector<Thread>();
/*     */     
/* 213 */     long t1 = System.currentTimeMillis();
/* 214 */     for (int i = 0; i < queryRanges.length; i++) {
/* 215 */       final OperationsParams queryParams = new OperationsParams(params);
/* 216 */       OperationsParams.setShape((Configuration)queryParams, "rect", (Shape)queryRanges[i]);
/* 217 */       if (OperationsParams.isLocal((Configuration)new JobConf((Configuration)queryParams), new Path[] { inPath })) {
/*     */         
/* 219 */         final Rectangle queryRange = queryRanges[i];
/* 220 */         final Shape shape = queryParams.getShape("shape");
/* 221 */         final Path output = (outPath == null) ? null : (
/* 222 */           (queryRanges.length == 1) ? outPath : new Path(outPath, String.format("%05d", new Object[] { Integer.valueOf(i) })));
/* 223 */         Thread thread = new Thread()
/*     */           {
/*     */             public void run() {
/* 226 */               FSDataOutputStream outFile = null;
/* 227 */               final byte[] newLine = System.getProperty("line.separator", "\n").getBytes();
/*     */               try {
/* 229 */                 ResultCollector<Shape> collector = null;
/* 230 */                 if (output != null) {
/* 231 */                   FileSystem outFS = output.getFileSystem((Configuration)queryParams);
/* 232 */                   final FSDataOutputStream foutFile = outFile = outFS.create(output);
/* 233 */                   collector = new ResultCollector<Shape>() {
/* 234 */                       final Text tempText = (Text)new Text2();
/*     */                       
/*     */                       public synchronized void collect(Shape r) {
/*     */                         try {
/* 238 */                           this.tempText.clear();
/* 239 */                           r.toText(this.tempText);
/* 240 */                           foutFile.write(this.tempText.getBytes(), 0, this.tempText.getLength());
/* 241 */                           foutFile.write(newLine);
/* 242 */                         } catch (IOException e) {
/* 243 */                           e.printStackTrace();
/*     */                         } 
/*     */                       }
/*     */                     };
/*     */                 } else {
/* 248 */                   outFile = null;
/*     */                 } 
/* 250 */                 long resultCount = RangeQuery.rangeQueryLocal(inPath, (Shape)queryRange, shape, queryParams, collector);
/* 251 */                 resultsCounts.add(Long.valueOf(resultCount));
/* 252 */               } catch (IOException e) {
/* 253 */                 e.printStackTrace();
/* 254 */               } catch (InterruptedException e) {
/* 255 */                 e.printStackTrace();
/*     */               } finally {
/*     */                 try {
/* 258 */                   if (outFile != null)
/* 259 */                     outFile.close(); 
/* 260 */                 } catch (IOException e) {
/* 261 */                   e.printStackTrace();
/*     */                 } 
/*     */               } 
/*     */             }
/*     */           };
/* 266 */         thread.start();
/* 267 */         threads.add(thread);
/*     */       } else {
/*     */         
/* 270 */         queryParams.setBoolean("background", true);
/* 271 */         Job job = rangeQueryMapReduce(inPath, outPath, queryParams);
/* 272 */         jobs.add(job);
/*     */       } 
/*     */     } 
/*     */     
/* 276 */     while (!jobs.isEmpty()) {
/* 277 */       Job firstJob = jobs.firstElement();
/* 278 */       firstJob.waitForCompletion(false);
/* 279 */       if (!firstJob.isSuccessful()) {
/* 280 */         System.err.println("Error running job " + firstJob);
/* 281 */         System.err.println("Killing all remaining jobs");
/* 282 */         for (int j = 1; j < jobs.size(); j++)
/* 283 */           ((Job)jobs.get(j)).killJob(); 
/* 284 */         System.exit(1);
/*     */       } 
/* 286 */       Counters counters = firstJob.getCounters();
/* 287 */       Counter outputRecordCounter = counters.findCounter((Enum)Task.Counter.MAP_OUTPUT_RECORDS);
/* 288 */       resultsCounts.add(Long.valueOf(outputRecordCounter.getValue()));
/* 289 */       jobs.remove(0);
/*     */     } 
/* 291 */     while (!threads.isEmpty()) {
/*     */       try {
/* 293 */         Thread thread = threads.firstElement();
/* 294 */         thread.join();
/* 295 */         threads.remove(0);
/* 296 */       } catch (InterruptedException e) {
/* 297 */         e.printStackTrace();
/*     */       } 
/*     */     } 
/* 300 */     long t2 = System.currentTimeMillis();
/*     */     
/* 302 */     System.out.println("Time for " + queryRanges.length + " jobs is " + (t2 - t1) + " millis");
/* 303 */     System.out.println("Results counts: " + resultsCounts);
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\RangeQuery.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */