/*     */ package com.dlmu.wisdomST.operation;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import com.dlmu.wisdomST.io.Text2;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialInputFormat31D;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialRecordReader31D;
/*     */ import com.dlmu.wisdomST.mapreduce.TextOutputFormat3;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import com.dlmu.wisdomST.util.Parallel;
/*     */ import java.io.IOException;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Vector;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.FSDataOutputStream;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.io.NullWritable;
/*     */ import org.apache.hadoop.io.Text;
/*     */ import org.apache.hadoop.mapred.JobConf;
/*     */ import org.apache.hadoop.mapred.Task;
/*     */ import org.apache.hadoop.mapreduce.Counter;
/*     */ import org.apache.hadoop.mapreduce.Counters;
/*     */ import org.apache.hadoop.mapreduce.InputSplit;
/*     */ import org.apache.hadoop.mapreduce.Job;
/*     */ import org.apache.hadoop.mapreduce.JobContext;
/*     */ import org.apache.hadoop.mapreduce.Mapper;
/*     */ import org.apache.hadoop.mapreduce.RecordReader;
/*     */ import org.apache.hadoop.mapreduce.lib.input.FileSplit;
/*     */ import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class RangeQuery1D
/*     */ {
/*  55 */   static final Log LOG = LogFactory.getLog(RangeQuery1D.class);
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static class RangeQueryMap
/*     */     extends Mapper<Segment, Iterable<Shape1D>, NullWritable, Shape1D>
/*     */   {
/*     */     protected void map(Segment cellMBR, Iterable<Shape1D> value, Mapper<Segment, Iterable<Shape1D>, NullWritable, Shape1D>.Context context) throws IOException, InterruptedException {
/*  67 */       NullWritable dummyKey = NullWritable.get();
/*  68 */       for (Shape1D s : value)
/*     */       {
/*  70 */         context.write(dummyKey, s);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public static Job rangeQueryMapReduce(Path inFile, Path outFile, OperationsParams params) throws IOException, ClassNotFoundException, InterruptedException {
/*  78 */     params.set("segment", params.get("segment"));
/*     */     
/*  80 */     params.setInt("mapreduce.local.map.tasks.maximum", Runtime.getRuntime().availableProcessors());
/*     */     
/*  82 */     Job job = new Job((Configuration)params, "RangeQuery1D");
/*  83 */     job.setJarByClass(RangeQuery1D.class);
/*  84 */     job.setNumReduceTasks(0);
/*     */     
/*  86 */     job.setInputFormatClass(SpatialInputFormat31D.class);
/*  87 */     SpatialInputFormat31D.setInputPaths(job, new Path[] { inFile });
/*     */     
/*  89 */     job.setMapperClass(RangeQueryMap.class);
/*     */     
/*  91 */     if (params.getBoolean("output", true) && outFile != null) {
/*  92 */       job.setOutputFormatClass(TextOutputFormat3.class);
/*  93 */       TextOutputFormat3.setOutputPath(job, outFile);
/*     */     } else {
/*     */       
/*  96 */       job.setOutputFormatClass(NullOutputFormat.class);
/*     */     } 
/*     */     
/*  99 */     if (!params.getBoolean("background", false)) {
/* 100 */       job.waitForCompletion(false);
/*     */     } else {
/* 102 */       job.submit();
/*     */     } 
/* 104 */     return job;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static <S extends Shape1D> long rangeQueryLocal(Path inPath, Shape1D queryRange, S shape, final OperationsParams params, final ResultCollector<S> output) throws IOException, InterruptedException {
/* 127 */     OperationsParams.setShape((Configuration)params, "segment", (Shape1D)queryRange.getSegment());
/*     */     
/* 129 */     final SpatialInputFormat31D<Segment, S> inputFormat = 
/* 130 */       new SpatialInputFormat31D();
/* 131 */     Job job = Job.getInstance((Configuration)params);
/* 132 */     SpatialInputFormat31D.setInputPaths(job, new Path[] { inPath });
/* 133 */     final List<InputSplit> splits = inputFormat.getSplits((JobContext)job);
/*     */ 
/*     */     
/* 136 */     List<Long> results = Parallel.forEach(splits.size(), new Parallel.RunnableRange<Long>()
/*     */         {
/*     */           public Long run(int i1, int i2) {
/* 139 */             long results = 0L;
/* 140 */             for (int i = i1; i < i2; i++) {
/*     */               try {
/* 142 */                 FileSplit fsplit = splits.get(i);
/* 143 */                 RecordReader<Segment, Iterable<S>> reader = 
/* 144 */                   inputFormat.createRecordReader((InputSplit)fsplit, null);
/* 145 */                 if (reader instanceof SpatialRecordReader31D) {
/* 146 */                   ((SpatialRecordReader31D)reader).initialize((InputSplit)fsplit, (Configuration)params);
/*     */                 } else {
/* 148 */                   throw new RuntimeException("Unknown record reader");
/*     */                 } 
/* 150 */                 while (reader.nextKeyValue()) {
/* 151 */                   Iterable<S> shapes = (Iterable<S>)reader.getCurrentValue();
/* 152 */                   for (Shape1D s : shapes) {
/* 153 */                     results++;
/* 154 */                     if (output != null)
/* 155 */                       output.collect(s); 
/*     */                   } 
/*     */                 } 
/* 158 */                 reader.close();
/* 159 */               } catch (IOException e) {
/* 160 */                 RangeQuery1D.LOG.error("Error processing split " + splits.get(i), e);
/* 161 */               } catch (InterruptedException e) {
/* 162 */                 RangeQuery1D.LOG.error("Error processing split " + splits.get(i), e);
/*     */               } 
/*     */             } 
/* 165 */             return Long.valueOf(results);
/*     */           }
/*     */         });
/* 168 */     long totalResultSize = 0L;
/* 169 */     for (Iterator<Long> iterator = results.iterator(); iterator.hasNext(); ) { long result = ((Long)iterator.next()).longValue();
/* 170 */       totalResultSize += result; }
/* 171 */      return totalResultSize;
/*     */   }
/*     */   
/*     */   private static void printUsage() {
/* 175 */     System.out.println("Performs a range query on an input file");
/* 176 */     System.out.println("Parameters: (* marks required parameters)");
/* 177 */     System.out.println("<input file> - (*) Path to input file");
/* 178 */     System.out.println("<output file> - Path to output file");
/* 179 */     System.out.println("shape:<point|rectangle|polygon> - (*) Type of shapes stored in input file");
/* 180 */     System.out.println("rect:<x1,y1,x2,y2> - (*) Query rectangle");
/* 181 */     System.out.println("-overwrite - Overwrite output file without notice");
/* 182 */     GenericOptionsParser.printGenericCommandUsage(System.out);
/*     */   }
/*     */   
/*     */   public static void main(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
/* 186 */     OperationsParams params = new OperationsParams(new GenericOptionsParser(args));
/*     */     
/* 188 */     Path[] paths = params.getPaths();
/* 189 */     if (paths.length <= 1 && !params.checkInput()) {
/* 190 */       printUsage();
/* 191 */       System.exit(1);
/*     */     } 
/* 193 */     if (paths.length >= 2 && !params.checkInputOutput()) {
/* 194 */       printUsage();
/* 195 */       System.exit(1);
/*     */     } 
/* 197 */     if (params.get("rect") == null) {
/* 198 */       System.err.println("You must provide a query range");
/* 199 */       printUsage();
/* 200 */       System.exit(1);
/*     */     } 
/* 202 */     final Path inPath = params.getInputPath();
/* 203 */     Path outPath = params.getOutputPath();
/* 204 */     Segment[] queryRanges = (Segment[])params.getShapes1D("segment", (Shape1D)new Segment());
/*     */ 
/*     */     
/* 207 */     final Vector<Long> resultsCounts = new Vector<Long>();
/* 208 */     Vector<Job> jobs = new Vector<Job>();
/* 209 */     Vector<Thread> threads = new Vector<Thread>();
/*     */     
/* 211 */     long t1 = System.currentTimeMillis();
/* 212 */     for (int i = 0; i < queryRanges.length; i++) {
/* 213 */       final OperationsParams queryParams = new OperationsParams(params);
/* 214 */       OperationsParams.setShape((Configuration)queryParams, "rect", (Shape1D)queryRanges[i]);
/* 215 */       if (OperationsParams.isLocal((Configuration)new JobConf((Configuration)queryParams), new Path[] { inPath })) {
/*     */         
/* 217 */         final Segment queryRange = queryRanges[i];
/* 218 */         final Shape1D shape = queryParams.getShape1D("shape");
/* 219 */         final Path output = (outPath == null) ? null : (
/* 220 */           (queryRanges.length == 1) ? outPath : new Path(outPath, String.format("%05d", new Object[] { Integer.valueOf(i) })));
/* 221 */         Thread thread = new Thread()
/*     */           {
/*     */             public void run() {
/* 224 */               FSDataOutputStream outFile = null;
/* 225 */               final byte[] newLine = System.getProperty("line.separator", "\n").getBytes();
/*     */               try {
/* 227 */                 ResultCollector<Shape1D> collector = null;
/* 228 */                 if (output != null) {
/* 229 */                   FileSystem outFS = output.getFileSystem((Configuration)queryParams);
/* 230 */                   final FSDataOutputStream foutFile = outFile = outFS.create(output);
/* 231 */                   collector = new ResultCollector<Shape1D>() {
/* 232 */                       final Text tempText = (Text)new Text2();
/*     */                       
/*     */                       public synchronized void collect(Shape1D r) {
/*     */                         try {
/* 236 */                           this.tempText.clear();
/* 237 */                           r.toText(this.tempText);
/* 238 */                           foutFile.write(this.tempText.getBytes(), 0, this.tempText.getLength());
/* 239 */                           foutFile.write(newLine);
/* 240 */                         } catch (IOException e) {
/* 241 */                           e.printStackTrace();
/*     */                         } 
/*     */                       }
/*     */                     };
/*     */                 } else {
/* 246 */                   outFile = null;
/*     */                 } 
/* 248 */                 long resultCount = RangeQuery1D.rangeQueryLocal(inPath, (Shape1D)queryRange, shape, queryParams, collector);
/* 249 */                 resultsCounts.add(Long.valueOf(resultCount));
/* 250 */               } catch (IOException e) {
/* 251 */                 e.printStackTrace();
/* 252 */               } catch (InterruptedException e) {
/* 253 */                 e.printStackTrace();
/*     */               } finally {
/*     */                 try {
/* 256 */                   if (outFile != null)
/* 257 */                     outFile.close(); 
/* 258 */                 } catch (IOException e) {
/* 259 */                   e.printStackTrace();
/*     */                 } 
/*     */               } 
/*     */             }
/*     */           };
/* 264 */         thread.start();
/* 265 */         threads.add(thread);
/*     */       } else {
/*     */         
/* 268 */         queryParams.setBoolean("background", true);
/* 269 */         Job job = rangeQueryMapReduce(inPath, outPath, queryParams);
/* 270 */         jobs.add(job);
/*     */       } 
/*     */     } 
/*     */     
/* 274 */     while (!jobs.isEmpty()) {
/* 275 */       Job firstJob = jobs.firstElement();
/* 276 */       firstJob.waitForCompletion(false);
/* 277 */       if (!firstJob.isSuccessful()) {
/* 278 */         System.err.println("Error running job " + firstJob);
/* 279 */         System.err.println("Killing all remaining jobs");
/* 280 */         for (int j = 1; j < jobs.size(); j++)
/* 281 */           ((Job)jobs.get(j)).killJob(); 
/* 282 */         System.exit(1);
/*     */       } 
/* 284 */       Counters counters = firstJob.getCounters();
/* 285 */       Counter outputRecordCounter = counters.findCounter((Enum)Task.Counter.MAP_OUTPUT_RECORDS);
/* 286 */       resultsCounts.add(Long.valueOf(outputRecordCounter.getValue()));
/* 287 */       jobs.remove(0);
/*     */     } 
/* 289 */     while (!threads.isEmpty()) {
/*     */       try {
/* 291 */         Thread thread = threads.firstElement();
/* 292 */         thread.join();
/* 293 */         threads.remove(0);
/* 294 */       } catch (InterruptedException e) {
/* 295 */         e.printStackTrace();
/*     */       } 
/*     */     } 
/* 298 */     long t2 = System.currentTimeMillis();
/*     */     
/* 300 */     System.out.println("Time for " + queryRanges.length + " jobs is " + (t2 - t1) + " millis");
/* 301 */     System.out.println("Results counts: " + resultsCounts);
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\RangeQuery1D.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */