/*     */ package com.dlmu.wisdomST.operation;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.QueryPlanner;
/*     */ import com.dlmu.wisdomST.core.Rectangle;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.io.Text2;
/*     */ import com.dlmu.wisdomST.mapreduce.RTreeRecordReader3;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialInputFormat3;
/*     */ import com.dlmu.wisdomST.mapreduce.SpatialRecordReader3;
/*     */ import com.dlmu.wisdomST.mapreduce.TextOutputFormat3;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import com.dlmu.wisdomST.util.Parallel;
/*     */ import java.io.IOException;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Vector;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.FSDataOutputStream;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.io.NullWritable;
/*     */ import org.apache.hadoop.io.Text;
/*     */ import org.apache.hadoop.mapred.JobConf;
/*     */ import org.apache.hadoop.mapred.Task;
/*     */ import org.apache.hadoop.mapreduce.Counter;
/*     */ import org.apache.hadoop.mapreduce.Counters;
/*     */ import org.apache.hadoop.mapreduce.InputSplit;
/*     */ import org.apache.hadoop.mapreduce.Job;
/*     */ import org.apache.hadoop.mapreduce.JobContext;
/*     */ import org.apache.hadoop.mapreduce.Mapper;
/*     */ import org.apache.hadoop.mapreduce.RecordReader;
/*     */ import org.apache.hadoop.mapreduce.lib.input.FileSplit;
/*     */ import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class STRangeQuery
/*     */ {
/*  61 */   static final Log LOG = LogFactory.getLog(STRangeQuery.class);
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static class RangeQueryMap
/*     */     extends Mapper<Rectangle, Iterable<Shape>, NullWritable, Shape>
/*     */   {
/*     */     protected void map(Rectangle cellMBR, Iterable<Shape> value, Mapper<Rectangle, Iterable<Shape>, NullWritable, Shape>.Context context) throws IOException, InterruptedException {
/*  72 */       NullWritable dummyKey = NullWritable.get();
/*  73 */       for (Shape s : value) {
/*  74 */         context.write(dummyKey, s);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public static Job rangeQueryMapReduce(Path inFile, Path outFile, OperationsParams params) throws IOException, ClassNotFoundException, InterruptedException {
/*  82 */     params.set("rect", params.get("rect"));
/*     */     
/*  84 */     params.setInt("mapreduce.local.map.tasks.maximum", Runtime.getRuntime().availableProcessors());
/*     */     
/*  86 */     Job job = new Job((Configuration)params, "RangeQuery");
/*  87 */     job.setJarByClass(RangeQuery.class);
/*  88 */     job.setNumReduceTasks(0);
/*     */     
/*  90 */     job.setInputFormatClass(SpatialInputFormat3.class);
/*  91 */     SpatialInputFormat3.setInputPaths(job, new Path[] { inFile });
/*     */     
/*  93 */     job.setMapperClass(RangeQueryMap.class);
/*     */     
/*  95 */     if (params.getBoolean("output", true) && outFile != null) {
/*  96 */       job.setOutputFormatClass(TextOutputFormat3.class);
/*  97 */       TextOutputFormat3.setOutputPath(job, outFile);
/*     */     } else {
/*     */       
/* 100 */       job.setOutputFormatClass(NullOutputFormat.class);
/*     */     } 
/*     */     
/* 103 */     if (!params.getBoolean("background", false)) {
/* 104 */       job.waitForCompletion(false);
/*     */     } else {
/* 106 */       job.submit();
/*     */     } 
/* 108 */     return job;
/*     */   }
/*     */   
/*     */   public static List<Path> getIndexedSlices(OperationsParams params) throws Exception {
/* 112 */     List<Path> slices = null;
/* 113 */     Path indexPath = params.getInputPath();
/* 114 */     Path outputPath = params.getOutputPath();
/* 115 */     String fromto = params.get("interval");
/* 116 */     String level = params.get("time");
/* 117 */     if (fromto.contains(",")) {
/*     */       
/* 119 */       String[] time = fromto.split(",");
/* 120 */       String fromTime = time[0];
/* 121 */       String toTime = time[1];
/* 122 */       QueryPlanner plan = new QueryPlanner(params);
/* 123 */       if (level != null) {
/* 124 */         slices = plan.getQueryPlanFromResolution(fromTime, toTime, level);
/*     */       } else {
/* 126 */         slices = plan.getQueryPlan(fromTime, toTime);
/*     */       } 
/* 128 */       return slices;
/*     */     } 
/*     */     
/* 131 */     return slices;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static <S extends Shape> long rangeQueryLocal(Path inPath, Shape queryRange, S shape, final OperationsParams params, final ResultCollector<S> output) throws IOException, InterruptedException {
/* 156 */     OperationsParams.setShape((Configuration)params, "rect", (Shape)queryRange.getMBR());
/*     */ 
/*     */     
/* 159 */     final SpatialInputFormat3<Rectangle, S> inputFormat = new SpatialInputFormat3();
/* 160 */     Job job = Job.getInstance((Configuration)params);
/* 161 */     SpatialInputFormat3.setInputPaths(job, new Path[] { inPath });
/* 162 */     final List<InputSplit> splits = inputFormat.getSplits((JobContext)job);
/*     */ 
/*     */     
/* 165 */     List<Long> results = Parallel.forEach(splits.size(), new Parallel.RunnableRange<Long>()
/*     */         {
/*     */           public Long run(int i1, int i2) {
/* 168 */             long results = 0L;
/* 169 */             for (int i = i1; i < i2; i++) {
/*     */               try {
/* 171 */                 FileSplit fsplit = splits.get(i);
/* 172 */                 RecordReader<Rectangle, Iterable<S>> reader = inputFormat.createRecordReader((InputSplit)fsplit, 
/* 173 */                     null);
/* 174 */                 if (reader instanceof SpatialRecordReader3) {
/* 175 */                   ((SpatialRecordReader3)reader).initialize((InputSplit)fsplit, (Configuration)params);
/* 176 */                 } else if (reader instanceof RTreeRecordReader3) {
/* 177 */                   ((RTreeRecordReader3)reader).initialize((InputSplit)fsplit, (Configuration)params);
/*     */                 } else {
/* 179 */                   throw new RuntimeException("Unknown record reader");
/*     */                 } 
/* 181 */                 while (reader.nextKeyValue()) {
/* 182 */                   Iterable<S> shapes = (Iterable<S>)reader.getCurrentValue();
/* 183 */                   for (Shape s : shapes) {
/* 184 */                     results++;
/* 185 */                     if (output != null)
/* 186 */                       output.collect(s); 
/*     */                   } 
/*     */                 } 
/* 189 */                 reader.close();
/* 190 */               } catch (IOException e) {
/* 191 */                 STRangeQuery.LOG.error("Error processing split " + splits.get(i), e);
/* 192 */               } catch (InterruptedException e) {
/* 193 */                 STRangeQuery.LOG.error("Error processing split " + splits.get(i), e);
/*     */               } 
/*     */             } 
/* 196 */             return Long.valueOf(results);
/*     */           }
/*     */         });
/* 199 */     long totalResultSize = 0L;
/* 200 */     for (Iterator<Long> iterator = results.iterator(); iterator.hasNext(); ) { long result = ((Long)iterator.next()).longValue();
/* 201 */       totalResultSize += result; }
/* 202 */      return totalResultSize;
/*     */   }
/*     */   
/*     */   private static void printUsage() {
/* 206 */     System.out.println("Runs a spatio-temporal range query on indexed data");
/* 207 */     System.out.println("Parameters: (* marks required parameters)");
/* 208 */     System.out.println("<input file> - (*) Path to input file");
/* 209 */     System.out.println("<output file> -  Path to input file");
/* 210 */     System.out.println("shape:<STPoint> - (*) Type of shapes stored in input file");
/* 211 */     System.out.println("rect:<x1,y1,x2,y2> - Spatial query range");
/* 212 */     System.out.println(
/* 213 */         "interval:<date1,date2> - Temporal query range. Format of each date is yyyy-mm-dd");
/* 214 */     System.out.println("time:[day,week,month,year] -  Time Format");
/* 215 */     System.out.println("-overwrite - Overwrite output file without notice");
/* 216 */     GenericOptionsParser.printGenericCommandUsage(System.out);
/*     */   }
/*     */   
/*     */   public static void rangeQueryOperation(OperationsParams parameters) throws Exception {
/* 220 */     OperationsParams params = parameters;
/*     */     
/* 222 */     Path[] paths = params.getPaths();
/* 223 */     if (paths.length <= 1 && !params.checkInput()) {
/* 224 */       printUsage();
/* 225 */       System.exit(1);
/*     */     } 
/* 227 */     if (paths.length >= 2 && !params.checkInputOutput()) {
/* 228 */       printUsage();
/* 229 */       System.exit(1);
/*     */     } 
/* 231 */     if (params.get("rect") == null) {
/* 232 */       String x1 = "-" + Double.toString(Double.MAX_VALUE);
/* 233 */       String y1 = "-" + Double.toString(Double.MAX_VALUE);
/* 234 */       String x2 = Double.toString(Double.MAX_VALUE);
/* 235 */       String y2 = Double.toString(Double.MAX_VALUE);
/* 236 */       System.out.println(String.valueOf(x1) + "," + y1 + "," + x2 + "," + y2);
/* 237 */       params.set("rect", String.valueOf(x1) + "," + y1 + "," + x2 + "," + y2);
/*     */     } 
/*     */ 
/*     */ 
/*     */ 
/*     */     
/* 243 */     if (params.get("interval") == null) {
/* 244 */       System.err.println("Temporal range missing");
/* 245 */       printUsage();
/* 246 */       System.exit(1);
/*     */     } 
/*     */     
/* 249 */     Shape shape = params.getShape("shape");
/* 250 */     if (!(shape instanceof com.dlmu.wisdomST.core.STPoint) && !(shape instanceof com.dlmu.wisdomST.core.STRectangle)) {
/* 251 */       LOG.error("Shape is not instance of STPoint or STRectangle");
/* 252 */       printUsage();
/* 253 */       System.exit(1);
/*     */     } 
/*     */ 
/*     */     
/* 257 */     List<Path> STPaths = getIndexedSlices(params);
/* 258 */     Path outPath = params.getOutputPath();
/* 259 */     Rectangle[] queryRanges = (Rectangle[])params.getShapes("rect", (Shape)new Rectangle());
/*     */ 
/*     */     
/* 262 */     final Vector<Long> resultsCounts = new Vector<Long>();
/* 263 */     Vector<Job> jobs = new Vector<Job>();
/* 264 */     Vector<Thread> threads = new Vector<Thread>();
/*     */     
/* 266 */     long t1 = System.currentTimeMillis();
/* 267 */     for (Path stPath : STPaths) {
/* 268 */       final Path inPath = stPath;
/* 269 */       for (int i = 0; i < queryRanges.length; i++) {
/* 270 */         final OperationsParams queryParams = new OperationsParams(params);
/* 271 */         OperationsParams.setShape((Configuration)queryParams, "rect", (Shape)queryRanges[i]);
/* 272 */         if (OperationsParams.isLocal((Configuration)new JobConf((Configuration)queryParams), new Path[] { inPath })) {
/*     */           
/* 274 */           final Rectangle queryRange = queryRanges[i];
/* 275 */           final Shape shape = queryParams.getShape("shape");
/* 276 */           final Path output = (outPath == null) ? null : (
/* 277 */             (queryRanges.length == 1) ? outPath : new Path(outPath, String.format("%05d", new Object[] { Integer.valueOf(i) })));
/* 278 */           Thread thread = new Thread()
/*     */             {
/*     */               public void run() {
/* 281 */                 FSDataOutputStream outFile = null;
/* 282 */                 final byte[] newLine = System.getProperty("line.separator", "\n").getBytes();
/*     */                 try {
/* 284 */                   ResultCollector<Shape> collector = null;
/* 285 */                   if (output != null) {
/* 286 */                     FileSystem outFS = output.getFileSystem((Configuration)queryParams);
/* 287 */                     final FSDataOutputStream foutFile = outFile = outFS.create(output);
/* 288 */                     collector = new ResultCollector<Shape>() {
/* 289 */                         final Text tempText = (Text)new Text2();
/*     */ 
/*     */                         
/*     */                         public synchronized void collect(Shape r) {
/*     */                           try {
/* 294 */                             this.tempText.clear();
/* 295 */                             r.toText(this.tempText);
/* 296 */                             foutFile.write(this.tempText.getBytes(), 0, this.tempText.getLength());
/* 297 */                             foutFile.write(newLine);
/* 298 */                           } catch (IOException e) {
/* 299 */                             e.printStackTrace();
/*     */                           } 
/*     */                         }
/*     */                       };
/*     */                   } else {
/* 304 */                     outFile = null;
/*     */                   } 
/* 306 */                   long resultCount = STRangeQuery.rangeQueryLocal(inPath, (Shape)queryRange, shape, queryParams, collector);
/* 307 */                   resultsCounts.add(Long.valueOf(resultCount));
/* 308 */                 } catch (IOException e) {
/* 309 */                   e.printStackTrace();
/* 310 */                 } catch (InterruptedException e) {
/* 311 */                   e.printStackTrace();
/*     */                 } finally {
/*     */                   try {
/* 314 */                     if (outFile != null)
/* 315 */                       outFile.close(); 
/* 316 */                   } catch (IOException e) {
/* 317 */                     e.printStackTrace();
/*     */                   } 
/*     */                 } 
/*     */               }
/*     */             };
/* 322 */           thread.start();
/* 323 */           threads.add(thread);
/*     */         } else {
/*     */           
/* 326 */           Path outTempPath = (outPath == null) ? null : new Path(outPath, String.valueOf(String.format("%05d", new Object[] { Integer.valueOf(i) })) + "-" + inPath.getName());
/* 327 */           queryParams.setBoolean("background", true);
/* 328 */           Job job = rangeQueryMapReduce(inPath, outTempPath, queryParams);
/* 329 */           jobs.add(job);
/*     */         } 
/*     */       } 
/*     */     } 
/*     */     
/* 334 */     while (!jobs.isEmpty()) {
/* 335 */       Job firstJob = jobs.firstElement();
/* 336 */       firstJob.waitForCompletion(false);
/* 337 */       if (!firstJob.isSuccessful()) {
/* 338 */         System.err.println("Error running job " + firstJob);
/* 339 */         System.err.println("Killing all remaining jobs");
/* 340 */         for (int j = 1; j < jobs.size(); j++)
/* 341 */           ((Job)jobs.get(j)).killJob(); 
/* 342 */         System.exit(1);
/*     */       } 
/* 344 */       Counters counters = firstJob.getCounters();
/* 345 */       Counter outputRecordCounter = counters.findCounter((Enum)Task.Counter.MAP_OUTPUT_RECORDS);
/* 346 */       resultsCounts.add(Long.valueOf(outputRecordCounter.getValue()));
/* 347 */       jobs.remove(0);
/*     */     } 
/* 349 */     while (!threads.isEmpty()) {
/*     */       try {
/* 351 */         Thread thread = threads.firstElement();
/* 352 */         thread.join();
/* 353 */         threads.remove(0);
/* 354 */       } catch (InterruptedException e) {
/* 355 */         e.printStackTrace();
/*     */       } 
/*     */     } 
/* 358 */     long t2 = System.currentTimeMillis();
/* 359 */     System.out.println("QueryPlan:");
/* 360 */     for (Path stPath : STPaths) {
/* 361 */       System.out.println(stPath.getName());
/*     */     }
/* 363 */     System.out.println("Time for " + queryRanges.length + " jobs is " + (t2 - t1) + " millis");
/* 364 */     System.out.println("Results counts: " + resultsCounts);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static void main(String[] args) throws Exception {
/* 386 */     OperationsParams params = new OperationsParams(new GenericOptionsParser(args));
/*     */     
/* 388 */     Path[] paths = params.getPaths();
/* 389 */     if (paths.length <= 1 && !params.checkInput()) {
/* 390 */       printUsage();
/* 391 */       System.exit(1);
/*     */     } 
/* 393 */     if (paths.length >= 2 && !params.checkInputOutput()) {
/* 394 */       printUsage();
/* 395 */       System.exit(1);
/*     */     } 
/* 397 */     if (params.get("rect") == null) {
/* 398 */       String x1 = "-" + Double.toString(Double.MAX_VALUE);
/* 399 */       String y1 = "-" + Double.toString(Double.MAX_VALUE);
/* 400 */       String x2 = Double.toString(Double.MAX_VALUE);
/* 401 */       String y2 = Double.toString(Double.MAX_VALUE);
/* 402 */       System.out.println(String.valueOf(x1) + "," + y1 + "," + x2 + "," + y2);
/* 403 */       params.set("rect", String.valueOf(x1) + "," + y1 + "," + x2 + "," + y2);
/*     */     } 
/*     */ 
/*     */ 
/*     */ 
/*     */     
/* 409 */     if (params.get("interval") == null) {
/* 410 */       System.err.println("Temporal range missing");
/* 411 */       printUsage();
/* 412 */       System.exit(1);
/*     */     } 
/*     */     
/* 415 */     Shape shape = params.getShape("shape");
/* 416 */     if (!(shape instanceof com.dlmu.wisdomST.core.STPoint) && !(shape instanceof com.dlmu.wisdomST.core.STRectangle)) {
/* 417 */       LOG.error("Shape is not instance of STPoint or STRectangle");
/* 418 */       printUsage();
/* 419 */       System.exit(1);
/*     */     } 
/*     */ 
/*     */     
/* 423 */     List<Path> STPaths = getIndexedSlices(params);
/* 424 */     Path outPath = params.getOutputPath();
/* 425 */     Rectangle[] queryRanges = (Rectangle[])params.getShapes("rect", (Shape)new Rectangle());
/*     */ 
/*     */     
/* 428 */     final Vector<Long> resultsCounts = new Vector<Long>();
/* 429 */     Vector<Job> jobs = new Vector<Job>();
/* 430 */     Vector<Thread> threads = new Vector<Thread>();
/*     */     
/* 432 */     long t1 = System.currentTimeMillis();
/* 433 */     for (Path stPath : STPaths) {
/* 434 */       final Path inPath = stPath;
/* 435 */       for (int i = 0; i < queryRanges.length; i++) {
/* 436 */         final OperationsParams queryParams = new OperationsParams(params);
/* 437 */         OperationsParams.setShape((Configuration)queryParams, "rect", (Shape)queryRanges[i]);
/* 438 */         if (OperationsParams.isLocal((Configuration)new JobConf((Configuration)queryParams), new Path[] { inPath })) {
/*     */           
/* 440 */           final Rectangle queryRange = queryRanges[i];
/* 441 */           final Shape shape = queryParams.getShape("shape");
/* 442 */           final Path output = (outPath == null) ? null : (
/* 443 */             (queryRanges.length == 1) ? outPath : new Path(outPath, String.format("%05d", new Object[] { Integer.valueOf(i) })));
/* 444 */           Thread thread = new Thread()
/*     */             {
/*     */               public void run() {
/* 447 */                 FSDataOutputStream outFile = null;
/* 448 */                 final byte[] newLine = System.getProperty("line.separator", "\n").getBytes();
/*     */                 try {
/* 450 */                   ResultCollector<Shape> collector = null;
/* 451 */                   if (output != null) {
/* 452 */                     FileSystem outFS = output.getFileSystem((Configuration)queryParams);
/* 453 */                     final FSDataOutputStream foutFile = outFile = outFS.create(output);
/* 454 */                     collector = new ResultCollector<Shape>() {
/* 455 */                         final Text tempText = (Text)new Text2();
/*     */ 
/*     */                         
/*     */                         public synchronized void collect(Shape r) {
/*     */                           try {
/* 460 */                             this.tempText.clear();
/* 461 */                             r.toText(this.tempText);
/* 462 */                             foutFile.write(this.tempText.getBytes(), 0, this.tempText.getLength());
/* 463 */                             foutFile.write(newLine);
/* 464 */                           } catch (IOException e) {
/* 465 */                             e.printStackTrace();
/*     */                           } 
/*     */                         }
/*     */                       };
/*     */                   } else {
/* 470 */                     outFile = null;
/*     */                   } 
/* 472 */                   long resultCount = STRangeQuery.rangeQueryLocal(inPath, (Shape)queryRange, shape, queryParams, collector);
/* 473 */                   resultsCounts.add(Long.valueOf(resultCount));
/* 474 */                 } catch (IOException e) {
/* 475 */                   e.printStackTrace();
/* 476 */                 } catch (InterruptedException e) {
/* 477 */                   e.printStackTrace();
/*     */                 } finally {
/*     */                   try {
/* 480 */                     if (outFile != null)
/* 481 */                       outFile.close(); 
/* 482 */                   } catch (IOException e) {
/* 483 */                     e.printStackTrace();
/*     */                   } 
/*     */                 } 
/*     */               }
/*     */             };
/* 488 */           thread.start();
/* 489 */           threads.add(thread);
/*     */         } else {
/*     */           
/* 492 */           Path outTempPath = (outPath == null) ? null : new Path(outPath, String.valueOf(String.format("%05d", new Object[] { Integer.valueOf(i) })) + "-" + inPath.getName());
/* 493 */           queryParams.setBoolean("background", true);
/* 494 */           Job job = rangeQueryMapReduce(inPath, outTempPath, queryParams);
/* 495 */           jobs.add(job);
/*     */         } 
/*     */       } 
/*     */     } 
/*     */     
/* 500 */     while (!jobs.isEmpty()) {
/* 501 */       Job firstJob = jobs.firstElement();
/* 502 */       firstJob.waitForCompletion(false);
/* 503 */       if (!firstJob.isSuccessful()) {
/* 504 */         System.err.println("Error running job " + firstJob);
/* 505 */         System.err.println("Killing all remaining jobs");
/* 506 */         for (int j = 1; j < jobs.size(); j++)
/* 507 */           ((Job)jobs.get(j)).killJob(); 
/* 508 */         System.exit(1);
/*     */       } 
/* 510 */       Counters counters = firstJob.getCounters();
/* 511 */       Counter outputRecordCounter = counters.findCounter((Enum)Task.Counter.MAP_OUTPUT_RECORDS);
/* 512 */       resultsCounts.add(Long.valueOf(outputRecordCounter.getValue()));
/* 513 */       jobs.remove(0);
/*     */     } 
/* 515 */     while (!threads.isEmpty()) {
/*     */       try {
/* 517 */         Thread thread = threads.firstElement();
/* 518 */         thread.join();
/* 519 */         threads.remove(0);
/* 520 */       } catch (InterruptedException e) {
/* 521 */         e.printStackTrace();
/*     */       } 
/*     */     } 
/* 524 */     long t2 = System.currentTimeMillis();
/* 525 */     System.out.println("QueryPlan:");
/* 526 */     for (Path stPath : STPaths) {
/* 527 */       System.out.println(stPath.getName());
/*     */     }
/* 529 */     System.out.println("Time for " + queryRanges.length + " jobs is " + (t2 - t1) + " millis");
/* 530 */     System.out.println("Results counts: " + resultsCounts);
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\STRangeQuery.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */