/*     */ package com.dlmu.wisdomST.operation;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.IPoint;
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import com.dlmu.wisdomST.io.Text2;
/*     */ import com.dlmu.wisdomST.io.TextSerializable;
/*     */ import com.dlmu.wisdomST.mapreduce.ShapeLineInputFormat1D;
/*     */ import com.dlmu.wisdomST.mapreduce.ShapeLineRecordReader1D;
/*     */ import com.dlmu.wisdomST.mapreduce.TextOutputFormat;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import java.io.IOException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Iterator;
/*     */ import java.util.Random;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.FileStatus;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.fs.PathFilter;
/*     */ import org.apache.hadoop.io.IntWritable;
/*     */ import org.apache.hadoop.io.LongWritable;
/*     */ import org.apache.hadoop.io.NullWritable;
/*     */ import org.apache.hadoop.io.Text;
/*     */ import org.apache.hadoop.mapred.ClusterStatus;
/*     */ import org.apache.hadoop.mapred.Counters;
/*     */ import org.apache.hadoop.mapred.FileSplit;
/*     */ import org.apache.hadoop.mapred.InputSplit;
/*     */ import org.apache.hadoop.mapred.JobClient;
/*     */ import org.apache.hadoop.mapred.JobConf;
/*     */ import org.apache.hadoop.mapred.MapReduceBase;
/*     */ import org.apache.hadoop.mapred.Mapper;
/*     */ import org.apache.hadoop.mapred.OutputCollector;
/*     */ import org.apache.hadoop.mapred.RecordReader;
/*     */ import org.apache.hadoop.mapred.Reducer;
/*     */ import org.apache.hadoop.mapred.Reporter;
/*     */ import org.apache.hadoop.mapred.RunningJob;
/*     */ import org.apache.hadoop.mapred.Task;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class Sampler1D
/*     */ {
/*  64 */   private static final Log LOG = LogFactory.getLog(Sampler1D.class);
/*     */   
/*     */   public static long sizeOfLastProcessedFile;
/*     */ 
/*     */   
/*     */   public static class Map
/*     */     extends MapReduceBase
/*     */     implements Mapper<Segment, Text, IntWritable, Text>
/*     */   {
/*     */     private double sampleRatio;
/*     */     
/*     */     private Random random;
/*     */     
/*     */     private IntWritable key;
/*     */     private Shape1D inShape;
/*     */     Conversion conversion;
/*     */     
/*     */     public Map() {
/*  82 */       this.key = new IntWritable((int)(Math.random() * 2.147483647E9D));
/*     */     }
/*     */     
/*     */     enum Conversion
/*     */     {
/*  87 */       None, ShapeToPoint, ShapeToRect;
/*     */     }
/*     */ 
/*     */     
/*     */     public void configure(JobConf job) {
/*  92 */       this.sampleRatio = job.getFloat("ratio", 0.01F);
/*  93 */       this.random = new Random(job.getLong("seed", System.currentTimeMillis()));
/*     */       
/*  95 */       TextSerializable inObj = OperationsParams.getTextSerializable((Configuration)job, "shape", (TextSerializable)new Text2());
/*  96 */       TextSerializable outObj = OperationsParams.getTextSerializable((Configuration)job, "outshape", (TextSerializable)new Text2());
/*     */       
/*  98 */       if (inObj.getClass() == outObj.getClass()) {
/*  99 */         this.conversion = Conversion.None;
/*     */       }
/* 101 */       else if (inObj instanceof Shape1D && outObj instanceof IPoint) {
/* 102 */         this.inShape = (Shape1D)inObj;
/* 103 */         this.conversion = Conversion.ShapeToPoint;
/* 104 */       } else if (inObj instanceof Shape1D && outObj instanceof Segment) {
/* 105 */         this.inShape = (Shape1D)inObj;
/* 106 */         this.conversion = Conversion.ShapeToRect;
/* 107 */       } else if (outObj instanceof Text) {
/* 108 */         this.conversion = Conversion.None;
/*     */       } else {
/* 110 */         throw new RuntimeException("Don't know how to convert from: " + 
/* 111 */             inObj.getClass() + " to " + outObj.getClass());
/*     */       } 
/*     */       
/* 114 */       System.out.println("conversion:" + this.conversion.name());
/*     */     }
/*     */ 
/*     */ 
/*     */     
/*     */     public void map(Segment cell, Text line, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
/* 120 */       if (this.random.nextFloat() < this.sampleRatio) {
/*     */         Segment mbr;
/* 122 */         switch (this.conversion) {
/*     */           case null:
/* 124 */             output.collect(this.key, line);
/*     */             break;
/*     */           case ShapeToPoint:
/* 127 */             this.inShape.fromText(line);
/*     */ 
/*     */             
/* 130 */             mbr = this.inShape.getSegment();
/*     */             
/* 132 */             if (mbr != null) {
/*     */               
/* 134 */               IPoint center = mbr.getCenterPoint();
/*     */ 
/*     */               
/* 137 */               line.clear();
/* 138 */               center.toText(line);
/*     */               
/* 140 */               output.collect(this.key, line);
/*     */             } 
/*     */             break;
/*     */           case ShapeToRect:
/* 144 */             this.inShape.fromText(line);
/* 145 */             mbr = this.inShape.getSegment();
/* 146 */             if (mbr != null) {
/* 147 */               line.clear();
/* 148 */               mbr.toText(line);
/* 149 */               output.collect(this.key, line);
/*     */             } 
/*     */             break;
/*     */         } 
/*     */       } 
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static class Reduce
/*     */     extends MapReduceBase
/*     */     implements Reducer<IntWritable, Text, NullWritable, Text>
/*     */   {
/*     */     public void reduce(IntWritable dummy, Iterator<Text> values, OutputCollector<NullWritable, Text> output, Reporter reporter) throws IOException {
/* 170 */       while (values.hasNext()) {
/* 171 */         Text x = values.next();
/* 172 */         output.collect(NullWritable.get(), x);
/*     */       } 
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static <T extends TextSerializable> int sampleMapReduceWithRatio(Path[] files, ResultCollector<T> output, OperationsParams params) throws IOException {
/*     */     Path outputPath;
/* 194 */     JobConf job = new JobConf((Configuration)params, Sampler1D.class);
/*     */ 
/*     */     
/* 197 */     FileSystem outFs = FileSystem.get((Configuration)job);
/*     */     do {
/* 199 */       outputPath = new Path(String.valueOf(files[0].toUri().getPath()) + 
/* 200 */           ".sample_" + (int)(Math.random() * 1000000.0D));
/* 201 */     } while (outFs.exists(outputPath));
/*     */     
/* 203 */     job.setJobName("Sample");
/* 204 */     job.setMapOutputKeyClass(IntWritable.class);
/* 205 */     job.setMapOutputValueClass(Text.class);
/*     */     
/* 207 */     job.setMapperClass(Map.class);
/* 208 */     job.setReducerClass(Reduce.class);
/*     */     
/* 210 */     ClusterStatus clusterStatus = (new JobClient(job)).getClusterStatus();
/* 211 */     job.setNumMapTasks(clusterStatus.getMaxMapTasks() * 5);
/*     */ 
/*     */     
/* 214 */     job.setNumReduceTasks(
/* 215 */         Math.max(1, clusterStatus.getMaxReduceTasks() * 9 / 10));
/*     */     
/* 217 */     job.setInputFormat(ShapeLineInputFormat1D.class);
/* 218 */     job.setOutputFormat(TextOutputFormat.class);
/*     */     
/* 220 */     ShapeLineInputFormat1D.setInputPaths(job, files);
/* 221 */     TextOutputFormat.setOutputPath(job, outputPath);
/*     */ 
/*     */     
/* 224 */     RunningJob run_job = JobClient.runJob(job);
/*     */     
/* 226 */     Counters counters = run_job.getCounters();
/* 227 */     Counters.Counter outputRecordCounter = (Counters.Counter)counters.findCounter((Enum)Task.Counter.MAP_OUTPUT_RECORDS);
/* 228 */     long resultCount = outputRecordCounter.getValue();
/*     */     
/* 230 */     Counters.Counter outputSizeConter = (Counters.Counter)counters.findCounter((Enum)Task.Counter.MAP_OUTPUT_BYTES);
/* 231 */     long sampleSize = outputSizeConter.getValue();
/*     */     
/* 233 */     LOG.info("resultSize: " + sampleSize);
/* 234 */     LOG.info("resultCount: " + resultCount);
/*     */     
/* 236 */     Counters.Counter inputBytesCounter = (Counters.Counter)counters.findCounter((Enum)Task.Counter.MAP_INPUT_BYTES);
/* 237 */     sizeOfLastProcessedFile = inputBytesCounter.getValue();
/*     */ 
/*     */ 
/*     */ 
/*     */     
/* 242 */     long desiredSampleSize = job.getLong("size", 0L);
/*     */     
/* 244 */     float selectRatio = (desiredSampleSize <= 0L) ? 2.0F : ((float)desiredSampleSize / (float)sampleSize);
/*     */ 
/*     */     
/* 247 */     int result_size = 0;
/* 248 */     if (selectRatio > 1.0F) {
/*     */       
/* 250 */       ShapeLineInputFormat1D inputFormat = new ShapeLineInputFormat1D();
/* 251 */       ShapeLineInputFormat1D.setInputPaths(job, new Path[] { outputPath });
/* 252 */       InputSplit[] splits = inputFormat.getSplits(job, 1); byte b; int i; InputSplit[] arrayOfInputSplit1;
/* 253 */       for (i = (arrayOfInputSplit1 = splits).length, b = 0; b < i; ) { InputSplit split = arrayOfInputSplit1[b];
/* 254 */         RecordReader<Segment, Text> reader = inputFormat.getRecordReader(split, job, null);
/* 255 */         Segment key = (Segment)reader.createKey();
/* 256 */         Text value = (Text)reader.createValue();
/* 257 */         TextSerializable textSerializable = OperationsParams.getTextSerializable((Configuration)params, "outshape", (TextSerializable)new Text2());
/* 258 */         while (reader.next(key, value)) {
/*     */           
/* 260 */           textSerializable.fromText(value);
/* 261 */           output.collect(textSerializable);
/*     */         } 
/* 263 */         reader.close();
/*     */         b++; }
/*     */     
/* 266 */     } else if (output != null) {
/* 267 */       OperationsParams params2 = new OperationsParams(params);
/* 268 */       params2.setFloat("ratio", selectRatio);
/* 269 */       params2.set("shape", params.get("outshape"));
/* 270 */       params2.set("outshape", params.get("outshape"));
/* 271 */       if (selectRatio > 0.1D) {
/* 272 */         LOG.info("Local return " + selectRatio + " of " + resultCount + " records");
/*     */         
/* 274 */         long tempSize = sizeOfLastProcessedFile;
/*     */ 
/*     */ 
/*     */         
/* 278 */         result_size = sampleLocalWithRatio(new Path[] { outputPath
/* 279 */             }, output, params2);
/* 280 */         sizeOfLastProcessedFile = tempSize;
/*     */       } else {
/* 282 */         LOG.info("MapReduce return " + selectRatio + " of " + resultCount + " records");
/*     */         
/* 284 */         long tempSize = sizeOfLastProcessedFile;
/*     */ 
/*     */ 
/*     */         
/* 288 */         result_size = sampleMapReduceWithRatio(new Path[] { outputPath
/* 289 */             }, output, params2);
/* 290 */         sizeOfLastProcessedFile = tempSize;
/*     */       } 
/*     */     } 
/*     */ 
/*     */     
/* 295 */     outFs.delete(outputPath, true);
/*     */     
/* 297 */     return result_size;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static <O extends TextSerializable, T extends TextSerializable> ResultCollector<T> createConverter(final ResultCollector<O> output, T inObj, final O outObj) {
/* 315 */     if (output == null)
/* 316 */       return null; 
/* 317 */     if (inObj.getClass() == outObj.getClass())
/* 318 */       return new ResultCollector<T>()
/*     */         {
/*     */           public void collect(T r) {
/* 321 */             output.collect(r);
/*     */           }
/*     */         }; 
/* 324 */     if (inObj instanceof Shape1D && outObj instanceof IPoint) {
/* 325 */       final IPoint out_pt = (IPoint)outObj;
/* 326 */       return new ResultCollector<T>()
/*     */         {
/*     */           public void collect(T r) {
/* 329 */             Shape1D s = (Shape1D)r;
/* 330 */             if (s == null)
/*     */               return; 
/* 332 */             Segment mbr = s.getSegment();
/* 333 */             if (mbr == null)
/*     */               return; 
/* 335 */             IPoint pt = mbr.getCenterPoint();
/* 336 */             out_pt.x = pt.x;
/* 337 */             output.collect(outObj); }
/*     */         };
/*     */     } 
/* 340 */     if (inObj instanceof Shape1D && outObj instanceof Segment) {
/* 341 */       final Segment out_rect = (Segment)outObj;
/* 342 */       return new ResultCollector<T>()
/*     */         {
/*     */           public void collect(T r) {
/* 345 */             out_rect.set((Shape1D)r);
/* 346 */             output.collect(outObj); }
/*     */         };
/*     */     } 
/* 349 */     if (outObj instanceof Text) {
/* 350 */       final Text text = (Text)outObj;
/* 351 */       return new ResultCollector<T>()
/*     */         {
/*     */           public void collect(T r) {
/* 354 */             text.clear();
/* 355 */             r.toText(text);
/* 356 */             output.collect(outObj); }
/*     */         };
/*     */     } 
/* 359 */     if (inObj instanceof Text) {
/* 360 */       final Text text = (Text)inObj;
/* 361 */       return new ResultCollector<T>()
/*     */         {
/*     */           public void collect(T r) {
/* 364 */             outObj.fromText(text);
/* 365 */             output.collect(outObj);
/*     */           }
/*     */         };
/*     */     } 
/* 369 */     throw new RuntimeException("Cannot convert from " + inObj.getClass() + 
/* 370 */         " to " + outObj.getClass());
/*     */   }
/*     */ 
/*     */   
/* 374 */   private static final PathFilter hiddenFileFilter = new PathFilter() {
/*     */       public boolean accept(Path p) {
/* 376 */         String name = p.getName();
/* 377 */         return (!name.startsWith("_") && !name.startsWith("."));
/*     */       }
/*     */     };
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static <T extends TextSerializable> int sampleLocalWithSize(Path[] files, ResultCollector<T> output, OperationsParams params) throws IOException {
/* 385 */     int average_record_size = 1024;
/* 386 */     final LongWritable current_sample_size = new LongWritable();
/* 387 */     int sample_count = 0;
/*     */ 
/*     */     
/* 390 */     TextSerializable inObj1 = OperationsParams.getTextSerializable((Configuration)params, "shape", (TextSerializable)new Text2());
/* 391 */     TextSerializable outObj1 = OperationsParams.getTextSerializable((Configuration)params, "outshape", (TextSerializable)new Text2());
/*     */ 
/*     */     
/* 394 */     final TextSerializable inObj = inObj1;
/* 395 */     TextSerializable textSerializable1 = outObj1;
/* 396 */     final ResultCollector<TextSerializable> converter = createConverter(output, inObj, textSerializable1);
/*     */     
/* 398 */     ResultCollector<Text2> counter = new ResultCollector<Text2>()
/*     */       {
/*     */         public void collect(Text2 r) {
/* 401 */           current_sample_size.set(current_sample_size.get() + r.getLength());
/* 402 */           inObj.fromText((Text)r);
/* 403 */           converter.collect(inObj);
/*     */         }
/*     */       };
/*     */     
/* 407 */     long total_size = params.getLong("size", 0L);
/* 408 */     long seed = params.getLong("seed", System.currentTimeMillis());
/*     */     
/* 410 */     while (current_sample_size.get() < total_size) {
/* 411 */       int count = (int)((total_size - current_sample_size.get()) / average_record_size);
/* 412 */       if (count < 10) {
/* 413 */         count = 10;
/*     */       }
/* 415 */       OperationsParams params2 = new OperationsParams(params);
/* 416 */       params2.setClass("shape", Text2.class, TextSerializable.class);
/* 417 */       params2.setClass("outshape", Text2.class, TextSerializable.class);
/* 418 */       params2.setInt("count", count);
/* 419 */       params2.setLong("seed", seed);
/* 420 */       sample_count += sampleLocalByCount(files, counter, params2);
/*     */ 
/*     */ 
/*     */       
/* 424 */       seed += sample_count;
/*     */       
/* 426 */       average_record_size = (int)(current_sample_size.get() / sample_count);
/*     */     } 
/* 428 */     return sample_count;
/*     */   }
/*     */ 
/*     */   
/*     */   private static <T extends TextSerializable> int sampleLocalWithRatio(Path[] files, ResultCollector<T> output, OperationsParams params) throws IOException {
/* 433 */     long total_size = 0L; byte b;
/*     */     int i;
/*     */     Path[] arrayOfPath;
/* 436 */     for (i = (arrayOfPath = files).length, b = 0; b < i; ) { Path file = arrayOfPath[b];
/* 437 */       FileSystem fs = file.getFileSystem((Configuration)params);
/* 438 */       FileStatus fStatus = fs.getFileStatus(file);
/* 439 */       if (fStatus.isDir()) {
/*     */         byte b1; int j; FileStatus[] arrayOfFileStatus;
/* 441 */         for (j = (arrayOfFileStatus = fs.listStatus(file)).length, b1 = 0; b1 < j; ) { FileStatus subFStatus = arrayOfFileStatus[b1];
/* 442 */           if (!subFStatus.isDir())
/* 443 */             total_size += subFStatus.getLen();  b1++; }
/*     */       
/*     */       } else {
/* 446 */         total_size += fStatus.getLen();
/*     */       }  b++; }
/*     */     
/* 449 */     sizeOfLastProcessedFile = total_size;
/* 450 */     float ratio = params.getFloat("ratio", 0.1F);
/* 451 */     params.setLong("size", (long)((float)total_size * ratio));
/* 452 */     return sampleLocalWithSize(files, output, params);
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   private static <T extends TextSerializable> int sampleLocalByCount(Path[] files, ResultCollector<T> output, OperationsParams params) throws IOException {
/* 458 */     ArrayList<Path> data_files = new ArrayList<Path>(); byte b; int j; Path[] arrayOfPath;
/* 459 */     for (j = (arrayOfPath = files).length, b = 0; b < j; ) { Path file = arrayOfPath[b];
/* 460 */       FileSystem fs = file.getFileSystem((Configuration)params);
/* 461 */       if (fs.getFileStatus(file).isDir()) {
/*     */         
/* 463 */         FileStatus[] fileStatus = fs.listStatus(file, hiddenFileFilter); byte b1; int k; FileStatus[] arrayOfFileStatus1;
/* 464 */         for (k = (arrayOfFileStatus1 = fileStatus).length, b1 = 0; b1 < k; ) { FileStatus f = arrayOfFileStatus1[b1];
/* 465 */           data_files.add(f.getPath());
/*     */           b1++; }
/*     */       
/*     */       } else {
/* 469 */         data_files.add(file);
/*     */       } 
/*     */       b++; }
/*     */     
/* 473 */     files = data_files.<Path>toArray(new Path[data_files.size()]);
/*     */ 
/*     */     
/* 476 */     TextSerializable inObj1 = OperationsParams.getTextSerializable((Configuration)params, "shape", (TextSerializable)new Text2());
/* 477 */     TextSerializable outObj1 = OperationsParams.getTextSerializable((Configuration)params, "outshape", (TextSerializable)new Text2());
/*     */ 
/*     */     
/* 480 */     TextSerializable inObj = inObj1;
/* 481 */     TextSerializable textSerializable1 = outObj1;
/*     */     
/* 483 */     ResultCollector<TextSerializable> converter = createConverter(output, inObj, textSerializable1);
/* 484 */     long[] files_start_offset = new long[files.length + 1];
/* 485 */     long total_length = 0L;
/* 486 */     for (int i_file = 0; i_file < files.length; i_file++) {
/* 487 */       FileSystem fs = files[i_file].getFileSystem((Configuration)params);
/* 488 */       files_start_offset[i_file] = total_length;
/* 489 */       total_length += fs.getFileStatus(files[i_file]).getLen();
/*     */     } 
/* 491 */     files_start_offset[files.length] = total_length;
/*     */ 
/*     */ 
/*     */     
/* 495 */     Random random = new Random(params.getLong("seed", System.currentTimeMillis()));
/* 496 */     long[] offsets = new long[params.getInt("count", 0)];
/* 497 */     for (int i = 0; i < offsets.length; i++) {
/* 498 */       if (total_length == 0L) {
/* 499 */         offsets[i] = 0L;
/*     */       } else {
/* 501 */         offsets[i] = Math.abs(random.nextLong()) % total_length;
/*     */       } 
/* 503 */     }  Arrays.sort(offsets);
/*     */     
/* 505 */     int record_i = 0;
/* 506 */     int records_returned = 0;
/*     */     
/* 508 */     int file_i = 0;
/* 509 */     while (record_i < offsets.length) {
/*     */       
/* 511 */       while (offsets[record_i] > files_start_offset[file_i + 1]) {
/* 512 */         file_i++;
/*     */       }
/* 514 */       long current_file_size = files_start_offset[file_i + 1] - files_start_offset[file_i];
/* 515 */       FileSystem fs = files[file_i].getFileSystem((Configuration)params);
/* 516 */       ShapeLineRecordReader1D reader = new ShapeLineRecordReader1D(fs.getConf(), 
/* 517 */           new FileSplit(files[file_i], 0L, current_file_size, new String[0]));
/* 518 */       Segment key = reader.createKey();
/* 519 */       Text line = reader.createValue();
/* 520 */       long pos = files_start_offset[file_i];
/*     */       
/* 522 */       while (record_i < offsets.length && 
/* 523 */         offsets[record_i] <= files_start_offset[file_i + 1] && 
/* 524 */         reader.next(key, line)) {
/* 525 */         pos += line.getLength();
/* 526 */         if (pos > offsets[record_i]) {
/*     */ 
/*     */           
/* 529 */           if (converter != null) {
/* 530 */             inObj.fromText(line);
/* 531 */             converter.collect(inObj);
/*     */           } 
/* 533 */           record_i++;
/* 534 */           records_returned++;
/*     */         } 
/*     */       } 
/* 537 */       reader.close();
/*     */ 
/*     */ 
/*     */ 
/*     */       
/* 542 */       while (record_i < offsets.length && 
/* 543 */         offsets[record_i] <= files_start_offset[file_i + 1])
/* 544 */         record_i++; 
/*     */     } 
/* 546 */     return records_returned;
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public static void sample(Path[] inputFiles, ResultCollector<? extends TextSerializable> output, OperationsParams params) throws IOException {
/* 552 */     if (params.get("ratio") != null) {
/* 553 */       if (params.getBoolean("local", false))
/* 554 */       { sampleLocalWithRatio(inputFiles, output, params); }
/*     */       else
/* 556 */       { sampleMapReduceWithRatio(inputFiles, output, params); } 
/* 557 */     } else if (params.get("size") != null) {
/* 558 */       sampleLocalWithSize(inputFiles, output, params);
/* 559 */     } else if (params.get("count") != null) {
/*     */       
/* 561 */       sampleLocalByCount(inputFiles, output, params);
/*     */     } else {
/* 563 */       throw new RuntimeException("Must provide one of three options 'size', 'ratio' or 'count'");
/*     */     } 
/*     */   }
/*     */   
/*     */   private static void printUsage() {
/* 568 */     System.out.println("Reads a random sample of an input file. Sample is written to stdout");
/* 569 */     System.out.println("Parameters (* marks required parameters):");
/* 570 */     System.out.println("<input file> - (*) Path to input file");
/* 571 */     System.out.println("shape:<s> - Type of shapes stored in the file");
/* 572 */     System.out.println("outshape:<s> - Shapes to write to output");
/* 573 */     System.out.println("ratio:<r> - ratio of random sample to read [0, 1]");
/* 574 */     System.out.println("count:<s> - approximate number of records in the sample");
/* 575 */     System.out.println("size:<s> - approximate size of the sample in bytes");
/* 576 */     System.out.println("seed:<s> - random seed to use while reading the sample");
/* 577 */     GenericOptionsParser.printGenericCommandUsage(System.out);
/*     */   }
/*     */   
/*     */   public static void main(String[] args) throws IOException {
/* 581 */     OperationsParams params = new OperationsParams(new GenericOptionsParser(args));
/* 582 */     Path[] inputFiles = params.getPaths();
/*     */     
/* 584 */     if (!params.checkInput()) {
/* 585 */       printUsage();
/* 586 */       System.exit(1);
/*     */     } 
/*     */     
/* 589 */     ResultCollector<TextSerializable> output = 
/* 590 */       new ResultCollector<TextSerializable>()
/*     */       {
/*     */         public void collect(TextSerializable value) {}
/*     */       };
/*     */ 
/*     */ 
/*     */     
/* 597 */     sample(inputFiles, output, params);
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\Sampler1D.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */