/*    */ package com.dlmu.wisdomST.operation;
/*    */ 
/*    */ import com.dlmu.wisdomST.core.Rectangle;
/*    */ import com.dlmu.wisdomST.core.Shape;
/*    */ import com.dlmu.wisdomST.mapreduce.SpatialRecordReader;
/*    */ import com.dlmu.wisdomST.util.OperationsParams;
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import org.apache.commons.logging.Log;
/*    */ import org.apache.commons.logging.LogFactory;
/*    */ import org.apache.hadoop.conf.Configuration;
/*    */ import org.apache.hadoop.io.ArrayWritable;
/*    */ import org.apache.hadoop.mapred.FileSplit;
/*    */ import org.apache.hadoop.mapred.Reporter;
/*    */ import org.apache.hadoop.mapred.lib.CombineFileSplit;
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ public class ShapeArrayRecordReader
/*    */   extends SpatialRecordReader<Rectangle, ArrayWritable>
/*    */ {
/* 34 */   public static final Log LOG = LogFactory.getLog(ShapeArrayRecordReader.class);
/*    */ 
/*    */   
/*    */   private Shape shape;
/*    */ 
/*    */   
/*    */   public ShapeArrayRecordReader(CombineFileSplit split, Configuration conf, Reporter reporter, Integer index) throws IOException {
/* 41 */     super(split, conf, reporter, index);
/* 42 */     this.shape = OperationsParams.getShape(conf, "shape");
/*    */   }
/*    */ 
/*    */   
/*    */   public ShapeArrayRecordReader(Configuration job, FileSplit split) throws IOException {
/* 47 */     super(job, split);
/* 48 */     this.shape = OperationsParams.getShape(job, "shape");
/*    */   }
/*    */ 
/*    */   
/*    */   public ShapeArrayRecordReader(InputStream is, long offset, long endOffset) throws IOException {
/* 53 */     super(is, offset, endOffset);
/*    */   }
/*    */ 
/*    */ 
/*    */   
/*    */   public boolean next(Rectangle key, ArrayWritable shapes) throws IOException {
/* 59 */     boolean element_read = nextShapes(shapes);
/* 60 */     key.set((Shape)this.cellMbr);
/* 61 */     return element_read;
/*    */   }
/*    */ 
/*    */   
/*    */   public Rectangle createKey() {
/* 66 */     return new Rectangle();
/*    */   }
/*    */ 
/*    */   
/*    */   public ArrayWritable createValue() {
/* 71 */     return new ArrayWritable(this.shape.getClass());
/*    */   }
/*    */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\ShapeArrayRecordReader.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */