/*    */ package com.dlmu.wisdomST.operation;
/*    */ 
/*    */ import com.dlmu.wisdomST.core.Rectangle;
/*    */ import com.dlmu.wisdomST.core.Shape;
/*    */ import com.dlmu.wisdomST.mapreduce.SpatialRecordReader;
/*    */ import com.dlmu.wisdomST.util.OperationsParams;
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import org.apache.commons.logging.Log;
/*    */ import org.apache.commons.logging.LogFactory;
/*    */ import org.apache.hadoop.conf.Configuration;
/*    */ import org.apache.hadoop.mapred.FileSplit;
/*    */ import org.apache.hadoop.mapred.Reporter;
/*    */ import org.apache.hadoop.mapred.lib.CombineFileSplit;
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ public class ShapeIterRecordReader
/*    */   extends SpatialRecordReader<Rectangle, SpatialRecordReader.ShapeIterator>
/*    */ {
/* 35 */   public static final Log LOG = LogFactory.getLog(ShapeIterRecordReader.class);
/*    */   
/*    */   private Shape shape;
/*    */   
/*    */   public ShapeIterRecordReader(CombineFileSplit split, Configuration conf, Reporter reporter, Integer index) throws IOException {
/* 40 */     super(split, conf, reporter, index);
/* 41 */     this.shape = OperationsParams.getShape(conf, "shape");
/*    */   }
/*    */ 
/*    */   
/*    */   public ShapeIterRecordReader(Configuration conf, FileSplit split) throws IOException {
/* 46 */     super(conf, split);
/* 47 */     this.shape = OperationsParams.getShape(conf, "shape");
/*    */   }
/*    */ 
/*    */   
/*    */   public ShapeIterRecordReader(InputStream is, long offset, long endOffset) throws IOException {
/* 52 */     super(is, offset, endOffset);
/*    */   }
/*    */   
/*    */   public void setShape(Shape shape) {
/* 56 */     this.shape = shape;
/*    */   }
/*    */ 
/*    */ 
/*    */   
/*    */   public boolean next(Rectangle key, SpatialRecordReader.ShapeIterator shapeIter) throws IOException {
/* 62 */     boolean element_read = nextShapeIter(shapeIter);
/* 63 */     key.set((Shape)this.cellMbr);
/* 64 */     return element_read;
/*    */   }
/*    */ 
/*    */   
/*    */   public Rectangle createKey() {
/* 69 */     return new Rectangle();
/*    */   }
/*    */ 
/*    */   
/*    */   public SpatialRecordReader.ShapeIterator createValue() {
/* 74 */     SpatialRecordReader.ShapeIterator shapeIter = new SpatialRecordReader.ShapeIterator();
/* 75 */     shapeIter.setShape(this.shape);
/* 76 */     return shapeIter;
/*    */   }
/*    */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\ShapeIterRecordReader.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */