/*    */ package com.dlmu.wisdomST.operation;
/*    */ 
/*    */ import com.dlmu.wisdomST.core.Segment;
/*    */ import com.dlmu.wisdomST.core.Shape1D;
/*    */ import com.dlmu.wisdomST.util.OperationsParams;
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import org.apache.commons.logging.Log;
/*    */ import org.apache.commons.logging.LogFactory;
/*    */ import org.apache.hadoop.conf.Configuration;
/*    */ import org.apache.hadoop.mapred.FileSplit;
/*    */ import org.apache.hadoop.mapred.Reporter;
/*    */ import org.apache.hadoop.mapred.lib.CombineFileSplit;
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ public class ShapeIterRecordReader1D
/*    */   extends SpatialRecordReader1D<Segment, SpatialRecordReader1D.ShapeIterator>
/*    */ {
/* 36 */   public static final Log LOG = LogFactory.getLog(ShapeIterRecordReader1D.class);
/*    */   
/*    */   private Shape1D shape;
/*    */   
/*    */   public ShapeIterRecordReader1D(CombineFileSplit split, Configuration conf, Reporter reporter, Integer index) throws IOException {
/* 41 */     super(split, conf, reporter, index);
/* 42 */     this.shape = OperationsParams.getShape1D(conf, "shape");
/*    */   }
/*    */ 
/*    */   
/*    */   public ShapeIterRecordReader1D(Configuration conf, FileSplit split) throws IOException {
/* 47 */     super(conf, split);
/* 48 */     this.shape = OperationsParams.getShape1D(conf, "shape");
/*    */   }
/*    */ 
/*    */   
/*    */   public ShapeIterRecordReader1D(InputStream is, long offset, long endOffset) throws IOException {
/* 53 */     super(is, offset, endOffset);
/*    */   }
/*    */   
/*    */   public void setShape(Shape1D shape) {
/* 57 */     this.shape = shape;
/*    */   }
/*    */ 
/*    */ 
/*    */   
/*    */   public boolean next(Segment key, SpatialRecordReader1D.ShapeIterator shapeIter) throws IOException {
/* 63 */     boolean element_read = nextShapeIter(shapeIter);
/* 64 */     key.set((Shape1D)this.cellMbr);
/* 65 */     return element_read;
/*    */   }
/*    */ 
/*    */   
/*    */   public Segment createKey() {
/* 70 */     return new Segment();
/*    */   }
/*    */ 
/*    */   
/*    */   public SpatialRecordReader1D.ShapeIterator createValue() {
/* 75 */     SpatialRecordReader1D.ShapeIterator shapeIter = new SpatialRecordReader1D.ShapeIterator();
/* 76 */     shapeIter.setShape(this.shape);
/* 77 */     return shapeIter;
/*    */   }
/*    */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\ShapeIterRecordReader1D.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */