/*     */ package com.dlmu.wisdomST.operation;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.Segment;
/*     */ import com.dlmu.wisdomST.core.Shape1D;
/*     */ import com.dlmu.wisdomST.core.SpatialSite;
/*     */ import com.dlmu.wisdomST.indexing.GlobalIndex1D;
/*     */ import com.dlmu.wisdomST.indexing.Partition1D;
/*     */ import com.dlmu.wisdomST.indexing.RTree;
/*     */ import java.io.DataInput;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.Arrays;
/*     */ import java.util.Iterator;
/*     */ import java.util.Vector;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.FSDataInputStream;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.fs.Seekable;
/*     */ import org.apache.hadoop.io.ArrayWritable;
/*     */ import org.apache.hadoop.io.Text;
/*     */ import org.apache.hadoop.io.Writable;
/*     */ import org.apache.hadoop.io.compress.CodecPool;
/*     */ import org.apache.hadoop.io.compress.CompressionCodec;
/*     */ import org.apache.hadoop.io.compress.CompressionCodecFactory;
/*     */ import org.apache.hadoop.io.compress.Decompressor;
/*     */ import org.apache.hadoop.io.compress.SplitCompressionInputStream;
/*     */ import org.apache.hadoop.io.compress.SplittableCompressionCodec;
/*     */ import org.apache.hadoop.mapred.FileSplit;
/*     */ import org.apache.hadoop.mapred.RecordReader;
/*     */ import org.apache.hadoop.mapred.Reporter;
/*     */ import org.apache.hadoop.mapred.lib.CombineFileSplit;
/*     */ import org.apache.hadoop.util.LineReader;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public abstract class SpatialRecordReader1D<K, V>
/*     */   implements RecordReader<K, V>
/*     */ {
/*     */   private int maxShapesInOneRead;
/*     */   private int maxBytesInOneRead;
/*     */   protected long start;
/*     */   protected long end;
/*     */   protected long pos;
/*     */   private InputStream in;
/*     */   private Seekable filePosition;
/*     */   private CompressionCodec codec;
/*  70 */   private static final Log LOG = LogFactory.getLog(SpatialRecordReader1D.class);
/*     */   
/*     */   private Decompressor decompressor;
/*     */   protected LineReader lineReader;
/*     */   
/*     */   enum BlockType
/*     */   {
/*  77 */     HEAP, RTREE;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*  95 */   protected Text tempLine = new Text();
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected byte[] buffer;
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private FileSystem fs;
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private Path path;
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected long blockSize;
/*     */ 
/*     */ 
/*     */   
/*     */   protected Segment cellMbr;
/*     */ 
/*     */ 
/*     */   
/*     */   protected BlockType blockType;
/*     */ 
/*     */ 
/*     */   
/*     */   private FSDataInputStream directIn;
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public SpatialRecordReader1D(CombineFileSplit split, Configuration conf, Reporter reporter, Integer index) throws IOException {
/* 133 */     this(conf, split.getStartOffsets()[index.intValue()], split.getLength(index.intValue()), split.getPath(index.intValue()));
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public SpatialRecordReader1D(Configuration job, FileSplit split) throws IOException {
/* 143 */     this(job, split.getStart(), split.getLength(), split.getPath());
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public SpatialRecordReader1D(Configuration job, long s, long l, Path p) throws IOException {
/* 155 */     this.start = s;
/* 156 */     this.end = s + l;
/* 157 */     this.path = p;
/* 158 */     LOG.info("Open a SpatialRecordReader to file: " + p + "[" + s + "," + (s + l) + ")");
/* 159 */     this.fs = this.path.getFileSystem(job);
/* 160 */     this.directIn = this.fs.open(this.path);
/* 161 */     this.blockSize = this.fs.getFileStatus(this.path).getBlockSize();
/* 162 */     this.cellMbr = new Segment();
/*     */ 
/*     */     
/* 165 */     this.codec = (new CompressionCodecFactory(job)).getCodec(this.path);
/*     */     
/* 167 */     if (isCompressedInput()) {
/* 168 */       this.decompressor = CodecPool.getDecompressor(this.codec);
/* 169 */       if (this.codec instanceof SplittableCompressionCodec) {
/* 170 */         SplitCompressionInputStream cIn = (
/* 171 */           (SplittableCompressionCodec)this.codec).createInputStream(
/* 172 */             (InputStream)this.directIn, this.decompressor, this.start, this.end, 
/* 173 */             SplittableCompressionCodec.READ_MODE.BYBLOCK);
/* 174 */         this.in = (InputStream)cIn;
/* 175 */         this.start = cIn.getAdjustedStart();
/* 176 */         this.end = cIn.getAdjustedEnd();
/* 177 */         this.filePosition = (Seekable)cIn;
/*     */       } else {
/* 179 */         this.in = (InputStream)this.codec.createInputStream((InputStream)this.directIn, this.decompressor);
/* 180 */         this.filePosition = (Seekable)this.directIn;
/*     */       } 
/*     */     } else {
/* 183 */       this.directIn.seek(this.start);
/* 184 */       this.in = (InputStream)this.directIn;
/* 185 */       this.filePosition = (Seekable)this.directIn;
/*     */     } 
/* 187 */     this.pos = this.start;
/* 188 */     this.maxShapesInOneRead = job.getInt("spatialHadoop.mapred.MaxShapesPerRead", 1000000);
/* 189 */     this.maxBytesInOneRead = job.getInt("spatialHadoop.mapred.MaxBytesPerRead", 33554432);
/*     */     
/* 191 */     initializeReader();
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public SpatialRecordReader1D(InputStream in, long offset, long endOffset) throws IOException {
/* 203 */     this.in = in;
/* 204 */     this.start = offset;
/* 205 */     this.end = endOffset;
/* 206 */     this.pos = offset;
/* 207 */     this.cellMbr = new Segment();
/* 208 */     initializeReader();
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private long getFilePosition() throws IOException {
/*     */     long retVal;
/* 221 */     if (isCompressedInput() && this.filePosition != null) {
/* 222 */       retVal = this.filePosition.getPos();
/*     */     } else {
/* 224 */       retVal = this.pos;
/*     */     } 
/* 226 */     return retVal;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private boolean isCompressedInput() {
/* 234 */     return (this.codec != null);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public long getPos() throws IOException {
/* 245 */     return this.pos;
/*     */   }
/*     */ 
/*     */   
/*     */   public void close() throws IOException {
/*     */     try {
/* 251 */       if (this.lineReader != null) {
/* 252 */         this.lineReader.close();
/* 253 */       } else if (this.in != null) {
/* 254 */         this.in.close();
/*     */       } 
/* 256 */       this.lineReader = null;
/* 257 */       this.in = null;
/*     */     } finally {
/* 259 */       if (this.decompressor != null) {
/* 260 */         CodecPool.returnDecompressor(this.decompressor);
/*     */       }
/*     */     } 
/*     */   }
/*     */ 
/*     */   
/*     */   public float getProgress() throws IOException {
/* 267 */     if (this.start == this.end) {
/* 268 */       return 0.0F;
/*     */     }
/* 270 */     return Math.min(1.0F, 
/* 271 */         (float)(this.directIn.getPos() - this.start) / (float)(this.end - this.start));
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected boolean initializeReader() throws IOException {
/* 284 */     this.cellMbr.invalidate();
/* 285 */     if (this.path != null) {
/* 286 */       GlobalIndex1D<Partition1D> globalIndex = 
/* 287 */         SpatialSite.getGlobalIndex1D(this.fs, this.path.getParent());
/* 288 */       if (globalIndex != null) {
/* 289 */         for (Partition1D partition : globalIndex) {
/* 290 */           if (partition.filename.equals(this.path.getName())) {
/* 291 */             this.cellMbr.set((Shape1D)partition);
/*     */           }
/*     */         } 
/*     */       }
/*     */     } 
/*     */ 
/*     */     
/* 298 */     this.buffer = new byte[8];
/* 299 */     int bufferLength = this.in.read(this.buffer);
/* 300 */     if (bufferLength <= 0) {
/* 301 */       this.buffer = null;
/* 302 */     } else if (bufferLength < this.buffer.length) {
/* 303 */       byte[] old_buffer = this.buffer;
/* 304 */       this.buffer = new byte[bufferLength];
/* 305 */       System.arraycopy(old_buffer, 0, this.buffer, 0, bufferLength);
/*     */     } 
/* 307 */     if (this.buffer != null && Arrays.equals(this.buffer, SpatialSite.RTreeFileMarkerB)) {
/* 308 */       this.blockType = BlockType.RTREE;
/* 309 */       this.pos += 8L;
/*     */       
/* 311 */       this.buffer = null;
/*     */     } else {
/* 313 */       this.blockType = BlockType.HEAP;
/*     */ 
/*     */       
/* 316 */       this.lineReader = new LineReader(this.in);
/*     */ 
/*     */ 
/*     */       
/* 320 */       boolean skipFirstLine = (getPos() != 0L);
/* 321 */       if (this.buffer != null && skipFirstLine) {
/*     */         
/* 323 */         int eol = RTree.skipToEOL(this.buffer, 0);
/*     */ 
/*     */ 
/*     */ 
/*     */         
/* 328 */         boolean skip_another_line_from_stream = (eol >= this.buffer.length && 
/* 329 */           this.buffer[this.buffer.length - 1] != 10);
/* 330 */         if (eol < this.buffer.length) {
/*     */           
/* 332 */           byte[] tmp = new byte[this.buffer.length - eol];
/* 333 */           System.arraycopy(this.buffer, eol, tmp, 0, tmp.length);
/* 334 */           this.buffer = tmp;
/*     */           
/* 336 */           this.pos += eol;
/*     */         } else {
/*     */           
/* 339 */           this.pos += this.buffer.length;
/*     */           
/* 341 */           this.buffer = null;
/*     */         } 
/*     */         
/* 344 */         if (skip_another_line_from_stream) {
/*     */           
/* 346 */           this.pos += this.lineReader.readLine(this.tempLine, 2147483647, (int)(this.end - this.pos));
/* 347 */           if (this.pos >= this.end)
/*     */           {
/*     */ 
/*     */ 
/*     */             
/* 352 */             this.pos++;
/*     */           }
/*     */         } 
/*     */       } 
/*     */     } 
/*     */ 
/*     */     
/* 359 */     return true;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected boolean nextLine(Text value) throws IOException {
/* 370 */     if (this.blockType == BlockType.RTREE && this.pos == 8L) {
/*     */ 
/*     */       
/* 373 */       this.pos += RTree.skipHeader(this.in);
/* 374 */       LOG.info("Skipped R-tree to position: " + this.pos);
/*     */       
/* 376 */       this.lineReader = new LineReader(this.in);
/*     */     } 
/* 378 */     while (getFilePosition() <= this.end) {
/* 379 */       value.clear();
/* 380 */       int b = 0;
/* 381 */       if (this.buffer != null) {
/*     */         
/* 383 */         int eol = RTree.skipToEOL(this.buffer, 0);
/* 384 */         b += eol;
/* 385 */         value.append(this.buffer, 0, eol);
/* 386 */         if (eol < this.buffer.length) {
/*     */           
/* 388 */           byte[] tmp = new byte[this.buffer.length - eol];
/* 389 */           System.arraycopy(this.buffer, eol, tmp, 0, tmp.length);
/* 390 */           this.buffer = tmp;
/*     */         } else {
/* 392 */           this.buffer = null;
/*     */         } 
/*     */         
/* 395 */         byte last_byte = value.getBytes()[value.getLength() - 1];
/* 396 */         if (last_byte == 10 || last_byte == 13) {
/* 397 */           return true;
/*     */         }
/*     */       } 
/*     */       
/* 401 */       Text temp = new Text();
/* 402 */       b += this.lineReader.readLine(temp);
/* 403 */       if (b == 0)
/*     */       {
/* 405 */         return false;
/*     */       }
/* 407 */       this.pos += b;
/*     */ 
/*     */       
/* 410 */       value.append(temp.getBytes(), 0, temp.getLength());
/*     */       
/* 412 */       if (value.getLength() > 1)
/*     */       {
/* 414 */         return true;
/*     */       }
/*     */     } 
/*     */     
/* 418 */     return false;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected boolean nextShape(Shape1D s) throws IOException {
/* 432 */     if (!nextLine(this.tempLine))
/* 433 */       return false; 
/* 434 */     s.fromText(this.tempLine);
/* 435 */     return true;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected boolean nextShapes(ArrayWritable shapes) throws IOException {
/* 456 */     Vector<Shape1D> vshapes = new Vector<Shape1D>();
/*     */     try {
/* 458 */       Shape1D stockObject = shapes.getValueClass().newInstance();
/*     */       
/* 460 */       if (getFilePosition() >= this.end) {
/* 461 */         return false;
/*     */       }
/* 463 */       long initialReadPos = getPos();
/* 464 */       long readBytes = 0L;
/*     */ 
/*     */       
/* 467 */       while ((this.maxShapesInOneRead <= 0 || vshapes.size() < this.maxShapesInOneRead) && (
/* 468 */         this.maxBytesInOneRead <= 0 || readBytes < this.maxBytesInOneRead) && 
/* 469 */         nextShape(stockObject)) {
/* 470 */         vshapes.add(stockObject.clone());
/* 471 */         readBytes = getPos() - initialReadPos;
/*     */       } 
/*     */ 
/*     */       
/* 475 */       shapes.set((Writable[])vshapes.toArray((Object[])new Shape1D[vshapes.size()]));
/*     */       
/* 477 */       return !vshapes.isEmpty();
/* 478 */     } catch (InstantiationException e1) {
/* 479 */       e1.printStackTrace();
/* 480 */     } catch (IllegalAccessException e1) {
/* 481 */       e1.printStackTrace();
/* 482 */     } catch (OutOfMemoryError e) {
/* 483 */       LOG.error("Error reading shapes. Stopped with " + vshapes.size() + " shapes");
/* 484 */       throw e;
/*     */     } 
/* 486 */     return false;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected boolean nextShapeIter(ShapeIterator iter) throws IOException {
/* 496 */     iter.setSpatialRecordReader((SpatialRecordReader1D)this);
/* 497 */     return iter.hasNext();
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public static class ShapeIterator
/*     */     implements Iterator<Shape1D>, Iterable<Shape1D>
/*     */   {
/*     */     protected Shape1D shape;
/*     */     
/*     */     protected Shape1D nextShape;
/*     */     
/*     */     private SpatialRecordReader1D<?, ? extends Shape1D> srr;
/*     */ 
/*     */     
/*     */     public void setSpatialRecordReader(SpatialRecordReader1D<?, ? extends Shape1D> srr) {
/* 513 */       this.srr = srr;
/*     */       try {
/* 515 */         if (this.shape != null)
/* 516 */           this.nextShape = this.shape.clone(); 
/* 517 */         if (this.nextShape != null && !srr.nextShape(this.nextShape))
/* 518 */           this.nextShape = null; 
/* 519 */       } catch (IOException iOException) {}
/*     */     }
/*     */ 
/*     */     
/*     */     public void setShape(Shape1D shape) {
/* 524 */       this.shape = shape;
/* 525 */       this.nextShape = shape.clone();
/*     */       try {
/* 527 */         if (this.srr != null && !this.srr.nextShape(this.nextShape))
/* 528 */           this.nextShape = null; 
/* 529 */       } catch (IOException iOException) {}
/*     */     }
/*     */ 
/*     */     
/*     */     public boolean hasNext() {
/* 534 */       if (this.nextShape == null)
/* 535 */         return false; 
/* 536 */       return (this.nextShape != null);
/*     */     }
/*     */ 
/*     */     
/*     */     public Shape1D next() {
/*     */       try {
/* 542 */         if (this.nextShape == null) {
/* 543 */           return null;
/*     */         }
/* 545 */         Shape1D temp = this.shape;
/* 546 */         this.shape = this.nextShape;
/* 547 */         this.nextShape = temp;
/*     */         
/* 549 */         if (!this.srr.nextShape(this.nextShape))
/* 550 */           this.nextShape = null; 
/* 551 */         return this.shape;
/* 552 */       } catch (IOException e) {
/* 553 */         return null;
/*     */       } 
/*     */     }
/*     */ 
/*     */     
/*     */     public Iterator<Shape1D> iterator() {
/* 559 */       return this;
/*     */     }
/*     */ 
/*     */     
/*     */     public void remove() {
/* 564 */       throw new RuntimeException("Unsupported method ShapeIterator#remove");
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected boolean nextRTree(RTree<? extends Shape1D> rtree) throws IOException {
/* 580 */     if (this.blockType == BlockType.RTREE) {
/* 581 */       if (getPos() != 8L) {
/* 582 */         return false;
/*     */       }
/* 584 */       this.buffer = null;
/* 585 */       DataInput dataIn = (this.in instanceof DataInput) ? 
/* 586 */         (DataInput)this.in : new DataInputStream(this.in);
/* 587 */       rtree.readFields(dataIn);
/* 588 */       this.pos++;
/* 589 */       return true;
/*     */     } 
/* 591 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\SpatialRecordReader1D.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */