/*     */ package com.dlmu.wisdomST.operation;
/*     */ 
/*     */ import com.dlmu.wisdomST.core.ResultCollector;
/*     */ import com.dlmu.wisdomST.core.Shape;
/*     */ import com.dlmu.wisdomST.io.Text2;
/*     */ import com.dlmu.wisdomST.io.TextSerializable;
/*     */ import com.dlmu.wisdomST.util.OperationsParams;
/*     */ import java.io.IOException;
/*     */ import org.apache.hadoop.conf.Configuration;
/*     */ import org.apache.hadoop.fs.FSDataInputStream;
/*     */ import org.apache.hadoop.fs.FileSystem;
/*     */ import org.apache.hadoop.fs.Path;
/*     */ import org.apache.hadoop.io.LongWritable;
/*     */ import org.apache.hadoop.io.Text;
/*     */ import org.apache.hadoop.mapred.JobConf;
/*     */ import org.apache.hadoop.util.GenericOptionsParser;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class Tail
/*     */ {
/*     */   public static <T extends TextSerializable> long tail(FSDataInputStream in, int n, T stockObject, ResultCollector<T> output) throws IOException {
/*  52 */     int lines_read = 0;
/*  53 */     long end = in.getPos();
/*  54 */     long offset_of_last_eol = end;
/*  55 */     long last_read_byte = end;
/*     */     
/*  57 */     LongWritable line_offset = new LongWritable();
/*  58 */     Text read_line = new Text();
/*  59 */     Text remainder_from_last_buffer = new Text();
/*  60 */     byte[] buffer = new byte[4096];
/*     */     
/*  62 */     while (last_read_byte > 0L && lines_read < n) {
/*     */       
/*  64 */       long first_byte_to_read = last_read_byte - 1L - (
/*  65 */         last_read_byte - 1L) % buffer.length;
/*  66 */       in.seek(first_byte_to_read);
/*  67 */       int bytes_to_read = (int)(last_read_byte - first_byte_to_read);
/*  68 */       in.read(buffer, 0, bytes_to_read);
/*  69 */       last_read_byte = first_byte_to_read;
/*     */ 
/*     */       
/*  72 */       int i_last_byte_consumed_in_buffer = bytes_to_read;
/*  73 */       int i_last_byte_examined_in_buffer = bytes_to_read;
/*  74 */       while (i_last_byte_examined_in_buffer > 0 && lines_read < n) {
/*  75 */         byte byte_examined = buffer[--i_last_byte_examined_in_buffer];
/*  76 */         if (byte_examined == 10 || byte_examined == 13) {
/*     */ 
/*     */           
/*  79 */           long offset_of_this_eol = first_byte_to_read + i_last_byte_examined_in_buffer;
/*  80 */           if (offset_of_last_eol - offset_of_this_eol > 1L) {
/*  81 */             if (output != null) {
/*  82 */               read_line.clear();
/*     */               
/*  84 */               read_line.append(buffer, i_last_byte_examined_in_buffer + 1, 
/*  85 */                   i_last_byte_consumed_in_buffer - i_last_byte_examined_in_buffer + 1);
/*     */               
/*  87 */               if (remainder_from_last_buffer.getLength() > 0) {
/*  88 */                 read_line.append(remainder_from_last_buffer.getBytes(), 0, 
/*  89 */                     remainder_from_last_buffer.getLength());
/*     */               }
/*  91 */               line_offset.set(offset_of_this_eol + 1L);
/*  92 */               stockObject.fromText(read_line);
/*  93 */               output.collect(stockObject);
/*     */             } 
/*  95 */             lines_read++;
/*  96 */             remainder_from_last_buffer.clear();
/*     */           } 
/*  98 */           i_last_byte_consumed_in_buffer = i_last_byte_examined_in_buffer;
/*  99 */           offset_of_last_eol = offset_of_this_eol;
/*     */         } 
/*     */       } 
/* 102 */       if (i_last_byte_consumed_in_buffer > 0) {
/*     */         
/* 104 */         if (remainder_from_last_buffer.getLength() == 0) {
/*     */           
/* 106 */           remainder_from_last_buffer.append(buffer, 0, 
/* 107 */               i_last_byte_consumed_in_buffer);
/*     */           continue;
/*     */         } 
/* 110 */         Text t = new Text();
/* 111 */         t.append(buffer, 0, i_last_byte_consumed_in_buffer);
/* 112 */         t.append(remainder_from_last_buffer.getBytes(), 0, 
/* 113 */             remainder_from_last_buffer.getLength());
/* 114 */         remainder_from_last_buffer = t;
/*     */       } 
/*     */     } 
/*     */ 
/*     */     
/* 119 */     if (lines_read < n && remainder_from_last_buffer.getLength() > 0) {
/*     */       
/* 121 */       lines_read++;
/* 122 */       if (output != null) {
/* 123 */         read_line = remainder_from_last_buffer;
/* 124 */         line_offset.set(0L);
/* 125 */         stockObject.fromText(read_line);
/* 126 */         output.collect(stockObject);
/*     */       } 
/* 128 */       offset_of_last_eol = -1L;
/*     */     } 
/*     */     
/* 131 */     return offset_of_last_eol + 1L;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public static <T extends TextSerializable> long tail(FileSystem fs, Path file, int n, T stockObject, ResultCollector<T> output) throws IOException {
/* 148 */     FSDataInputStream in = null;
/*     */     try {
/* 150 */       in = fs.open(file);
/* 151 */       long length = fs.getFileStatus(file).getLen();
/* 152 */       in.seek(length);
/* 153 */       return tail(in, n, stockObject, output);
/*     */     } finally {
/* 155 */       if (in != null)
/* 156 */         in.close(); 
/*     */     } 
/*     */   }
/*     */   public static void main(String[] args) throws IOException {
/*     */     Text2 text2;
/* 161 */     OperationsParams cla = new OperationsParams(new GenericOptionsParser(args));
/* 162 */     JobConf conf = new JobConf(Sampler.class);
/* 163 */     Path inputFile = cla.getPath();
/* 164 */     FileSystem fs = inputFile.getFileSystem((Configuration)conf);
/* 165 */     if (!fs.exists(inputFile)) {
/* 166 */       throw new RuntimeException("Input file does not exist");
/*     */     }
/* 168 */     int count = cla.getInt("count", 10);
/* 169 */     Shape shape = cla.getShape("shape");
/* 170 */     if (shape == null) {
/* 171 */       text2 = new Text2();
/*     */     }
/* 173 */     tail(fs, inputFile, count, text2, new ResultCollector<TextSerializable>()
/*     */         {
/*     */           public void collect(TextSerializable value)
/*     */           {
/* 177 */             System.out.println(value);
/*     */           }
/*     */         });
/*     */   }
/*     */ }


/* Location:              E:\大连公交集团-项目文档\公交项目相关文档\田\wisdomST-0.0.1.jar!\com\dlmu\wisdomST\operation\Tail.class
 * Java compiler version: 6 (50.0)
 * JD-Core Version:       1.1.3
 */