import tkinter as tk
from image_processor import load_image
from utilities import clear_canvas, save_canvas, save_path, save_full_model, load_model, run_dijkstras_on_all_pairs  # Import save_path function
from canvas_tools import MapCanvas
from path_finding import create_grid, generate_paths, validate_paths, disable_grid_mode

def setup_ui(root):
    root.title("Map Maker with Editable Background")

    # Create the canvas and associated functionality
    map_canvas = MapCanvas(root)

    # Set up tools and controls
    control_frame = tk.Frame(root, padx=5, pady=5)
    control_frame.pack(side=tk.RIGHT, fill=tk.BOTH)

    # Buttons for different tools and actions
    tk.Button(control_frame, text='Load Map Model', command=lambda: load_image(map_canvas)).pack(fill=tk.X)
    tk.Button(control_frame, text='Create Grid', command=lambda: create_grid(map_canvas)).pack(fill=tk.X)
    tk.Button(control_frame, text='Generate Path', command=lambda: generate_paths(map_canvas)).pack(fill=tk.X)
    tk.Button(control_frame, text='Finish Grid Selection', command=lambda: disable_grid_mode(map_canvas)).pack(fill=tk.X)
    tk.Button(control_frame, text='Pen', command=lambda: map_canvas.set_tool('pen')).pack(fill=tk.X)
    tk.Button(control_frame, text='Line', command=lambda: map_canvas.set_tool('line')).pack(fill=tk.X)
    tk.Button(control_frame, text='Rectangle', command=lambda: map_canvas.set_tool('rectangle')).pack(fill=tk.X)
    tk.Button(control_frame, text='Eraser', command=lambda: map_canvas.set_tool('eraser')).pack(fill=tk.X)
    tk.Button(control_frame, text='Choose Color', command=lambda: map_canvas.choose_color()).pack(fill=tk.X)
    tk.Button(control_frame, text='Brush Size', command=lambda: map_canvas.choose_brush_size()).pack(fill=tk.X)
    tk.Button(control_frame, text='Undo', command=lambda: map_canvas.undo()).pack(fill=tk.X)
    tk.Button(control_frame, text='Redo', command=lambda: map_canvas.redo()).pack(fill=tk.X)
    tk.Button(control_frame, text='Clear', command=lambda: clear_canvas(map_canvas)).pack(fill=tk.X)
    tk.Button(control_frame, text='Save', command=lambda: save_canvas(map_canvas)).pack(fill=tk.X)
    tk.Button(control_frame, text='Validate Path', command=lambda: validate_paths(map_canvas)).pack(fill=tk.X)
    tk.Button(control_frame, text='Save Path', command=lambda: save_path(map_canvas)).pack(fill=tk.X)  # New button
    tk.Button(control_frame, text='Save Full Model', command=lambda: save_full_model(map_canvas)).pack(fill=tk.X)
    tk.Button(control_frame, text='Load Model', command=lambda: load_model(map_canvas)).pack(fill=tk.X)
    tk.Button(control_frame, text="Run Dijkstra's", command=lambda: run_dijkstras_on_all_pairs(map_canvas)).pack(fill=tk.X)
