// Toggle sidebar
function toggleMenu() {
    const sidebar = document.getElementById("sidebar");
    const hamburgerIcon = document.getElementById("hamburgerIcon");
    
    sidebar.classList.toggle("open");
    hamburgerIcon.classList.toggle("hidden");
}

// Fetch all floor data points from the Flask API on page load
document.addEventListener("DOMContentLoaded", () => {
    fetchDataPoints();
});

let dataPoints = {};
let startFloorData = null;
let endFloorData = null;
let currentFloor = "start";

// Fetch nodes grouped by floor from the API
function fetchDataPoints() {
    fetch('http://127.0.0.1:5000/api/nodes')
        .then(response => response.json())
        .then(data => {
            dataPoints = data;
            populateFloorDropdowns();
        })
        .catch(error => console.error("Error fetching data points:", error));
}

// Populate the floor selection dropdowns
function populateFloorDropdowns() {
    const startFloorSelect = document.getElementById("startFloorSelect");
    const endFloorSelect = document.getElementById("endFloorSelect");
    startFloorSelect.innerHTML = '<option value="">Select Start Floor</option>';
    endFloorSelect.innerHTML = '<option value="">Select End Floor</option>';

    Object.keys(dataPoints).forEach(floor => {
        const option1 = new Option(`Floor ${floor}`, floor);
        const option2 = new Option(`Floor ${floor}`, floor);
        startFloorSelect.add(option1);
        endFloorSelect.add(option2);
    });
}

// Populate start and end dropdowns based on selected floors
function populateNodeDropdowns(type) {
    const floorSelect = type === 'start' ? document.getElementById("startFloorSelect").value : document.getElementById("endFloorSelect").value;
    const nodeSelect = type === 'start' ? document.getElementById("startSelect") : document.getElementById("endSelect");

    nodeSelect.innerHTML = `<option value="">Select ${type === 'start' ? 'Start' : 'End'} Position</option>`;

    if (floorSelect && dataPoints[floorSelect]) {
        Object.keys(dataPoints[floorSelect]).forEach(node => {
            const option = new Option(node, node);
            nodeSelect.add(option);
        });
    }
}

// Ensure the selected value in one dropdown cannot be chosen in the other
function updateEndOptions() {
    const startValue = document.getElementById("startSelect").value;
    const endSelect = document.getElementById("endSelect");

    Array.from(endSelect.options).forEach(option => {
        option.disabled = option.value === startValue;
    });
}

function updateStartOptions() {
    const endValue = document.getElementById("endSelect").value;
    const startSelect = document.getElementById("startSelect");

    Array.from(startSelect.options).forEach(option => {
        option.disabled = option.value === endValue;
    });
}

// Submit selected positions and floors
function submitPositions() {
    const start = document.getElementById("startSelect").value;
    const end = document.getElementById("endSelect").value;
    const startFloor = document.getElementById("startFloorSelect").value;
    const endFloor = document.getElementById("endFloorSelect").value;

    if (start && end && startFloor && endFloor) {
        fetch('http://127.0.0.1:5000/api/path', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ start: start, end: end, start_floor: startFloor, end_floor: endFloor })
        })
        .then(response => {
            console.log("Server response status:", response.status);
            return response.json();
        })
        .then(result => {
            console.log("Response data from server:", result);
            
            if (result.start_floor && result.end_floor) {
                // Store data for each floor
                startFloorData = result.start_floor;
                endFloorData = result.end_floor;
                
                // Display the start floor map and floor header
                displayFloor(startFloorData);
                document.getElementById("nextFloorArrow").style.display = "block"; // Show the next floor arrow
                document.getElementById("prevFloorArrow").style.display = "none"; // Hide the previous floor arrow
                currentFloor = "start";
            } else if (result.image) {
                // Single-floor path
                document.getElementById('mapImage').src = 'data:image/png;base64,' + result.image;
                document.getElementById('floorHeader').innerText = `Floor ${result.floor}`;
                document.getElementById("nextFloorArrow").style.display = "none"; // No need for next floor arrow
                document.getElementById("prevFloorArrow").style.display = "none"; // No need for previous floor arrow
            } else {
                alert(result.error || 'Path not found.');
            }
        })
        .catch(error => console.error("Error running Dijkstra:", error));
    } else {
        alert("Please select both start and end floors, and positions.");
    }
}

// Display map and floor name for the current floor
function displayFloor(floorData) {
    document.getElementById('mapImage').src = 'data:image/png;base64,' + floorData.image;
    document.getElementById('floorHeader').innerText = `Floor ${floorData.floor}`;
}

// Show the next floor map and update navigation arrows
function showNextFloor() {
    if (currentFloor === "start" && endFloorData) {
        // Display the end floor map and floor header
        displayFloor(endFloorData);
        document.getElementById("nextFloorArrow").style.display = "none"; // Hide the next floor arrow
        document.getElementById("prevFloorArrow").style.display = "block"; // Show the previous floor arrow
        currentFloor = "end";
    }
}

// Show the previous floor map and update navigation arrows
function showPrevFloor() {
    if (currentFloor === "end" && startFloorData) {
        // Display the start floor map and floor header
        displayFloor(startFloorData);
        document.getElementById("nextFloorArrow").style.display = "block"; // Show the next floor arrow
        document.getElementById("prevFloorArrow").style.display = "none"; // Hide the previous floor arrow
        currentFloor = "start";
    }
}
