from sqlalchemy import Column, Integer, String, LargeBinary, DateTime
from datetime import datetime
from config import Base, engine

class FileStorage(Base):
    __tablename__ = 'file_storage'

    id = Column(Integer, primary_key=True, index=True)
    filename = Column(String, nullable=False)
    file_type = Column(String, nullable=False)  # 'image' or 'text'
    content = Column(LargeBinary, nullable=False)
    timestamp = Column(DateTime, default=datetime.utcnow)

# Create the tables if they don't exist
Base.metadata.create_all(bind=engine)
