import matplotlib.pyplot as plt
import numpy as np 

import pdb


colors = ['#1f77b4',
          '#ff7f0e',
          '#2ca02c',
          '#d62728',
          '#9467bd',
          '#8c564b',
          '#e377c2',
          '#7f7f7f',
          '#bcbd22',
          '#17becf',
          '#1a55FF']

fig, ax = plt.subplots(nrows=1, ncols=1,figsize=(10, 8.2))
#ax.set_facecolor('whitesmoke')
#ax.set_facecolor('aliceblue')
from matplotlib.font_manager import FontProperties
font = FontProperties()
font.set_size(25)
plt.grid(ls="dotted",)
plt.xlim((-5, 155))

xtick = [0, 50, 100, 150]
plt.xticks(xtick,['10','50', '100','200'],fontsize=20)
x = [0, 50, 100, 150]
plt.ylim((91,93.7))
y = np.linspace(91, 93.5, 6)
plt.yticks(y, fontsize=20)
ep0 = [91.32, 92.51, 93.02, 93.31]
ep01 = [91.58, 92.78,93.36,93.37]
ep1 = [92.31, 92.92, 93.45,93.42]



plt.plot(x, ep0,label='FLOPs (PR)=65.8%', linewidth=4, marker='^', color = '#5495BF',markersize = 10)
plt.plot(x, ep01,label='FLOPs (PR)=51.2%',linewidth=4, marker='o', color = '#aeb8fe', markersize =10)
plt.plot(x, ep1,label='FLOPs (PR)=39.4%',linewidth=4,marker='s', color = '#B9DFB7', markersize =10)

plt.xlabel('Mask Training (Epochs)',fontsize = 30, fontproperties=font)
plt.ylabel('Top-1 Accuracy (%)',fontsize = 30, fontproperties=font)
#plt.title('LLaMA-V1-7B',fontsize = 30, fontproperties=font)
plt.legend(fontsize=30,loc="lower right", prop=font, framealpha=0, handlelength=2.5)
plt.savefig("fig_hyperparameter.pdf",bbox_inches='tight')
#plt.show() 