
% GRIFD Deep Learning Version - LSTM + GUI + EyePACS Support
% This script integrates LSTM modeling and GUI interface for DR detection.

clc; clear; close all;

% Load dataset from GUI
disp('Select folder containing fundus images...');
image_folder = uigetdir;
image_files = dir(fullfile(image_folder, '*.jpg'));
nImages = length(image_files);

% Parameters
imageSize = [512 512];
numFeatures = 100; % Adjust as needed
maxSeqLength = 5;  % For RNN sequence modeling

% Preprocess and extract features
X = {};
Y = [];
for i = 1:nImages
    img = imread(fullfile(image_folder, image_files(i).name));
    img = imresize(img, imageSize);
    grayImg = rgb2gray(img);
    normImg = mat2gray(grayImg);

    % Extract LBP + edge features
    lbp = extractLBPFeatures(normImg, 'CellSize', [64 64]);
    edgeMap = edge(normImg, 'Sobel');
    edgeFeat = mean(edgeMap(:));
    features = [lbp, edgeFeat];

    % Pad/trim features to fixed length
    if length(features) > numFeatures
        features = features(1:numFeatures);
    else
        features(end+1:numFeatures) = 0;
    end

    X{i} = features';
    % Dummy label: even=normal, odd=DR for demo (replace with true labels)
    Y(end+1) = mod(i, 2); 
end

% Convert to sequence
Xseq = cell2mat(X');
Xseq = reshape(Xseq, [numFeatures, maxSeqLength, floor(nImages/maxSeqLength)]);
Y = categorical(Y(1:floor(nImages/maxSeqLength)*maxSeqLength));

% LSTM Model
layers = [ ...
    sequenceInputLayer(numFeatures)
    lstmLayer(64,'OutputMode','last')
    fullyConnectedLayer(2)
    softmaxLayer
    classificationLayer];

options = trainingOptions('adam', ...
    'MaxEpochs',30, ...
    'MiniBatchSize',8, ...
    'Shuffle','every-epoch', ...
    'Verbose',false, ...
    'Plots','training-progress');

% Train model
Xtrain = squeeze(num2cell(Xseq, [1 2]));
Ytrain = Y(1:numel(Xtrain));

disp('Training LSTM model...');
net = trainNetwork(Xtrain, Ytrain, layers, options);

% GUI result
uiwait(msgbox('Model training complete. You may now evaluate images.'));
