# Preparation of Fine and Coarse Scale LST and Auxiliary Variables using Google Earth Engine

---

## 1. Introduction

This project generates fine-resolution Land Surface Temperature (LST) maps and coarse-resolution reflectance and temperature variables using satellite data processed on Google Earth Engine (GEE). The datasets used are Landsat 9 Operational Land Imager/Thermal Infrared Sensor-2 (OLI/TIRS-2) and MODIS Terra Surface Reflectance/Temperature products. Outputs are exported as GeoTIFFs for subsequent use in land surface analysis, modeling, and machine learning-based downscaling experiments.

---

## 2. Objectives

- Derive fine-resolution LST maps from Landsat 9 data.
- Process MODIS surface reflectance products to create coarse-resolution auxiliary variables (e.g., NDVI, NDWI, NDBI).
- Extract MODIS daytime LST at a coarse spatial resolution.
- Export all outputs as GeoTIFF format.

---

## 3. Methodology

### 3.1 Platform
- **Google Earth Engine (GEE)**: A cloud-based geospatial processing platform.

### 3.2 Datasets Used
| Dataset | ID | Description |
|:--------|:---|:------------|
| Landsat 9 | `LANDSAT/LC09/C02/T1/LC09_140044_20220128` | Level-1 Collection 2 Tier 1 Scene from Path 140, Row 044, acquired on January 28, 2022. |
| MODIS Surface Reflectance | `MODIS/061/MOD09GA/2022_01_28` | MOD09GA Version 6.1 Daily Surface Reflectance, January 28, 2022. |
| MODIS Land Surface Temperature | `MODIS/061/MOD11A1/2022_01_28` | MOD11A1 Version 6.1 Daily LST, January 28, 2022. |

---

## 4. Processing Workflow

### 4.1 Area of Interest (AOI)
- Rectangle between latitudes **22.99°N to 23.43°N** and longitudes **85.27°E to 85.75°E**.

### 4.2 Landsat 9 LST Processing
- **Brightness Temperature (BT)** from thermal band B10.
- **NDVI Calculation** using bands B5 (NIR) and B4 (Red).
- **Emissivity Estimation** based on NDVI thresholds (NDVI_s = 0.2, NDVI_v = 0.5).
- **LST Retrieval**:
```
LST = (BT / (1 + (0.00108 × BT / 1.4388) × log(ε))) - 273.15
```

### 4.3 MODIS Surface Reflectance Processing
- Bands scaled by 0.0001 (Blue, Green, Red, NIR, SWIR1, SWIR2).
- **Indices Calculation**: NDVI, NDWI, NDBI, SAVI, MNDWI.

### 4.4 MODIS LST Processing
- Extract `LST_Day_1km`.
- Apply scaling (0.02) and convert Kelvin to Celsius.

---

## 5. Export Settings

| Dataset | Scale (m) | CRS | Format | Folder | Description |
|:--------|:---------|:----|:-------|:-------|:------------|
| Landsat LST | 90 | EPSG:4326 | GeoTIFF | APP | Fine-resolution LST |
| MODIS Reflectance + Indices | 463.31 | EPSG:4326 | GeoTIFF | APP | Auxiliary variables |
| MODIS LST | 926.62 | EPSG:4326 | GeoTIFF | APP | Coarse daytime LST |

- **Max Pixels Allowed:** 1e13
- **Region:** AOI polygon.

---

## 6. Script Overview
```
Authenticate Earth Engine
↓
Define AOI
↓
Load Landsat imagery
↓
Retrieve Landsat LST
↓
Export Landsat LST
↓
Load MODIS reflectance
↓
Calculate indices (NDVI, NDWI, NDBI, SAVI, MNDWI)
↓
Export reflectance & indices
↓
Load MODIS LST
↓
Process and export MODIS LST
↓
Start Google Drive exports
```

---

## 7. Notes
- Emissivity estimated using NDVI Threshold Method.
- MODIS LST scaled (0.02), converted to Celsius.
- Export via Google Drive for offline analysis.
- CRS: EPSG:4326 (WGS 84).

---

## 8. Requirements
- Google Earth Engine Account
- Python with earthengine-api
- Google Drive access
- Adequate storage in Google Drive

---

## 9. Acknowledgements
- USGS for Landsat data.
- NASA for MODIS products.
- Google Earth Engine Team.

---

## 10. License
This project is for **research and academic use**. Cite datasets and platforms appropriately.