import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

plt.rcParams['font.sans-serif'] = ['SimHei']  
plt.rcParams['axes.unicode_minus'] = False  

fig, ax = plt.subplots(dpi=150)  

x = [10, 20, 30, 40, 50, 60, 70]
plt.xticks(size=12)
plt.yticks(size=12)


y_avl_512 = [6.64, 7.36, 8.71, 9.00, 9.50, 9.64, 9.71]
ax.plot(x, y_avl_512, color='b', linestyle='-', marker='o', label="ABM 512")
y_kd_512 = [1.71, 2.43, 3.14, 3.71, 4.93, 4.79, 5.50]
ax.plot(x, y_kd_512, color='r', linestyle='-', marker='o', label="MDQ 512")

y_avl_1024 = [9.57, 12.07, 12.00, 11.00, 12.57, 13.07, 13.00]
ax.plot(x, y_avl_1024, color='g', linestyle='-', marker='s', label="ABM 1024")
y_kd_1024 = [1.71, 2.71, 3.21, 3.71, 4.57, 5.29, 5.36]
ax.plot(x, y_kd_1024, color='maroon', linestyle='-', marker='s', label="MDQ 1024")

y_avl_2048 = [19.29, 23.43, 19.93, 20.29, 21.29, 23.07, 23.29]
ax.plot(x, y_avl_2048, color='c', linestyle='-', marker='x', label="ABM 2048")
y_kd_2048 = [1.93, 2.36, 3.21, 3.93, 4.64, 5.36, 5.43]
ax.plot(x, y_kd_2048, color='darkorange', linestyle='-', marker='x', label="MDQ 2048")

ax.xaxis.set_major_locator(ticker.MultipleLocator(10))
ax.yaxis.set_major_locator(ticker.MultipleLocator(10))
ax.legend(loc='upper left', prop={"size": 10})
ax.set_xlabel('The number of most approximate images', size=13)
ax.set_ylabel('The time of originality detection query (ms)', size=13)

plt.ylim([0, 45])
ax.grid(False)
plt.savefig("QueryCostWithK")
plt.show()
