import matplotlib.pyplot as plt
import numpy as np

plt.rcParams['font.sans-serif'] = ['SimHei']  
plt.rcParams['axes.unicode_minus'] = False  
plt.figure(dpi=150)

x = np.arange(6)
width = 0.13

bm_k_20 = [2.79, 4.50, 7.36, 12.07, 23.43, 69.64]
mdq_k_20 = [2.36, 2.71, 2.43, 2.71, 2.36, 2.50]

bm_k_40 = [3.36, 5.50, 9.00, 11.00, 20.29, 71.57]
mdq_k_40 = [3.64, 4.50, 3.71, 3.71, 3.93, 3.50]

bm_k_60 = [5.07, 6.64, 9.64, 13.07, 23.07, 74.07]
mdq_k_60 = [4.71, 5.93, 4.79, 5.29, 5.36, 5.71]

name_list = [128, 256, 512, 1024, 2048, 4096]

plt.bar(x - 3 * width, bm_k_20, width=width, label='K=20 ABM', fc='dodgerblue')
plt.bar(x - 2 * width, mdq_k_20, width=width, label='K=20 MDQ', fc='orangered')
plt.bar(x - 1 * width, bm_k_40, width=width, label='K=40 ABM', fc='limegreen')
plt.bar(x, mdq_k_40, width=width, label='K=40 MDQ', fc='violet', tick_label=name_list)
plt.bar(x + 1 * width, bm_k_60, width=width, label='K=60 ABM', fc='skyblue')
plt.bar(x + 2 * width, mdq_k_60, width=width, label='K=60 MDQ', fc='coral')

plt.xlabel("The number of transactions per block")
plt.ylabel("The time of originality detection query (ms)")
plt.ylim(ymax=100)
plt.legend(loc='upper left')
plt.savefig("QueryCostWithTxInBlock")
plt.show()
